<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'manage/authorization', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/roles/find', [
        'as' => 'authorization::roles',
        'uses' => 'RoleController@findRoles',
    ]);

    Route::get('/permissions/find', [
        'as' => 'authorization::permissions',
        'uses' => 'PermissionController@findPermissions',
    ]);

    Route::get('/users/find', [
        'as' => 'authorization::users',
        'uses' => 'UserController@findUsers',
    ]);

    Route::resource('/users', 'UserController');

    Route::resource('/roles', 'RoleController');

    Route::resource('/permissions', 'PermissionController');

});

Route::group(['prefix' => 'authorization', 'middleware' => ['filter_ip']], function () {
    Route::get('/user/get-token', [
        'as' => 'authorization::users',
        'uses' => 'UserController@getToken',
    ]);
});
