<?php
$locale = env('APP_LOCALE', '');
if ($locale) {
    $locale = '/' . $locale;
}
Module::onVariable('setting_menu', function (&$data) use ($locale) {

    if (authorizationHasPermission('authorization/*', '*') || authorizationHasPermission('authorization/users', '*')) {
        $data[] = [
            'url' => $locale . '/manage/authorization/users',
            'icon' => 'fa-users',
            'title' => 'Users',
            'subtitle' => 'Quản lí user'
        ];
        if (authorizationHasPermission('authorization/*', '*')) {
            $data[] = [
                'url' => $locale . '/manage/authorization/roles',
                'icon' => 'fa-user',
                'title' => 'Roles',
                'subtitle' => 'Quản lí role'
            ];

            $data[] = [
                'url' => $locale . '/manage/authorization/permissions',
                'icon' => 'fa-key',
                'title' => 'Permission',
                'subtitle' => 'Quản lí Permission'
            ];
        }

    }

    return $data;
});

Module::onVariable('system.menu', function (&$data) use ($locale) {

    if (authorizationHasPermission('authorization/*', '*') || authorizationHasPermission('authorization/users', '*')) {
        $children = [
            [
                'icon' => '<i class="fa fa-users"></i>',
                'title' => 'Quản lí user',
                'url' => $locale . '/manage/authorization/users',
            ],
        ];
        if (authorizationHasPermission('authorization/*', '*')) {
            $children[] = [
                'icon' => '<i class="fa fa-user"></i>',
                'title' => 'Quản lí role',
                'url' => $locale . '/manage/authorization/roles',
            ];
            $children[] = [
                'icon' => '<i class="fa fa-key"></i>',
                'title' => 'Quản lí Permission',
                'url' => $locale . '/manage/authorization/permissions',
            ];
        }
        $data[] = [
            'icon' => '<i class="fa fa-user"></i>',
            'title' => 'Phân quyền',
            'url' => $locale . '/manage/authorization/users',
            'children' => $children
        ];
    }

    return $data;
});