<?php

namespace Modules\AutoPrice\Models;

use Illuminate\Support\Facades\Redis;
use Illuminate\Database\Eloquent\Model;

class Option extends Model
{
    public $timestamps = false;

    protected $table = 'option';

    protected $fillable = [
        'name', 'key', 'value', 'type'
    ];

    protected static function boot() {
        parent::boot();
        static::created(function ($model) {
            Redis::del('LOCALE');
            Redis::del('CURRENCY');
            Redis::del('PREFIX_URL');
        });
        static::updated(function ($model) {
            Redis::del('LOCALE');
            Redis::del('CURRENCY');
            Redis::del('PREFIX_URL');
        });
        static::deleted(function ($model) {
            Redis::del('LOCALE');
            Redis::del('CURRENCY');
            Redis::del('PREFIX_URL');
        });
    }
}
