<?php

namespace Modules\AutoPrice\Models;

use Illuminate\Support\Facades\DB;
use Modules\AutoPrice\Models\Traits\BaseTrait;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use BaseTrait;
    public $timestamps = false;
    protected $table = "order";
    const STATUS_OUT = 'OUT';

    static $operationFilter = [
        'eq' => [
            'source', 'type', 'from',
            'payment_type', 'payment_status',
            'warehouse_id', 'country_id'
        ],
        //>
        'gt' => [
        ],
        // >=
        'gte' => [
            [
                'filter' => 'create_time_gte',
                'column' => 'created_at',
            ]
        ],
        //<
        'lt' => [],
        // <=
        'lte' => [
            [
                'filter' => 'create_time_lte',
                'column' => 'created_at',
            ]
        ],
        //!=
        'ne' => [
        ],
        //not in
        'nin' => [
        ],
        //in
        'in' => [
        ],
        'like' => []
    ];

    public static function buildOrderQuery($filter) {

        $query = self::buildQuery($filter);
        if (array_key_exists('join_order_item', $filter)) {
            $query->join('order_item', 'order_item.order_id', '=', 'order.id');
            if (array_key_exists('product_ids', $filter)) {
                $query->whereIn('product_id', $filter['product_ids']);
            }
        }

        if (array_key_exists('sources', $filter)) {
            $query->join(DB::raw('sb_order_meta as order_meta_adwords'), function($join) use ($filter) {
                $join->on(DB::raw('order_meta_adwords.order_id'), '=', 'order.id')
                    ->where(DB::raw('order_meta_adwords.key'), '=', 'from')
                    ->whereIn(DB::raw('order_meta_adwords.value'), $filter['sources']);
            });
        }

        return $query;
    }
}
