<?php

namespace Modules\AutoPrice\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Product extends Model
{
    protected $table = 'product';

    protected $fillable = [
        'sku',
        'barcode',
        'name',
        'slug',
        'image_url',
        'price',
        'high_price',
        'add_shipping_fee',
        'weight',
        'status',
        'description',
        'content',
        'note',
        'inventory',
        'brand_id',
        'status_out_stock',
        'pod_parent_id',
        "approve_advertising",
        'created_at',
        'updated_at',
        'deleted_at',
        'gtin',
        'actor_id',
        'updater_id'
    ];

    public function productSkuValue() {
        return $this->hasMany(ProductSkuValue::class);
    }

    public static function getProductCostPrice($productSkuId, $findBy = 'product_sku_id', $countryId = 0) {
        $retVal = 0;
        $productInfo = DB::table('product_info')->where($findBy, '=', $productSkuId)->first();
        $checkStyle = false;
        if (!empty($productInfo->product_id)) {
            $product = DB::table('product')->where('id', '=', $productInfo->product_id)->select('name')->first();
            $categories = DB::table('product_n_category')->join('category', 'product_n_category.category_id', '=', 'category.id')
                // ->where('is_parent', '=', 0)
                ->where('product_id', '=', $productInfo->product_id)
                ->select('name', 'slug')
                ->get();

            foreach ($categories as $category) {
                $query = DB::table('printing_cost')->where('merch', '=', $category->slug)->orderBy('id', 'DESC');
                $defaultQuery = clone $query;

                if (!empty($productInfo->variants)) {
                    $variants = array_map('trim', explode(",", $productInfo->variants));
                    foreach ($variants as $variant) {
                        $variantAttr = explode(': ', $variant);
                        if (count($variantAttr) == 2) {
                            switch($variantAttr[0]) {
                                case 'Style': $checkStyle = true; break;
                                case 'Type': $query->where('type', '=', $variantAttr[1]); break;
                                case 'Size': {
                                    $sizeName = $variantAttr[1];
                                    if (in_array(strtolower($sizeName), ['small'])) {
                                        $query->where('size', '=', 'S');
                                    } else if (in_array(strtolower($sizeName), ['medium'])) {
                                        $query->where('size', '=', 'M');
                                    } else if (in_array(strtolower($sizeName), ['large'])) {
                                        $query->where('size', '=', 'L');
                                    } else if (in_array(strtolower($sizeName), ['x-large'])) {
                                        $query->where('size', '=', 'XL');
                                    } else if (in_array(strtolower($sizeName), ['xx-large'])) {
                                        $query->where('size', '=', '2XL');
                                    } else if (in_array(strtolower($sizeName), ['3x-large'])) {
                                        $query->where('size', '=', '3XL');
                                    } else if (in_array(strtolower($sizeName), ['4x-large'])) {
                                        $query->where('size', '=', '4XL');
                                    } else if (in_array(strtolower($sizeName), ['5x-large'])) {
                                        $query->where('size', '=', '5XL');
                                    } else {
                                        $query->where('size', '=', $sizeName);
                                    }
                                }  break;
                                case 'Color': {
                                    if (env('APP_LOCALE') == 'jp') {
                                        $query->where('color', '=', $variantAttr[1]); break;
                                    }
                                }
                                default: break;
                            }
                        }
                    }
                }

                $cloneQuery = clone $query;
                $printingCosts = $query->where('country_id', '=', $countryId)->get();

                if (count($printingCosts) <= 0) {
                    $printingCosts = $cloneQuery->where('country_id', '=', 0)->get();
                }
                $minValues = [];
                foreach ($printingCosts as $printingCost) {
                    if ($checkStyle && !empty(trim($printingCost->style)) && !empty($product->name)) {
                        if ($printingCost->style == "Classic") {
                            $retVal = $printingCost->max_price;
                        }
                        $product->name = strtolower($product->name);
                        $styles = explode(' ', trim($printingCost->style));
                        foreach ($styles as $style) {
                            if (strpos($product->name, strtolower($style)) !== false) {
                                $retVal = $printingCost->max_price;
                                break;
                            }
                        }
                    } else {
                        array_push($minValues, $printingCost->max_price);
                    }
                }

                if ($retVal == 0 && !empty($minValues)) {
                    $retVal = min($minValues);
                }

                if ($retVal == 0) {
                    $cloneDefaultCategory = clone $defaultQuery;

                    $defaultValue = $defaultQuery->where('country_id', '=', $countryId)->select(DB::raw('MIN(max_price) AS minPrice'))->first();
                    if (!empty($defaultValue->minPrice)) {
                        $retVal = $defaultValue->minPrice;
                    } else {
                        $defaultValue = $cloneDefaultCategory->where('country_id', '=', 0)->select(DB::raw('MIN(max_price) AS minPrice'))->first();
                        if (!empty($defaultValue->minPrice)) {
                            $retVal = $defaultValue->minPrice;
                        }
                    }
                }
            }
        }

        return $retVal;
    }

    public static function getTaxPercent($countryCode){
        $retVal = 1;
        $countryCode = strtoupper($countryCode);
        $taxes = [];
        $config = Option::where("key", "country_taxes")->first();
        if ($config) {
            $taxes = json_decode($config->value,true);
        }
        if (isset($taxes[$countryCode])){
            $retVal = 1 + ($taxes[$countryCode]/100);
        }
        return $retVal;
    }
    public static function getProductCost($id, $findBy = 'product_sku_id', $countryId = 0){
        $retVal = 0;
        $productCost = ProductCost::where($findBy,$id)->first(['cost']);
        if (!empty($productCost)){
            $ratios = config('default.currencyRatio',[]);
            $locale = strtolower(env('APP_LOCALE'));
            $currencyRatio = isset($ratios[$locale])?$ratios[$locale]:1;
            $retVal = round($productCost->cost * $currencyRatio,2);
        }
        if (empty($retVal)){
            $retVal = self::getProductCostPrice($id, $findBy, $countryId);
        }
        return $retVal;
    }
}
