<?php

namespace  Modules\AutoPrice\Models\Traits;




trait BaseTrait
{

    static $operationList = [
        'eq' => '=',
        'gt' => '>',
        'gte' => '>=',
        'lt' => '<',
        'lte' => '<=',
        'ne' => '!=',
    ];

    public static function getTableName()
    {
        return with(new static )->getTable();
    }

    public static function getData($filter = [])
    {
        if (!array_key_exists('columns', $filter)) {
            $filter['columns'] = ['*'];
        }
        if (!array_key_exists('page_id', $filter)) {
            $filter['page_id'] = 1;
        }
        $query = self::buildQuery($filter);
        if (array_key_exists('page_size', $filter)) {
            $query->forPage($filter['page_id'], $filter['page_size']);
        }
        return $query->get($filter['columns']);
    }

    public static function getCount($filter = [])
    {
        return self::buildQuery($filter)->count();
    }

    public function getPaginator($filter = [])
    {
        $count = self::getCount($filter);
        $pageSize = $filter['page_size'];
        $pageId = $filter['page_id'];
        $pageCount = ceil($count / $pageSize);
        $hasNext = true;
        if ($pageId == $pageCount) {
            $hasNext = false;
        }
        $paginator = [
            'has_next' => $hasNext,
            'total_count' => $count,
            'page_count' => $pageCount,
            'limit' => (int)$pageSize,
            'offset' => ($pageId - 1) * $pageSize,
            'page_id' => $filter['page_id'],
        ];
        return $paginator;
    }

    public static function buildQuery($filter = [])
    {
        $query = self::query();
        $tableName = self::getTableName();
        $operations = static::$operationFilter;
        foreach ($operations as $operation => $operationData) {
            if (!$operationData || count($operationData) == 0) {
                continue;
            }

            if (is_array($operationData)) {
                foreach ($operationData as $operationItem) {
                    list($keyFilter, $column) = self::getFilterAndColumn($operationItem, $tableName);
                    if (!array_key_exists($keyFilter, $filter)) {
                        continue;
                    }
                    $value = $filter[$keyFilter];
                    if (array_key_exists($operation, self::$operationList)) {
                        $query->where($column, self::$operationList[$operation], $value);
                    } else if ($operation == 'like') {
                        $query->where($column, 'LIKE', '%' . $value . '%');
                    } else if ($operation == 'in') {
                        $query->whereIn($column, $value);
                    } else if ($operation == 'nin') {
                        $query->whereNotIn($column, $value);
                    } else if ($operation == 'search') {
                        $query->search($value);
                    }
                }
            }
            if ($operation == 'or') {
                $query->where(function ($orQuery) use ($operationData, $tableName, $filter) {
                    $i = 0;
                    foreach ($operationData as $operationItem) {
                        list($keyFilter, $column) = self::getFilterAndColumn($operationItem, $tableName);
                        if (!array_key_exists($keyFilter, $filter)) {
                            continue;
                        }
                        $value = $filter[$keyFilter];
                        if ($i == 0) {
                            $orQuery->where($column, '=', $value);
                        } else {
                            $orQuery->orWhere($column, '=', $value);
                        }
                        $i++;
                    }
                });
            }
        }
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }
        if (array_key_exists('group_by', $filter)) {
            if (is_array($filter['group_by'])) {
                $query->groupBy($filter['group_by']);
            } else {
                $query->groupBy($tableName . '.' . $filter['group_by']);
            }
        }
        if (array_key_exists('order_by', $filter)) {
            list($column, $direction) = $filter['order_by'];
            $query->orderBy($tableName . '.' . $column, $direction);
        }
        if (array_key_exists('orders_by', $filter)) {
            foreach ($filter['orders_by'] as $order) {
                list($column, $direction) = $order;
                $query->orderBy($tableName . '.' . $column, $direction);
            }
        }
        if (array_key_exists('page_size', $filter)) {
            $query->limit($filter['page_size']);
        }
        return $query;
    }

    protected static function getFilterAndColumn($operationItem, $tableName)
    {
        $key = $operationItem;
        $column = $operationItem;
        if (is_array($operationItem)) {
            $key = $operationItem['filter'];
            $column = $operationItem['column'];
        }
        if (!str_contains($column, '.')) {
            $column = $tableName . '.' . $column;
        }
        return [$key, $column];
    }

    protected static function checkExists ($args) {
        $query = self::query();
        foreach ($args as $key => $value) {
            $query->where($key, '=', $value);
        }
        return $query->exists();
    }


}
