system.controller("AutoPriceController", AutoPriceController);
function AutoPriceController($scope, $http, $rootScope, Upload, $timeout) {

    $scope.baseController = this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);

    const UPDATE_MODE = 'update';
    const CREATE_MODE = 'create';

    const API_ENDPOINT = {
        'FETCH_DATA': '/auto-price/get-report'
    }

    let yesterday = new Date();
    yesterday.setDate(yesterday.getDate() - 1);
    let defaultDateFrom = [('0' + yesterday.getDate()).slice(-2), ('0' + (yesterday.getMonth() + 1)).slice(-2), yesterday.getFullYear()].join('/');

    $scope.locale = '/';
    if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
        $scope.locale = '/' + localePrefix + '/';
    }

    $scope.pagination = {
        current_page: 1,
        number_page: 1
    }

    $scope.filters = {
        page_size: 100,
        date_from: defaultDateFrom,
        date_to: defaultDateFrom
    }

    $scope.state = {
        search_string: null,
        old_search_string: null
    }

    $scope.status = {
        is_fetching: true
    }

    $scope.commentStatuses = [
        'ACTIVE', 'PENDING', 'BLOCK'
    ];

    $scope.timeOut = setTimeout(() => { }, 0);
    $scope.records = [];
    $scope.commentIds = [];

    $scope.initialize = function () {
        $('#dateTo').datepicker({dateFormat: 'dd/mm/yy'});
        $('#dateFrom').datepicker({dateFormat: 'dd/mm/yy'});
        fetchData();
    };

    $scope.range = function (min, max, step) {
        step = step || 1;
        var input = [];
        for (var i = min; i <= max; i += step) {
            input.push(i);
        }
        return input;
    };

    $scope.removeAllFilters = function () {
        $scope.removePagination();
        $scope.filters = {
            page_size: 100,
            date_from: defaultDateFrom,
            date_to: defaultDateFrom
        };
        fetchData();
    };

    $scope.removePagination = function () {
        $scope.pagination = {
            current_page: 1,
            number_page: 1
        };
    }

    $scope.fetch = fetchData;

    $scope.doSearch = function () {
        $scope.removePagination();
        fetchData();
    }

    function fetchData() {
        $scope.status.is_fetching = true;
        let filters = angular.copy($scope.filters);

        if (filters.date_from) {
            let dateParts = filters.date_from.split('/');
            let thisDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]);
            filters.date_from = thisDate.getTime() / 1000;
        }

        if (filters.date_to) {
            let dateParts = filters.date_to.split('/');
            let thisDate = new Date(dateParts[2], dateParts[1] - 1, dateParts[0]);
            filters.date_to = thisDate.getTime() / 1000;
        }

        filters.page_id = $scope.pagination.current_page - 1;

        $http({
            method: 'POST',
            url: API_ENDPOINT.FETCH_DATA,
            params: filters
        }).then(function success(response) {
            $scope.status.is_fetching = false;
            if (response.data.status == 'successful') {
                $scope.records = response.data.data;
                standardize();

                $scope.pagination.meta = response.data.meta;
                $scope.pagination.number_page = response.data.meta.page_count;
                if ($scope.pagination.number_page < $scope.pagination.current_page)
                    $scope.pagination.current_page = 1;

            } else {
                $scope.status.is_fetching = false;
                toastr.error('Error fetch data!');
            }
        }, function error() {
            $scope.status.is_fetching = false;
            toastr.error('Error fetch data!');
        });
    }

    $scope.toInt = function(number) { 
        return parseInt(number); 
    }

    function standardize() {
        for (let index = 0; index < $scope.records.length; index++) {
            $scope.records[index].is_stop_ads = parseInt($scope.records[index].is_stop_ads);
            $scope.records[index].order_count = parseInt($scope.records[index].order_count);
            $scope.records[index].click = parseInt($scope.records[index].click);
        }
    }

    $scope.initialize();
}
