@extends('system.layout.main', [
'ngController' => 'AutoPriceController'
])
@section('title')
    <title>Auto Price report</title>
@endsection
@section('content')
    @include('auto-price::includes.auto-price-style')
    <div class="content" ng-cloak>
        <div class="body">
            <h3 style="margin-top: 0; padding: 7px;">Auto Price Report</h3>
            <div class="box no-border">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <input
                                    ng-keyup="$event.keyCode == 13 && doSearch()"
                                    type="text"
                                    class="form-control"
                                    ng-model="filters.search"
                                    placeholder="Search product"
                                >
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <input
                                    id="dateFrom"
                                    type="text"
                                    class="form-control"
                                    ng-model="filters.date_from"
                                    placeholder="Created From"
                                >
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <input
                                    id="dateTo"
                                    type="text"
                                    class="form-control"
                                    ng-model="filters.date_to"
                                    placeholder="Created To"
                                >
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <input
                                    type="number"
                                    class="form-control"
                                    ng-model="filters.click_from"
                                    placeholder="Click From"
                                >
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <input
                                    type="number"
                                    class="form-control"
                                    ng-model="filters.click_to"
                                    placeholder="Click To"
                                >
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <input
                                    type="number"
                                    class="form-control"
                                    ng-model="filters.profit_from"
                                    placeholder="Profit From"
                                >
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <input
                                    type="number"
                                    class="form-control"
                                    ng-model="filters.profit_to"
                                    placeholder="Profit To"
                                >
                            </div>
                        </div>
                        <!--
                        <div class="col-md-2">
                            <div class="form-group">
                                <select class="form-control" ng-model="filters.is_stop_ads">
                                    <option value="">-- Advertising Status --</option>
                                    <option value="0">Running</option>
                                    <option value="1">Stoped</option>
                                </select>
                            </div>
                        </div>-->
                        <div class="col-md-3">
                            <button type="button" class="btn btn-primary " ng-click="doSearch()">
                                <i class="fa fa-search"></i>
                                Search
                            </button>
                            <button type="button" class="btn btn-default ml-3" ng-click="removeAllFilters(); doSearch()">
                                <i class="fa fa-refresh"></i>
                                Reset
                            </button>
                        </div>
                    </div>

                    <div ng-if="status.is_fetching" style="position: absolute; width: 100%;">
                        <div class="loader">Loading...</div>
                    </div>

                    <table class="table table-bordered auto-price-table" style="margin-top: 25px;">
                        <tr>
                            <th>#</th>
                            <th style="width: 20%">Name</th>
                            <th>SKU</th>
                            <th>Price</th>
                            <th>New Price</th>
                            <th style="width: 100px;" class="text-center">Click</th>
                            <th style="width: 100px;" class="text-center">Profit</th>
                            <!--<th style="width: 100px;" class="text-center">C-Rate</th>-->
                            <th style="width: 150px">Date</th>
                            <!--<th title="Advertising Status" style="max-width: 85px;">Advertising Status</th>-->
                        </tr>
                        <tr ng-repeat="record in records">
                            <td>@{{ $index + 1 }}</td>
                            <td>
                                <a target="_blank" href="@{{ locale }}@{{ record.slug }}-p@{{ record.product_id }}">@{{ record.name }}</a>
                            </td>
                            <td>@{{ record.sku }}</td>
                            <td>
                                <strong>@{{ formatPrice(record.price) }}</strong>
                            </td>
                            <td ng-class="{'up-price': (record.new_price - record.price) > 0, 'down-price': (record.new_price - record.price) < 0}">
                                <strong>@{{ formatPrice(record.new_price) }}</strong>
                            </td>
                            <td class="text-center">@{{ record.click }}</td>
                            <td class="text-center">@{{ formatPrice(record.profit) }}</td>
                            <!--
                            <td class="text-center">
                                <strong>
                                    @{{ record.order_count / record.click * 100 | number : 2 }}%
                                </strong>
                            </td>
                            -->
                            <td>
                                @{{ toVietnameseDate(record.date, true) }}
                            </td>
                            <!--
                            <td>
                                <span class="label label-success" ng-if="!record.is_stop_ads">Running</span>
                                <span class="label label-danger" ng-if="record.is_stop_ads">Stoped</span>
                            </td>
                            -->
                        </tr>

                    </table>

                </div>
                <div class="box-footer clearfix" ng-class="{'disable' : !(!status.is_fetching && pagination.number_page > 1)}">
                    <div class="pull-right" style="display: flex">
                        <span class="pagination-meta" ng-if="pagination.meta.total_count"> 
                            Rendered: 
                            @{{ toInt(pagination.meta.page_size) * (toInt(pagination.current_page) - 1) + 1 }} - 
                            @{{ toInt(pagination.meta.page_size) * (toInt(pagination.current_page) - 1) + toInt(pagination.meta.page_size) }} (@{{ pagination.meta.page_size }})
                            / @{{ pagination.meta.total_count }}
                        </span>
                        <ul class="pagination" style="margin: 0">
                            <li ng-repeat="n in range(pagination.current_page - 4, pagination.current_page - 1)"
                                ng-if="n > 0" class="page-item">
                                <a ng-click="pagination.current_page = n; fetch();" class="page-link"
                                    href="#">@{{ n }}</a>
                            </li>
                            <li class="page-item active">
                                <a href="#">@{{ pagination.current_page }}</a>
                            </li>
                            <li ng-repeat="n in range(pagination.current_page + 1, pagination.current_page + 4)"
                                ng-if="n <= pagination.number_page" class="page-item">
                                <a ng-click="pagination.current_page = n; fetch();" class="page-link"
                                    href="#">@{{ n }}</a>
                            </li>
                        </ul>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>

@endsection
@section('script')
    <script>
        var base_url = '<?= url(' / ') ?>';
    </script>
    <script src="@asset('auto-price/controllers/auto-price-controller.js')?v=<?= Config::get("sa.version") ?>"></script>
@endsection
