<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
$systemAuth = config('app.system_auth_middleware');

Route::group(['prefix' => 'auto-price', 'middleware' => 'example'], function () use ($systemAuth) {
    Route::get('/index', [
        'as' => 'auto-price::home',
        'uses' => 'HomeController@index',
    ]);
    Route::get('/get-stop-ads-product', [
        'as' => 'auto-price::get-stop-ads-product',
        'uses' => 'HomeController@getStopAdsProduct',
    ]);
    Route::get('/get-report', [
        'as' => 'auto-price::get-report',
        'uses' => 'HomeController@report',
    ]);
    Route::post('/get-report', [
        'as' => 'auto-price::get-report',
        'uses' => 'HomeController@report',
    ]);
    Route::get('/product-react/cron', [
        'as' => 'auto-price::product-react::cronProductReact',
        'uses' => 'ProductReactController@cronProductReact',
    ]);
    Route::get('/product-react/find', [
        'as' => 'auto-price::product-react::find',
        'uses' => 'ProductReactController@find',
    ]);
    Route::get('/product-react/report-order', [
        'as' => 'auto-price::product-react::reportOrder',
        'uses' => 'ProductReactController@reportOrder',
    ])->middleware(['filter_token']);
    Route::get('/rebuild-log', [
        'as' => 'auto-price::home::rebuild-log',
        'uses' => 'HomeController@rebuildLog',
    ]);
    Route::get('/get-summary-result', [
        'as' => 'auto-price::home::get-summary-result',
        'uses' => 'HomeController@getSummaryResult',
    ]);

    Route::get('/report', [
        'as' => 'auto-price::report',
        'uses' => 'HomeController@autoPriceReport',
    ])->middleware($systemAuth);

});
