<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 9/8/21
 * Time: 11:15 AM
 */

namespace Modules\BingAds\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Modules\BingAds\Controllers\Controller;
use Modules\BingAds\Models\AdsCost;

class AdwordsController extends Controller
{
    public function storeByAdScript(Request $request) {
        set_time_limit(3600);
        ini_set('memory_limit', '1024M');
        $response = [
            'status' => 'fail'
        ];
        if ($request->has('items') && $request->has('account')) {
            $account = $request->input('account');
            $accountKey = $account['name'];
            if (is_array($request->input('items')) && count($request->input('items')) > 0) {
                $dateReport = $request->input('items')[0]['date_report'];
                $arrData = $this->getDataCost($dateReport);
                $listDataExchangeRate = $this->getDataExchangeRate($dateReport);
                foreach($request->input('items') as $item) {
                    $newData = [
                        'click' => $item['click'],
                        'ads_type' => 'adwords',
                        'account_key' => $accountKey,
                        'campaign_id' => $item['campaign_id'],
                        'date_report' => $item['date_report'],
                        'campaign_name' => $item['campaign_name'],
                        'currency' => strtolower($account['currency']),
                    ];
                    if (!empty($account['time_zone']) && isset($item['hour'])) {
                        if (strlen($item['hour']) == 1) {
                            $item['hour'] = '0' . $item['hour'];
                        }
                        $date = new \DateTime($item['date_report'] . ' ' . $item['hour'] . ':00:00', new \DateTimeZone($account['time_zone']));
                        if ($date) {
                            $date->setTimezone(new \DateTimeZone('Asia/Ho_Chi_Minh'));
                            $newData['date_report'] = $date->format('Y-m-d');
                            $newData['hour_report'] = intval($date->format('H'));
                        }
                        $newData['origin_date'] = $item['date_report'];
                        $newData['origin_time_zone'] = $account['time_zone'];
                        $newData['origin_hour'] = intval($item['hour']);
                    }
                    $cost = str_replace(',', '', $item['cost']);
                    $exchangeRate = isset($listDataExchangeRate[$newData['date_report']]) ? $listDataExchangeRate[$newData['date_report']] : 23000;
                    if ($newData['currency'] == 'vnd') {
                        $newData['cost_vnd'] = (int) $cost;
                        $newData['cost'] = (int) $cost / $exchangeRate;
                    } else {
                        $newData['cost'] = $cost;
                        $newData['cost_vnd'] = $cost * $exchangeRate;
                    }
                    $newData['exchange_rate'] = $exchangeRate;

                    if (isset($arrData[$newData['ads_type']][$newData['account_key']][$newData['campaign_id']][$newData['date_report']][$newData['hour_report']])) {
                        DB::table('ads_cost')
                            ->where('id', '=', $arrData[$newData['ads_type']][$newData['account_key']][$newData['campaign_id']][$newData['date_report']][$newData['hour_report']])
                            ->update([
                                'click' => $item['click'],
                                'cost' => $newData['cost'],
                                'cost_vnd' => $newData['cost_vnd'],
                                'exchange_rate' => $newData['exchange_rate'],
                                'updated_at' => date('Y-m-d H:i:s')
                            ]);
                    } else {
                        $newData['created_at'] = date('Y-m-d H:i:s');
                        $newData['updated_at'] = date('Y-m-d H:i:s');
                        DB::table('ads_cost')
                            ->insert($newData);
                    }
                }
            }
            $response['status'] = 'successful';
            $response['message'] = 'Update data successfully';
        }
        return response()->json($response);
    }

    public function storeByAdScriptV2(Request $request) {
        set_time_limit(3600);
        ini_set('memory_limit', '1024M');
        $response = [
            'status' => 'fail'
        ];
        if ($request->has('items') && $request->has('account')) {
            $account = $request->input('account');
            $accountKey = $account['name'];
            if (is_array($request->input('items')) && count($request->input('items')) > 0) {
                $dateReport = $request->input('items')[0]['date_report'];
                $arrData = $this->getDataCost($dateReport);
                foreach($request->input('items') as $item) {
                    $newData = [
                        'click' => $item['click'],
                        'ads_type' => 'adwords',
                        'account_key' => $accountKey,
                        'campaign_id' => $item['campaign_id'],
                        'date_report' => $item['date_report'],
                        'campaign_name' => $item['campaign_name'],
                        'currency' => strtolower($account['currency']),
                    ];
                    if (!empty($account['time_zone']) && isset($item['hour'])) {
                        if (strlen($item['hour']) == 1) {
                            $item['hour'] = '0' . $item['hour'];
                        }
                        $date = new \DateTime($item['date_report'] . ' ' . $item['hour'] . ':00:00', new \DateTimeZone($account['time_zone']));
                        if ($date) {
                            $date->setTimezone(new \DateTimeZone('Asia/Ho_Chi_Minh'));
                            $newData['date_report'] = $date->format('Y-m-d');
                            $newData['hour_report'] = intval($date->format('H'));
                        }
                        $newData['origin_date'] = $item['date_report'];
                        $newData['origin_time_zone'] = $account['time_zone'];
                        $newData['origin_hour'] = intval($item['hour']);
                    }
                    $cost = str_replace(',', '', $item['cost']);
                    if ($newData['currency'] == 'vnd') {
                        $newData['cost_vnd'] = (int) $cost;
                        $newData['cost'] = (int) $cost / 22000;
                    } else {
                        $newData['cost'] = $cost;
                        $newData['cost_vnd'] = $cost * 22000;
                    }
                    if (isset($arrData[$newData['ads_type']][$newData['account_key']][$newData['campaign_id']][$newData['date_report']][$newData['hour_report']])) {
                        DB::table('ads_cost_copy')
                            ->where('id', '=', $arrData[$newData['ads_type']][$newData['account_key']][$newData['campaign_id']][$newData['date_report']][$newData['hour_report']])
                            ->update([
                                'click' => $item['click'],
                                'cost' => $newData['cost'],
                                'cost_vnd' => $newData['cost_vnd'],
                                'updated_at' => date('Y-m-d H:i:s')
                            ]);
                    } else {
                        $newData['created_at'] = date('Y-m-d H:i:s');
                        $newData['updated_at'] = date('Y-m-d H:i:s');
                        DB::table('ads_cost_copy')
                            ->insert($newData);
                    }
                }
            }
            $response['status'] = 'successful';
            $response['message'] = 'Update data successfully';
        }
        return response()->json($response);
    }

    private function getDataCost ($dateReport) {
        $retVal = [];
        $dataCostDB = DB::table('ads_cost')
            ->where('ads_type', '=', 'adwords')
            ->where('date_report', '>=', date('Y-m-d', strtotime('-1 day', strtotime($dateReport))))
            ->where('date_report', '<=', date('Y-m-d', strtotime('+1 day', strtotime($dateReport))))
            ->get();
        foreach ($dataCostDB as $item) {
            $retVal[$item->ads_type][$item->account_key][$item->campaign_id][$item->date_report][$item->hour_report] = $item->id;
        }
        return $retVal;
    }
}
