<?php

namespace Modules\BingAds\Controllers;

// Specify the Microsoft\BingAds\Auth classes that will be used.
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Microsoft\BingAds\Auth\AuthorizationData;
use Microsoft\BingAds\Auth\OAuthTokenRequestException;
use Microsoft\BingAds\Auth\OAuthWebAuthCodeGrant;

// Specify the Microsoft\BingAds\Auth classes that will be used.
use Microsoft\BingAds\Auth\ServiceClient;
use Microsoft\BingAds\Auth\ServiceClientType;

// Specify the Microsoft\BingAds\V13\CustomerManagement classes that will be used.
use Microsoft\BingAds\Samples\V13\AuthHelper;
use Microsoft\BingAds\V13\CustomerManagement\GetUserRequest;
use Microsoft\BingAds\V13\CustomerManagement\SearchAccountsRequest;
use Microsoft\BingAds\V13\CustomerManagement\Paging;
use Microsoft\BingAds\V13\CustomerManagement\Predicate;
use Microsoft\BingAds\V13\CustomerManagement\PredicateOperator;

use Microsoft\BingAds\V13\CampaignManagement\GetCampaignsByAccountIdRequest;

use Microsoft\BingAds\V13\Reporting\AccountPerformanceReportColumn;
use Microsoft\BingAds\V13\Reporting\AccountPerformanceReportRequest;
use Microsoft\BingAds\V13\Reporting\AccountThroughAdGroupReportScope;
use Microsoft\BingAds\V13\Reporting\CampaignPerformanceReportColumn;
use Microsoft\BingAds\V13\Reporting\CampaignPerformanceReportRequest;
use Microsoft\BingAds\V13\Reporting\KeywordPerformanceReportColumn;
use Microsoft\BingAds\V13\Reporting\AccountReportScope;
use Microsoft\BingAds\V13\Reporting\KeywordPerformanceReportRequest;
use Microsoft\BingAds\V13\Reporting\ReportAggregation;
use Microsoft\BingAds\V13\Reporting\ReportFormat;
use Microsoft\BingAds\V13\Reporting\ReportRequestStatusType;
use Microsoft\BingAds\V13\Reporting\ReportTime;
use Microsoft\BingAds\V13\Reporting\ReportTimePeriod;
use Microsoft\BingAds\V13\Reporting\ReportTimeZone;
use Modules\BingAds\Helpers\ReportingExampleHelper;
use Modules\BingAds\Helpers\WebAuthHelper;
use Modules\BingAds\Models\AdsCost;
use Modules\BingAds\Models\BingCampaign;
use Modules\BingAds\Models\BingToken;

use Exception;

session_start();

class CampaignController extends Controller
{
    public function createAuthorization($isReturn = true) {
        $token = BingToken::first();
        if ($token) {
            $authentication = (new OAuthWebAuthCodeGrant())
                    ->withClientId(WebAuthHelper::ClientId)
                    ->withClientSecret(WebAuthHelper::ClientSecret)
                    ->withRedirectUri('https://' . $_SERVER['HTTP_HOST'] . WebAuthHelper::RedirectUri)
                    ->withState(rand(0,999999999));

                // Assign this authentication instance to the global authorization_data.
            $auth = (new AuthorizationData())
                ->withAuthentication($authentication)
                ->withDeveloperToken(WebAuthHelper::DeveloperToken);
            $_SESSION['AuthorizationData'] = $auth;
            $GLOBALS['AuthorizationData'] = $auth;
            $_SESSION['AuthorizationData']->Authentication->RequestOAuthTokensByRefreshToken($token->refresh_token);
            $refreshToken = $_SESSION['AuthorizationData']->Authentication->OAuthTokens->RefreshToken;
            if ($refreshToken && $refreshToken != null) {
                $this->saveRefreshToken($refreshToken);
                if ($isReturn) {
                    return redirect()->route('bing-ads::cron-campaign');
                }
            } else {
                echo 'Click <a href="' . route('bing-ads::callback') . '">here</a> to try again with new refresh token.';
            }
        } else {
            echo 'Click <a href="' . route('bing-ads::callback') .  '">here</a> to try again with new refresh token.';
        }
    }


    public function cronCampaign() {
        // If there is no user authenticated, go back to the site index.
        if(!isset($_SESSION['AuthorizationData']) ||
        !isset($_SESSION['AuthorizationData']->Authentication) ||
        !isset($_SESSION['AuthorizationData']->Authentication->OAuthTokens)
        )
        {
            return redirect()->route('bing-ads::create-authorization');
        }
        else {
            $GLOBALS['CustomerManagementProxy'] = new ServiceClient(
                ServiceClientType::CustomerManagementVersion13,
                $_SESSION['AuthorizationData'],
                WebAuthHelper::GetApiEnvironment());

            // Set the GetUser request parameter to an empty user identifier to get the current 
            // authenticated Microsoft Advertising user, and then search for all accounts the user can access.

            $getUserRequest = new GetUserRequest();
            $getUserRequest->UserId = null;

            $user = $GLOBALS['CustomerManagementProxy']->GetService()->GetUser($getUserRequest)->User;
            $_SESSION['AuthorizationData']->CustomerId = $user->Id;
            // Search for the Microsoft Advertising accounts that the user can access.

            $pageInfo = new Paging();
            $pageInfo->Index = 0;    // The first page
            $pageInfo->Size = 1000;   // The first 1,000 accounts for this page of results    
            $predicate = new Predicate();
            $predicate->Field = "UserId";
            $predicate->Operator = PredicateOperator::Equals;
            $predicate->Value = $user->Id;

            $searchAccountsRequest = new SearchAccountsRequest();
            $searchAccountsRequest->Predicates = array($predicate);
            $searchAccountsRequest->Ordering = null;
            $searchAccountsRequest->PageInfo = $pageInfo;

            $accounts = $GLOBALS['CustomerManagementProxy']->GetService()->SearchAccounts($searchAccountsRequest)->Accounts;
            foreach ($accounts->AdvertiserAccount as $account)
            {
                $_SESSION['AuthorizationData']->AccountId = $account->Id;
                $campaigns = $this->getCampaign($account->Id);
                $this->saveCampaigns($campaigns, $account);
            }
        }
        $response = ['status' => 'successful'];
        return response()->json($response);
    }

    private function saveCampaigns($campaigns, $account) {
        if (isset($campaigns->Campaigns->Campaign) && !empty($campaigns->Campaigns->Campaign)) {
            $data = [];
            foreach ($campaigns->Campaigns->Campaign as $campaign) {
                $newData = [
                    'campaign_id' => $campaign->Id,
                    'campaign_name' => $campaign->Name,
                    'status' => $campaign->Status,
                    'type' => $campaign->CampaignType,
                    'account_id' => $account->Id,
                    'account_name' => $account->Name
                ];
                $campaign = BingCampaign::where('campaign_id', $campaign->Id)->first();
                if (!$campaign) {
                    $campaign = BingCampaign::create();
                }
                foreach($newData as $key => $value) {
                    $campaign->{$key} = $value;
                }
                $campaign->save();
            }
        }

    }

    private function getCampaign($accountId) {
        $GLOBALS['CampaignManagementProxy'] = new ServiceClient(
            ServiceClientType::CampaignManagementVersion13,
            $_SESSION['AuthorizationData'],
            WebAuthHelper::GetApiEnvironment()
        );
        $GLOBALS['CampaignManagementProxy']->SetAuthorizationData($_SESSION['AuthorizationData']);
        $GLOBALS['Proxy'] = $GLOBALS['CampaignManagementProxy'];

        $request = new GetCampaignsByAccountIdRequest();

        $request->AccountId = $accountId;
        $request->CampaignType = WebAuthHelper::CampaignTypes;
        return $GLOBALS['CampaignManagementProxy']->GetService()->GetCampaignsByAccountId($request);
    }

    public function callback() {
        // unset($_SESSION['AuthorizationData']);
        // die;
        try
        {
            if(!isset($_SESSION['AuthorizationData']) || !isset($_SESSION['AuthorizationData']->Authentication))
            {
                // Prepare the OAuth object for use with the authorization code grant flow. 
                // It is recommended that you specify a non guessable 'state' request parameter to help prevent
                // cross site request forgery (CSRF). 
                $authentication = (new OAuthWebAuthCodeGrant())
                    ->withClientId(WebAuthHelper::ClientId)
                    ->withClientSecret(WebAuthHelper::ClientSecret)
                    ->withRedirectUri('https://' . $_SERVER['HTTP_HOST'] . WebAuthHelper::RedirectUri)
                    ->withState(rand(0,999999999));

                // Assign this authentication instance to the global authorization_data. 

                $_SESSION['AuthorizationData'] = (new AuthorizationData())
                    ->withAuthentication($authentication)
                    ->withDeveloperToken(WebAuthHelper::DeveloperToken);

                $_SESSION['state'] = $_SESSION['AuthorizationData']->Authentication->State;
                // The user needs to provide consent for the application to access their Microsoft Advertising accounts.
                return redirect()->to($_SESSION['AuthorizationData']->Authentication->GetAuthorizationEndpoint());
            }

            // If the current HTTP request is a callback from the Microsoft Account authorization server,
            // use the current request url containing authorization code to request new access and refresh tokens
            if(isset($_GET['code']))
            {
                // Verify whether the 'state' value is the same random value we created
                // when the authorization request was initiated.
                if ($_GET['state'] != $_SESSION['state'])
                {
                    throw new Exception(sprintf(
                        "The OAuth response state (%s) does not match the client request state (%s)",
                        $_GET['state'],
                        $_SESSION['state']));
                }

                $_SESSION['AuthorizationData']->Authentication->RequestOAuthTokensByResponseUri(
                    $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);

                $refreshToken = $_SESSION['AuthorizationData']->Authentication->OAuthTokens->RefreshToken;
                if ($refreshToken && $refreshToken != null) {
                    $this->saveRefreshToken($refreshToken);
                }
                return redirect()->route('bing-ads::cron-campaign');
            }
        }
        catch(OAuthTokenRequestException $e)
        {
            // The user could not be authenticated or the grant is expired. 
            // The user must first sign in and if needed grant the client application access to the requested scope.
            print $e;
        }
        catch(Exception $e)
        {
            print $e;
        }
    }

    private function saveRefreshToken($token) {
        BingToken::truncate();
        $bingToken = BingToken::create();
        $bingToken->refresh_token = $token;
        $bingToken->save();
    }

    function GetAccountPerformanceReportRequest($accountId)
    {
        $report = new AccountPerformanceReportRequest();

        $report->Format = ReportFormat::Csv;
        $report->ReportName = 'My Account Performance Report';
        $report->ReturnOnlyCompleteData = false;
        $report->Aggregation = ReportAggregation::Daily;

        $report->Scope = new AccountReportScope();
        $report->Scope->AccountIds = array();
        $report->Scope->AccountIds[] = $accountId;

        $report->Time = new ReportTime();
        $report->Time->PredefinedTime = ReportTimePeriod::LastSevenDays;
        $report->Time->ReportTimeZone = ReportTimeZone::BangkokHanoiJakarta;

        $report->Columns = array (
            AccountPerformanceReportColumn::TimePeriod,
            AccountPerformanceReportColumn::AccountId,
            AccountPerformanceReportColumn::AccountName,
            AccountPerformanceReportColumn::Clicks,
            AccountPerformanceReportColumn::Impressions,
            AccountPerformanceReportColumn::Ctr,
            AccountPerformanceReportColumn::AverageCpc,
            AccountPerformanceReportColumn::Spend,
            AccountPerformanceReportColumn::DeviceOS
        );

        $encodedReport = new \SoapVar(
            $report,
            SOAP_ENC_OBJECT,
            'AccountPerformanceReportRequest',
            $GLOBALS['ReportingProxy']->GetNamespace()
        );

        return $encodedReport;
    }

    function GetKeywordPerformanceReportRequest($accountId)
    {
        $report = new KeywordPerformanceReportRequest();

        $report->Format = ReportFormat::Csv;
        $report->ReportName = 'My Keyword Performance Report';
        $report->ReturnOnlyCompleteData = false;
        $report->Aggregation = ReportAggregation::Daily;

        $report->Scope = new AccountThroughAdGroupReportScope();
        $report->Scope->AccountIds = array();
        $report->Scope->AccountIds[] = $accountId;
        $report->Scope->AdGroups = null;
        $report->Scope->Campaigns = null;

        $report->Time = new ReportTime();
        $report->Time->PredefinedTime = ReportTimePeriod::LastSevenDays;
        $report->Columns = array (
            KeywordPerformanceReportColumn::TimePeriod,
            KeywordPerformanceReportColumn::AccountId,
            KeywordPerformanceReportColumn::CampaignId,
            KeywordPerformanceReportColumn::CampaignName,
//            KeywordPerformanceReportColumn::Keyword,
//            KeywordPerformanceReportColumn::KeywordId,
//            KeywordPerformanceReportColumn::DeviceType,
//            KeywordPerformanceReportColumn::BidMatchType,
            KeywordPerformanceReportColumn::Clicks,
            KeywordPerformanceReportColumn::Impressions,
            KeywordPerformanceReportColumn::Ctr,
            KeywordPerformanceReportColumn::AverageCpc,
            KeywordPerformanceReportColumn::Spend,
            KeywordPerformanceReportColumn::QualityScore
        );

        $encodedReport = new \SoapVar(
            $report,
            SOAP_ENC_OBJECT,
            'KeywordPerformanceReportRequest',
            $GLOBALS['ReportingProxy']->GetNamespace()
        );

        return $encodedReport;
    }

    function GetCampaignPerformanceReportRequest($accountId, $isGetLastWeek)
    {
        $report = new CampaignPerformanceReportRequest();

        $report->Format = ReportFormat::Csv;
        $report->ReportName = 'My Campaign Performance Report';
        $report->ReturnOnlyCompleteData = false;
        $report->Aggregation = ReportAggregation::Hourly;

        $report->Scope = new AccountThroughAdGroupReportScope();
        $report->Scope->AccountIds = array();
        $report->Scope->AccountIds[] = $accountId;
        $report->Scope->AdGroups = null;
        $report->Scope->Campaigns = null;
        $report->Time = new ReportTime();
        if ($isGetLastWeek) {
            $report->Time->PredefinedTime = ReportTimePeriod::LastSevenDays;
        } else {
            $report->Time->PredefinedTime = ReportTimePeriod::Today;
        }
        $report->Time->ReportTimeZone = ReportTimeZone::BangkokHanoiJakarta;

        $report->Columns = array (
            CampaignPerformanceReportColumn::TimePeriod,
            CampaignPerformanceReportColumn::AccountId,
            CampaignPerformanceReportColumn::CampaignId,
            CampaignPerformanceReportColumn::CampaignName,
            CampaignPerformanceReportColumn::Clicks,
            CampaignPerformanceReportColumn::Impressions,
            CampaignPerformanceReportColumn::Ctr,
            CampaignPerformanceReportColumn::AverageCpc,
            CampaignPerformanceReportColumn::Spend,
            CampaignPerformanceReportColumn::QualityScore
        );

        $encodedReport = new \SoapVar(
            $report,
            SOAP_ENC_OBJECT,
            'CampaignPerformanceReportRequest',
            $GLOBALS['ReportingProxy']->GetNamespace()
        );

        return $encodedReport;
    }

    public function cronCost (Request $request) {
        $accountIds = $request->input('accountIds', '');
        $isGetLastWeek = $request->input('isGetLastWeek');
        $accountIds = explode(',', $accountIds);
        foreach ($accountIds as $key => $value) {
            $accountIds[$key] = intval($value);
        }
        set_time_limit(3600);
        $this->createAuthorization(false);
        $GLOBALS['ReportingProxy'] = new ServiceClient(
            ServiceClientType::ReportingVersion13,
            $_SESSION['AuthorizationData'],
            WebAuthHelper::GetApiEnvironment()
        );
        $GLOBALS['CustomerManagementProxy'] = new ServiceClient(
            ServiceClientType::CustomerManagementVersion13,
            $_SESSION['AuthorizationData'],
            WebAuthHelper::GetApiEnvironment());
        // Set the GetUser request parameter to an empty user identifier to get the current
        // authenticated Microsoft Advertising user, and then search for all accounts the user can access.

        $getUserRequest = new GetUserRequest();
        $getUserRequest->UserId = null;

        $user = $GLOBALS['CustomerManagementProxy']->GetService()->GetUser($getUserRequest)->User;
        $_SESSION['AuthorizationData']->CustomerId = $user->Id;
        // Search for the Microsoft Advertising accounts that the user can access.

        $pageInfo = new Paging();
        $pageInfo->Index = 0;    // The first page
        $pageInfo->Size = 1000;   // The first 1,000 accounts for this page of results
        $predicate = new Predicate();
        $predicate->Field = "UserId";
        $predicate->Operator = PredicateOperator::Equals;
        $predicate->Value = $user->Id;

        $searchAccountsRequest = new SearchAccountsRequest();
        $searchAccountsRequest->Predicates = array($predicate);
        $searchAccountsRequest->Ordering = null;
        $searchAccountsRequest->PageInfo = $pageInfo;

        $accounts = $GLOBALS['CustomerManagementProxy']->GetService()->SearchAccounts($searchAccountsRequest)->Accounts;
        foreach ($accounts->AdvertiserAccount as $account)
        {
            if (in_array($account->Id, $accountIds)) {
                $report = $this->GetCampaignPerformanceReportRequest($account->Id, $isGetLastWeek);
                $data = $this->getReport($report);
            }
        }
        $response = ['status' => 'successful'];
        return response()->json($response);
    }

    private function getReport ($report) {
//        print("-----\r\nSubmitGenerateReport:\r\n");
        $reportRequestId = ReportingExampleHelper::SubmitGenerateReport(
            $report
        )->ReportRequestId;

//        printf("Report Request ID: %s\r\n", $reportRequestId);

        $waitTime = 10 * 1;
        $requestStatus = null;
        $resultFileUrl = null;

        // This sample polls every 10 seconds up to 5 minutes.
        // In production you may poll the status every 1 to 2 minutes for up to one hour.
        // If the call succeeds, stop polling. If the call or
        // download fails, the call throws a fault.

        for ($i = 0; $i < 30; $i++)
        {
//            printf("-----\r\nsleep(%s seconds)\r\n", $waitTime);
            sleep($waitTime);

            // Get the download request status.
//            print("-----\r\nPollGenerateReport:\r\n");
            $pollGenerateReportResponse = ReportingExampleHelper::PollGenerateReport(
                $reportRequestId
            );

            $requestStatus = $pollGenerateReportResponse->ReportRequestStatus->Status;
            $resultFileUrl = $pollGenerateReportResponse->ReportRequestStatus->ReportDownloadUrl;


            if ($requestStatus == ReportRequestStatusType::Success ||
                $requestStatus == ReportRequestStatusType::Error)
            {
                break;
            }
        }

        if ($requestStatus != null)
        {
            if ($requestStatus == ReportRequestStatusType::Success)
            {
                if($resultFileUrl == null)
                {
                    print "No report data for the submitted request.\r\n";
                }
                else
                {
//                    printf("-----\r\nDownloading from %s.\r\n", $resultFileUrl);
                    $DownloadPath = public_path('/bing_report/report.zip');
                    $this->DownloadFile($resultFileUrl, $DownloadPath);
//                    printf("The report was written to %s.\r\n", $DownloadPath);
                    $this->getDataFromZipFile($DownloadPath);
                }

            }
            else if ($requestStatus == ReportRequestStatusType::Error)
            {
                printf("The request failed. Try requesting the report later.\r\n" .
                    "If the request continues to fail, contact support.\r\n"
                );
            }
            else  // Pending
            {
                printf("The request is taking longer than expected.\r\n " .
                    "Save the report ID (%s) and try again later.\r\n",
                    $reportRequestId
                );
            }
        }
    }

    private function DownloadFile($resultFileUrl, $downloadPath)
    {
        if (!$reader = fopen($resultFileUrl, 'rb'))
        {
            throw new Exception("Failed to open URL " . $resultFileUrl . ".");
        }

        if (!$writer = fopen($downloadPath, 'wb'))
        {
            fclose($reader);
            throw new Exception("Failed to create ZIP file " . $downloadPath . ".");
        }

        $bufferSize = 100 * 1024;

        while (!feof($reader))
        {
            if (false === ($buffer = fread($reader, $bufferSize)))
            {
                fclose($reader);
                fclose($writer);
                throw new Exception("Read operation from URL failed.");
            }

            if (fwrite($writer, $buffer) === false)
            {
                fclose($reader);
                fclose($writer);
                $exception = new Exception("Write operation to ZIP file failed.");
            }
        }

        fclose($reader);
        fflush($writer);
        fclose($writer);
    }

    private function getDataFromZipFile ($path) {
        $zip = new \ZipArchive();
        if ($zip->open($path) === TRUE) {
            $name =  $zip->getNameIndex(0);
            $zip->extractTo(public_path('/bing_report'));
            $zip->close();
            $row = 1;
            $countData = 0;
            if (($handle = fopen(public_path('/bing_report/' . $name), "r")) !== FALSE) {
                $dataCost = [];
                while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    if ($row == 9) {
                        $countData = str_replace('Rows: ', '', $data[0]);
                        $countData = intval($countData);
                    }
                    if ($row >= 12 && $countData > 0) {
                        preg_match('/(\d{1,2}\/\d{1,2}\/\d{4}) (\d{1,2}:\d{1,2}:\d{1,2}) .*\|(\d{1,2})/',$data[0],$matches);
                        $dateReport = date('Y-m-d', strtotime($matches[1]));
                        $hourReport = $matches[3];
                        if (isset($dataCost[$dateReport][$hourReport][$data[2]])) {
                            $dataCost[$dateReport][$hourReport][$data[2]]['click'] += $data[4];
                            $dataCost[$dateReport][$hourReport][$data[2]]['cost'] += $data[8];
//                            $dataCost[$dateReport][$data[2]]['cost_vnd'] = intval($dataCost[$data[0]][$data[2]]['cost'] * 22000);
                        } else {
                            $dataCost[$dateReport][$hourReport][$data[2]] = [
                                'ads_type' => 'bing',
                                'account_key' => $data[1],
                                'campaign_id' => $data[2],
                                'cost' => $data[8],
//                                'cost_vnd' => intval($data[8] * 22000),
                                'date_report' => $dateReport,
                                'origin_date' => $dateReport,
                                'origin_hour' => $hourReport,
                                'hour_report' => $hourReport,
                                'currency' => 'usd',
                                'campaign_name' => $data[3],
                                'click' => $data[4],
                            ];
                        }
                        $countData--;
                    }
                    $row++;
                }
                foreach ($dataCost as $dateReport => $itemsByHour) {
                    $listDataExchangeRate = $this->getDataExchangeRate($dateReport);
                    foreach ($itemsByHour as $items) {
                        foreach ($items as $item){
                            $exchangeRate = isset($listDataExchangeRate[$item['date_report']]) ? $listDataExchangeRate[$item['date_report']] : 23000;
                            $item['cost_vnd'] = intval($item['cost'] * $exchangeRate);
                            $item['exchange_rate'] = $exchangeRate;
                            $adsCost = AdsCost::where('date_report', $item['date_report'])
                                ->where('ads_type', $item['ads_type'])
                                ->where('campaign_id', $item['campaign_id'])
                                ->where('account_key', $item['account_key'])
                                ->where('hour_report', $item['hour_report'])
                                ->first();
                            if ($adsCost) {
                                $adsCost->click = $item['click'];
                                $adsCost->cost = $item['cost'];
                                $adsCost->cost_vnd = $item['cost_vnd'];
                                $adsCost->campaign_name = $item['campaign_name'];
                                $adsCost->exchange_rate = $exchangeRate;
                                $adsCost->save();
                            } else {
                                AdsCost::create($item);
                            }
                        }
                    }
                }
                fclose($handle);
            }
        }
    }



}
