<?php

namespace Modules\BingAds\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected function getDataExchangeRate ($date) {
        $retVal = [];
        $from = date('Y-m-d', strtotime('-1 day', strtotime($date)));
        $to = date('Y-m-d', strtotime('+1 day', strtotime($date)));
        $url = 'https://printerval.com/localization/exchange-rate?currency_code_to=VND&currency_code_from=USD&effective_date_from=' . $from . '&effective_date_to=' . $to;
        $data = $this->sendRequest($url);
        if ($data && is_array($data)) {
            foreach ($data as $item) {
                $retVal[$item->effective_date] = $item->rate;
            }
            $listDate = [date('Y-m-d', strtotime('-1 day', strtotime($date))), $date, date('Y-m-d', strtotime('+1 day', strtotime($date)))];
            foreach ($listDate as $itemDate) {
                if (!isset($retVal[$itemDate])) {
                    $retVal[$itemDate] = $data[0]->rate;
                }
            }
        }
        return $retVal;
    }

    protected function sendRequest($url, $method = "GET", $data = [], $validate = true) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        curl_setopt($channel, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($channel, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        $response = curl_exec($channel);
        curl_close($channel);
        $responseInJson = json_decode($response);
        return isset($responseInJson->result) ? $responseInJson->result : $responseInJson;
    }
}
