<?php

namespace Modules\BingAds\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\BingAds\Controllers\Controller;
use Modules\BingAds\Models\AdsCost;
use Module;
use Carbon\Carbon;

class HomeController extends Controller
{
    public function __construct()
    {
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS, PATCH, DELETE');
        header('Access-Control-Allow-Credentials: true');
        header('Access-Control-Allow-Headers: *');
        Module::onView("content", function() {
            return "This is content view from BingAds Module HomeController";
        }, 5);
    }
    public function index(Request $request)
    {
        $input = $request->all();
        echo '<pre>';
        print_r($input);
        echo '</pre>';
        exit();
    }

    public function getSummaryData (Request $request) {
        $input = $request->all();
        $dateFrom = $request->input('dateFrom');
        $dateTo = $request->input('dateTo');
        $dateOriginFrom = $request->input('dateOriginFrom');
        $dateOriginTo = $request->input('dateOriginTo');
        $type = $request->input('type');
        $searchStartCampaignNames = $request->input('searchStartCampaignNames');
        $searchStartCampaignName = $request->input('searchStartCampaignName');
        $searchAccountKey = $request->input('searchAccountKey');
        $searchAccountKeys = $request->input('searchAccountKeys');
        $query = DB::table('ads_cost');
        if ($dateFrom) {
            $date = new \DateTime();
            $date->setTimestamp($dateFrom);
            $date->setTimezone(new \DateTimeZone('Asia/Ho_Chi_Minh'));
            $query->where('date_report', '>=', $date->format('Y-m-d'));
        }
        if ($dateTo) {
            $date = new \DateTime();
            $date->setTimestamp($dateTo);
            $date->setTimezone(new \DateTimeZone('Asia/Ho_Chi_Minh'));
            $query->where('date_report', '<=', $date->format('Y-m-d'));
        }
        if ($dateOriginFrom) {
            $date = new \DateTime();
            $date->setTimestamp($dateOriginFrom);
            $date->setTimezone(new \DateTimeZone('Asia/Ho_Chi_Minh'));
            $query->where('origin_date', '>=', $date->format('Y-m-d'));
        }
        if ($dateOriginTo) {
            $date = new \DateTime();
            $date->setTimestamp($dateOriginTo);
            $date->setTimezone(new \DateTimeZone('Asia/Ho_Chi_Minh'));
            $query->where('origin_date', '<=', $date->format('Y-m-d'));
        }
        if ($type) {
            $query->where('ads_type', '=', $type);
        }
        if ($searchStartCampaignName) {
            $query->where('campaign_name', 'like', $searchStartCampaignName . '%');
        }
        if ($searchAccountKey) {
            $query->where('account_key', 'like', '%' . $searchAccountKey . '%');
        }
        if ($searchAccountKeys) {
            $arrSearch = explode(',', $searchAccountKeys);
            $query->whereIn('account_key', $arrSearch);
        }
        if ($searchStartCampaignNames) {
            $arrSearch = explode(',', $searchStartCampaignNames);
            $query->where(function ($q) use ($arrSearch) {
                foreach ($arrSearch as $key => $search) {
                    if ($key == 0) {
                        $q->where('campaign_name', 'like', $search . '%');
                    } else {
                        $q->orWhere('campaign_name', 'like', $search . '%');
                    }
                }
            });
        }
        $groupBy = ['ads_type', 'date_report'];
        if (array_key_exists('groupBy', $input)) {
            $groupBy = explode(',', $input['groupBy']);
        }
        $query->groupBy($groupBy);
        $orderBy = ['date_report','asc'];
        if (array_key_exists('orderBy', $input)) {
            $orderBy = explode(',', $input['orderBy']);
        }
        $query->orderBy($orderBy[0], $orderBy[1]);
        $columns = [DB::raw('sum(cost) as cost'), DB::raw('sum(cost_vnd) as cost_vnd'), DB::raw('sum(click) as click')];
        $addColumns = ['ads_type', 'date_report'];
        if (array_key_exists('columns', $input)) {
            $addColumns = explode(',', $input['columns']);
        }
        $columns = array_merge($addColumns,$columns);
        $data = $query->get($columns);
        return response()->json([
            'status' => 'successful',
            'data' => $data
        ]);
    }

    public function getDataByCampaign (Request $request) {
        $date= $request->input('date');
        $type = $request->input('type');
        $campaignId = $request->input('campaignId');
        $query = DB::table('ads_cost');
        if ($date) {
            $query->where('date_report', '=', $date);
        }
        if ($type) {
            $query->where('ads_type', '=', $type);
        }
        if ($campaignId) {
            $query->where('campaign_id', '=', $campaignId);
        }
        $query->groupBy(['ads_type', 'date_report', 'campaign_id']);
        $data = $query->first(['ads_type', 'date_report', 'campaign_id', 'campaign_name', DB::raw('sum(cost) as cost'), DB::raw('sum(cost_vnd) as cost_vnd'), DB::raw('sum(click) as click')]);
        return response()->json([
            'status' => 'successful',
            'data' => $data
        ]);
    }

    public function saveTiktokAdsCost(Request $request){
        $retVal = [
            'status' => 'fail'
        ];
        $response = $request->input('response');
        $adsType = $request->input('ads_type','tiktok');
        $accountKey = $request->input('account_key');
        $listDataExchangeRate = [];
        if ($response['status'] === 'successful' && isset($response['result']['data']['list'])) {
            $campaignData = $response['result']['data']['list'];

            foreach ($campaignData as $data) {
                $metrics = $data['metrics'];
                $dimensions = $data['dimensions'];
                $date = new \DateTime($dimensions['stat_time_hour'], new \DateTimeZone('America/New_York'));
                        if ($date) {
                            $date->setTimezone(new \DateTimeZone('Asia/Ho_Chi_Minh'));
                            $dateReport = $date->format('Y-m-d');
                            $hourReport = intval($date->format('H'));
                        }

                // Parse the date and hour from `stat_time_hour`
                $dateTime = Carbon::parse($dimensions['stat_time_hour']);
                $originDateReport = $dateTime->toDateString();
                $originHourReport = $dateTime->hour;
                if (empty($dateReport)) {
                    $dateReport = $originDateReport;
                }
                if (empty($hourReport)) {
                    $hourReport = $originHourReport;
                }
                if (empty($listDataExchangeRate)) {
                    $listDataExchangeRate = $this->getDataExchangeRate($dateReport);
                }
                 $exchangeRate = isset($listDataExchangeRate[$dateReport]) ? $listDataExchangeRate[$dateReport] : 24000;
                $cost = str_replace(',', '', $metrics['spend']);
                // Calculate cost in VND
                $costVnd = $cost * $exchangeRate;
                // Prepare data for insertion
                $adsCostData = [
                    'ads_type' => $adsType,
                    'account_key' => $accountKey,
                    'campaign_id' => $dimensions['campaign_id'],
                    'cost' => $cost,
                    'cost_vnd' => $costVnd,
                    'exchange_rate' => $exchangeRate,
                    'date_report' => $dateReport,
                    'hour_report' => $hourReport,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'currency' => 'USD', // Adjust currency if necessary
                    'campaign_name' => $metrics['campaign_name'],
                    'click' => $metrics['clicks'],
                    'origin_date' => $originDateReport,
                    'origin_hour' => $originHourReport,
                    'origin_time_zone' => 'America/New_York'
                ];

                // Insert or update the record in the database
                AdsCost::updateOrCreate(
                    [
                        'campaign_id' => $adsCostData['campaign_id'],
                        'date_report' => $adsCostData['date_report'],
                        'hour_report' => $adsCostData['hour_report'],
                        'ads_type' => $adsCostData['ads_type'],
                        'account_key' => $adsCostData['account_key'],
                    ],
                    $adsCostData
                );
            }
            $retVal['status'] = 'successful';
            $retVal['message'] = 'Update data successfully';
        }
        return response()->json($retVal);
    }
    public function saveAdsCost(Request $request){
        $retVal = [
            'status' => 'fail'
        ];
        $campaignData = $request->input('campaignData');
        $adsType = $request->input('ads_type');
        $listDataExchangeRate = [];
            foreach ($campaignData as $data) {
                $date = new \DateTime($data['origin_date'], new \DateTimeZone($data['origin_time_zone']));
                        if ($date) {
                            $date->setTimezone(new \DateTimeZone('Asia/Ho_Chi_Minh'));
                            $dateReport = $date->format('Y-m-d');
                            $hourReport = intval($date->format('H'));
                        }

                $dateTime = Carbon::parse($data['origin_date']);
                $originDateReport = $dateTime->toDateString();
                $originHourReport = $dateTime->hour;
                if (empty($dateReport)) {
                    $dateReport = $originDateReport;
                }
                if (empty($hourReport)) {
                    $hourReport = $originHourReport;
                }
                if (empty($listDataExchangeRate)) {
                    $listDataExchangeRate = $this->getDataExchangeRate($dateReport);
                }
                 $exchangeRate = isset($listDataExchangeRate[$dateReport]) ? $listDataExchangeRate[$dateReport] : 24000;
                $cost = str_replace(',', '', $data['cost']);
                // Calculate cost in VND
                $costVnd = $cost * $exchangeRate;
                // Prepare data for insertion
                $adsCostData = [
                    'ads_type' => $adsType,
                    'account_key' => $data['account_key'],
                    'campaign_id' => $data['campaign_id'],
                    'cost' => $cost,
                    'cost_vnd' => $costVnd,
                    'exchange_rate' => $exchangeRate,
                    'date_report' => $dateReport,
                    'hour_report' => $hourReport,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'currency' => $data['currency'], // Adjust currency if necessary
                    'campaign_name' => $data['campaign_name'],
                    'click' => isset($data['click'])?$data['click']:0,
                    'origin_date' => $originDateReport,
                    'origin_hour' => $originHourReport,
                    'origin_time_zone' => $data['origin_time_zone']
                ];

                // Insert or update the record in the database
                AdsCost::updateOrCreate(
                    [
                        'campaign_id' => $adsCostData['campaign_id'],
                        'date_report' => $adsCostData['date_report'],
                        'hour_report' => $adsCostData['hour_report'],
                        'ads_type' => $adsCostData['ads_type'],
                        'account_key' => $adsCostData['account_key'],
                    ],
                    $adsCostData
                );
            }
            $retVal['status'] = 'successful';
            $retVal['message'] = 'Update data successfully';
        return response()->json($retVal);
    }
}
