<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'bing-ads', 'middleware' => 'example'], function () {
    Route::get('/', [
        'as' => 'bing-ads::home',
        'uses' => 'HomeController@index',
    ]);
    Route::get('/cron/campaign', [
        'as' => 'bing-ads::cron-campaign',
        'uses' => 'CampaignController@cronCampaign'
    ]);
    Route::get('/cron/cron-cost', [
        'as' => 'bing-ads::cron-cost',
        'uses' => 'CampaignController@cronCost'
    ]);

    Route::get('/create-authorization', [
        'as' => 'bing-ads::create-authorization',
        'uses' => 'CampaignController@createAuthorization'
    ]);

    Route::get('/callback', [
        'as' => 'bing-ads::callback',
        'uses' => 'CampaignController@callback'
    ]);
});
Route::any('/adwords/store-by-ads-script', [
    'as' => 'adwords::storeByAdScript',
    'uses' => 'AdwordsController@storeByAdScript'
]);
Route::any('/adwords/store-by-ads-script-v2', [
    'as' => 'adwords::storeByAdScriptV2',
    'uses' => 'AdwordsController@storeByAdScriptV2'
]);
Route::any('/ads/get-summary-data', [
    'as' => 'ads::getSummaryData',
    'uses' => 'HomeController@getSummaryData'
]);
Route::any('/ads/get-data-by-campaign', [
    'as' => 'ads::getDataByCampaign',
    'uses' => 'HomeController@getDataByCampaign'
]);
Route::any('/tiktok/save-cost', [
    'as' => 'tiktok::saveCost',
    'uses' => 'HomeController@saveTiktokAdsCost'
]);
Route::any('/ads/save-cost', [
    'as' => 'ads::saveCost',
    'uses' => 'HomeController@saveAdsCost'
]);

