<?php


namespace Modules\BoughtTogether\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Module;
use Modules\BoughtTogether\Models\Product;
use Modules\BoughtTogether\Models\ProductBoughtTogether;
use Modules\BoughtTogether\Models\TagStatistic;

class CronController extends Controller
{

    public function initData(Request $request) {
        set_time_limit(7200);
        ini_set('memory_limit', '1024M');
        $update = $request->input('is_update');
        if (!$update) {
            return;
        }
        $startYear = 2021;
        $toYear = date('Y');
        $res = [
            'tagStatistic' => [],
            'boughtTogetherFromOrder' => [],
        ];
        for($year = $startYear; $year <= $toYear; $year++) {
            for($month = 1; $month <= 12; $month++) {
                $request->merge([
                    'month' => $month,
                    'year' => $year,
                ]);
                $res['tagStatistic'][] = $this->tagStatistic($request);
                $res['boughtTogetherFromOrder'][] = $this->boughtTogetherFromOrder($request);
            }
        }
        return $res;
    }

    public function cronFromOrder(Request $request) {
        set_time_limit(1800);
        $res['boughtTogetherFromOrder'] = $this->boughtTogetherFromOrder($request);
        $res['tagStatistic'] = $this->tagStatistic($request);
        return $res;
    }

    public function tagStatistic(Request $request) {
        set_time_limit(1800);
        \Log::info('tagStatistic', $request->all());
        $filter = $this->buildFilter($request);
        $items = $this->buildOrderQuery($filter)
            ->groupBy('order_item.product_id')
            ->get([
                DB::raw('COUNT("order_item.product_id") as total'), 'product_id'
            ]);
        $count = 0;
        if ($items) {
            $count = $this->bulkStoreTagStatistic($items, $filter['month'], $filter['year']);
        }
        $response = [
            "status" => "successful",
            "result" => $count,
        ];
        \Log::info('tagStatistic response', $response);
        return response()->json($response);
    }

    //from order
    public function boughtTogetherFromOrder(Request $request)
    {
        set_time_limit(1800);
        \Log::info('boughtTogetherFromOrder', $request->all());
        $filter = $this->buildFilter($request);
        $orders = $this->buildOrderQuery($filter)
            ->groupBy('order.id', 'order_item.product_id')
            ->get([
                'order.id', 'order_item.product_id'
            ]);
        $count = 0;
        if ($orders) {
            $boughtTogetherData = $this->buildData($orders);
            $count = $this->bulkStoreBoughtTogether($boughtTogetherData, $filter['month'], $filter['year']);
        }
        $response = [
            "status" => "successful",
            "result" => $count,
        ];
        \Log::info('boughtTogetherFromOrder response', $response);
        return response()->json($response);

    }

    protected function bulkStoreBoughtTogether($boughtTogetherData, $month, $year)
    {
        $count = 0;
        foreach ($boughtTogetherData as $productId => $items) {
            foreach ($items as $boughtTogetherId => $quantity) {
                ProductBoughtTogether::store([
                    'product_id' => $productId,
                    'bought_together_id' => $boughtTogetherId,
                    'number' => $quantity,
                    'month' => $month,
                    'year' => $year,
                ]);
                $count++;
            }

        }
        return $count;
    }


    protected function buildData($orders)
    {
        $result = [];
        $dataByOrder = $this->groupByOrder($orders);

        foreach ($dataByOrder as $orderId => $pIds) {
            if (count($pIds) == 1) {
                continue;
            }
            $boughtTogetherInOrder = $this->boughtTogetherInOrder($pIds);
            foreach ($boughtTogetherInOrder as $productId => $otherPIds) {
                if (!array_key_exists($productId, $result)) {
                    $result[$productId] = [];
                }
                foreach ($otherPIds as $otherPId) {
                    if (!array_key_exists($otherPId, $result[$productId])) {
                        $result[$productId][$otherPId] = 0;
                    }
                    $result[$productId][$otherPId]++;
                }
            }
        }
        return $result;
    }

    protected function boughtTogetherInOrder($pIds)
    {
        $result = [];

        foreach ($pIds as $mainPId) {
            $result[$mainPId] = [];
            foreach ($pIds as $otherPId) {
                if ($mainPId == $otherPId) {
                    continue;
                }
                $result[$mainPId][] = $otherPId;
            }
        }
        return $result;
    }

    protected function groupByOrder($orders)
    {
        $result = [];
        foreach ($orders as $order) {
            $result[$order->id][$order->product_id] = $order->product_id;
        }
        return $result;
    }


    private function buildOrderQuery($filter) {
        return DB::table('order')
            ->join('order_item', 'order.id', '=', 'order_item.order_id')
            ->where('order.created_at', '>=', $filter['fromTime'])
            ->where('order.created_at', '<=', $filter['toTime'])
            ->where('order.payment_status', 'PAID');
    }

    protected function bulkStoreTagStatistic($items, $month, $year) {
        $count = 0;
        foreach ($items as $item) {
            $tagIds = $this->getTagIds($item->product_id);
            $categoryId = $this->getCategory($item->product_id);
            if (!$tagIds) {
                continue;
            }
            foreach ($tagIds as $tagId) {
                $count++;
                TagStatistic::store([
                    'product_id' => $item->product_id,
                    'tag_id' => $tagId,
                    'category_id' => $categoryId,
                    'number' => $item->total,
                    'month' => $month,
                    'year' => $year,
                ]);
            }
        }
        return $count;
    }

    protected function getCategory($productId) {
        return Product::getCategory($productId);
    }

    protected function getTagIds($productId) {
        return DB::table('tag_refer')
            ->where('refer_id', $productId)
            ->where('refer_type', 'PRODUCT')
            ->pluck('tag_id')
            ->toArray();
    }


    protected function buildFilter($request)
    {
        $month = $request->input('month');
        $year = $request->input('year');
        if ($month && $year) {
            if ($month < 10) {
                $month = '0' . $month;
            }
            $fromTime = "$year-$month-01 00:00:00";
            $toTime = date("Y-m-d 23:59:59", strtotime("last day of this month", strtotime($fromTime)));

        } else {
            $day = date('j');
            $relText = $day == 1 ? 'previous' : 'this';
            $fromTime = date("Y-m-d 00:00:00", strtotime("first day of $relText month"));
            $toTime = date("Y-m-d 23:59:59", strtotime("last day of $relText month"));
            $month = date('m', strtotime("first day of $relText month"));
            $year = date('Y', strtotime("first day of $relText month"));
        }
        return compact('month', 'year', 'fromTime', 'toTime');

    }


}
