<?php

namespace Modules\BoughtTogether\Controllers;

use Illuminate\Http\Request;
use Modules\BoughtTogether\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Modules\BoughtTogether\Models\Product;
use Modules\BoughtTogether\Models\CartItem;
use Modules\BoughtTogether\Models\UserViewed;

class DataController extends Controller
{
    public function getUserViews(Request $request) {
        $retval = [];
        $token = $request->input('token', null);
        if ($token) {
            $query = UserViewed::where('imei', '=', $token);
        } else {
            $size = $request->input('size', 1000);
            $query = UserViewed::orderBy('id', 'desc')->take($size);
        }
        $fromId = $request->input('from_id', 0);
        if ($fromId > 0) {
            $query = $query->where('id', '>=', $fromId);
        }
        $retval = $query->where('type' , '=', 'product')->get(['id', 'imei', 'target']);
        return response()->json([
            'status' => 'successful',
            'result' => $retval
        ]);
    }

    public function getCartItems(Request $request) {
        $retval = [];
        $token = $request->input('token', null);
        if ($token) {
            $query = CartItem::whereHas('cart', function($q) use ($token) {
                $q->where('token', '=', $token);
            });
        } else {
            $size = $request->input('size', 20);
            $query = CartItem::with(['cart'])->take($size);
        }
        $fromId = $request->input('from_id', 0);
        if ($fromId > 0) {
            $query = $query->where('id', '>=', $fromId);
        }
        $retval = $query->orderBy('id', 'desc')->get(['id', 'product_id','cart_id']);
        return response()->json([
            'status' => 'successful',
            'result' => $retval
        ]);
    }

    public function getProducts(Request $request) {
        $ids = $request->input('ids', null);
        $ids = explode(',', $ids);
        $products = Product::whereIn('product.id', $ids)
            ->where('product.status', '=', 'ACTIVE')
            ->leftJoin('score_product', 'product.id', '=', 'score_product.id')
            ->orderBy('score_product.score', 'desc')
            ->get(['product.id', 'product.slug', 'product.sku', 'product.image_url', 'product.name', 'product.price', 'product.high_price', 'product.sold', 'product.view_count', 'product.created_at', 'score_product.score']);
        return response()->json([
            'status' => 'successful',
            'result' => $products
        ]);
    }

    public function getProductCollections(Request $request) {
        $retval = [
            'status' => 'successful'
        ];
        $productId = $request->input('id', null);
        $product = Product::where('id', $productId)
            ->where('status', '=', 'ACTIVE')
            ->first(['id']);
        if ($product != NULL) {
            $retval['categories'] = $product->categories->toArray();
            $retval['tags'] = [];
            foreach ($product->tags as $item) {
                $tag = $item->toArray();
                $tag['image_url'] = '';
                if ($item->images != null) {
                    $tagImages = $item->images->toArray();
                    $tagImages = json_decode($tagImages['string_value']);
                    if (count($tagImages) > 0) {
                        $tag['image_url'] = $tagImages[0];
                    }
                }
                $retval['tags'][] = $tag;
            }
        }
        return response()->json($retval);
    }
}
