<?php

namespace Modules\BoughtTogether\Controllers\Mobile;

use DB;
use Modules\BoughtTogether\Models\Product;
use Modules\BoughtTogether\Controllers\HomeController;

class MobileHomeController extends HomeController
{
    public function buildBoughtTogetherQuery($productIds) {
        return Product::where("product.status", "ACTIVE")
        ->leftJoin('product_custom', 'product.id', 'product_custom.product_id')
        ->whereNull('product_custom.product_id')
        ->whereIn("product.id", array_slice($productIds, 0, 8));
    }
}