<?php
namespace Modules\BoughtTogether\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use SoftDeletes;
    protected $table = 'product';
    protected $guarded = ['id'];

    protected $fillable = [
        'sku',
        'barcode',
        'name',
        'slug',
        'image_url',
        'price',
        'high_price',
        'add_shipping_fee',
        'weight',
        'status',
        'description',
        'content',
        'note',
        'inventory',
        'brand_id',
        'status_out_stock',
        'pod_parent_id',
        "approve_advertising",
        'created_at',
        'updated_at',
        'gtin'
    ];
    protected $variantDefault = null;

    protected $appends = [
        'url', 'display_price', 'display_high_price'
    ];

    public function getUrlAttribute () {
        $retval = isset($_SERVER['PREFIX_URL']) ? $_SERVER['PREFIX_URL'] : '';
        return clroute($retval . "/" . (!empty($this->slug) ? $this->slug : "san-pham") . "-p" . $this->id);
    }

    public function tags() {
        return $this->belongsToMany(Tag::class, 'tag_refer' ,'refer_id', 'tag_id')
            ->where('refer_type', TagRefer::REFER_PRODUCT);
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class, 'product_n_category', 'product_id', 'category_id')->select(["category.id", "category.slug", "category.image_url", "category.name", "category.breadcrumb", "category.is_valid_print_back"])->withPivot('is_parent');
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function variantDefault()
    {
        return $this->hasMany(ProductSku::class, 'product_id', 'id')->where('is_default', 1);
    }

    public function getDisplayPriceAttribute() {
        if ($this->price > 0) {
            $this->price = doubleval($this->price);
            return formatPrice($this->price);
        } else {
            return translate('Liên hệ');
        }
    }

    public function getDisplayHighPriceAttribute() {
        if ($this->high_price > 0) {
            $this->high_price = doubleval($this->high_price);
            return formatPrice($this->high_price);
        }
        return;
    }

    public static function getCategory($productId) {
        $item =  DB::table('product_n_category')
            ->where('product_id', $productId)
            ->where('is_parent', 0)
            ->first(['category_id']);
        return $item && isset($item->category_id) ? $item->category_id : 0;
    }
}
