<?php

namespace Modules\BoughtTogether\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ProductBoughtTogether extends Model
{
    protected $table = 'product_bought_together';
    protected $guarded = ['id'];
    public $timestamps = true;

    public static function isExists($data)
    {
        return self::queryItem($data)->exists();
    }

    public static function store($data)
    {
        if (self::isExists($data)) {
            self::queryItem($data)->update([
                'number' => $data['number']
            ]);
        } else {
            self::create($data);
        }
    }

    private static function queryItem($data, $useDB = false)
    {
        $query = $useDB ? DB::table('product_bought_together') : self::query();
        if (array_key_exists('product_id', $data)) {
            $query->where('product_id', $data['product_id']);
        }
        if (array_key_exists('bought_together_id', $data)) {
            $query->where('bought_together_id', $data['bought_together_id']);
        }
        if (array_key_exists('month', $data)) {
            $query->where('month', $data['month']);
        }
        if (array_key_exists('year', $data)) {
            $query->where('year', $data['year']);
        }
        if (array_key_exists('from_time', $data) && $data['from_time']) {
            $month = date('n', strtotime($data['from_time']));
            $year = date('Y', strtotime($data['from_time']));

            $query->where(function ($where) use ($month, $year) {
                $where->where(function ($whereChild) use ($month, $year) {
                    $whereChild->where('month', '>=', $month)
                        ->where('year', '=', $year);
                })->orWhere(function ($orWhereChild) use ($month, $year) {
                    $orWhereChild->where('year', '>', $year);
                });
            });
        }
        return $query;
    }


    public static function isExistsProduct($productId)
    {
        return self::queryItem([
            'product_id' => $productId
        ])->exists();
    }

    public static function getByProduct($productId, $fromTime = null)
    {
        $query = self::queryItem([
            'product_id' => $productId,
        ], true);
        return $query
            ->groupBy('bought_together_id')
            ->orderBy(DB::raw('SUM(number)'), 'desc')
            ->limit(10)
            ->pluck('bought_together_id')
            ->toArray();
    }

}
