<?php

namespace Modules\BoughtTogether\Models;

use Illuminate\Database\Eloquent\Model;

class ProductSku extends Model
{
    protected $table = 'product_sku';

    protected $fillable = [
        'sku',
        'barcode',
        'price',
        'high_price',
        'image_url',
        'product_id',
        'is_default',
        'sale_percent',
        'display_drop_price',
        'inventory',
        'status'
    ];
    protected $appends = ['product_name'];

    public function getProductNameAttribute()
    {
        $name = '';
        $productVariantName = [];
        if ($this->product_id && $this->id) {
            $productOrigin = Product::find($this->product_id);
            if (!isset($productOrigin->name)) {
                return $name;
            }
            $skuValues = ProductSkuValue::where('sku_id', '=', $this->id)->get();
            $listProductSku = ProductSkuValue::where('product_id', $this->product_id)->get();

            $groupProductsSku = [];
            foreach ($listProductSku as $sku) {
                $groupProductsSku[$sku->sku_id][] = $sku;
            }

            $variantOptionIds = [];
            foreach ($skuValues as $skuValue) {
                if ($skuValue->variant_id && $skuValue->variant_option_id) {
                    $variant = ProductVariant::find($skuValue->variant_id);
                    $variantOption = ProductVariantOption::find($skuValue->variant_option_id);
                    if ($variantOption) {
                        $variantOptionIds[] = $variantOption->id;
                        $attrName = $variantOption->name;
                        
                        $productVariantName[] = [
                            "variant" => $variant,
                            "variantOption" => $variantOption,
                            "name" => $attrName
                        ];
                    }
                    
                }
            }

            foreach ($productVariantName as $key => $groupVariantName) {
                $name .= $groupVariantName['name'];
                if ($key < count($productVariantName) - 1) {
                    $name .= ", ";
                }
            }
        }

        return $name;
    }
}
