<?php
namespace Modules\BoughtTogether\Models;


use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Tag extends Model
{
    protected $table = "tag";
    protected $fillable = [];    

    public function images() {
        return $this->hasOne(TagMeta::class)
            ->where('key', '=', 'top_product_images')
            ->select(['string_value']);
    }


    public static function getTags($productId) {
        return DB::table('tag_refer')
            ->where('refer_id', $productId)
            ->where('refer_type', 'PRODUCT')
            ->pluck('tag_id')
            ->toArray();
    }

}
