<?php

namespace Modules\BoughtTogether\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class TagStatistic extends Model
{
    protected $table = 'tag_statistic';
    protected $guarded = ['id'];
    public $timestamps = true;

    public static function isExists($data)
    {
        return self::queryItem($data)->exists();
    }

    public static function store($data)
    {
        if (self::isExists($data)) {
            self::queryItem($data)->update([
                'number' => $data['number']
            ]);
        } else {
            self::create($data);
        }
    }

    private static function queryItem($data)
    {
        return self::query()
            ->where('tag_id', $data['tag_id'])
            ->where('product_id', $data['product_id'])
            ->where('category_id', $data['category_id'])
            ->where('month', $data['month'])
            ->where('year', $data['year']);
    }

    public static function getTopProduct($tagIds, $excludeCategoryId)
    {
        if (!$tagIds) {
            return [];
        }
        $result = [];
        $items = DB::table('tag_statistic')
            ->whereIn('tag_id', $tagIds)
            ->groupBy('product_id')
            ->orderBy(DB::raw('SUM(number)'), 'desc')
            ->limit(20)
            ->pluck('category_id', 'product_id');

        if ($items) {
            foreach ($items as $productId => $categoryId) {
                if ($categoryId == $excludeCategoryId) {
                    continue;
                }
                $result[] = $productId;
            }
            if ($excludeCategoryId && count($result) < 10) {
                foreach ($items as $productId => $categoryId) {
                    if ($categoryId == $excludeCategoryId) {
                        $result[] = $productId;
                    }
                }
            }

        }
        return $result;

    }
}
