productPageModule.filter("trusted", ["$sce", function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
}]);

productPageModule.controller("BoughtTogetherController", function($scope, $http) {
    $scope.mainProduct = btgMainProduct;
    $scope.currentItem = {};
    $scope.currentVariant = {};
    $scope.variantOptionSelected = {};
    $scope.variantImageSelected = {};
    $scope.variants = {};
    $scope.productsBoughtTogether = [];
    $scope.moreProductsBoughtTogether = [];
    $scope.isLoading = false;
    $scope.totalPrice = 0;
    $scope.totalSavePrice = 0;
    $scope.loadingMakeChange = false;
    $scope.totalProducts = 0;
    $scope.limitBoughtTogether = btgLimitBoughtTogether;
    $scope.showSeeMore = btgShowSeeMore;
    $scope.listAddedToCart = [];
    $scope.relatedProducts = [];
    $scope.customer = {
        token: token
    };
    $scope.ignoreOptionIds = ignoreOptionIds;
    $scope.variantsStatistic = [];
    $scope.productVariants = [];
    $scope.variantByOption = {};
    $scope.optionById = {};
    $scope.hasSize = false;
    $scope.selectedSize = null;
    $scope.optionTree = {};
    $scope.selectSizeText = $scope.chooseSizeText;
    $scope.printLocations = printLocationsBoughtTogether;
    $scope.printLocationsPrice = printLocationsPrice;

    $scope.findBoughtTogetherProducts = (productId) => {
        return new Promise(function(resolve) {
            let limit = $scope.limitBoughtTogether;
            let url = "/bought-together/find?limit=" + limit + "&product_id=" + productId;
            if (localePrefix) url = '/' + localePrefix + url;
            $http({
                method: "GET",
                url: url,
            }).then(function successCallback(response) {
                if (response.data.status == "successful") {
                    $scope.productsBoughtTogether = response.data.result;
                    $scope.productsBoughtTogether.forEach((element, index) => {
                        element.variantName = "";
                        if (element.is_valid_print_back) {
                            element.print_location = "front";
                            element.tmp_print_location = "front";
                        }
                        if (element.variant_default.length > 0) {
                            element.variantName = element.variant_default[0].product_name;
                            element.price = element.variant_default[0].price;
                            element.high_price = element.variant_default[0].high_price;
                            element.product_sku_id = element.variant_default[0].id;
                            element.status = element.variant_default[0].status;
                        }
                        element.is_select = false;
                        if (!element.is_custom_design) {
                            element.is_select = true;
                        }
                        element.price = parseFloat(parseFloat(element.price).toFixed(2));
                        element.high_price = parseFloat(parseFloat(element.high_price).toFixed(2));
                        $scope.buildPricePrintLocation(element);

                        // $scope.productsBoughtTogether[idnex]
                    });
                    $scope.totalProducts = response.data.count;
                    resolve();
                }
            }).catch(function errorCallback(err) {
                console.log(err);
                resolve();
            });
        });
    };

    $scope.buildTmpSku = (item) => {
        return {
            id: item.product_sku_id,
            product_id: item.id,
            price: item.price,
            high_price: item.high_price,
            status: item.status,
            printLocationData: item.printLocationData ? item.printLocationData : null,
            variants: item.currentVariant ? item.currentVariant.variants : []
        }
    }

    $scope.findChangingItem = function () {
        if (!$scope.currentItem || !$scope.currentItem.id) {
            return;
        }
        for (let key in $scope.productsBoughtTogether) {
            if ($scope.productsBoughtTogether[key] && $scope.productsBoughtTogether[key].id == $scope.currentItem.id) {
                return $scope.productsBoughtTogether[key];
            }
        }

        return $scope.mainProduct;
    }

    $scope.openFormChangeVariant = async (item, type = "normal") => {
        item.loadingMakeChange = true;
        $scope.variantOptionSelected = {};
        $scope.variantImageSelected = {};
        $scope.variants = {};
        $scope.products = {};
        await $scope.getProduct(item);
        $scope.$applyAsync(function() {
            if (type == "normal") {
                $scope.productsBoughtTogether.forEach((element, index) => {
                    if (element.id == item.id) {
                        if (
                            !$scope.productsBoughtTogether[index].tmp_sku ||
                            !$scope.productsBoughtTogether[index].tmp_sku.variants || 
                            !$scope.productsBoughtTogether[index].tmp_sku.variants.length
                        ) {
                            $scope.productsBoughtTogether[index].tmp_sku = $scope.buildTmpSku(element);
                        }
                    }
                });
            } else {
                if (
                    !$scope.mainProduct.tmp_sku ||
                    !$scope.mainProduct.tmp_sku.variants || 
                    !$scope.mainProduct.tmp_sku.variants.length
                ) {
                    $scope.mainProduct.tmp_sku = $scope.buildTmpSku($scope.mainProduct);
                }
            }
            item.loadingMakeChange = false;
        });
        $scope.currentItem = angular.copy(item);
        $('.bought-together-change').addClass('active-change-item');
        $('body').addClass('make-change-item-product');
    }

    $scope.getMainProduct = (productId) => {
        return new Promise(function(resolve) {
            let url = "/product/find?id=" + productId;
            if (localePrefix) url = '/' + localePrefix + url;
            $http({
                method: "GET",
                url: url,
            }).then(function successCallback(response) {
                if (response.data.status == "successful") {
                    $scope.mainProduct = response.data.result;
                    if ($scope.mainProduct.variant_default && $scope.mainProduct.variant_default.id) {
                        $scope.mainProduct.product_sku_id = $scope.mainProduct.variant_default.id;
                        $scope.mainProduct.price = parseFloat($scope.mainProduct.variant_default.price);
                        $scope.mainProduct.high_price = parseFloat($scope.mainProduct.variant_default.high_price);
                        if ($scope.mainProduct.variant_default.image_url) {
                            $scope.mainProduct.image_url = $scope.mainProduct.variant_default.image_url;
                        }
                    }
                    resolve();
                }
            }).catch(function errorCallback(err) {
                console.log(err);
                resolve();
            });
        });
    }
    $scope.getProduct = (item) => {
        return new Promise(function(resolve) {
            let url = "/product/find?id=" + item.id;
            if (localePrefix) url = '/' + localePrefix + url;
            $http({
                method: "GET",
                url: url,
            }).then(function successCallback(response) {
                if (response.data.status == "successful") {
                    $scope.currentProduct = response.data.result;
                    resolve();
                }
            }).catch(function errorCallback() {
                resolve();
            });
        });
    }

    $scope.getLoadingSvgClass = (item) => {
        let classSvg = "bi bi-arrow-repeat";
        if ($scope.loadingMakeChange && $scope.currentProduct && item.id == $scope.currentProduct.id) {
            classSvg += " loading";
        }
        return classSvg;
    }

    $scope.getItemName = (item) => {
        let name = "";
        if (item.currentVariant && item.currentVariant.id) {
            name = item.currentVariant.variants.map(option => option.name).filter(itemName => itemName).join(', ');
        }
        return name;
    }

    $scope.addAllToCart = () => {
        $scope.loading = true;
        let data = [];
        $scope.productsBoughtTogether.forEach(element => {
            if (element.is_select && element.status == "ACTIVE") {
                let config = {};
                if (element.printLocationData && element.printLocationData.position) {
                    config = {};
                    config.print_location = element.printLocationData.position.value;
                } else if (element.print_location) {
                    config = {};
                    config.print_location = element.print_location;
                }
                data.push({
                    productId: element.id,
                    productSkuId: element.product_sku_id ? element.product_sku_id : null,
                    quantity: 1,
                    configurations: config ? JSON.stringify(config) : {},
                });
            }
        });
        if (data.length == 0) {
            toastr.error(displayTrans.choose_at_least_one_product);
            $scope.loading = false;
            return;
        }
        if ($scope.mainProduct.variant_default.length > 0 && !$scope.mainProduct.currentVariant) {
            toastr.error(displayTrans.choose_product_variant);
            $scope.loading = false;
            return;
        }
        if ($scope.mainProduct.currentVariant && $scope.mainProduct.currentVariant.status != "ACTIVE") {
            toastr.error(displayTrans.product_inactive);
            $scope.loading = false;
            return;
        }
        let configMain = {};
        if ($scope.mainProduct.printLocationData && $scope.mainProduct.printLocationData.position) {
            configMain = {};
            configMain.print_location = $scope.mainProduct.printLocationData.position.value;
        }
        data.push({
            productId: $scope.mainProduct.id,
            productSkuId: $scope.mainProduct.product_sku_id ? $scope.mainProduct.product_sku_id : null,
            quantity: 1,
            configurations: configMain ? JSON.stringify(configMain) : {},
        });
        let url = '/bought-together/add-all-to-cart';
        if (localePrefix) url = '/' + localePrefix + url;
        var addCartReqParams = {
            url: url,
            method: 'POST',
            data: {
                data: data,
                productId: $scope.mainProduct.id,
                token: $scope.customer.token
            }
        };
        $http(addCartReqParams).then(async (response) => {
            if (response.data.status == "successful") {
                $scope.showCartPopup(response.data.result)
                $scope.relatedProducts = response.data.relatedProducts;
                $('.add-all-item-list').html("");
                $('.add-all-item-list').removeClass('slick-initialized slick-slider');
               
                let html = "";
                $scope.relatedProducts.forEach(item => {
                    html += `
                        <div class="addallitem-box">
                            <a class="add-all-item-link" href="${ item.url }?internal_source=bought-together" target="_blank">
                            <picture>
                                <source media="(max-width:767px)" srcset="${ $scope.getImageCdn(item.image_url, 360, 360, true) }">
                                <source media="(min-width:768px)" srcset="${ $scope.getImageCdn(item.image_url, 540, 540, true) }">
                                <img class="addallitem-image" ng-src="${ $scope.getImageCdn(item.image_url, 540, 540, true) }" alt="Discover ${ item.name }">
                            </picture>
                            </a>
                            <div class="add-all-item-title-box flex-b align-c">
                                <a class="md-product-title" href="${ item.url }?internal_source=bought-together" target="_blank">
                                    ${ item.name }
                                </a>
                            </div>
                            <span class="add-all-item-price">
                                ${ $scope.formatPrice(item.price) }
                                `;
                    if (item.high_price > item.price) {
                        html += `
                                <del>${ $scope.formatPrice(item.high_price) }</del>
                            `;
                    }
                    html += `
                            </span>
                        </div>
                        `;
                });
                $('.add-all-item-list').html(html);
                
                $scope.loading = false;
            }
        })

    }

    $scope.showCartPopup = (cartItems) => {
        $scope.listAddedToCart = [];
        let isAdd = false;
        cartItems.forEach((element) => {
            if (element.product_id == $scope.mainProduct.id) {
                if (!isAdd) {
                    $scope.listAddedToCart.push(element);
                    isAdd = true;
                }
            } else {
                var addItem = {};
                $scope.productsBoughtTogether.forEach(item => {
                    if (item.is_select) {
                        if (element.product_id == item.id && element.product_sku_id == item.product_sku_id) {
                            let config = {};
                            if (item.printLocationData && item.printLocationData.position) {
                                config.print_location = item.printLocationData.position.value;
                            } else {
                                if (item.is_valid_print_back) {
                                    config.print_location = "front";
                                }
                            }
                            if (JSON.stringify(config) == element.configurations) {
                                addItem = element;
                            }
                        }
                    }
                });
                if (addItem && addItem.product_id) {
                    $scope.listAddedToCart.push(addItem);
                }
            }
        })
        let listAdd = angular.copy($scope.listAddedToCart);
        for (let index = 0; index < listAdd.length; index++) {
            const element = listAdd[index];
            element.quantity = 1;
        }
        let detail = {
            listAdd: listAdd,
            cartItems: cartItems
        }
        window.dispatchEvent(new CustomEvent('item-add-to-cart', {detail: detail}))
        window.dispatchEvent(new CustomEvent('change-cart', {detail: {showCart: true}}));
        localStorage.setItem("change-cart", Date.now());
        // $('.add-all-item-popup').addClass('active');
        // $('body').addClass('open-addall')
    }

    $scope.loadMore = () => {
        let url = "/bought-together/find?limit=-1&product_id=" + $scope.mainProduct.id;
        if (localePrefix) url = '/' + localePrefix + url;
        $http({
            method: "GET",
            url: url,
        }).then(function successCallback(response) {
            if (response.data.status == "successful") {
                $scope.productsBoughtTogether = [];
                $scope.moreProductsBoughtTogether = response.data.result;
                $scope.moreProductsBoughtTogether.forEach(product => {
                    product.price = parseFloat(parseFloat(product.price).toFixed(2));
                    product.high_price = parseFloat(parseFloat(product.high_price).toFixed(2));
                });
            }
        }).catch(function errorCallback() {
        });
    }

    $scope.getCustomerToken = () => {
        return new Promise(function (resolve) {
            var locale = '';
            if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
                locale = `/${localePrefix}`;
            }
            $scope.loading = true;
            var url = `${locale}/cart/get-customer-token`;
            $http({
                method: "GET",
                url: url,
            }).then(
                function successCallback(response) {
                    if (response.data.status == "successful") {
                        $scope.customer.token = response.data.result;
                    }
                    $scope.loading = false;
                    resolve();
                },
                function errorCallback(response) {
                    resolve();
                }
            );
        });
    }

    function getCartItems() {
        var pTemplate = "{{ getCurrencyTemplate() }}";
        var locale = '';
        if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
            locale = '/' + localePrefix;
        }
        let cart_id = localStorage.getItem("cart_id" + locale);
        let url = '/cart/get-cart-items';
        if (cart_id) {
            url += '?cart_id=' + cart_id;
        }
        var getCartReqParams = {
            url: url,
            method: 'GET'
        };
        $.ajax(getCartReqParams)
            .done(function(result) {
                if (result.status == 'successful') {
                    $("#list-cart-items").html("");
                    // $(".mini-cart-list").show();
                    $("#cart-error").hide();
                    var html = "";
                    var quantity = 0;
                    result.result.forEach((element) => {
                        quantity += parseInt(element.quantity);
                        html += `
                            <a class="mini-cart-item flex-box" href="${locale}${element.url}">
                                <picture>
                                    <source media="(max-width:767px)" srcset="${getImageCdn(element.image_url, 360, 360)}">
                                    <source media="(min-width:768px)" srcset="${getImageCdn(element.image_url, 540, 540)}">
                                    <img src="${getImageCdn(element.image_url, 540, 540)}" alt="Copyright @Printerval.com">
                                </picture>
                                
                                <div class="mini-cart-content">
                                    <div class="mini-cart-head">
                                        ${element.product_name}
                                    </div>
                                    <div class="mini-cart-info flex-box align-c ">
                                        <span class="new-price">${$scope.formatPrice(element.price)}
                        `;
                        if (element.high_price && element.high_price > element.price) {
                            html += `<span class="discount-price" style="text-decoration: line-through;">${$scope.formatPrice(element.high_price)}</span>`
                        }
                        html += `</span><span style"color: red;">&times;</span>
                                            <span class="quantity-mini-cart"> ${element.quantity}</span>
                                        </div>
                                    </div>
                                </a>
                        `;
                    });
                    $("#list-cart-items").append(html);
                    $(".js-mini-cart-count").text(parseInt(quantity));
                    if (parseInt(quantity) > 0) {
                        $(".js-mini-cart-count").show();
                    }
                    $(".cart-icon").replaceWith($(".cart-icon").clone());
                }
            });
    }

    $scope.cancelForm = () => {
        $('.bought-together-change').removeClass('active-change-item');
        $('body').removeClass('make-change-item-product');
    }

    $scope.onSaveItem = (element) => {
        element.currentVariant = element.tmp_sku;
        element.product_sku_id = element.currentVariant.id;
        element.status = element.currentVariant.status;
        element.price = parseFloat(element.currentVariant.price);
        element.high_price = parseFloat(element.currentVariant.high_price);
        if (element.currentVariant.image_url) {
            element.image_url = element.currentVariant.image_url;
        }
        element.variantName = $scope.getItemName(element);
        element.printLocationData = element.currentVariant.printLocationData;
        $scope.buildPricePrintLocation(element);
    }

    $scope.save = ($event, item) => {
        $scope.onSaveItem(item);
        $scope.originVariant = null;
        $scope.currentItem = {};
        $scope.getTotalPrice();
        $scope.getTotalSavePrice();
        $('.bought-together-change').removeClass('active-change-item');
        $('body').removeClass('make-change-item-product');
    }

    $scope.getImageCdn = window.getImageCdn;

    $scope.formatPrice = function(price, numberAdd = 1, format = true) {
        if (format) {
            if (typeof btgPriceConfig != 'undefined' && btgPriceConfig) {
                price = (parseFloat(price) + parseFloat(btgPriceConfig.adding_price) * numberAdd) * parseFloat(btgPriceConfig.ratio);
            }
            price = decimalAdjust('ceil', price);
        }
        return formatPrice(price, priceTempate);
    };

    $scope.getTotalPrice = () => {
        let price = 0;
        $scope.productsBoughtTogether.forEach(element => {
            if (element.is_select) {
                let priceItem = parseFloat(element.price);
                if (typeof btgPriceConfig != 'undefined') {
                    priceItem += parseFloat(btgPriceConfig.adding_price);
                    priceItem *= parseFloat(btgPriceConfig.ratio);
                }
                price += decimalAdjust('ceil', priceItem);
            }
        });
        let priceMain = parseFloat($scope.mainProduct.price);
        if (typeof btgPriceConfig != 'undefined') {
            priceMain += parseFloat(btgPriceConfig.adding_price);
            priceMain *= parseFloat(btgPriceConfig.ratio);
        }
        price += decimalAdjust('ceil', priceMain);
        $scope.$applyAsync(function() {
            $scope.totalPrice = price;
        })
    }

    $scope.getTotalSavePrice = () => {
        let price = 0;
        $scope.productsBoughtTogether.forEach(element => {
            if (element.is_select && element.price < element.high_price) {
                price += parseFloat(element.high_price) - parseFloat(element.price);
            }
        });
        if ($scope.mainProduct.price < $scope.mainProduct.high_price) {
            price += parseFloat($scope.mainProduct.high_price) - parseFloat($scope.mainProduct.price);
        }
        $scope.$applyAsync(function() {
            $scope.totalSavePrice = parseFloat(price.toFixed(2));
        })
    }

    $scope.onRevertChange = (element) => {
        element.image_url = $scope.currentItem.image_url;
    }

    $scope.closeChange = () => {
        $scope.loadingMakeChange = false;
        let isFound = false;
        $scope.productsBoughtTogether.forEach(element => {
            if (element.id == $scope.currentItem.id) {
                $scope.onRevertChange(element);
                isFound = true;
            }
        });
        if (!isFound) {
            $scope.onRevertChange($scope.mainProduct);
        }
        $scope.currentItem = null;
        $scope.originVariant = null;
        $scope.getTotalPrice();
        $scope.getTotalSavePrice();
        $('.bought-together-change').removeClass('active-change-item');
        $('body').removeClass('make-change-item-product');
    }

    $scope.initial = async () => {
        let productid = $("#productId").val();
        await $scope.getCustomerToken();
        await Promise.all([
            $scope.findBoughtTogetherProducts(productid),
        ]);
        $scope.getTotalPrice();
        $scope.getTotalSavePrice();

        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply();
        }

        if (screen.width < 960) {
            $(document).on('click', '.make-change-button', function() {
                $('.bought-together-change').addClass('active-change-item');
                $('body').addClass('make-change-item-product')
            })
        } else {
            $('.make-change-button').mouseup(function(e) {
                $('.bought-together-change').removeClass('active-change-item');
                $(e.target).parents('.bought-together-change').addClass('active-change-item');
                $('html, body').animate({
                    scrollTop: $('.bought-together-list-item').offset().top
                }, 500)
            });

        }

        setTimeout(() => {
            if (window.globalVariants) {
                $scope.$apply(function () {
                    $scope.buildMainProductVariantName(window.globalVariants)
                })
            }
        }, 3000);
    }

    window.addEventListener('variantChanged', function (event, data) {
        let detail = angular.copy(event.detail);
        $scope.currentVariant = detail;
        if (detail.variants) {
            if (typeof detail.variants[0] === 'object') {
                $scope.currentVariant.variants = detail.variants.map(i => i.id);
            }
        }
        if ($scope.currentVariant.gallery.length) {
            $scope.currentVariant.image_url = $scope.currentVariant.gallery[0];
        }
        $scope.mainProduct.currentVariant = detail;
        if (typeof detail.variants[0] === 'object') {
            $scope.mainProduct.currentVariant.variants = detail.variants.map(i => i.id);
        }
        $scope.mainProduct.product_sku_id = $scope.currentVariant.id;
        $scope.mainProduct.price = parseFloat($scope.currentVariant.price);
        $scope.mainProduct.high_price = parseFloat($scope.currentVariant.high_price);
        if ($scope.currentVariant.image_url) {
            $scope.mainProduct.image_url = $scope.currentVariant.image_url;
        }
        $scope.mainProduct.variantName = $scope.getItemName({currentVariant: angular.copy(event.detail)});
        $scope.buildPricePrintLocation($scope.mainProduct);
    })

    window.addEventListener('changePrintLocation', function (event) {
        if ($scope.mainProduct) {
            $scope.mainProduct.printLocationData = event.detail;
            $scope.buildPricePrintLocation($scope.mainProduct);
        }
    })

    $scope.checkThemeVariantColor = (slug) => {
        let retVal = 'dark';
        if (lightVariantColors.includes(slug)) {
            retVal = 'light';
        }
        return retVal;
    }

    $(document).on('click', '.add-all-item-popup-bg, .close-addallitem, .continue-shipping-button', function () {
        $('.add-all-item-popup').removeClass('active');
        $('body').removeClass('open-addall')
    })

    $scope.getByField = function (list, fieldName, value) {
        var retVal = null;
        list.forEach(function (item) {
            if (item[fieldName] == value) {
                retVal = item;
            }
        });
        return retVal;
    };

    $scope.onChangePrintLocation = function (data) {
        let changingItem = $scope.findChangingItem();
        if (changingItem && changingItem.tmp_sku) {
            changingItem.tmp_sku.printLocationData = data;
        }
    }

    $scope.onChangeSku = function (value) {
        for (let key in $scope.productsBoughtTogether) {
            if ($scope.productsBoughtTogether[key].id == value.product_id) {
                $scope.productsBoughtTogether[key].tmp_sku = value;
                $scope.handleChangeSku($scope.productsBoughtTogether[key], value);
                break;
            }
        }
    }

    $scope.onChangeMainSku = function (value) {
        $scope.handleChangeSku($scope.mainProduct, value);
    }

    $scope.handleChangeSku = function (item, value) {
        if (value.gallery && value.gallery.length) {
            item.image_url = value.gallery[0];
        }
        value.printLocationData = item.tmp_sku.printLocationData;
        item.tmp_sku = value;
    }

    $scope.initial();

    $scope.getAdditionalPrintLocationPrice = (price, printLocationData) => {
        let addPrice = $scope.buildAddPrice(price, printLocationData);
        price = parseFloat(price) + addPrice;
        price = parseFloat(price).toFixed(3);
        return parseFloat(price);
    }

    $scope.buildAddPrice = (price, printLocationData) => {
        let addPrice = 0;
        if (printLocationData && printLocationData.additional_price) {
            if (printLocationData.additional_price.type == 'percent') {
                addPrice = parseFloat(price) * printLocationData.additional_price.value;
            } else {
                addPrice = printLocationData.additional_price.value;
            }
        }
        return addPrice;
    }

    $scope.buildPricePrintLocation = (item) => {
        if (!item.price) {
            return;
        }
        item.show_price = parseFloat(item.price);
        item.show_high_price = parseFloat(item.high_price);
        if (item.printLocationData) {
            item.show_price = $scope.getAdditionalPrintLocationPrice(parseFloat(item.price), item.printLocationData)
            item.show_high_price = $scope.getAdditionalPrintLocationPrice(parseFloat(item.high_price), item.printLocationData)
        }
    }

    $scope.buildMainProductVariantName = function (data) {
        if ($scope.mainProduct && $scope.mainProduct.variant_default) {
            let spid = $scope.mainProduct.variant_default.id;
            let optionIds = [];
            let productSku = data.productVariants.find(item => item.id == spid);

            if (productSku) {
                let optionIds = productSku.variants.map(id => parseInt(id));
                let variantNames = [];

                for (let variant of data.variants) {
                    for (let option of variant.values) {
                        if (optionIds.includes(parseInt(option.id))) {
                            variantNames.push(option.name);
                        }
                    }
                }

                $scope.mainProduct.variantName = variantNames.join(', ');
            }
        }
    }

    $scope.changeSelectItem = (index) => {
        const item = $scope.productsBoughtTogether[index];
        $scope.productsBoughtTogether.forEach(element => {
            if (item.id == element.id) {
                element.is_select = !item.is_select;
            }
        });
        $scope.getTotalPrice();
        $scope.getTotalSavePrice();
    }

    window.addEventListener('doneGetVariant', function (event) {
        let data = event.detail;
        $scope.buildMainProductVariantName(data);
    })
});