productPageModule.filter("trusted", ["$sce", function ($sce) {
    return function (val) {
        return $sce.trustAsHtml(val);
    };
}]);

productPageModule.controller("BoughtTogetherController", function($scope, $http) {
    $scope.mainProduct = {};
    $scope.currentItem = {};
    $scope.currentProduct = {};
    $scope.currentVariant = {};
    $scope.variantOptionSelected = {};
    $scope.variantImageSelected = {};
    $scope.variants = {};
    $scope.productsBoughtTogether = [];
    $scope.moreProductsBoughtTogether = [];
    $scope.isLoading = false;
    $scope.totalPrice = 0;
    $scope.totalSavePrice = 0;
    $scope.loadingMakeChange = false;
    $scope.totalProducts = 0;
    $scope.limitBoughtTogether = btgLimitBoughtTogether;
    $scope.showSeeMore = btgShowSeeMore;
    $scope.listAddedToCart = [];
    $scope.relatedProducts = [];
    $scope.customer = {
        token: token
    };
    $scope.ignoreOptionIds = ignoreOptionIds;
    $scope.variantsStatistic = [];
    $scope.productVariants = [];
    $scope.variantByOption = {};
    $scope.optionById = {};
    $scope.hasSize = false;
    $scope.selectedSize = null;
    $scope.optionTree = {};
    $scope.selectSizeText = $scope.chooseSizeText;
    $scope.printLocations = printLocationsBoughtTogether;
    $scope.printLocationsPrice = printLocationsPrice;
    $scope.btgVariantBases = {};
    $scope.loadingBoughtTogetherProducts = true;

    $scope.findBoughtTogetherProducts = (productId) => {
        return new Promise(function(resolve) {
            let limit = $scope.limitBoughtTogether;
            let url = "/bought-together/find?limit=" + limit + "&product_id=" + productId;
            if (localePrefix) url = '/' + localePrefix + url;
            $http({
                method: "GET",
                url: url,
            }).then(function successCallback(response) {
                if (response.data.status == "successful") {
                    $scope.productsBoughtTogether = response.data.result;
                    $scope.productsBoughtTogether.forEach((element, index) => {
                        element.variantName = "";
                        if (element.is_valid_print_back) {
                            element.print_location = "front";
                            element.tmp_print_location = "front";
                        }
                        if (element.variant_default.length > 0) {
                            element.variantName = element.variant_default[0].product_name;
                            element.price = element.variant_default[0].price;
                            element.high_price = element.variant_default[0].high_price;
                            element.product_sku_id = element.variant_default[0].id;
                            element.status = element.variant_default[0].status;
                        }
                        element.is_select = false;
                        if (!element.is_custom_design) {
                            element.is_select = true;
                        }
                        element.price = parseFloat(parseFloat(element.price).toFixed(2));
                        if (element.attributes.print_locations) {
                            element.attributes.print_locations.forEach(item => {
                                const matchingPrintLocation = $scope.printLocations.find(location => location.value === item.value);
                                if (matchingPrintLocation) {
                                    item.selectImage = matchingPrintLocation.selectImage;
                                    item.defaultImage = matchingPrintLocation.defaultImage;
                                } else {
                                    // Optional: Set to default or null if no match is found
                                    item.selectImage = null;
                                    item.defaultImage = null;
                                }
                            });
                        } else {
                            element.attributes.print_locations = $scope.printLocations;
                        }
                        element.high_price = parseFloat(parseFloat(element.high_price).toFixed(2));
                        $scope.buildPricePrintLocation(element);

                        // $scope.productsBoughtTogether[idnex]
                    });
                    $scope.totalProducts = response.data.count;
                    resolve();
                }
            }).catch(function errorCallback(err) {
                console.log(err);
                resolve();
            });
        });
    };

    $scope.openFormChangeVariant = async (item, type = "normal") => {
        item.loadingMakeChange = true;
        $scope.productVariants = [];
        $scope.variantsStatistic = {};
        $scope.variantByOption = {};
        $scope.optionById = {};
        $scope.hasSize = false;
        $scope.selectedSize = null;
        $scope.optionTree = {};
        $scope.selectSizeText = $scope.chooseSizeText;
        $scope.currentItem = item;
        $scope.currentProduct = {};
        $scope.currentVariant = item;
        $scope.variantOptionSelected = {};
        $scope.variantImageSelected = {};
        $scope.variants = {};
        $scope.products = {};
        $scope.btgVariantBases = {};
        $scope.groupVariants = [];
        $scope.globalIsSelectSize = false;
        $scope.originVariant = null;
        await $scope.getProduct(item);
        await $scope.changeVariant(item, type);
        if (type == "normal") {
            $scope.productsBoughtTogether.forEach(element => {
                if (element.id == item.id) {
                    element.tmp_print_location = element.print_location;
                }
            });
        } else {
            $scope.mainProduct.tmp_print_location = $scope.mainProduct.print_location;
        }
        $scope.$apply(function() {
            item.loadingMakeChange = false;
        });
        $('.bought-together-change').addClass('active-change-item');
        $('body').addClass('make-change-item-product');
    }

    $scope.getMainProduct = (productId) => {
        return new Promise(function(resolve) {
            let url = "/product/find?id=" + productId;
            if (localePrefix) url = '/' + localePrefix + url;
            $http({
                method: "GET",
                url: url,
            }).then(function successCallback(response) {
                if (response.data.status == "successful") {
                    $scope.mainProduct = response.data.result;
                    if ($scope.mainProduct.variant_default && $scope.mainProduct.variant_default.id) {
                        $scope.mainProduct.product_sku_id = $scope.mainProduct.variant_default.id;
                        $scope.mainProduct.price = parseFloat($scope.mainProduct.variant_default.price);
                        $scope.mainProduct.high_price = parseFloat($scope.mainProduct.variant_default.high_price);
                        if ($scope.mainProduct.variant_default.image_url) {
                            $scope.mainProduct.image_url = $scope.mainProduct.variant_default.image_url;
                        }
                    }
                    if ($scope.mainProduct.attributes.print_locations) {
                        $scope.mainProduct.attributes.print_locations.forEach(item => {
                            const matchingPrintLocation = $scope.printLocations.find(location => location.value === item.value);
                            if (matchingPrintLocation) {
                                item.selectImage = matchingPrintLocation.selectImage;
                                item.defaultImage = matchingPrintLocation.defaultImage;
                            } else {
                                // Optional: Set to default or null if no match is found
                                item.selectImage = null;
                                item.defaultImage = null;
                            }
                        });
                    } else {
                        $scope.mainProduct.attributes.print_locations = $scope.printLocations;
                    }
                    if ($scope.mainProduct.is_valid_print_back) {
                        $scope.mainProduct.print_location = Object.values($scope.mainProduct.attributes.print_locations)[0].value;
                        $scope.mainProduct.tmp_print_location = Object.values($scope.mainProduct.attributes.print_locations)[0].value;
                    }
                    $scope.buildPricePrintLocation($scope.mainProduct);
                    resolve();
                }
            }).catch(function errorCallback(err) {
                console.log(err);
                resolve();
            });
        });
    }
    $scope.getProduct = (item) => {
        return new Promise(function(resolve) {
            let url = "/product/find?id=" + item.id;
            if (localePrefix) url = '/' + localePrefix + url;
            $http({
                method: "GET",
                url: url,
            }).then(function successCallback(response) {
                if (response.data.status == "successful") {
                    $scope.currentProduct = response.data.result;
                    resolve();
                }
            }).catch(function errorCallback() {
                resolve();
            });
        });
    }

    $scope.getLoadingSvgClass = (item) => {
        let classSvg = "bi bi-arrow-repeat";
        if ($scope.loadingMakeChange && $scope.currentProduct && item.id == $scope.currentProduct.id) {
            classSvg += " loading";
        }
        return classSvg;
    }

    $scope.changeVariant = (item, type) => {
        return new Promise(function(resolve) {
            $scope.loading = true;
            let url = '/v2/product/variant/' + item.id;
            if (localePrefix) url = '/' + localePrefix + url;
            let pv2 = getParameterByName("pv2");
            if (pv2) {
                url += '?pv2=' + pv2;
            }
            $http.get(url)
                .then(res => {
                    try {
                        if (res.data.status == 'successful') {
                            if (res.data.status == 'successful') {
                                $scope.variants = res.data.result.variants;
                                $scope.productVariants = res.data.result.productVariants.filter(item => item.variants.length > 0);
                                $scope.onChangeVariant(item, type);
                            }
                        }

                        $scope.loading = false;
                        resolve();
                    } catch (error) {
                        console.log(error);
                        $scope.loading = false;
                        resolve();
                    }
                }, err => {
                    $scope.loading = false;
                    resolve();
                })
        })
    }

    $scope.onChangeVariant = function (item, type) {
        for (let i of $scope.variants) {
            if (i.slug == 'size') {
                $scope.hasSize = true;
                break;
            }
        }
        $scope.buildVariantByOption();
        $scope.buildVariantsStatistic();
        $scope.buildChangeVariant(type, item);
        if (type == 'main') {
            $scope.mainProduct.variantName = $scope.getItemName($scope.mainProduct);
        }
    }

    $scope.buildChangeVariant = (type, item = null) => {
        $scope.products = buildProductVariants();
        $scope.btgVariantBases = buildVariantBase();
        if ($scope.variants.length > 0) {
            if (type == "normal") {
                let currentProductBoughtTogether = null;
                if (item) {
                    currentProductBoughtTogether = $scope.productsBoughtTogether.find(i => i.id == item.id);
                }
                if (currentProductBoughtTogether && currentProductBoughtTogether.currentVariant && currentProductBoughtTogether.currentVariant.id) {
                    $scope.currentVariant = currentProductBoughtTogether.currentVariant;
                } else {
                    $scope.currentVariant = $scope.products.productById[$scope.currentProduct.variant_default.id];
                }
            } else {
                if ($scope.mainProduct.currentVariant && $scope.mainProduct.currentVariant.id) {
                    $scope.currentVariant = $scope.mainProduct.currentVariant;
                    if (typeof $scope.mainProduct.currentVariant.variants[0] === 'object') {
                        $scope.currentVariant.variants = $scope.mainProduct.currentVariant.variants.map(i => i.id);
                    }
                    if (!$scope.mainProduct.currentVariant.image_url) {
                        $scope.mainProduct.currentVariant.image_url = $scope.mainProduct.image_url;
                    }
                } else {
                    let spid = getParameterByName("spid");
                    if (spid) {
                        $scope.currentVariant = $scope.products.productById[spid];
                    } else {
                        $scope.currentVariant = $scope.products.productById[$scope.mainProduct.variant_default.id];
                    }
                    $scope.mainProduct.currentVariant = $scope.currentVariant;
                    if ($scope.mainProduct.currentVariant.image_url) {
                        $scope.mainProduct.image_url = $scope.mainProduct.currentVariant.image_url;
                    }
                    if ($scope.mainProduct.currentVariant.id) {
                        $scope.mainProduct.product_sku_id = $scope.mainProduct.currentVariant.id;
                    }
                    if ($scope.mainProduct.currentVariant.price) {
                        $scope.mainProduct.price = parseFloat($scope.mainProduct.currentVariant.price);
                    }
                    if ($scope.mainProduct.currentVariant.high_price) {
                        $scope.mainProduct.high_price = parseFloat($scope.mainProduct.currentVariant.high_price);
                    }
                }
            }

            $scope.variants.forEach((element, index) => {
                element.show_invalid = index == 0;
                if ($scope.variants[0].type != 'OPTION') {
                    if (index <= $scope.variants.length - 3) {
                        element.show_invalid = true;
                    }
                    if (index <= $scope.variants.length - 2 && element.type != "IMAGE") {
                        element.show_invalid_above = true;
                    }
                }
            });
            $scope.groupVariants = angular.copy($scope.variants);
            $scope.buildSelectedVariant();
            $scope.rebuildVariants();
            if (!$scope.originVariant) {
                $scope.originVariant = angular.copy($scope.currentVariant);
            }
        }
    }

    $scope.initVariants = function (variants) {
        retVal = [];

        for (let variant of variants) {
            variant.values = variant.values.filter(value => !$scope.ignoreOptionIds.includes(parseInt(value.id)));
            retVal.push(variant);
        }

        return retVal;
    }

    $scope.buildSelectedVariant = () => {
        if ($scope.currentVariant && $scope.currentVariant.variants && $scope.variants) {
            $scope.variants.forEach(element => {
                let currentOption = $scope.currentVariant.variants.find(id => $scope.variantByOption[id] == element.id);
                if (element.type == "OPTION") {
                    $scope.variantOptionSelected[element.id] = currentOption;
                } else if (element.type == "IMAGE" && $scope.optionById[currentOption] && $scope.optionById[currentOption].name) {
                    $scope.variantImageSelected[element.id] = $scope.optionById[currentOption].name;
                }
            });
        } else {
            $scope.currentVariant = $scope.currentProduct;
        }
    }

    $scope.rebuildVariants = (option = null) => {
        let selectedSize = false;
        if (option && option.slug == 'size') {
            selectedSize = option.id;
        }
        for (let index = 0; index < $scope.variants.length; index++) {
            const variant = angular.copy($scope.variants[index]);
            if (option && option.id && option.id == variant.id) {
                continue;
            }
            let anotherVariant = $scope.currentVariant.variants.filter(id => $scope.variantByOption[id] != variant.id);
            let variantKey = "";
            anotherVariant.forEach(id => {
                if (typeof id === 'object') {
                    variantKey += id.id + "-";
                } else {
                    variantKey += id + "-";
                }
            });
            let optionGroup = [];
            let currentProductBySpid = $scope.products.productById[$scope.currentVariant.id];
            variant.values.forEach(item => {
                let prefixVariant = '';
                let variantIsOk = true;
                if (variant.slug == 'style' && index > 0) {
                    if (anotherVariant && anotherVariant.length >= 2) {
                        prefixVariant = anotherVariant[0] + '-' + item.id;
                        variantIsOk = false;
                        if (selectedSize || getParameterByName("spid")) {
                            let keyWithColor = currentProductBySpid.variants.filter(id => $scope.variantByOption[id] != 2).map(id => $scope.variantByOption[id] == $scope.variantByOption[item.id] ? item.id : id).join('-');
                            if ($scope.variantsStatistic[keyWithColor]) {
                                variantIsOk = true;
                                prefixVariant = keyWithColor;
                            }
                        }
                        if (prefixVariant && $scope.variantsStatistic) {
                            if ($scope.variantsStatistic[prefixVariant]) {
                                variantIsOk = true;
                            } else if ($scope.variantsStatistic[item.id + '-' + anotherVariant[0]]) {
                                variantIsOk = true;
                                prefixVariant = item.id + '-' + anotherVariant[0];
                            }

                            if (!$scope.variantsStatistic[prefixVariant]) {
                                for (let key in $scope.variantsStatistic) {
                                    if (key.indexOf(variantKey.id + '-') === 0) {
                                        prefixVariant = key;
                                        variantIsOk = true;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                let itemVariantKey = variantKey + item.id;
                if (variantIsOk && (($scope.products.productByUniqId[itemVariantKey] && $scope.products.productByUniqId[itemVariantKey].id) || variant.show_invalid)) {
                    optionGroup.push(item);
                }
            });
            $scope.groupVariants.forEach(item => {
                if (item.id == variant.id) {
                    item.values = optionGroup;
                }
            });
        }
    }

    $scope.selectVariant = (group, option = null, item = null) => {
        let listOptionIds = [];
        $scope.currentVariant.variants.forEach(id => {
            let isExists = false;
            for (let index = 0; index < group.values.length; index++) {
                const item = group.values[index];
                if (item.id == id) {
                    isExists = true;
                    break;
                }
            }
            if (!isExists) {
                listOptionIds.push(id);
            }
        });
        let key = "";
        if (option != null) {
            key = option.id;
        } else {
            key = $scope.variantOptionSelected[group.id];
        }
        listOptionIds.forEach(id => {
            key += "-" + id;
        });
        let lastImageUrl = $scope.currentVariant.image_url;
        $scope.currentVariant = $scope.changeCurrentVariant(key, group, option);
        if ($scope.selectedSize || group.slug == 'size') {
            let selectedSizeId = $scope.currentVariant.variants.find(id => $scope.variantByOption[id] == 1)
            if (selectedSizeId) {
                $scope.selectedSize = selectedSizeId;
                $scope.selectSizeText = $scope.optionById[selectedSizeId].name + $scope.getPriceVariant($scope.optionById[selectedSizeId], $scope.variantByOption[selectedSizeId], item)
            }
        }
        $scope.buildSelectedVariant();
        $scope.rebuildVariants(group);
        if ($scope.currentVariant.gallery.length) {
            $scope.currentVariant.image_url = $scope.currentVariant.gallery[0];
        } else {
            $scope.currentVariant.image_url = lastImageUrl;
        }
        if ($scope.currentVariant.price) {
            item.price = $scope.currentVariant.price;
        }
        if ($scope.currentVariant.high_price) {
            item.high_price = $scope.currentVariant.high_price;
        }
        if ($scope.currentVariant.image_url) {
            item.image_url = $scope.currentVariant.image_url;
        }
        $scope.buildPricePrintLocation(item);
    }

    $scope.changeCurrentVariant = function (key, group, valueWantToChange) {
        if ($scope.products.productByUniqId[key]) {
            return $scope.products.productByUniqId[key];
        } else {
            let newKey = $scope.buildCallbackProductVariantKey(key, group.id, valueWantToChange);
            if ($scope.products.productByUniqId[newKey]) {
                return $scope.products.productByUniqId[newKey];
            }
        }
    }
    $scope.buildCallbackProductVariantKey = (key, variantId, valueWantToChange) => {
        let oldOptionIds = key.split('-');
        let optionByVariant = {};
        let optionByVariantSorted = [];
        for (let variant of $scope.variants) {
            let optionIds = variant.values.map(item => item.id + '');
            for (let optionId of oldOptionIds) {
                if (optionIds.includes(optionId)) {
                    optionByVariant[variant.id] = optionId;
                    optionByVariantSorted.push({
                        variant_id: variant.id,
                        option_id: optionId
                    });
                    break;
                }
            }
        }
        let newKey = key;
        if ($scope.selectedSize) {
            let tmpOptionByVariant = Object.fromEntries(Object.entries(optionByVariant).filter(([key]) => !key.includes(2)));
            let likeKey = Object.values(tmpOptionByVariant).join('-');
            for (let uniqKey in $scope.products.productByUniqId) {
                if (uniqKey.indexOf(likeKey) == 0) {
                    newKey = uniqKey;
                    break;
                }
            }
    
            if (!$scope.products.productByUniqId[newKey]) {
                let variantIndex = -1;
                for (let index in $scope.groupVariants) {
                    if ($scope.groupVariants[index].id == variantId) {
                        variantIndex = index;
                        break;
                    }
                }
                if (variantIndex >= 0 && variantIndex < $scope.groupVariants.length - 1 && $scope.groupVariants[variantIndex + 1]) {
                    let minPrice = 9999999999;
                    for (let value of scope.groupVariants[variantIndex + 1].values) {
                        tmpOptionByVariant = {...optionByVariant};
                        tmpOptionByVariant[value.variant_id] = value.id;
                        optionIds = Object.values(tmpOptionByVariant);
                        let tmpNewKey = optionIds.join('-');
                        if ($scope.products.productByUniqId[newKey] && $scope.products.productByUniqId[newKey].price < minPrice) {
                            optionByVariant = tmpOptionByVariant;
                            newKey = tmpNewKey;
                        }
                    }
                }
            }
        }

        if (!$scope.products.productByUniqId[newKey]) {
            let currentIndex = 0;
            for (let index in $scope.btgVariantBases.variantIds) {
                if ($scope.btgVariantBases.variantIds[index] == variantId) {
                    currentIndex = parseInt(index);
                    break;
                }
            }
            for (let index = currentIndex; index >= 0; index--) {
                let likeIds = oldOptionIds.slice(0, index + 1);
                let likeKey = likeIds.join('-') + '-';
                let minPrice = 9999999999999;
                let maxIncludeCount = 0;
                for (let uniqKey in $scope.products.productByUniqId) {
                    if (uniqKey.indexOf(likeKey) == 0) {
                        let includeCount = uniqKey.split('-').filter(optionId => oldOptionIds.includes(optionId)).length;
                        if (includeCount < maxIncludeCount || parseFloat($scope.products.productByUniqId[uniqKey].price) > parseFloat(minPrice)) {
                            continue;
                        }
                        if (parseFloat($scope.products.productByUniqId[uniqKey].price) <= parseFloat(minPrice)) {
                            newKey = uniqKey;
                            minPrice = parseFloat($scope.products.productByUniqId[uniqKey].price);
                            if (includeCount > maxIncludeCount) {
                                maxIncludeCount = includeCount;
                            }
                        }
                    }
                }
                if ($scope.products.productByUniqId[newKey]) {
                    break;
                }
            }
        }

        return newKey;
    }

    $scope.getOptionIds = function (optionIds, valueWantToChange, result = []) {
        result.push(valueWantToChange.id);
        if (valueWantToChange.options && valueWantToChange.options.length) {
            let option = valueWantToChange.options[0];
            let values = []
            for (let item of $scope.variants) {
                if (item.id == option.variant_id) {
                    values = item.values;
                    break;
                }
            }
            let availableOptionIds = valueWantToChange.options.map(value => value.id);
            for (let item of values) {
                if (availableOptionIds.includes(item.id)) {
                    option = item;
                    break;
                }
            }

            for (let item of valueWantToChange.options) {
                if (optionIds.includes(item.id + '')) {
                    option = item;
                    break;
                }
            }
            result = $scope.getOptionIds(optionIds, option, result);
        }

        return result;
    }

    function buildVariantBase() {
        var retVal = {};
        var variantIds = [];
        var variantById = {};
        var variantOptionById = {};
        if ($scope.variants) {
            for (var i = 0; i < $scope.variants.length; i++) {
                variantIds.push($scope.variants[i].id);
                variantById[$scope.variants[i].id] = $scope.variants[i].name;
                for (var j = 0; j < $scope.variants[i].values.length; j++) {
                    variantOptionById[$scope.variants[i].values[j].id] = $scope.variants[i].values[j].name;
                }
            }
        }
        retVal["variantIds"] = variantIds;
        retVal["variantById"] = variantById;
        retVal["variantOptionById"] = variantOptionById;
        return retVal;
    }

    function buildProductVariants() {
        var productById = {};
        var productByUniqId = {};
        if ($scope.productVariants) {
            $scope.productVariants.forEach(function(item) {
                productById[item.id] = item;
                var variantOptionIds = angular.copy(item.variants);
                if (variantOptionIds.length > 0) {
                    var permutes = permute(variantOptionIds);
                    for (var i = 0; i < permutes.length; i++) {
                        var key = permutes[i].join("-");
                        productByUniqId[key] = item;
                    }
                }
            });
        }
        var retVal = {
            productById: productById,
            productByUniqId: productByUniqId,
        };
        return retVal;
    }

    $scope.isSelected = (variant, type = "ELSE") => {
        let result = false;
        if ($scope.currentVariant && $scope.currentVariant.variants) {
            let isExists = $scope.currentVariant.variants.find(id => id == variant.id);
            if (isExists) {
                result = true;
            }
        }
        return result;
    }

    $scope.getPriceVariant = (option, groupId, item = null) => {
        let result = "";
        if ($scope.variants.length > 0) {
            let key = option.id;
            let listIndex = [];
            $scope.currentVariant.variants.forEach(element => {
                if ($scope.variantByOption[element] != groupId) {
                    key += "-" + element;
                    listIndex.push(element);
                }
            });
            let currentProductBySpid = $scope.products.productById[$scope.currentVariant.id];
            if (key in $scope.products.productByUniqId) {
                let price = $scope.products.productByUniqId[key].price;
                if (item.print_location) {
                    price = $scope.getAdditionalPrintLocationPrice(price, item.tmp_print_location, item.category_ids);
                }
                result = " (" + $scope.formatPrice(price) + ")";
            } else {
                let prefixVariant = '';
                let variantIsOk = true;
                if (listIndex && listIndex.length >= 2) {
                    prefixVariant = listIndex[0] + '-' + option.id;
                    variantIsOk = false;
                    if ($scope.selectedSize || ($scope.currentVariant && $scope.currentVariant.id)) {
                        let keyWithColor = currentProductBySpid.variants.filter(id => $scope.variantByOption[id] != 2).map(id => $scope.variantByOption[id] == $scope.variantByOption[option.id] ? option.id : id).join('-');
                        if ($scope.variantsStatistic[keyWithColor]) {
                            variantIsOk = true;
                            prefixVariant = keyWithColor;
                        }
                    }
                    if (prefixVariant && $scope.variantsStatistic) {
                        if ($scope.variantsStatistic[prefixVariant]) {
                            variantIsOk = true;
                        } else if ($scope.variantsStatistic[option.id + '-' + listIndex[0]]) {
                            variantIsOk = true;
                            prefixVariant = option.id + '-' + listIndex[0];
                        }
                    }
                }
                if (variantIsOk && key) {
                    if (prefixVariant && $scope.variantsStatistic && $scope.variantsStatistic[prefixVariant] && $scope.products.productByUniqId[key]) {
                        let price = $scope.products.productByUniqId[key].price;
                        if (item.print_location) {
                            price = $scope.getAdditionalPrintLocationPrice(price, item.tmp_print_location, item.category_ids);
                        }
                        result = " (" + $scope.formatPrice(price) + ")";
                    }
                }
            }
        }
        return result;
    }

    $scope.isFullImage = (item) => {
        let result = true;
        for (let index = 0; index < item.values.length; index++) {
            const element = item.values[index];
            if (!element.image_url) {
                result = false;
            }
        }
        return result;
    }

    $scope.getItemName = (item) => {
        let name = "";
        if (item.currentVariant && item.currentVariant.id) {
            let variantOptionById = null;
            if ($scope.btgVariantBases && $scope.btgVariantBases.variantOptionById) {
                variantOptionById = $scope.btgVariantBases.variantOptionById;
            } else if (globalVariants && globalVariants.variants.length) {
                variantOptionById = {}
                for (let variant of globalVariants.variants) {
                    for (let option of variant.values) {
                        variantOptionById[option.id] = option.name;
                    }
                }
            }

            if (variantOptionById) {
                item.currentVariant.variants.forEach((optionId, index) => {
                    if (variantOptionById[optionId]) {
                        name += variantOptionById[optionId];
                        if (index < item.currentVariant.variants.length - 1) {
                            name += ", ";
                        }
                    }
                });
            }
        }
        return name;
    }

    $scope.changeSelectItem = (item) => {
        $scope.productsBoughtTogether.forEach(element => {
            if (item.id == element.id) {
                element.is_select = !item.is_select;
            }
        });
        $scope.getTotalPrice();
        $scope.getTotalSavePrice();
    }

    $scope.selectPrintLocation = (type, printLocation, item) => {
        if (type == 'main') {
            $scope.mainProduct.tmp_print_location = printLocation.value;
        } else {
            $scope.productsBoughtTogether.forEach(element => {
                if (element.id == item.id) {
                    element.tmp_print_location = printLocation.value;
                }
            });
        }
        $scope.currentProduct.tmp_print_location = printLocation.value;
        $scope.buildPricePrintLocation(item);
    }

    $scope.buildVariantByOption = () => {
        $scope.variantByOption = {};
        $scope.optionById = {};
        $scope.variants.forEach(variant => {
            variant.values.forEach(item => {
                $scope.variantByOption[item.id] = variant.id
                $scope.optionById[item.id] = item;
            })
        })
    }

    $scope.buildVariantsStatistic = () => {
        $scope.variantsStatistic = {}
        if ($scope.variants.length < 2) {
            return;
        }
        let firstOptionIndex = 0;
        for (let key in $scope.variants) {
            if ($scope.variants[key].type == 'OPTION') {
                firstOptionIndex = parseInt(key);
                break;
            }
        }
        for (let item of $scope.productVariants) {
            let vKeyArr = item.variants.filter((value, index) => index <= firstOptionIndex).map(item => item);
            for (let i = firstOptionIndex + 1; i < item.variants.length; i++) {
                let vKey = vKeyArr.join('-') + '-' + item.variants[i];
                if (!$scope.variantsStatistic[vKey]) {
                    $scope.variantsStatistic[vKey] = {
                        sku_key: item.variants.join('-'),
                        count: 1,
                        price: item.price,
                        high_price: item.high_price
                    }
                } else {
                    $scope.variantsStatistic[vKey].count++;
                    if (item.price < $scope.variantsStatistic[vKey]) {
                        $scope.variantsStatistic[vKey].sku_key = item.variants.join('-');
                        $scope.variantsStatistic[vKey].price = item.price;
                        $scope.variantsStatistic[vKey].high_price = item.high_price;
                    }
                }
            }

            let vKey = vKeyArr.join('-');

            if (!$scope.variantsStatistic[vKey]) {
                $scope.variantsStatistic[vKey] = {
                    sku_key: item.variants.join('-'),
                    count: 1,
                    price: item.price,
                    high_price: item.high_price
                }
            } else {
                $scope.variantsStatistic[vKey].count++;
                if (item.price < $scope.variantsStatistic[vKey]) {
                    $scope.variantsStatistic[vKey].sku_key = item.variants.join('-');
                    $scope.variantsStatistic[vKey].price = item.price;
                    $scope.variantsStatistic[vKey].high_price = item.high_price;
                }
            }
        }
    }

    $scope.addAllToCart = () => {
        $scope.loading = true;
        let data = [];
        $scope.productsBoughtTogether.forEach(element => {
            if (element.is_select && element.status == "ACTIVE") {
                let config = {};
                if (element.print_location) {
                    config.print_location = element.print_location;
                }
                data.push({
                    productId: element.id,
                    productSkuId: element.product_sku_id ? element.product_sku_id : null,
                    quantity: 1,
                    configurations: JSON.stringify(config),
                });
            }
        });
        if (data.length == 0) {
            toastr.error(displayTrans.choose_at_least_one_product);
            $scope.loading = false;
            return;
        }
        if ($scope.mainProduct.variant_default.length > 0 && !$scope.mainProduct.currentVariant) {
            toastr.error(displayTrans.choose_product_variant);
            $scope.loading = false;
            return;
        }
        if ($scope.mainProduct.currentVariant && $scope.mainProduct.currentVariant.status != "ACTIVE") {
            toastr.error(displayTrans.product_inactive);
            $scope.loading = false;
            return;
        }
        let configMain = null;
        if ($scope.mainProduct.print_location) {
            configMain = {};
            configMain.print_location = $scope.mainProduct.print_location;
        }
        data.push({
            productId: $scope.mainProduct.id,
            productSkuId: $scope.mainProduct.product_sku_id ? $scope.mainProduct.product_sku_id : null,
            quantity: 1,
            configurations: configMain ? JSON.stringify(configMain) : null,
        });
        let url = '/bought-together/add-all-to-cart';
        if (localePrefix) url = '/' + localePrefix + url;
        var addCartReqParams = {
            url: url,
            method: 'POST',
            data: {
                data: data,
                productId: $scope.mainProduct.id,
                token: $scope.customer.token
            }
        };
        $http(addCartReqParams).then(async (response) => {
            if (response.data.status == "successful") {
                $scope.showCartPopup(response.data.result)
                $scope.relatedProducts = response.data.relatedProducts;
                $('.add-all-item-list').html("");
                $('.add-all-item-list').removeClass('slick-initialized slick-slider');
               
                let html = "";
                $scope.relatedProducts.forEach(item => {
                    html += `
                        <div class="addallitem-box">
                            <a class="add-all-item-link" href="${ item.url }?internal_source=bought-together" target="_blank">
                                <picture>
                                    <source media="(max-width:767px)" srcset="${ $scope.getImageCdn(item.image_url, 360, 360, true) }">
                                    <source media="(min-width:768px)" srcset="${ $scope.getImageCdn(item.image_url, 540, 540, true) }">
                                    <img src="${getImageCdn(item.image_url, 540, 540)}" alt="Discover ${ item.name }">
                                </picture>
                            </a>
                            <div class="add-all-item-title-box flex-b align-c">
                                <a class="md-product-title" href="${ item.url }?internal_source=bought-together" target="_blank">
                                    ${ item.name }
                                </a>
                            </div>
                            <span class="add-all-item-price">
                                ${ $scope.formatPrice(item.price) }
                                `;
                    if (item.high_price > item.price) {
                        html += `
                                <del>${ $scope.formatPrice(item.high_price) }</del>
                            `;
                    }
                    html += `
                            </span>
                        </div>
                        `;
                });
                $('.add-all-item-list').html(html);
                
                $scope.loading = false;
            }
        })

    }

    $scope.showCartPopup = (cartItems) => {
        $scope.listAddedToCart = [];
        let isAdd = false;
        cartItems.forEach((element) => {
            if (element.product_id == $scope.mainProduct.id) {
                if (!isAdd) {
                    $scope.listAddedToCart.push(element);
                    isAdd = true;
                }
            } else {
                var addItem = {};
                $scope.productsBoughtTogether.forEach(item => {
                    if (item.is_select) {
                        if (element.product_id == item.id && element.product_sku_id == item.product_sku_id) {
                            let config = {};
                            if (item.print_location) {
                                config.print_location = item.print_location;
                            }
                            if (JSON.stringify(config) == element.configurations) {
                                addItem = element;
                            }
                        }
                    }
                });
                if (addItem && addItem.product_id) {
                    $scope.listAddedToCart.push(addItem);
                }
            }
        })
        let listAdd = angular.copy($scope.listAddedToCart);
        for (let index = 0; index < listAdd.length; index++) {
            const element = listAdd[index];
            if (!element.quantity) {
                element.quantity = 1;
            }
        }
        let detail = {
            listAdd: listAdd,
            cartItems: cartItems
        }
        window.dispatchEvent(new CustomEvent('item-add-to-cart', {detail: detail}))
        window.dispatchEvent(new CustomEvent('change-cart', {detail: {showCart: true}}));
        localStorage.setItem("change-cart", Date.now());
        // $('.add-all-item-popup').addClass('active');
        // $('body').addClass('open-addall')
    }

    $scope.loadMore = () => {
        let url = "/bought-together/find?limit=-1&product_id=" + $scope.mainProduct.id;
        if (localePrefix) url = '/' + localePrefix + url;
        $http({
            method: "GET",
            url: url,
        }).then(function successCallback(response) {
            if (response.data.status == "successful") {
                $scope.productsBoughtTogether = [];
                $scope.moreProductsBoughtTogether = response.data.result;
                $scope.moreProductsBoughtTogether.forEach(product => {
                    product.price = parseFloat(parseFloat(product.price).toFixed(2));
                    product.high_price = parseFloat(parseFloat(product.high_price).toFixed(2));
                });
            }
        }).catch(function errorCallback() {
        });
    }

    $scope.getCustomerToken = () => {
        return new Promise(function (resolve) {
            var locale = '';
            if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
                locale = `/${localePrefix}`;
            }
            $scope.loading = true;
            var url = `${locale}/cart/get-customer-token`;
            $http({
                method: "GET",
                url: url,
            }).then(
                function successCallback(response) {
                    if (response.data.status == "successful") {
                        $scope.customer.token = response.data.result;
                    }
                    $scope.loading = false;
                    resolve();
                },
                function errorCallback(response) {
                    resolve();
                }
            );
        });
    }

    function getCartItems() {
        var pTemplate = "{{ getCurrencyTemplate() }}";
        var locale = '';
        if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
            locale = '/' + localePrefix;
        }
        let cart_id = localStorage.getItem("cart_id" + locale);
        let url = '/cart/get-cart-items';
        if (cart_id) {
            url += '?cart_id=' + cart_id;
        }
        var getCartReqParams = {
            url: url,
            method: 'GET'
        };
        $.ajax(getCartReqParams)
            .done(function(result) {
                if (result.status == 'successful') {
                    $("#list-cart-items").html("");
                    // $(".mini-cart-list").show();
                    $("#cart-error").hide();
                    var html = "";
                    var quantity = 0;
                    result.result.forEach((element) => {
                        quantity += parseInt(element.quantity);
                        html += `
                            <a class="mini-cart-item flex-box" href="${locale}${element.url}">
                                <picture>
                                    <source media="(max-width:767px)" srcset="${getImageCdn(element.image_url, 360, 360)}">
                                    <source media="(min-width:768px)" srcset="${getImageCdn(element.image_url, 540, 540)}">
                                    <img src="${getImageCdn(element.image_url, 540, 540)}" alt="Copyright @Printerval.com">
                                </picture>
                                
                                <div class="mini-cart-content">
                                    <div class="mini-cart-head">
                                        ${element.product_name}
                                    </div>
                                    <div class="mini-cart-info flex-box align-c ">
                                        <span class="new-price">${$scope.formatPrice(element.price)}
                        `;
                        if (element.high_price && element.high_price > element.price) {
                            html += `<span class="discount-price" style="text-decoration: line-through;">${$scope.formatPrice(element.high_price)}</span>`
                        }
                        html += `</span><span style"color: red;">&times;</span>
                                            <span class="quantity-mini-cart"> ${element.quantity}</span>
                                        </div>
                                    </div>
                                </a>
                        `;
                    });
                    $("#list-cart-items").append(html);
                    $(".js-mini-cart-count").text(parseInt(quantity));
                    if (parseInt(quantity) > 0) {
                        $(".js-mini-cart-count").show();
                    }
                    $(".cart-icon").replaceWith($(".cart-icon").clone());
                }
            });
    }

    $scope.cancelForm = () => {
        $('.bought-together-change').removeClass('active-change-item');
        $('body').removeClass('make-change-item-product');
    }

    $scope.save = (item) => {
        let isFound = false;
        $scope.productsBoughtTogether.forEach(element => {
            if (element.id == item.id) {
                element.currentVariant = $scope.currentVariant;
                element.product_sku_id = element.currentVariant.id;
                element.status = element.currentVariant.status;
                element.price = parseFloat(element.currentVariant.price);
                element.high_price = parseFloat(element.currentVariant.high_price);
                if (element.currentVariant.image_url) {
                    element.image_url = element.currentVariant.image_url;
                }
                element.variantName = $scope.getItemName(element);
                element.print_location = element.tmp_print_location;
                $scope.buildPricePrintLocation(element);
                isFound = true;
            }
        });
        if (!isFound) {
            $scope.mainProduct.currentVariant = $scope.currentVariant;
            $scope.mainProduct.price = parseFloat($scope.currentVariant.price);
            $scope.mainProduct.high_price = parseFloat($scope.currentVariant.high_price);
            if ($scope.mainProduct.currentVariant.image_url) {
                $scope.mainProduct.image_url = $scope.mainProduct.currentVariant.image_url;
            }
            $scope.mainProduct.product_sku_id = $scope.mainProduct.currentVariant.id;
            $scope.mainProduct.print_location = $scope.mainProduct.tmp_print_location;
            $scope.mainProduct.variantName = $scope.getItemName($scope.mainProduct);
            $scope.buildPricePrintLocation($scope.mainProduct);
        }
        $scope.originVariant = null;
        $scope.currentItem = {};
        $scope.getTotalPrice();
        $scope.getTotalSavePrice();
        $('.bought-together-change').removeClass('active-change-item');
        $('body').removeClass('make-change-item-product');
    }

    $scope.getImageCdn = window.getImageCdn;

    $scope.formatPrice = function(price, numberAdd = 1, format = true) {
        if (format) {
            if (typeof btgPriceConfig != 'undefined' && btgPriceConfig) {
                price = (parseFloat(price) + parseFloat(btgPriceConfig.adding_price) * numberAdd) * parseFloat(btgPriceConfig.ratio);
            }
            price = decimalAdjust('ceil', price);
        }
        return formatPrice(price, priceTempate);
    };

    $scope.getTotalPrice = () => {
        let price = 0;
        $scope.productsBoughtTogether.forEach(element => {
            if (element.is_select) {
                let priceItem = parseFloat(element.price);
                if (typeof btgPriceConfig != 'undefined' && btgPriceConfig) {
                    priceItem += parseFloat(btgPriceConfig.adding_price);
                    priceItem *= parseFloat(btgPriceConfig.ratio);
                }
                price += decimalAdjust('ceil', priceItem);
            }
        });
        let priceMain = parseFloat($scope.mainProduct.price);
        if (typeof btgPriceConfig != 'undefined' && btgPriceConfig) {
            priceMain += parseFloat(btgPriceConfig.adding_price);
            priceMain *= parseFloat(btgPriceConfig.ratio);
        }
        price += decimalAdjust('ceil', priceMain);
        $scope.$applyAsync(function() {
            $scope.totalPrice = price;
        })
    }

    $scope.getTotalSavePrice = () => {
        let price = 0;
        $scope.productsBoughtTogether.forEach(element => {
            if (element.is_select && element.price < element.high_price) {
                price += parseFloat(element.high_price) - parseFloat(element.price);
            }
        });
        if ($scope.mainProduct.price < $scope.mainProduct.high_price) {
            price += parseFloat($scope.mainProduct.high_price) - parseFloat($scope.mainProduct.price);
        }
        $scope.$applyAsync(function() {
            $scope.totalSavePrice = parseFloat(price.toFixed(2));
        })
    }

    $scope.closeChange = () => {
        $scope.loadingMakeChange = false;
        let isFound = false;
        $scope.productsBoughtTogether.forEach(element => {
            if (element.id == $scope.currentItem.id) {
                element.currentVariant = $scope.originVariant;
                element.product_sku_id = element.currentVariant.id;
                element.status = element.currentVariant.status;
                element.price = parseFloat(element.currentVariant.price);
                element.high_price = parseFloat(element.currentVariant.high_price);
                if (element.currentVariant.gallery.length) {
                    element.image_url = element.currentVariant.gallery[0];
                }
                element.variantName = $scope.getItemName(element);
                element.tmp_print_location = element.print_location;
                $scope.buildPricePrintLocation(element);
                isFound = true;
            }
            
        });
        if (!isFound) {
            $scope.currentVariant = $scope.originVariant;
            $scope.mainProduct.currentVariant = $scope.originVariant;
            $scope.mainProduct.price = parseFloat($scope.currentVariant.price);
            $scope.mainProduct.high_price = parseFloat($scope.currentVariant.high_price);
            if ($scope.currentVariant.gallery.length) {
                $scope.mainProduct.image_url = $scope.currentVariant.gallery[0];
                console.log($scope.mainProduct.image_url)

            }
            $scope.mainProduct.product_sku_id = $scope.mainProduct.currentVariant.id;
            $scope.mainProduct.tmp_print_location = $scope.mainProduct.print_location;
            $scope.mainProduct.variantName = $scope.getItemName($scope.mainProduct);
            $scope.buildPricePrintLocation($scope.mainProduct);
        }
        $scope.originVariant = null;
        $scope.getTotalPrice();
        $scope.getTotalSavePrice();
        $('.bought-together-change').removeClass('active-change-item');
        $('body').removeClass('make-change-item-product');
    }

    $scope.initial = async () => {
        let productid = $("#productId").val();
        await $scope.getCustomerToken();
        await Promise.all([
            $scope.getMainProduct(productid),
            $scope.findBoughtTogetherProducts(productid),
        ]);

        $scope.getTotalPrice();
        $scope.getTotalSavePrice();

        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply();
        }
        
        $scope.$evalAsync(
            function( $scope ) {
                $scope.loadingBoughtTogetherProducts = false;
            }
        );

        if (screen.width < 960) {
            $(document).on('click', '.make-change-button', function() {
                $('.bought-together-change').addClass('active-change-item');
                $('body').addClass('make-change-item-product')
            })
        } else {
            $('.make-change-button').mouseup(function(e) {
                $('.bought-together-change').removeClass('active-change-item');
                $(e.target).parents('.bought-together-change').addClass('active-change-item');
                $('html, body').animate({
                    scrollTop: $('.bought-together-list-item').offset().top
                }, 500)
            });

        }

        setTimeout(() => {
            if (window.globalVariants) {
                $scope.$apply(function () {
                    $scope.buildMainProductVariantName(window.globalVariants)
                })
            }
        }, 3000);
    }

    window.addEventListener('variantChanged', function (event, data) {
        let detail = angular.copy(event.detail);
        let lastImageUrl = $scope.mainProduct.currentVariant ? $scope.mainProduct.currentVariant.image_url : ($scope.mainProduct.variant_default ? $scope.mainProduct.variant_default.image_url : $scope.mainProduct.image_url);
        $scope.currentVariant = detail;
        if (detail.variants) {
            if (typeof detail.variants[0] === 'object') {
                $scope.currentVariant.variants = detail.variants.map(i => i.id);
            }
        }
        if ($scope.currentVariant.gallery.length) {
            $scope.currentVariant.image_url = $scope.currentVariant.gallery[0];
        } else {
            $scope.currentVariant.image_url = lastImageUrl;
        }
        $scope.mainProduct.currentVariant = detail;
        if (typeof detail.variants[0] === 'object') {
            $scope.mainProduct.currentVariant.variants = detail.variants.map(i => i.id);
        }
        $scope.mainProduct.product_sku_id = $scope.currentVariant.id;
        $scope.mainProduct.price = parseFloat($scope.currentVariant.price);
        $scope.mainProduct.high_price = parseFloat($scope.currentVariant.high_price);
        if ($scope.currentVariant.image_url) {
            $scope.mainProduct.image_url = $scope.currentVariant.image_url;
        }
        $scope.mainProduct.variantName = $scope.getItemName($scope.mainProduct);
        $scope.buildPricePrintLocation($scope.mainProduct);
    })

    window.addEventListener('changePrintLocation', function (event) {
        if ($scope.mainProduct) {
            $scope.mainProduct.print_location = event.detail.position.value;
            if ($scope.mainProduct.print_location) {
                $scope.mainProduct.tmp_print_location = $scope.mainProduct.print_location;
            }
            $scope.buildPricePrintLocation($scope.mainProduct);
        }
    })

    $scope.checkThemeVariantColor = (slug) => {
        let retVal = 'dark';
        if (lightVariantColors.includes(slug)) {
            retVal = 'light';
        }
        return retVal;
    }

    $(document).on('click', '.add-all-item-popup-bg, .close-addallitem, .continue-shipping-button', function () {
        $('.add-all-item-popup').removeClass('active');
        $('body').removeClass('open-addall')
    })

    $scope.getByField = function (list, fieldName, value) {
        var retVal = null;
        list.forEach(function (item) {
            if (item[fieldName] == value) {
                retVal = item;
            }
        });
        return retVal;
    };

    $scope.initial();

    $scope.getAdditionalPrintLocationPrice = (price, type, categoryIds = []) => {
        let addPrice = $scope.buildAddPrice(price, type, categoryIds);
        price = parseFloat(price) + addPrice;
        price = parseFloat(price).toFixed(3);
        return price;
    }

    $scope.buildAddPrice = (price, type, categoryIds = []) => {
        let retVal = null;
        let locale = prefixLocaleUrlBoughtTogether == "/" ? "us" : prefixLocaleUrlBoughtTogether.replace(/\//g, "");
        if ($scope.printLocationsPrice && $scope.printLocationsPrice[type]) {
            if ($scope.printLocationsPrice[type][locale]) {
                let printLocationsPriceByLocale = $scope.printLocationsPrice[type][locale];
                for (let cateId in printLocationsPriceByLocale.category) {
                    let check = categoryIds.find(id => id == cateId);
                    if (check) {
                        retVal = printLocationsPriceByLocale.category[cateId];
                        break;
                    }
                }
                if (!retVal && printLocationsPriceByLocale.default) {
                    retVal = printLocationsPriceByLocale.default;
                }
            }
        }
        let addPrice = 0;
        if (retVal) {
            if (retVal.type == 'percent') {
                addPrice = parseFloat(price) * retVal.value;
            } else {
                addPrice = retVal.value;
            }
        }
        return addPrice;
    }

    $scope.buildPricePrintLocation = (item) => {
        item.show_price = item.price
        item.show_high_price = item.high_price
        if (item.print_location) {
            item.show_price = $scope.getAdditionalPrintLocationPrice(parseFloat(item.price), item.tmp_print_location, item.category_ids)
            let addPrice = $scope.buildAddPrice(parseFloat(item.price), item.tmp_print_location, item.category_ids);
            item.show_high_price = parseFloat(item.show_high_price) + addPrice;
            item.show_high_price = parseFloat(item.show_high_price).toFixed(3);
        }
    }

    $scope.buildMainProductVariantName = function (data) {
        if ($scope.mainProduct && $scope.mainProduct.variant_default) {
            let spid = $scope.mainProduct.variant_default.id;
            let optionIds = [];
            let productSku = data.productVariants.find(item => item.id == spid);

            if (productSku) {
                let optionIds = productSku.variants.map(id => parseInt(id));
                let variantNames = [];

                for (let variant of data.variants) {
                    for (let option of variant.values) {
                        if (optionIds.includes(parseInt(option.id))) {
                            variantNames.push(option.name);
                        }
                    }
                }

                $scope.mainProduct.variantName = variantNames.join(', ');
            }
        }
    }

    window.addEventListener('doneGetVariant', function (event) {
        let data = event.detail;
        $scope.buildMainProductVariantName(data);
    })
});