@php
    $checkoutLocale = env('APP_LOCALE', 'us');
    if (!$checkoutLocale) {
        $checkoutLocale = 'us';
    }
@endphp
<script type="text/javascript">
    var prefixLocaleUrlBoughtTogether = "{{ env('APP_LOCALE') != '' ? '/' . env('APP_LOCALE') . '/' : '/' }}";
    var token = '{{ getFingerprint() }}';
    var btgPriceConfig = <?= json_encode(getPriceConfig()) ?>;
    var ignoreOptionIds = <?= json_encode(config('pod::sa.custom_ignore_option_id.' . $checkoutLocale, [])) ?>;
    var btgCdnIgnoreUrl = <?= json_encode(config('cdn.ignore', [])); ?>;
    var btgCdnAllowUrl = <?= json_encode(config('cdn.allow', [])); ?>;
    var btgLimitBoughtTogether = "<?= config('bought-together::sa.limit_product', 3) ?>";
    var btgShowSeeMore = "<?= config('bought-together::sa.use_see_more', false) ?>";
    var apiUrl = "<?= env("API_URL"); ?>"
    var displayTrans = {
        'choose_at_least_one_product': '{{ __('Please choose at least one product!') }}',
        'choose_product_variant': '{{ __('Please choose product variant') }}',
        'product_inactive': '{{ __('Product is out of stock') }}',
    };
    var printLocationsBoughtTogether = <?= json_encode(getPrintLocationConfig()) ?>;
    var printLocationsPrice = <?= json_encode(getPrintLocationPriceConfig()) ?>;

</script>

<script src="{{ Module::asset('bought-together/js/bought-together.js') }}?v=<?= Config::get("sa.version") ?>" defer></script>