<link rel="preload" href="{{ Module::asset('bought-together/css/bought-together.css') }}?v=<?= Config::get("sa.version") ?>" as="style" onload="this.onload=null;this.rel='stylesheet'">
<div ng-controller="BoughtTogetherController" id="BoughtTogetherController" style="width: 100%">
    
    {{-- loading block --}}
    <div ng-if="loadingBoughtTogetherProducts == true">
        <style>
             @media (min-width: 760px) {
                .bought-together-loading .has-fancy-loading {
                    width: 250px;
                    height: 200px;
                }

                .bought-together-loading  {
                    gap: 1rem;
                    grid-gap: 1rem
                }
            }

            @media (max-width: 760px) {
                .bought-together-loading {
                    display: grid;
                    grid-template-columns: repeat(1, 1fr);
                    grid-gap: 1rem;
                    padding: 8px;
                }
                .bought-together-loading .fancy-loading-block {
                    display: block;
                    width: 100%;
                    position: relative;
                }

                .bought-together-loading .has-fancy-loading {
                    position: relative;
                }
                .bought-together-loading .fancy-loading-block::before {
                    content: "";
                    aspect-ratio: 396 / 137;
                    display: block
                }
                
                .mb-m-8 {
                    margin: 8px;
                    margin-top: 0;
                }
            }
        </style>
        <div class="has-fancy-loading mb-m-8" style="height: 30px; width: 70vw; max-width: 400px; margin-bottom: 8px;">
            <span class="fancy-loading-block no-border animated-background"></span>
        </div>
        <div class="bought-together-loading flex-b align-c flex-s" style="margin-bottom: 15px">
            <div class="has-fancy-loading" >
                <span class="fancy-loading-block no-border animated-background"></span>
            </div>
            <div class="has-fancy-loading" >
                <span class="fancy-loading-block no-border animated-background"></span>
            </div>
            <div class="has-fancy-loading" >
                <span class="fancy-loading-block no-border animated-background"></span>
            </div>
            <div class="has-fancy-loading" >
                <span class="fancy-loading-block no-border animated-background"></span>
            </div>
        </div>
    </div>
    
    <div ng-cloak class="md-bought-together-wrapper section-product-page" ng-show="!loadingBoughtTogetherProducts && (productsBoughtTogether.length > 0 || moreProductsBoughtTogether.length > 0)">
        
        <div class="flex-b align-c flex-s">
            <h3 class="md-bought-together-title section-product-page-title">
                {{ __('Frequently bought together') }}
            </h3>
            <a class="component-seemore" href="javascript:;" ng-if="moreProductsBoughtTogether.length == 0 && productsBoughtTogether.length < totalProducts && showSeeMore" ng-click="loadMore()" aria-label="See more product bought together">
                {{ __('See all items')}}
                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"></path>
                </svg>
            </a>
        </div>

        <div class="bought-together-wrapper" ng-if="productsBoughtTogether.length > 0">
            <div class="bought-together-list-item">
                <div class="bought-together-item current-product-item" ng-if="mainProduct">
                    <a class="bought-together-picture has-fancy-loading" ng-href="@{{ mainProduct.url }}?internal_source=bought-together" target="_blank">
                        <picture>
                            <source media="(max-width:767px)" data-srcset="@{{ getImageCdn(mainProduct.image_url, 360, 360, false) }}">
                            <source media="(min-width:768px)" data-srcset="@{{ getImageCdn(mainProduct.image_url, 540, 540, false) }}">
                            <img lazy-load 
                                data-loading="bought-together-picture-mainProduct" 
                                src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                                data-original="@{{ mainProduct.image_url }}"
                                alt="Discover @{{ mainProduct.name }}" referrerpolicy="no-referrer" width="180" height="180">
                        </picture>
                        <span class="fancy-loading-block animated-background" id="bought-together-picture-mainProduct"></span>
                    </a>
                    <div class="bought-together-info">
                        <div class="bought-together-title flex-b align-c flex-s">
                            <label for="make-changes-0" class="bought-together-variant flex-b align-s flex-s">
                                <input id="make-changes-0" type="checkbox" ng-model="item.is_select" checked disabled>
                                <span class="checkbox-type"></span>
                            </label>
                            <a ng-href="@{{ mainProduct.url }}?internal_source=bought-together" target="_blank" ng-bind-html="mainProduct.name | trusted"></a>
                        </div>
                        <div class="bought-together-variant flex-b align-s flex-s">
                            @{{ mainProduct.variantName }}
                        </div>
                        <div class="bought-together-change" ng-if="mainProduct.variant_default && mainProduct.variant_default.id">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" ng-show="mainProduct.loadingMakeChange" viewBox="0 0 16 16" class="bi bi-arrow-repeat loading">
                                    <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"></path>
                                    <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"></path>
                                </svg>
                                <svg ng-click="openFormChangeVariant(mainProduct, 'main')" xmlns="http://www.w3.org/2000/svg" ng-show="!mainProduct.loadingMakeChange" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="16" height="16" x="0" y="0" viewBox="0 0 512 511" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                    <g>
                                        <path d="M405.332 256.484c-11.797 0-21.332 9.559-21.332 21.332v170.668c0 11.754-9.559 21.332-21.332 21.332H64c-11.777 0-21.332-9.578-21.332-21.332V149.816c0-11.754 9.555-21.332 21.332-21.332h170.668c11.797 0 21.332-9.558 21.332-21.332 0-11.777-9.535-21.336-21.332-21.336H64c-35.285 0-64 28.715-64 64v298.668c0 35.286 28.715 64 64 64h298.668c35.285 0 64-28.714 64-64V277.816c0-11.796-9.54-21.332-21.336-21.332zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                                        <path d="M200.02 237.05a10.793 10.793 0 0 0-2.922 5.438l-15.082 75.438c-.703 3.496.406 7.101 2.922 9.64a10.673 10.673 0 0 0 7.554 3.114c.68 0 1.387-.063 2.09-.211l75.414-15.082c2.09-.43 3.988-1.43 5.461-2.926l168.79-168.79-75.415-75.41zM496.383 16.102c-20.797-20.801-54.633-20.801-75.414 0l-29.524 29.523 75.414 75.414 29.524-29.527C506.453 81.465 512 68.066 512 53.816s-5.547-27.648-15.617-37.714zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                                    </g>
                                </svg>
                                <span class="make-change-button" ng-click="openFormChangeVariant(mainProduct, 'main')">{{ __('Edit')}}</span>
                                <div class="make-change-item-wrapper" ng-if="mainProduct.id == currentItem.id && groupVariants.length > 0">
                                    <div class="make-change-item-content">
                                        @handheld
                                        <div class="make-change-item-row flex-b align-s">
                                            <a class="bought-together-picture has-fancy-loading" ng-href="@{{ mainProduct.url }}?internal_source=bought-together" target="_blank">
                                                <picture>
                                                    <source media="(max-width:767px)" data-srcset="@{{ getImageCdn(currentVariant.image_url, 360, 360, false) }}">
                                                    <source media="(min-width:768px)" data-srcset="@{{ getImageCdn(currentVariant.image_url, 540, 540, false) }}">
                                                    <img lazy-load 
                                                        data-loading="bought-together-picture-mainProduct-handheld"
                                                        src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                                                        data-original="@{{ currentVariant.image_url }}"
                                                        alt="Discover @{{ currentVariant.name }}" referrerpolicy="no-referrer" width="180" height="180">
                                                </picture>
                                                <span class="fancy-loading-block animated-background" id="bought-together-picture-mainProduct-handheld"></span>
                                            </a>
                                            <div class="bought-together-info">
                                                <div class="bought-together-title">
                                                    <a href="@{{ mainProduct.url }}?internal_source=bought-together" target="_blank" ng-bind-html="currentVariant.name ? currentVariant.name : mainProduct.name | trusted">
                                                    </a>
                                                </div>
                                                <div class="bought-together-price">
                                                    <div class="bought-together-saleprice">
                                                        @{{ formatPrice(mainProduct.show_price) }}
                                                    </div>
                                                    <div class="bought-together-hightprice" ng-if="currentVariant.price < currentVariant.high_price">
                                                        @{{ formatPrice(mainProduct.show_high_price) }}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endhandheld
                                        <div class="make-change-item-content-col" ng-repeat="groupVariant in groupVariants" data-slug="@{{ groupVariant.slug }}">
                                            <div class="make-change-item-row type-gender" ng-if="groupVariant.type != 'IMAGE' && groupVariant.type != 'OPTION'">
                                                <div class="make-change-item-variant-title">@{{ groupVariant.name }}</div>
                                                <div class="make-change-item-variant-content">
                                                    <label for="type-@{{ groupVariant.slug }}-@{{ $index }}" class="make-change-item-variant" data-variant-option-slug="@{{ variant.slug }}" data-theme-variant-color="@{{ checkThemeVariantColor(variant.slug) }}" ng-repeat="variant in groupVariant['values']" ng-click="selectVariant(groupVariant, variant, mainProduct)">
                                                        <input type="radio" id="type-@{{ groupVariant.slug }}-@{{ $index }}" name="type-@{{ groupVariant.slug }}" ng-checked="isSelected(variant)">
                                                        <span>@{{ variant.name }}</span>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="make-change-item-row type-color" ng-if="groupVariant.type == 'IMAGE'">
                                                <div class="make-change-item-variant-title">
                                                    @{{ groupVariant.name }}: @{{ variantImageSelected[groupVariant.id] }}
                                                </div>
                                                <div class="make-change-item-variant-content">
                                                    <div
                                                        ng-repeat="option in groupVariant.values"
                                                        id="js-choose-variant-@{{ option.id }}"
                                                        class="p-p5 js-choose-variant choose-image-variant variant-image-item @{{ isSelected(option) ? 'active' : '' }}"
                                                        style="width: 30px"
                                                        ng-style="option.color_code && {'background-color': option.color_code}"
                                                        data-variant-id="@{{ groupVariant.id }}"
                                                        data-variant-option-id="@{{ option.id }}"
                                                        data-variant-option-slug="@{{ option.slug }}"
                                                        data-theme-variant-color="@{{ checkThemeVariantColor(option.slug) }}"
                                                        title="@{{ option.name }}"
                                                        ng-click="selectVariant(groupVariant, option, mainProduct)"
                                                    >
                                                        <img 
                                                            ng-if="!option.color_code"
                                                            ng-src="@{{ getImageCdn(option.image_url, 100, 100) }}"
                                                            alt="@{{ option.name }}"
                                                            title="@{{ option.name }}"
                                                            class="w-full img-round"
                                                            referrerpolicy="no-referrer"
                                                        />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="make-change-item-row type-style" ng-if="groupVariant.type == 'OPTION'">
                                                <div class="make-change-item-variant-title">@{{ groupVariant.name }}</div>
                                                <div class="make-change-item-variant-content">
                                                    <select class="select" name="" ng-model="variantOptionSelected[groupVariant.id]" ng-change="selectVariant(groupVariant, null, mainProduct)" ng-options="variant.id as variant.name + getPriceVariant(variant, groupVariant.id, mainProduct) for variant in groupVariant['values']">
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="product-variant-heading" style="color: black;" ng-show="mainProduct.is_valid_print_back">
                                            {{ __('Print Location') }}:
                                            <span id="selected-print-location">@{{ getByField(printLocations, 'value', mainProduct.tmp_print_location) ? getByField(printLocations, 'value', mainProduct.tmp_print_location).name : "" }}</span>
                                        </div>
                                        <div class="image-select-wrapper" ng-show="mainProduct.is_valid_print_back">
                                            <div class="image-select-option @{{ mainProduct.tmp_print_location == printLocation.value ? 'active' : '' }}" ng-repeat="printLocation in printLocations" ng-click="selectPrintLocation('main', printLocation, mainProduct)">
                                                <div class="image-wrapper-inner">
                                                    <img class="selected" ng-src="@{{ printLocation.selectImage }}" alt="@{{ printLocation.name }}" class="image-select-option">
                                                    <img class="default" ng-src="@{{ printLocation.defaultImage }}" alt="@{{ printLocation.name }}" class="image-select-option">
                                                </div>
                                                <label>@{{ printLocation.name }}</label>
                                            </div>
                                        </div>
                                        <div class="make-change-item-row flex-b flex-e align-c type-action">
                                            <button class="button make-change-cancel" ng-click="closeChange()">
                                                {{ __('Cancel')}}
                                            </button>
                                            <button class="button make-change-comfirm" ng-click="save(mainProduct)" ng-show="currentVariant.status == 'ACTIVE'">
                                                {{ __('Confirm')}}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="make-change-cancel-background" ng-click="closeChange()"></div>
                            </div>
                        </div>
                        <div class="bought-together-price">
                            <span class="bought-together-saleprice">
                                @{{ formatPrice(mainProduct.show_price) }}
                            </span>
                            <span class="bought-together-hightprice" ng-if="mainProduct.price < mainProduct.high_price">
                                @{{ formatPrice(mainProduct.show_high_price) }}
                            </span>
                        </div>
                    </div>
                </div>
                <div class="bought-together-plus">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" stroke="currentColor" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 2a.5.5 0 0 1 .5.5v5h5a.5.5 0 0 1 0 1h-5v5a.5.5 0 0 1-1 0v-5h-5a.5.5 0 0 1 0-1h5v-5A.5.5 0 0 1 8 2Z"/>
                    </svg>
                </div>
                <div class="bought-together-other-product" ng-if="productsBoughtTogether.length > 0">
                    <div class="bought-together-item" id="js-bought-together-item_@{{ item.id }}" ng-repeat="item in productsBoughtTogether">
                        <a class="bought-together-picture has-fancy-loading" ng-href="@{{ item.url }}?internal_source=bought-together" target="_blank">
                            <picture>
                                <source media="(max-width:767px)" data-srcset="@{{ getImageCdn(item.image_url, 360, 360, false) }}">
                                <source media="(min-width:768px)" data-srcset="@{{ getImageCdn(item.image_url, 540, 540, false) }}">
                                <img lazy-load 
                                    data-loading="bought-together-other-product-@{{ item.id }}"
                                    src="data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                                    data-original="@{{ item.image_url }}" 
                                    alt="Discover @{{ item.name }}" width="180" height="180">
                            </picture>
                            <span class="fancy-loading-block animated-background" id="bought-together-other-product-@{{ item.id }}"></span>
                        </a>
                        <div class="bought-together-info">
                            <div class="bought-together-title flex-b align-c">
                                <label for="make-changes" class="bought-together-variant flex-b align-s flex-s" ng-click="changeSelectItem(item)" ng-disabled="item.is_custom_design">
                                    <input type="checkbox" ng-model="item.is_select" ng-disabled="item.is_custom_design">
                                    <span class="checkbox-type"></span>
                                </label>
                                <a ng-href="@{{ item.url }}?internal_source=bought-together" ng-bind-html="item.name | trusted" target="_blank">
                                </a>
                            </div>
                            <div class="bought-together-variant flex-b align-s flex-s">
                                @{{ item.variantName }}
                            </div>
                            <div class="bought-together-change" ng-if="item.variant_default.length > 0 && !item.is_custom_design">
                                <div ng-click="openFormChangeVariant(item)">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" ng-show="item.loadingMakeChange" viewBox="0 0 16 16" class="bi bi-arrow-repeat loading">
                                        <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"></path>
                                        <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"></path>
                                    </svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" ng-show="!item.loadingMakeChange" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="16" height="16" x="0" y="0" viewBox="0 0 512 511" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                        <g>
                                            <path d="M405.332 256.484c-11.797 0-21.332 9.559-21.332 21.332v170.668c0 11.754-9.559 21.332-21.332 21.332H64c-11.777 0-21.332-9.578-21.332-21.332V149.816c0-11.754 9.555-21.332 21.332-21.332h170.668c11.797 0 21.332-9.558 21.332-21.332 0-11.777-9.535-21.336-21.332-21.336H64c-35.285 0-64 28.715-64 64v298.668c0 35.286 28.715 64 64 64h298.668c35.285 0 64-28.714 64-64V277.816c0-11.796-9.54-21.332-21.336-21.332zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                                            <path d="M200.02 237.05a10.793 10.793 0 0 0-2.922 5.438l-15.082 75.438c-.703 3.496.406 7.101 2.922 9.64a10.673 10.673 0 0 0 7.554 3.114c.68 0 1.387-.063 2.09-.211l75.414-15.082c2.09-.43 3.988-1.43 5.461-2.926l168.79-168.79-75.415-75.41zM496.383 16.102c-20.797-20.801-54.633-20.801-75.414 0l-29.524 29.523 75.414 75.414 29.524-29.527C506.453 81.465 512 68.066 512 53.816s-5.547-27.648-15.617-37.714zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                                        </g>
                                    </svg>
                                    <span class="make-change-button">{{ __('Edit')}}</span>
                                </div>
                                @include('bought-together::home.make-change-item')
                            </div>
                            <a class="bought-together-change" ng-href="@{{ item.url }}?internal_source=bought-together" target="_blank" ng-if="item.is_custom_design">
                                <svg xmlns="http://www.w3.org/2000/svg"  version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="16" height="16" x="0" y="0" viewBox="0 0 512 511" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                    <g>
                                        <path d="M405.332 256.484c-11.797 0-21.332 9.559-21.332 21.332v170.668c0 11.754-9.559 21.332-21.332 21.332H64c-11.777 0-21.332-9.578-21.332-21.332V149.816c0-11.754 9.555-21.332 21.332-21.332h170.668c11.797 0 21.332-9.558 21.332-21.332 0-11.777-9.535-21.336-21.332-21.336H64c-35.285 0-64 28.715-64 64v298.668c0 35.286 28.715 64 64 64h298.668c35.285 0 64-28.714 64-64V277.816c0-11.796-9.54-21.332-21.336-21.332zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                                        <path d="M200.02 237.05a10.793 10.793 0 0 0-2.922 5.438l-15.082 75.438c-.703 3.496.406 7.101 2.922 9.64a10.673 10.673 0 0 0 7.554 3.114c.68 0 1.387-.063 2.09-.211l75.414-15.082c2.09-.43 3.988-1.43 5.461-2.926l168.79-168.79-75.415-75.41zM496.383 16.102c-20.797-20.801-54.633-20.801-75.414 0l-29.524 29.523 75.414 75.414 29.524-29.527C506.453 81.465 512 68.066 512 53.816s-5.547-27.648-15.617-37.714zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                                    </g>
                                </svg>
                                {{__('Customize')}}
                            </a>
                            <div class="bought-together-price">
                                <span class="bought-together-saleprice">
                                    @{{ formatPrice(item.show_price) }}
                                </span>
                                <span class="bought-together-hightprice" ng-if="item.price < item.high_price">
                                    @{{ formatPrice(item.show_high_price) }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bought-together-button">
                    <a class="bought-together-btn" href="javascript:;" ng-click="addAllToCart()" ng-if="!loading">
                        <span class="default-text">
                            {{ __('Add all to cart')}}
                        </span>
                    </a>

                    <span class="bought-together-btn" ng-if="loading">
                        <span class="default-loading">
                        </span>
                    </span>
                </div>
            </div>
            
        </div>
        <!-- <div class="md-bought-together-footer" ng-if="productsBoughtTogether.length > 0">
            {{-- <div class="bought-together-action">
                <div class="bought-together-price" ng-if="totalPrice > 0">
                    <span class="footer-text">{{ __('Price')}}</span>
                    <span class="bought-together-saleprice">
                        @{{ formatPrice(totalPrice, 1, false) }}
                    </span>
                </div>
                <div class="bought-together-price" ng-if="totalSavePrice > 0">
                    <span class="footer-text">{{ __('Save')}}</span>
                    <span class="bought-together-saleprice">
                        @{{ formatPrice(totalSavePrice, 0, true) }}
                    </span>
                </div>
            </div> --}}
            
        </div> -->
        <!-- Load more products -->
        <div class="more-bought-together-products" ng-if="moreProductsBoughtTogether.length > 0">
            <div class="more-bought-together-list">
                <div class="sale-product-item" ng-repeat="item in moreProductsBoughtTogether">
                    <div class="available-product">
                        <a ng-href="@{{ item.url }}?internal_source=bought-together" class="available-product-link">
                            <picture>
                                <source media="(max-width:767px)" srcset="@{{ getImageCdn(item.image_url, 360, 360, false) }}">
                                <source media="(min-width:768px)" srcset="@{{ getImageCdn(item.image_url, 540, 540, false) }}">
                               <img ng-src="@{{ getImageCdn(item.image_url, 540, 540, false) }}" alt="Discover @{{ item.name }}" referrerpolicy="no-referrer" width="180" height="180">
                            </picture>
                        </a>
                        <div class="available-product-info">
                            <a ng-href="@{{ item.url }}?internal_source=bought-together" class="available-product-link">
                                <div class="available-product-title" ng-bind-html="item.name | trusted"></div>
                            </a>
                            <div class="available-product-price-box">
                                <div class="available-product-price">
                                    @{{ formatPrice(item.price) }}
                                </div>
                                <div class="available-product-high-price" ng-if="item.price < item.high_price">
                                    @{{ formatPrice(item.high_price) }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="add-all-item-popup">
            <div class="add-all-item-content">
                <div class="addallitem-header flex-b align-c">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#198754" class="bi bi-check2-circle" viewBox="0 0 16 16" style="margin-right: 10px;">
                        <path d="M2.5 8a5.5 5.5 0 0 1 8.25-4.764.5.5 0 0 0 .5-.866A6.5 6.5 0 1 0 14.5 8a.5.5 0 0 0-1 0 5.5 5.5 0 1 1-11 0z"></path>
                        <path d="M15.354 3.354a.5.5 0 0 0-.708-.708L8 9.293 5.354 6.646a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0l7-7z"></path>
                    </svg>
                    {{ __('Your items were added to the cart') }}
                    <button type="button" class="button close-addallitem">&times;</button>
                </div>
                <div class="addallitem-list">
                    <a ng-href="@{{ item.url }}?internal_source=bought-together" target="_blank" class="item-boughttogether" ng-repeat="item in listAddedToCart">
                        <div class="item-boughttogether-image">
                            <picture>
                                <source media="(max-width:767px)" srcset="@{{ getImageCdn(item.image_url, 360, 360, false) }}">
                                <source media="(min-width:768px)" srcset="@{{ getImageCdn(item.image_url, 540, 540, false) }}">
                                <img ng-src="@{{ getImageCdn(item.image_url, 540, 540, false) }}" alt="Discover @{{ item.product_name }}" width="180" height="180" referrerpolicy="no-referrer">
                            </picture>
                        </div>
                        <div class="addallitem-info">
                            <div class="item-boughttogether-content">
                                @{{ item.product_name }}
                            </div>
                            <div class="available-product-price-box">
                                <div class="available-product-price">
                                    @{{ formatPrice(item.show_price) }}
                                </div>
                                <div class="available-product-high-price" ng-if="item.price < item.high_price">
                                    @{{ formatPrice(item.show_high_price) }}
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="md-add2basket-slide-head" ng-if="relatedProducts.length > 0">
                    {{ __('You may also like') }}
                </div>
                <div class="add-all-item-list" ng-show="relatedProducts.length > 0">
                </div>

                <div class="addallitem-footer flex-b align-c flex-e">
                    <a href="javascript:;" class="continue-shipping-button">{{ __('Continue shopping')}}</a>
                    <a href="{{ clroute('/cart') }}" class="button checkout-button">{{ __('Checkout') }}</a>
                </div>
            </div>
            <span class="add-all-item-popup-bg"></span>
        </div>
    </div>
</div>
