<div class="make-change-item-wrapper" ng-if="item.variant_default.length > 0 && item.id == currentItem.id && groupVariants.length > 0">
    <div class="make-change-item-content">
        @handheld
        <div class="make-change-item-row flex-b align-s">
            <a class="bought-together-picture" ng-href="@{{ item.url }}?internal_source=bought-together" target="_blank">
                <picture>
                    <source media="(min-width: 320px)" srcset="@{{ currentVariant.image_url ? getImageCdn(currentVariant.image_url, 320, 320, true) : getImageCdn(item.image_url, 320, 320, true) }}">
                    <source src="/images/blank.gif">
                    <img src="/images/blank.gif" alt="Discover @{{ currentVariant.name ? currentVariant.name : item.name }}" referrerpolicy="no-referrer">
                </picture>
            </a>
            <div class="bought-together-info">
                <div class="bought-together-title">
                    <a ng-href="@{{ item.url }}?internal_source=bought-together" target="_blank">
                        @{{ currentVariant.name ? currentVariant.name : item.name }}
                    </a>
                </div>
                <div class="bought-together-price">
                    <div class="bought-together-saleprice">
                        @{{ formatPrice(item.show_price) }}
                    </div>
                    <div class="bought-together-hightprice" ng-if="currentVariant.price < currentVariant.high_price">
                        @{{ formatPrice(item.show_high_price) }}
                    </div>
                </div>
            </div>
        </div>
        @endhandheld
        <div class="make-change-item-content-col" ng-repeat="groupVariant in groupVariants" data-slug="@{{ groupVariant.slug }}">
            <div class="make-change-item-row type-gender" ng-if="(groupVariant.type != 'IMAGE' && groupVariant.type != 'OPTION')">
                <div class="make-change-item-variant-title">@{{ groupVariant.name }}</div>
                <div class="make-change-item-variant-content">
                    <label for="type-@{{ groupVariant.slug }}-@{{ $index }}" class="make-change-item-variant" ng-repeat="variant in groupVariant['values']" ng-click="selectVariant(groupVariant, variant, item)">
                        <input type="radio" id="type-@{{ groupVariant.slug }}-@{{ $index }}" name="type-@{{ groupVariant.slug }}" ng-checked="isSelected(variant)">
                        <span>@{{ variant.name }}</span>
                    </label>
                </div>
            </div>
            <div class="make-change-item-row type-color" ng-if="groupVariant.type == 'IMAGE'">
                <div class="make-change-item-variant-title">
                    @{{ groupVariant.name }}: @{{ variantImageSelected[groupVariant.id] }}
                </div>
                <div class="make-change-item-variant-content">
                    <div
                        ng-repeat="option in groupVariant.values"
                        id="js-choose-variant-@{{ option.id }}"
                        class="p-p5 js-choose-variant choose-image-variant variant-image-item @{{ isSelected(option) ? 'active' : '' }}"
                        style="width: 30px"
                        ng-style="option.color_code && {'background-color': option.color_code}"
                        data-variant-id="@{{ groupVariant.id }}"
                        data-variant-option-id="@{{ option.id }}"
                        data-variant-option-slug="@{{ option.slug }}"
                        data-theme-variant-color="@{{ checkThemeVariantColor(option.slug) }}"
                        title="@{{ option.name }}"
                        ng-click="selectVariant(groupVariant, option, item)"
                    >
                        <img 
                            ng-if="!option.color_code"
                            ng-src="@{{ getImageCdn(option.image_url, 100, 100) }}"
                            alt="@{{ option.name }}"
                            title="@{{ option.name }}"
                            class="w-full img-round"
                            referrerpolicy="no-referrer"
                        />
                    </div>
                </div>
            </div>
            <div class="make-change-item-row type-style" ng-if="groupVariant.type == 'OPTION'">
                <div class="make-change-item-variant-title">@{{ groupVariant.name }}</div>
                <div class="make-change-item-variant-content">
                    <select class="select" name="" ng-model="variantOptionSelected[groupVariant.id]" ng-change="selectVariant(groupVariant, null, item)" ng-options="variant.id as variant.name + getPriceVariant(variant, groupVariant.id, item) for variant in groupVariant['values']">
                    </select>
                </div>
            </div>
        </div>
        <div class="product-variant-heading" style="color: black;" ng-show="item.is_valid_print_back">
            {{ __('Print Location') }}:
            <span id="selected-print-location">@{{ getByField(printLocations, 'value', item.tmp_print_location) ? getByField(printLocations, 'value', item.tmp_print_location).name : "" }}</span>
        </div>
        <div class="image-select-wrapper" ng-show="item.is_valid_print_back">
            <div class="image-select-option @{{ item.tmp_print_location == printLocation.value ? 'active' : '' }}" ng-repeat="printLocation in printLocations" ng-click="selectPrintLocation('item', printLocation, item)">
                <div class="image-wrapper-inner">
                    <img class="selected" ng-src="@{{ printLocation.selectImage }}" alt="@{{ printLocation.name }}" class="image-select-option">
                    <img class="default" ng-src="@{{ printLocation.defaultImage }}" alt="@{{ printLocation.name }}" class="image-select-option">
                </div>
                <label>@{{ printLocation.name }}</label>
            </div>
        </div>
        <div class="make-change-item-row flex-b flex-e align-c type-action">
            <button class="button make-change-cancel" ng-click="closeChange()">
                {{ __('Cancel')}}
            </button>
            <button class="button make-change-comfirm" ng-click="save(item)" ng-show="currentVariant.status == 'ACTIVE'">
                {{ __('Confirm')}}
            </button>
        </div>
    </div>
</div>
<div class="make-change-cancel-background" ng-click="closeChange()"></div>
