<div class="add-all-item-popup" ng-cloak>
    <div class="add-all-item-content">
        <div class="addallitem-header flex-b align-c">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#198754" class="bi bi-check2-circle" viewBox="0 0 16 16" style="margin-right: 10px;">
                <path d="M2.5 8a5.5 5.5 0 0 1 8.25-4.764.5.5 0 0 0 .5-.866A6.5 6.5 0 1 0 14.5 8a.5.5 0 0 0-1 0 5.5 5.5 0 1 1-11 0z"></path>
                <path d="M15.354 3.354a.5.5 0 0 0-.708-.708L8 9.293 5.354 6.646a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0l7-7z"></path>
            </svg>
            {{ __('Your items were added to the cart') }}
            <button type="button" class="button close-addallitem">&times;</button>
        </div>
        <div class="addallitem-list">
            <a ng-href="@{{ item.url }}?internal_source=bought-together" target="_blank" class="item-boughttogether" ng-repeat="item in listAddedToCart">
                <div class="item-boughttogether-image">
                    <picture>
                        <source media="(max-width:767px)" srcset="@{{ getImageCdn(item.image_url, 360, 360, true) }}">
                        <source media="(min-width:768px)" srcset="@{{ getImageCdn(item.image_url, 540, 540, true) }}">
                        <img ng-src="@{{ getImageCdn(item.image_url, 540, 540, true) }}" alt="Discover @{{ item.product_name }}" width="200" height="200" referrerpolicy="no-referrer">
                    </picture>
                </div>
                <div class="addallitem-info">
                    <div class="item-boughttogether-content">
                        @{{ item.product_name }}
                    </div>
                    <div class="available-product-price-box">
                        <div class="available-product-price">
                            @{{ formatPrice(item.show_price) }}
                        </div>
                        <div class="available-product-high-price" ng-if="item.price < item.high_price">
                            @{{ formatPrice(item.show_high_price) }}
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="md-add2basket-slide-head" ng-if="relatedProducts.length > 0">
            {{ __('You may also like') }}
        </div>
        <div class="add-all-item-list" ng-show="relatedProducts.length > 0">
        </div>

        <div class="addallitem-footer flex-b align-c flex-e">
            <a href="javascript:;" class="continue-shipping-button">{{ __('Continue shopping')}}</a>
            <a href="{{ clroute('/cart') }}" class="button checkout-button">{{ __('Checkout') }}</a>
        </div>
    </div>
    <span class="add-all-item-popup-bg"></span>
</div>