@php
    if (!isset($btgMainProduct)) {
        return;
    }
    $checkoutLocale = env('APP_LOCALE', 'us');
    if (!$checkoutLocale) {
        $checkoutLocale = 'us';
    }

    $tmpMainProduct = [
        'id' => $btgMainProduct['id'],
        'price' => $btgMainProduct['price'],
        'high_price' => $btgMainProduct['high_price'],
        'image_url' => $btgMainProduct['image_url'],
        'variant_default' => $btgMainProduct['variant_default'],
        'status' => $btgMainProduct['status'],
        'categoriesIds' => !empty($btgMainProduct['category']) ? [$btgMainProduct['category']['id']] : [],
        'is_valid_print_back' => $btgMainProduct['is_valid_print_back']
    ];
@endphp
<script type="text/javascript">
    var prefixLocaleUrlBoughtTogether = "{{ env('APP_LOCALE') != '' ? '/' . env('APP_LOCALE') . '/' : '/' }}";
    var token = '{{ getFingerprint() }}';
    var btgPriceConfig = <?= json_encode(getPriceConfig()) ?>;
    var ignoreOptionIds = <?= json_encode(config('pod::sa.custom_ignore_option_id.' . $checkoutLocale, [])) ?>;
    var btgCdnIgnoreUrl = <?= json_encode(config('cdn.ignore', [])); ?>;
    var btgCdnAllowUrl = <?= json_encode(config('cdn.allow', [])); ?>;
    var btgLimitBoughtTogether = "<?= config('bought-together::sa.limit_product', 3) ?>";
    var btgShowSeeMore = "<?= config('bought-together::sa.use_see_more', false) ?>";
    var apiUrl = "<?= env("API_URL"); ?>"
    var displayTrans = {
        'choose_at_least_one_product': '{{ __('Please choose at least one product!') }}',
        'choose_product_variant': '{{ __('Please choose product variant') }}',
        'product_inactive': '{{ __('Product is out of stock') }}',
    };
    var printLocationsBoughtTogether = <?= json_encode(getPrintLocationConfig()) ?>;
    var printLocationsPrice = <?= json_encode(getPrintLocationPriceConfig()) ?>;
    var btgMainProduct = <?= json_encode($tmpMainProduct) ?>;
</script>

<script src="{{ Module::asset('bought-together/js/bought-together-no-ajax.js') }}?v=<?= Config::get("sa.version") ?>" defer></script>