@php
    if (!isset($btgMainProduct)) {
        return;
    }
@endphp

<link rel="preload" href="{{ Module::asset('bought-together/css/bought-together-no-ajax.css') }}?v=<?= Config::get("sa.version") ?>" as="style" onload="this.onload=null;this.rel='stylesheet'">
<link rel="preload" href="{{ asset('/assets/css/sku-chosen.css?v=' . config('sa.version')) }}" as="style" onload="this.onload=null;this.rel='stylesheet'">

<div ng-controller="BoughtTogetherController" id="BoughtTogetherController" style="width: 100%">
    <div class="md-bought-together-wrapper section-product-page">
        <div class="flex-b align-c flex-s">
            <h3 class="md-bought-together-title section-product-page-title">
                {{ __('Frequently bought together') }}
            </h3>
            <a class="component-seemore" href="javascript:;" ng-if="moreProductsBoughtTogether.length == 0 && productsBoughtTogether.length < totalProducts && showSeeMore" ng-click="loadMore()" aria-label="See more product bought together">
                {{ __('See all items')}}
                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"></path>
                </svg>
            </a>
        </div>
        <div class="bought-together-wrapper" ng-if="moreProductsBoughtTogether.length == 0">
            <div class="bought-together-list-item">
                @include('bought-together::home.no-ajax.main-item')
                <div class="bought-together-plus">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" stroke="currentColor" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 2a.5.5 0 0 1 .5.5v5h5a.5.5 0 0 1 0 1h-5v5a.5.5 0 0 1-1 0v-5h-5a.5.5 0 0 1 0-1h5v-5A.5.5 0 0 1 8 2Z"/>
                    </svg>
                </div>
                <div class="bought-together-other-product">
                    @foreach ($btgProducts as $key => $item)
                        @include('bought-together::home.no-ajax.item')
                    @endforeach
                </div>
                <div class="bought-together-button" ng-cloak>
                    <a class="bought-together-btn" href="javascript:;" ng-click="addAllToCart()" ng-if="!loading">
                        <span class="default-text">
                            {{ __('Add all to cart')}}
                        </span>
                    </a>

                    <span class="bought-together-btn" ng-if="loading">
                        <span class="default-loading">
                        </span>
                    </span>
                </div>
            </div>
            
        </div>

        <!-- Load more products -->
        <div class="more-bought-together-products" ng-cloak ng-if="moreProductsBoughtTogether.length > 0">
            <div class="more-bought-together-list">
                <div class="sale-product-item" ng-repeat="item in moreProductsBoughtTogether">
                    <div class="available-product">
                        <a ng-href="@{{ item.url }}?internal_source=bought-together" class="available-product-link">
                            <picture>
                                <source media="(max-width:767px)" srcset="@{{ getImageCdn(item.image_url, 360, 360, true) }}">
                                <source media="(min-width:768px)" srcset="@{{ getImageCdn(item.image_url, 540, 540, true) }}">
                                <img ng-src="@{{ getImageCdn(item.image_url, 360, 360, false) }}" alt="Discover @{{ item.name }}" referrerpolicy="no-referrer" width="180" height="180">
                            </picture>
                        </a>
                        <div class="available-product-info">
                            <a ng-href="@{{ item.url }}?internal_source=bought-together" class="available-product-link">
                                <div class="available-product-title" ng-bind-html="item.name | trusted"></div>
                            </a>
                            <div class="available-product-price-box">
                                <div class="available-product-price">
                                    @{{ formatPrice(item.price) }}
                                </div>
                                <div class="available-product-high-price" ng-if="parseFloat(item.price) < parseFloat(item.high_price)">
                                    @{{ formatPrice(item.high_price) }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('bought-together::home.no-ajax.add-all-item-popup')
    </div>
</div>
