<div class="bought-together-item current-product-item">
    <a class="bought-together-picture has-fancy-loading" href="{{ $btgMainProduct['url'] }}?internal_source=bought-together" target="_blank">
        <picture>
            <source media="(max-width:767px)" srcset="{{ getImageCdn($btgMainProduct['image_url'], 360, 360, false) }}" ng-srcset="@{{ getImageCdn(mainProduct.image_url, 360, 360, false) }}">
            <source media="(min-width:768px)" srcset="{{ getImageCdn($btgMainProduct['image_url'], 540, 540, false) }}" ng-srcset="@{{ getImageCdn(mainProduct.image_url, 540, 540, false) }}">
            <img data-loading="bought-together-picture-main" ng-src="/images/blank['gif']" alt="{{ sprintf( __('Discover %s'), $btgMainProduct['name']) }}" referrerpolicy="no-referrer" ng-src="@{{ getImageCdn(mainProduct.image_url, 540, 540, false) }}">
        </picture>
        <span id="bought-together-picture-main" class="fancy-loading-block animated-background"></span>
    </a>
    <div class="bought-together-info">
        <div class="bought-together-title flex-b align-c flex-s">
            <label for="make-changes-0" class="bought-together-variant flex-b align-s flex-s">
                <input id="make-changes-0" type="checkbox" checked disabled>
                <span class="checkbox-type"></span>
            </label>

            <a href="{{ $btgMainProduct['url'] }}?internal_source=bought-together" target="_blank">
                {{ $btgMainProduct['name'] }}
            </a>
        </div>
        <div class="bought-together-variant flex-b align-s flex-s" ng-bind-html="mainProduct.variantName | trusted">
        </div>
        @if(!empty($btgMainProduct['variant_default']['id']))
            <div class="bought-together-change">
                <div class="make-change-button-wrapper" ng-click="openFormChangeVariant(mainProduct, 'main')">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" ng-show="mainProduct.loadingMakeChange" viewBox="0 0 16 16" class="bi bi-arrow-repeat loading">
                        <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"></path>
                        <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"></path>
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" ng-show="!mainProduct.loadingMakeChange" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="16" height="16" x="0" y="0" viewBox="0 0 512 511" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                        <g>
                            <path d="M405.332 256.484c-11.797 0-21.332 9.559-21.332 21.332v170.668c0 11.754-9.559 21.332-21.332 21.332H64c-11.777 0-21.332-9.578-21.332-21.332V149.816c0-11.754 9.555-21.332 21.332-21.332h170.668c11.797 0 21.332-9.558 21.332-21.332 0-11.777-9.535-21.336-21.332-21.336H64c-35.285 0-64 28.715-64 64v298.668c0 35.286 28.715 64 64 64h298.668c35.285 0 64-28.714 64-64V277.816c0-11.796-9.54-21.332-21.336-21.332zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                            <path d="M200.02 237.05a10.793 10.793 0 0 0-2.922 5.438l-15.082 75.438c-.703 3.496.406 7.101 2.922 9.64a10.673 10.673 0 0 0 7.554 3.114c.68 0 1.387-.063 2.09-.211l75.414-15.082c2.09-.43 3.988-1.43 5.461-2.926l168.79-168.79-75.415-75.41zM496.383 16.102c-20.797-20.801-54.633-20.801-75.414 0l-29.524 29.523 75.414 75.414 29.524-29.527C506.453 81.465 512 68.066 512 53.816s-5.547-27.648-15.617-37.714zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                        </g>
                    </svg>
                    <span class="make-change-button">{{ __('Edit')}}</span>
                </div>
                @include('bought-together::home.no-ajax.make-change-main')
            </div>
        @endif
        <div class="bought-together-price">
            <span class="bought-together-saleprice" ng-bind-html="mainProduct.show_price ? formatPrice(mainProduct.show_price) : '<?= $btgMainProduct['display_price'] ?>' | trusted">
                {{ $btgMainProduct['display_price'] }}
            </span>
            <span class="bought-together-hightprice" ng-show="mainProduct.show_high_price" ng-bind-html="formatPrice(mainProduct.show_high_price) | trusted">
                @if($btgMainProduct['price'] < $btgMainProduct['high_price']) 
                    {{ $btgMainProduct['display_high_price'] }}
                @endif
            </span>
        </div>
    </div>
</div>