<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'bought-together', 'middleware' => 'example'], function () {
    Route::get('/generate', [
        'as' => 'bought-together::generate',
        'uses' => 'HomeController@generate',
    ]);
    Route::get('/generate-by-id', [
        'as' => 'bought-together::generateById',
        'uses' => 'HomeController@generateById',
    ]);

    Route::get('/cron/cron-from-order', [
        'as' => 'bought-together::cronFromOrder',
        'uses' => 'CronController@cronFromOrder',
    ]);
    Route::get('/cron/bought-together-from-order', [
        'as' => 'bought-together::boughtTogetherFromOrder',
        'uses' => 'CronController@boughtTogetherFromOrder',
    ]);
    Route::get('/cron/tag-statistic', [
        'as' => 'bought-together::tagStatistic',
        'uses' => 'CronController@tagStatistic',
    ]);
    Route::get('/cron/init-data', [
        'as' => 'bought-together::initData',
        'uses' => 'CronController@initData',
    ]);
    Route::get('/data/views', [
        'as' => 'bought-together::data::views',
        'uses' => 'DataController@getUserViews',
    ]);
    Route::get('/data/cart-items', [
        'as' => 'bought-together::data::cart-items',
        'uses' => 'DataController@getCartItems',
    ]);
    Route::get('/data/products', [
        'as' => 'bought-together::data::products',
        'uses' => 'DataController@getProducts',
    ]);
    Route::get('/data/product-collections', [
        'as' => 'bought-together::data::product-collections',
        'uses' => 'DataController@getProductCollections',
    ]);
    Route::get('/find', [
        'as' => 'bought-together::find',
        'uses' => 'HomeController@findBoughtTogetherProducts'
    ]);
    Route::get('/mobile/find', [
        'as' => 'bought-together::mobile::find',
        'uses' => 'Mobile\MobileHomeController@findBoughtTogetherProducts'
    ]);
    Route::get('/product/find', [
        'as' => 'bought-together::product::find',
        'uses' => 'HomeController@findProduct'
    ]);
    Route::get('/product-variant', [
        'as' => 'bought-together::product::variant',
        'uses' => 'HomeController@getProductVariant'
    ]);
    Route::post('/add-all-to-cart', [
        'as' => 'bought-together::add-all-to-cart',
        'uses' => 'HomeController@addAllToCart'
    ]);
});
