module.exports = ProductController;
const request = require(__dir + '/utils/request');
const CacheEngine = require("cache");
cache = new CacheEngine(12 * 60 * 60 * 1000);
const g = require('ger')
const esm = new g.MemESM()
const ger = new g.GER(esm);
const moment = require('moment');
function ProductController($config, $event, $logger) {
    const dataWarehouseAPI = $config.get("api.data_warehouse", "");
    const siteURL = $config.get("app.siteURL", "/");
    var topProducts = [];
    this.recommend = async function (io) {
        let uid = io.inputs.uid;
        let pid = io.inputs.pid;
        let size = io.inputs.size || 12;
        let type = io.inputs.type;
        let recommendationFilter = {
            "actions": {
                "views": 1,
                "cart_items": 2,
            },
            // "similarity_search_size": 10000,
            "filter_previous_actions": ["cart_items"],
        };
        switch (type) {
            case 'views':
                recommendationFilter.actions = {
                    "views": 1
                }
                break;
            case 'cart-items':
                recommendationFilter.actions = {
                    "cart_items": 1
                }
                break;
        }
        if (uid != null) {
            ger.recommendations_for_person('products', uid, recommendationFilter)
                .then(async function (recommendations) {
                    let productIds = [];
                    for (let index = 0; index < recommendations.recommendations.length; index++) {
                        const element = recommendations.recommendations[index];
                        if (index >= size) {
                            break;
                        }
                        productIds.push(productCodeToId(element["thing"]));
                    }
                    productIds = mixTopProducts(productIds, size);
                    let products = await getProducts(productIds);
                    io.json({
                        "status": "successful",
                        "result": products
                    });
                });
        } else if (pid != null) {
            ger.recommendations_for_thing('products', productIdToCode(pid), recommendationFilter)
                .then(async function (recommendations) {
                    let productIds = [];
                    for (let index = 0; index < recommendations.recommendations.length; index++) {
                        const element = recommendations.recommendations[index];
                        if (index >= size) {
                            break;
                        }
                        productIds.push(productCodeToId(element["thing"]));
                    }
                    productIds = mixTopProducts(productIds, size);
                    let products = await getProducts(productIds);
                    io.json({
                        "status": "successful",
                        "result": products
                    });
                });
        }
    }

    this.recommendKeywords = async function (io) {
        var result = [];
        let pid = io.inputs.pid;
        if (pid != null) {
            let productCollections = await request.sendRequest(dataWarehouseAPI.host + "/product-collections", {
                "size": 5,
                "id": pid
            });
            if (productCollections.status == "successful") {
                productCollections.categories.reverse().forEach(item => {
                    result.push({
                        "title": item.name,
                        "url": siteURL + item.slug,
                        "image_url": item.image_url,
                    });
                });
                productCollections.tags.forEach(item => {
                    result.push({
                        "title": item.title,
                        "url": siteURL + item.slug,
                        "image_url": item.image_url,
                    });
                });
            }
        }
        io.json({
            "status": "successful",
            "result": result
        });
    }
    async function buildDataSet() {
        retval = [];
        let dataSetExpiredTime = moment();
        dataSetExpiredTime = dataSetExpiredTime.add(7, "days");
        dataSetExpiredTime = dataSetExpiredTime.format("YYYY-MM-DD");
        try {
            let cartItems = await request.sendRequest(dataWarehouseAPI.host + "/cart-items", {
                "size": 20000,
            });
            console.log("cartItems", cartItems.result.length);
            if (cartItems.status == "successful") {
                cartItems.result.forEach(item => {
                    if (item.cart != null && item.product_id != null) {
                        let pcode = productIdToCode(item.product_id)
                        retval.push({
                            namespace: "products",
                            person: item.cart.token,
                            action: "cart_items",
                            thing: pcode,
                            expires_at: dataSetExpiredTime
                        });
                    }
                });
            }
            let views = await request.sendRequest(dataWarehouseAPI.host + "/views", {
                "size": 50000,
            });
            console.log("views", views.result.length);
            let productMap = {};
            if (views.status == "successful") {
                views.result.forEach(item => {
                    let pcode = productIdToCode(item.target)
                    if (productMap[pcode] == null) {
                        productMap[pcode] = [];
                    } else if (!productMap[pcode].includes(item.imei)) {
                        productMap[pcode].push(item.imei);
                    }
                    retval.push(
                        {
                            namespace: "products",
                            person: item.imei,
                            action: "views",
                            thing: pcode,
                            expires_at: dataSetExpiredTime
                        }
                    );
                });
                topProducts = buildTopProducts(productMap);
                console.log("topProducts", topProducts.length);
            }
        } catch (error) {
            console.log("buildDataSet failed", error);
        }
        return retval;
    }
    function productCodeToId(pcode) {
        return pcode.replace("P_", "");
    }
    function productIdToCode(pid) {
        return "P_" + pid;
    }
    async function buildModel() {
        let dataSet = await buildDataSet();
        if (dataSet.length > 0) {
            await ger.initialize_namespace('products');
            await ger.events(dataSet);
            console.log("buildModel successed.");
        }
    }
    async function getProducts(productIds) {
        let retval = [];
        let productFilter = "";
        productIds.forEach(element => {
            productFilter += (element + ",")
        });
        let result = await request.sendRequest(dataWarehouseAPI.host + "/products", {
            "ids": productFilter
        });
        retval = result.result;
        for (let index = 0; index < retval.length; index++) {
            retval[index].url = siteURL + ((retval[index].slug != null) ? retval[index].slug : "san-pham") + "-p" + retval[index].id;        
        }
        return retval;
    }
    function buildTopProducts(productMap, size = 50) {
        var retval = [];
        for (const pcode in productMap) {
            if (Object.hasOwnProperty.call(productMap, pcode)) {
                const uids = productMap[pcode];
                retval.push({
                    "code": pcode,
                    "views": uids.length,
                });
            }
        }
        return retval.sort((a, b) => b.views - a.views).slice(0, size);;
    }

    function mixTopProducts(inputProductIds, size = 20) {
        topProducts = shuffle(topProducts);
        for (let index = 0; index < topProducts.length; index++) {
            const pid = productCodeToId(topProducts[index].code);
            if (inputProductIds.length < size && !inputProductIds.includes(pid)) {
                inputProductIds.push(pid);
            } else if (inputProductIds.length >= size) {
                break;
            }
        }
        return inputProductIds;
    }
    function shuffle(array) {
        let currentIndex = array.length, randomIndex;
        // While there remain elements to shuffle.
        while (currentIndex != 0) {
            // Pick a remaining element.
            randomIndex = Math.floor(Math.random() * currentIndex);
            currentIndex--;
            // And swap it with the current element.
            [array[currentIndex], array[randomIndex]] = [
                array[randomIndex], array[currentIndex]];
        }
        return array;
    }
    async function init() {
        let isBuildingModel = false;
        await buildModel();
        setInterval(async function () {
            if (isBuildingModel == false) {
                isBuildingModel = true;
                await buildModel();
                isBuildingModel = false;
            }
        }, 50 * 1000);
    }
    init();
}