const request = require("request");
module.exports = {
    sendRequest: function (url, params, method) {
        method = method == null ? "get" : method;
        var requestParam = {
            "url": url,
            "method": method,
            headers: {
                'cache-control': 'no-cache',
                'Content-Type': 'application/json'
            },
        };
        if (method.toLowerCase() == "get") {
            if (params != null) {
                var isFirst = true;
                for (var prop in params) {
                    url += (isFirst ? "?" : "&") + prop + "=" + params[prop];
                    isFirst = false;
                }
            }
            requestParam.url = url;
        } else {
            requestParam.json = true;
            requestParam.body = params;
        }
        return new Promise((resolve, reject) => {
            request(requestParam, function (error, response, body) {
                if (error != null) {
                    reject(error);
                } else {
                    if (typeof body === 'string' || body instanceof String) {
                        var bodyJSON = {};
                        try {
                            bodyJSON = JSON.parse(body);                                                  
                        } catch (error) {
                            bodyJSON = {};
                        }
                        resolve(bodyJSON);      
                    } else {
                        resolve(body);
                    }
                }
            });
        });
    }
}