<?php

namespace Modules\BrowsingHistory\Controllers;

use Illuminate\Http\Request as IHRequest;
use Illuminate\Support\Facades\DB;
use Request;
use Module;
use Modules\BrowsingHistory\Models\Product;
use Modules\BrowsingHistory\Models\UserViewed;
use Session;

class HomeController extends Controller
{
    public function __construct()
    {        
        Module::onView("content", function() {
            return "This is content view from BrowsingHistory Module HomeController";
        }, 5);
    }
    public function index($data)
    {
        return view('browsing-history::home.index',$data);
    }
    public function viewPage(Request $request)
    {
    }
    public function getProducts(IHRequest $request)
    {
        $id = $request->input('id');
        $fingerprint = getFingerprint();
        if ($request->has("token")) {
            $fingerprint = $request->input("token");
        }
        if (!empty($id)) {
            $this->cleanData($fingerprint);
            $userViewed = UserViewed::where('imei',$fingerprint)->where('target',$id)->where('type',UserViewed::TYPE_PRODUCT)->first();
            if (empty($userViewed)){
                $userViewed = new UserViewed;
                $userViewed->created_at = date('Y-m-d H:i:s');
            }
            $userViewed->updated_at = date('Y-m-d H:i:s');
            $userViewed->imei = $fingerprint;
            $userViewed->target = $id;
            $userViewed->ip = Request::ip();
            $userViewed->user_agent = Request::header('User-Agent');
            $saved = $userViewed->save();
            if (!$saved){
                \Log::info("BrowsingHistory ErrorSave: " . $fingerprint . ':' . $id . ':' . Request::ip() . ':' .Request::header('User-Agent'));
            }
        }
        $query = UserViewed::where('imei', '=', $fingerprint);
        $productList = $query->where('type', '=', UserViewed::TYPE_PRODUCT)
            ->orderBy('updated_at', 'DESC')
            ->limit(20)
            ->pluck('target')->toArray();
        if (!empty($productList)) {
            $products = Product::whereIn('id', $productList)
                ->where('status', '=', 'ACTIVE')
                ->where('deleted_at', NULL)
                ->get(['id', 'sku', 'image_url', 'price', 'high_price', 'name', 'slug'])->toArray();
            usort($products, function($a, $b) use ($productList) {
                $posA = array_search($a['id'], $productList);
                $posB = array_search($b['id'], $productList);
                return $posA - $posB;
            }); 
        } else {
            return response()->json(["status" => "successful", 'result' => []]);
        }
        priceChangeDecor($products);

        return response()->json(["status" => "successful", 'result' => $products]);
    }

    private function cleanData($fingerprint){
        $cache = \Cache::get($fingerprint);
        if (!empty($cache) && $cache == 'cache'){
            DB::delete("DELETE t1 FROM sb_user_viewed t1 JOIN sb_user_viewed t2 ON t1.target = t2.target AND t1.id < t2.id AND `t1`.`imei` = '".$fingerprint."' and `t2`.`imei` = '".$fingerprint."' and `t1`.`type` = 'product' and `t2`.`type` = 'product' ");
            \Cache::forever($fingerprint, 'cache');
        }
    }

    public function getFingerPrint(IHRequest $request)
    {
        $fingerprint = getFingerprint();
        if ($request->has("token")) {
            $fingerprint = $request->input("token");
        }
        $productId = $request->input('product_id');
        $products = [];
        if ($productId != '') {
            $products = Product::where('id', $productId)
                ->where('status', '=', 'ACTIVE')
                ->where('deleted_at', NULL)
                ->get(['id', 'sku', 'image_url', 'price', 'high_price', 'name', 'slug'])->toArray();
            priceChangeDecor($products);

        }
        return response()->json(['status' => 'successful', 'result' => $fingerprint, 'products' => $products]);
    }
    public function saveUserViewed(IHRequest $request)
    {
        $id = $request->input('id');
        $fingerprint = getFingerprint();
        if ($request->has("token")) {
            $fingerprint = $request->input("token");
        }
        if (!empty($id)) {
            $this->cleanData($fingerprint);
            $userViewed = UserViewed::where('imei',$fingerprint)->where('target',$id)->where('type',UserViewed::TYPE_PRODUCT)->first();
            if (empty($userViewed)){
                $userViewed = new UserViewed;
                $userViewed->created_at = date('Y-m-d H:i:s');
            }
            $userViewed->updated_at = date('Y-m-d H:i:s');
            $userViewed->imei = $fingerprint;
            $userViewed->target = $id;
            $userViewed->ip = Request::ip();
            $userViewed->user_agent = Request::header('User-Agent');
            $saved = $userViewed->save();
            if (!$saved){
                \Log::info("BrowsingHistory ErrorSave: " . $fingerprint . ':' . $id . ':' . Request::ip() . ':' .Request::header('User-Agent'));
            }
        }

        return response()->json(['status' => 'successful', 'result' => []]);
    }
}
