<?php

namespace Modules\BrowsingHistory\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{

    public $timestamps = false;
    protected $table = "product";
    protected $guarded = ['id'];
    protected $fillable = ['sku', 'name', 'slug', 'image_url', 'status'];
    protected $appends = ["url","display_price","display_high_price"];
    use SoftDeletes;

    public function getUrlAttribute () {
        return "/" . (!empty($this->slug) ? $this->slug : "san-pham") . "-p" . $this->id;
    }
    public function getDisplayPriceAttribute() {
        if ($this->price > 0) {
            $this->price = doubleval($this->price);
            return formatPrice($this->price);
        } else {
            return translate('Contact');
        }
    }

    public function getDisplayHighPriceAttribute() {
        if ($this->high_price > 0) {
            $this->high_price = doubleval($this->high_price);
            return formatPrice($this->high_price);
        }
    }
}
