let localeBrowsingHistory = '';
var urlGetFingerPrint = '/browsing-history/get-fingerPrint';
var urlSaveUserViewed = '/browsing-history/save-user-viewed';

function loadFingerPrint(trackingOnly = false) {
    if (trackingOnly && browsingHistoryProductId != '') {
        saveUserViewedToDatabase();
        return;
    }
    let url = localeBrowsingHistory + urlGetFingerPrint + '?product_id=' + browsingHistoryProductId;
    fetch(
        url, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json'
            }
        }
    ).then(function (response) {
        return response.json();  // Chuyển phản hồi sang JSON
    }).then(function (data) {
        if (data.status === 'successful') {
            let fingerPrint = data.result;
            let product = data.products;
            if (browsingHistoryProductId != '') {
                saveUserViewed(browsingHistoryProductId, fingerPrint, localePrefix, product)
            }
            let productList = getUserViewed(fingerPrint, localePrefix);
            bindDataToHtml(productList);
            saveUserViewedToDatabase();
        }
    }).catch(function (error) {
        console.log("Error:", error);
    });
}

function getLocale() {
    let locale = '';
    if (typeof localePrefix !== 'undefined' && localePrefix !== '' && localePrefix != 'us') {
        locale += '/' + localePrefix;
    }
    return  locale;
}

function bindDataToHtml(products) {
    if (products && products.length > 0) {
        document.querySelectorAll('#product-viewed-content .md-product-viewed-heading').forEach(element => element.classList.remove("hide"));
        let html = "";
        products.forEach(element => {
            html += `
                            <div class="md-product-viewed-item-wrapp swiper-slide">
                                <div class="md-product-viewed-item">
                                    <a class="md-product-viewed-link" href="${getLocale()}${element.url}" target="_blank">
                                        <img class="md-product-viewed-image" loading="lazy" src="${getImageCdn(element.image_url, 540, 540)}" width="233" height="233" referrerpolicy="no-referrer" alt="Discover ${element.name}">
                                    </a>
                                    <div class="md-product-viewed-title-box flex-b align-c">
                                        <a class="md-product-title" href="${getLocale()}${element.url}" target="_blank">
                                            ${element.name}
                                        </a>
                                    </div>
                                    ${getItemPriceHtml(element)}
                                </div>
                            </div>
                        `;
        });

        $("#product-viewed-content").find(".md-product-viewed-list .swiper-wrapper").html(html);
        $("#product-viewed-content").show();
        if (products.length) {
            triggerSlide();
        }
    } else {
        $("#product-viewed-content").hide();
    }

    let loading_product = document.querySelector('#product-viewed-content .loading-product-viewed-content');
    if(loading_product) {
        loading_product.remove();
    }
}

function saveUserViewed(id, fingerprint, localeBrowsingHistory, product) {
    if (!id || !fingerprint || !product) {
        return;
    }
    if (localeBrowsingHistory === '' || localeBrowsingHistory === 'undefined') {
        localeBrowsingHistory = 'us';
    }

    const key = localeBrowsingHistory + '_userViewed';
    let userViewedList = JSON.parse(localStorage.getItem(key)) || [];

    // Clean duplicates: loại bỏ các bản ghi trùng lặp dựa trên target (id) và fingerprint (imei)
    userViewedList = userViewedList.filter(function (item) {
        return !(item.imei === fingerprint && item.target === id);
    });

    // Tạo đối tượng mới cho mục đã xem
    const userViewed = {
        imei: fingerprint,
        target: id,
        user_agent: navigator.userAgent,
        url: product[0].url,
        display_high_price: product[0].display_high_price,
        display_price: product[0].display_price,
        image_url: product[0].image_url,
        name: product[0].name,
        high_price: product[0].high_price,
        price: product[0].price,
        created_at: new Date().toISOString(),
        updated_at: new Date().toISOString()
    };

    // Thêm mục đã xem mới vào danh sách
    userViewedList.push(userViewed);

    // Giới hạn danh sách chỉ có 20 mục gần đây nhất
    if (userViewedList.length > 20) {
        userViewedList = userViewedList.slice(-20);
    }

    // Lưu lại danh sách đã xem vào localStorage
    localStorage.setItem(key, JSON.stringify(userViewedList));
}

// Lấy danh sách các sản phẩm đã xem
function getUserViewed(fingerprint, localeBrowsingHistory) {
    if (localeBrowsingHistory === '' || localeBrowsingHistory === 'undefined') {
        localeBrowsingHistory = 'us';
    }
    const key = localeBrowsingHistory + '_userViewed';
    const userViewedList = JSON.parse(localStorage.getItem(key)) || [];

    // Lọc danh sách dựa trên fingerprint (imei) và lấy target (id)
    const productList = userViewedList
        .filter(function (item) {
            return item.imei === fingerprint;
        })
        .sort(function (a, b) {
            return new Date(b.updated_at) - new Date(a.updated_at); // Sắp xếp theo updated_at giảm dần
        })
        .map(function (item) {
            return item; // Lấy target (id)
        });

    return productList;
}

function saveUserViewedToDatabase() {
    fetch(
        localeBrowsingHistory + urlSaveUserViewed, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({id: browsingHistoryProductId, url: document.URL})
        }
    ).then(function (data) {
        if (data.status === 200) return data.json(); else return {};
    }).then(function (response) {

    })
}

function getItemPriceHtml(element) {
    let priceHtml = '';
    if (element.price > 0) {
        priceHtml += `<span class="md-product-viewed-price">${element.display_price}`;
        if (element.high_price && parseFloat(element.high_price) > parseFloat(element.price)) {
            priceHtml += `<small style="text-decoration: line-through; color: #595959; padding-left: 5px;">${element.display_high_price}</small>`
        }
        priceHtml += `</span>`;
    } else {
        priceHtml += `<span class="md-product-viewed-price"> <?= __("Contact") ?> </span>`;
    }
    return priceHtml;
}

function triggerSlide() {
    var swiper = new Swiper('.md-product-viewed-list', {
        slidesPerView: 2.1,
        slidesPerGroup: 2.1,
        spaceBetween: 6,
        navigation: {
            nextEl: ".recently-btn-next",
            prevEl: ".recently-btn-prev",
        },
        breakpoints: {
            480: {
                slidesPerView: 3,
                slidesPerGroup: 3,
            },
            800: {
                slidesPerView: 4,
                slidesPerGroup: 4,
            },
            1200: {
                slidesPerView: 5,
                slidesPerGroup: 5,
            },
            1400: {
                slidesPerView: 6,
                slidesPerGroup: 6,
            },
        },
    });
}

function generateSliderViewed(selectorSlide) {
    function productViewedSlider(selector, config) {
        let
            _mainElement = document.querySelector(selector),
            _sliderWrapper = _mainElement.querySelector('.md-product-viewed-list'),
            _sliderItems = _mainElement.querySelectorAll('.md-product-viewed-item'),
            _sliderControls = _mainElement.querySelectorAll('.md-product-viewed-slider-control'),
            _sliderControlLeft = _mainElement.querySelector('.md-product-viewed-slider-control_left'),
            _sliderControlRight = _mainElement.querySelector('.md-product-viewed-slider-control_right'),
            _wrapperWidth = parseFloat(getComputedStyle(_sliderWrapper).width),
            _itemWidth = parseFloat(getComputedStyle(_sliderItems[0]).width),
            _positionLeftItem = 0,
            _transform = 0,
            _step = _itemWidth / _wrapperWidth * 100,
            _items = [];

        _sliderItems.forEach(function (item, index) {
            _items.push({item: item, position: index, transform: 0});
        });

        let position = {
            getItemMin: function () {
                var indexItem = 0;
                _items.forEach(function (item, index) {
                    if (item.position < _items[indexItem].position) {
                        indexItem = index;
                    }
                });
                return indexItem;
            },
            getItemMax: function () {
                var indexItem = 0;
                _items.forEach(function (item, index) {
                    if (item.position > _items[indexItem].position) {
                        indexItem = index;
                    }
                });
                return indexItem;
            },
            getMin: function () {
                return _items[position.getItemMin()].position;
            },
            getMax: function () {
                return _items[position.getItemMax()].position;
            }
        }
        let _transformItem = function (direction) {
            var nextItem;

            if (direction === 'right') {
                if (_positionLeftItem + 1 > _items.length) {
                    return;
                }

                _positionLeftItem++;
                if ((_positionLeftItem + _wrapperWidth / _itemWidth - 1) > position.getMax()) {
                    nextItem = position.getItemMin();
                    _sliderControlLeft.classList.remove('disabled');
                    _items[nextItem].position = position.getMax() + 1;
                    _items[nextItem].transform += _items.length * 100;
                    _items[nextItem].item.style.transform = 'translateX(' + _items[nextItem].transform + '%)';
                }

                _sliderControlLeft.style.display = 'flex'
                if (_positionLeftItem > _items.length - 6) {
                    return;
                }

                if (_positionLeftItem == _items.length - 6) {
                    _sliderControlRight.style.display = 'none'
                }

                _transform -= _step;
            }
            if (direction === 'left') {
                if (_positionLeftItem - 1 < 0) {
                    return;
                }

                _positionLeftItem--;
                if (_positionLeftItem < position.getMin()) {
                    nextItem = position.getItemMax();
                    _sliderControlRight.classList.remove('disabled');
                    _items[nextItem].position = position.getMin() - 1;
                    _items[nextItem].transform -= _items.length * 100;
                    _items[nextItem].item.style.transform = 'translateX(' + _items[nextItem].transform + '%)';
                }
                _sliderControlRight.style.display = 'flex'
                if (_positionLeftItem < 0) {
                    return;
                }

                if (_positionLeftItem < 1) {
                    _sliderControlLeft.style.display = 'none'
                }

                _transform += _step;
            }
            _sliderWrapper.style.transform = 'translateX(' + _transform + '%)';
        }

        let _controlClick = function (e) {
            var direction = this.classList.contains('md-product-viewed-slider-control_right') ? 'right' : 'left';
            e.preventDefault();
            _transformItem(direction);
        };

        let _setUpListeners = function () {
            _sliderControls.forEach(function (item) {
                item.addEventListener('click', _controlClick);
            });
        }

        _setUpListeners();
        return {
            right: function () {
                _transformItem('right');
            },
            left: function () {
                _transformItem('left');
            }
        }
    }

    var slider = productViewedSlider(selectorSlide)
}

function browsingHistoryReady(callback) {
    // in case the document is already rendered
    if (document.readyState !== 'loading') callback();
    // modern browsers
    else if (document.addEventListener) document.addEventListener('DOMContentLoaded', callback);
    // IE <= 8
    else document.attachEvent('onreadystatechange', function () {
            if (document.readyState === 'complete') callback();
        });
}

browsingHistoryReady(function () {
    const browsingHistoryObserver = new IntersectionObserver(function (entries, observer) {
        entries.forEach(function (entry) {
            if (entry.isIntersecting) {
                document.querySelectorAll('#product-viewed-content .md-product-viewed-slide').forEach(element => element.classList.remove("hide"));
                browsingHistoryObserver.unobserve(entry.target);
                loadFingerPrint();
            }
        });
    }, {
        rootMargin: "200px"
    });

    if (document.getElementById('product-viewed-content')) {
        browsingHistoryObserver.observe(document.getElementById('product-viewed-content'));
    }

    loadFingerPrint();
});