<?php

namespace Modules\Cart\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use App\Helpers\ApiClient;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\CustomerLoginController;
use Illuminate\Support\Facades\View;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    public function __construct()
    {
        $user = Auth::user();
        if($user && isset($user->role) && in_array($user->role, ['STAFF','ADMIN']) ) {
            \Illuminate\Support\Facades\View::share('isAdmin', true);
        }else{
            View::share('isAdmin', false);
        }

        $customer = Auth::guard('customer')->user();
        if($customer && $customer->status == CustomerLoginController::USER_ACTIVE_STATUS) {
            View::share('customer', $customer);
        }
    }
    const DEFAULT_STATUS = 'fail';
    const SUCCESS_STATUS = 'successful';

    protected function getDefaultStatus() {
        return ['status' => self::DEFAULT_STATUS];
    }
    
    protected function getSuccessStatus() {
        return ['status' => self::SUCCESS_STATUS];
    }

    public function isPageRefresh($items, $type) {
        $productIds = [];
        foreach ($items as $item) {
            $productIds[] = $item['product_id'];
        }
        sort($productIds);
        $token = getFingerprint();
        $key = $type . '-' . $token ;
        $compareValue = \Cache::get($key);
        $check = false;
        $value = md5(json_encode($productIds));
        if ($compareValue != $value) {
            \Cache::forever($key, $value);
        } else {
            $check = true;
        }

        return $check;
    }

    public function clearPageRefresh($items) {
        $token = getFingerprint();
        Cache::forget('cart-' . $token);
        Cache::forget('checkout-' . $token);
        $key = 'cart-product-' . $token;
        Cache::forget($key);
        $key = 'checkout-product-' . $token;
        Cache::forget($key);
    }

    public function getUntrackItem($items, $type) {
        $retVal = [];
        $token = getFingerprint();
        foreach($items as $item) {
            $key = $type . '-product-' . $token;
            $value = Cache::get($key);
            if (!$value) {
                $value = [];
            }
            if (!in_array($item['product_id'], $value)) {
                $value[] = $item['product_id'];
                Cache::forever($key, $value);
                $retVal[] = $item;
            }
        }

        return $retVal;
    }

    protected function getCountries() {
        $key = 'all-countries';
        $countries = Cache::get($key);
        if (!$countries || !empty($_GET['clear_cache'])) {
            $query = ApiClient::buildClient("/country?embeds=provinces&page_size=-1");
            $result = $query->get();
            if (isset($result['status']) && $result['status'] == 'successful') {
                $countries = $result['result'];
                if (!empty($countries)) {
                    Cache::forever($key, $countries);
                }
            }
        }
        
        return $countries;
    }

    protected function getProductTrademarks() {
        $key = 'all-product-trademarks';
        $locale = env('APP_LOCALE');
        if (!empty($locale)) {
            $key = $key . '-' . $locale;
        }
        $keywords = Cache::get($key);
        if (!$keywords || !empty($_GET['clear_cache'])) {
            $keywords = DB::table('product_trademarks')
                            ->where("type", "keyword")
                            ->where("site", "PAYPAL")
                            ->where("status", "ACTIVE")
                            ->pluck("keyword")
                            ->toArray();
            if (!empty($keywords)) {
                Cache::forever($key, $keywords);
            }
        }
        return $keywords;
    }

}
