<?php 
namespace Modules\Cart\Controllers\Services;

use App\Helpers\ApiClient;
use Megaads\ApifyClient\Client;
use Modules\Cart\Controllers\Controller;
use Illuminate\Http\Request;

class CartService extends Controller 
{
    public function getDistricts(Request $request) {
        $retval = $this->getDefaultStatus();
        $input = $request->all();
        if ( isset($input['location_id']) ) {
            $locationId = explode('_', $input['location_id'])[0];
            $query = ApiClient::buildClient("location");
            $query->filter('parent_id', Client::SELECTION_EQUAL, $locationId);
            $result = $query->get();
            if ( isset($result['status']) 
            && $result['status'] == 'successful'
            && count($result['result']) > 0 ) {
                $retval = $this->getSuccessStatus();
                $retval['data'] = $result['result'];
            }
        }
        return response()->json($retval);
    }

    public function changeQuantity(Request $request) {
        $retval = $this->getDefaultStatus();
        $input = $request->all();
        
        if ( isset($input['item_id']) && isset($input['item_quantity']) && isset($input['type']) ) {

        }
        
        return response()->json($retval);
    }
}