# Custom checkout footer

## Installation

Create a file name "checkout-footer.blade.php" in folder resources/views/themes/{theme-name}/inc/cart/

## Content

```
<?php 
    $checkoutFooter = getOption('checkout.footer');
?>

{!! $checkoutFooter !!}
```
## Usage

Create an Option Editor name "checkout.footer" with your custom content

# Custom shipping description

## Installation

Create a file name "shipping-description.blade.php" in folder resources/views/themes/{theme-name}/inc/cart/

## Content

```
<?php 
    $shippingDescription = getOption('checkout.shipping.description');
?>

{!! $shippingDescription !!}
```

## Usage

Create an Option Editor name "checkout.shipping.description" with your custom content

## Shipping url
Create an Option Editor name "checkout.shipping.url" with your shipping policy url

# Cart Usage
## Include header

Add this line to header 
```
@view('cart.mini-cart-header')
```


## Include mini cart

Add this line to header 
```
@view('cart.mini-cart')
```

## Add to cart script

Add this line to js section on product page.
```
@view('cart.add-to-cart-script')
```

Add this to product page.
```
<input type="hidden" id="productId" value="{{ $product['id'] }}">
<input type="hidden" id="isOption" value="{{ count($variants['variants']) > 0 ? 1 : 0 }}">
<input type="hidden" class="js-productSkuId" id="productSkuId" value="{{ request()->input('spid') }}">
```