system.config(['dynamicNumberStrategyProvider', function(dynamicNumberStrategyProvider){
    dynamicNumberStrategyProvider.addStrategy('price', {
      numInt: 6,
      numFract: 2,
      numSep: '.',
      numPos: true,
      numNeg: true,
      numRound: 'round',
      numThousand: true
    });
  }]);
system.controller("ProductTrademarksController", ProductTrademarksController);
function ProductTrademarksController($scope, $http, $rootScope, $timeout, Upload) {
    $scope.baseController = this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.filters = {
        page_id: 0
    };
    $scope.isLoading = false;
    $scope.items = [];
    $scope.statusses = {
        ACTIVE: "Active",
        PENDING: "Pending",
    };
    $scope.types = {
        keyword: "Keyword",
        product: "Product",
    };
    $scope.sites = {
        PAYPAL: "Paypal",
        STRIPE: "Stripe",
    };
    $scope.init = function () {
        $scope.find(true);
    }

    $scope.clear = function () {
        $scope.filters = {
            page_id: 0
        }
        $scope.find(true);
    }

    $scope.find = function (refresh) {
        if (refresh) {
            $scope.filters.page_id = 0;
        }
        var filter = buildFilter();
        var params = getParams(filter);
        var url = '/service/product/trademarks/find';
        if (params.length > 0) {
            url += '?' + params.join('&');
        }
        $scope.isLoading = true;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    var items = [];
                    if (response.data.result.length > 0) {
                        response.data.result.forEach(function(item) {
                            items.push(item);
                        });
                    }
                    $scope.items = items;
                    $scope.pagesCount = response.data.pagesCount;
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    function buildFilter() {
        var retVal = {};
        if ($scope.filters.keyword) {
            retVal.keyword = $scope.filters.keyword;
        }
        if ($scope.filters.status) {
            retVal.status = $scope.filters.status;
        }
        if ($scope.filters.site) {
            retVal.site = $scope.filters.site;
        }
        if ($scope.filters.type) {
            retVal.type = $scope.filters.type;
        }
        retVal.page_id = $scope.filters.page_id;
        return retVal;
    }

    getParams = function(filter) {
        var params = [];
        for (var key in filter) {
            var filterValue = filter[key];
            var param = '';
            if (typeof filterValue == 'object' || typeof filterValue == 'array') {
                if (filterValue.length > 0) {
                    param = key + '=' + filterValue.join(',');
                }
            } else {
                param = key + '=' + filterValue;
            }
            if (param != '') {
                params.push(param);
            }
        }
        return params;
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find(false);
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find(false);
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find(false);
        }
    };


    $scope.saveProductTrademarks = function () {
        var data = buildData();
        console.log(data)
        if (!data.keyword) {
            toastr.error('Please enter keyword.');
            return;
        }
        if (!data.type) {
            toastr.error('Please select type.');
            return;
        }
        if (!data.site) {
            toastr.error('Please select site.');
            return;
        }
        if (!data.status) {
            toastr.error('Please select status.');
            return;
        }
        var url = 'service/product/trademarks/store';
        
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.find();
                    $scope.showForm = false;
                    toastr.success('Save product trademarks successfully');
                    $('#addProductTrademarksModal').modal('toggle');
                } else {
                    toastr.error('Error. PLease try again!');
                }
            }, function (error) {
                toastr.error('Error. PLease try again!');
            })
    }

    function buildData () {
        var retVal = angular.copy($scope.productTrademarks);
        return retVal;
    }

    
    $scope.editProductTrademarks = function (item) {
        $scope.productTrademarks = angular.copy(item);
        $('#addProductTrademarksModal').modal('toggle');
    }
    $scope.openModalCreateProductTrademarks = function () {
        $scope.productTrademarks = {};
        $('#addProductTrademarksModal').modal('toggle');
    }
    $scope.closeCreateProductTrademarks = function () {
        $('#addProductTrademarksModal').modal('toggle');
    }

    $scope.deleteProductTrademarks = (item) => {
        $.confirm({
            title: "Delete product trademarks!",
            content: "Are you sure you want to delete this product trademarks?",
            buttons: {
                confirm: function() {
                    var url = "service/product/trademarks/delete";
                    var data = {
                        id: item.id,
                    };
                    if (typeof user != "undefined") {
                        data.email = user.email;
                    }
                    $scope.isLoading = true;
                    $http
                        .post(url, data)
                        .then(function(response) {
                            if (response.data.status == "successful") {
                                $scope.find(true);
                                toastr.success("Data deleted successfully!");
                            } else {
                                if (response.data.message) {
                                    toastr.error(response.data.message);
                                } else {
                                    toastr.error("Error. PLease try again!");
                                }
                            }
                            $scope.isLoading = false;
                        })
                        .catch(function(error) {
                            toastr.error("Error. PLease try again!");
                            $scope.isLoading = false;
                        });
                },
                cancel: function() {},
            },
        });
    };

    $scope.init();
}