@extends('layouts')
@section('main')
	{!! Breadcrumbs::render('check_out') !!}
	<div id="tt-pageContent">
		<div class="container-indent">
			<div class="container">
				<h1 class="tt-title-subpages noborder"><?= __("SHOPPING CART") ?></h1>
				<div class="tt-shopcart-table-02">
                    @if ( isset($cartItems) && count($cartItems) > 0)
                    <table>
						<tbody>
                            @foreach( $cartItems as $cItem )
                            @php
                                $cItem = (object) $cItem;
                                $product = (object) $cItem->product;
                            @endphp
                            <tr>
								<td>
									<div class="tt-product-img">
										<img src="images/loader.svg" data-src="{{ $cItem->image_url }}" alt="">
									</div>
									<input type="hidden" id="js-cart-hidden-item-id" value="{{ $cItem->id }}" />
								</td>
								<td>
									<h2 class="tt-title">
										<a href="{{ route('product', ['slug' => $product->slug, 'id' => $product->id]) }}">{{ $cItem->product_name }}</a>
									</h2>
									<ul class="tt-list-description">
										<li>{{ __('Size') }}: 22</li>
										<li>{{ __('Color') }}: Green</li>
									</ul>
									<ul class="tt-list-parameters">
										<li>
											<div class="tt-price">
												{{ $cItem->price }}
											</div>
										</li>
										<li>
											<div class="detach-quantity-mobile"></div>
										</li>
										<li>
											<div class="tt-price subtotal">
                                            {{ $cItem->price }}
											</div>
										</li>
									</ul>
								</td>
								<td>
									<div class="tt-price">
                                    {{ $cItem->price }}
									</div>
								</td>
								<td>
									<div class="detach-quantity-desctope">
										<div class="tt-input-counter style-01">
											<span id="js-cart-minus" class="minus-btn"></span>
											<input id="js-cart-quantity" type="text" value="{{ $cItem->quantity }}" size="1000">
											<span id="js-cart-plus" class="plus-btn"></span>
										</div>
									</div>
								</td>
								<td>
									<div class="tt-price subtotal">
                                    {{ $cItem->price }}
									</div>
								</td>
								<td>
									<a id="js-cart-remove" href="#" class="tt-btn-close"></a>
								</td>
							</tr>
                            @endforeach
						</tbody>
					</table>
                    @endif
					<div class="tt-shopcart-btn">
						<div class="col-left">
							<a class="btn-link" href="shopping_cart_02.html#"><i class="icon-e-19"></i><?= __("CONTINUE SHOPPING") ?></a>
						</div>
						<div class="col-right">
							<a class="btn-link" href="shopping_cart_02.html#"><i class="icon-h-02"></i><?= __("CLEAR SHOPPING CART") ?></a>
							<a class="btn-link" href="shopping_cart_02.html#"><i class="icon-h-48"></i><?= __("UPDATE CART") ?></a>
						</div>
					</div>
				</div>
				<div class="tt-shopcart-col">
					<div class="row">
						<div class="col-md-6 col-lg-4">
							<div class="tt-shopcart-box">
								<h4 class="tt-title">
									<?= __("ESTIMATE SHIPPING AND TAX") ?>
								</h4>
								<p><?= __("Enter your destination to get a shipping estimate.") ?></p>
								<form class="form-default">
									<div class="form-group">
										<label for="address_country"><?= __("COUNTRY") ?> <sup>*</sup></label>
										<select id="js-cart-location" class="form-control">
											@if( isset($cities) && count($cities) > 0 )
											@foreach($cities as $city )
											@php $city = (object) $city; @endphp
												<option value="{{ $city->id . '_' . $city->is_urban }}">{{ $city->name }}</option>
											@endforeach
											@endif
										</select>
									</div>
									<div class="form-group">
										<label for="address_province"><?= __("STATE/PROVINCE") ?> <sup>*</sup></label>
										<select id="js-cart-district" class="form-control">
											<option>{{ __('State/Province') }}</option>
										</select>
									</div>
									<div class="form-group">
										<label for="address_zip"><?= __("ADDRESS") ?><sup>*</sup></label>
										<input type="text" name="name" class="form-control" id="address_zip" placeholder="Zip/Postal Code">
									</div>
									<a href="shopping_cart_02.html#" class="btn btn-border"><?= __("CALCULATE SHIPPING") ?></a>
									<p>
										<?= __("There is one shipping rate available for Alabama, Tanzania, United Republic Of.") ?>
									</p>
									<ul class="tt-list-dot list-dot-large">
										<?php $textInternalShip = 'International Shipping at %s'; ?>
										<li><a href="shopping_cart_02.html#">{{ formatString(__($textInternalShip), '$20.00') }}</a></li>
									</ul>
								</form>
							</div>
						</div>
						<div class="col-md-6 col-lg-4">
							<div class="tt-shopcart-box">
								<h4 class="tt-title">
									<?= __("NOTE") ?>
								</h4>
								<p><?= __("Add special instructions for your order...") ?></p>
								<form class="form-default">
									<textarea class="form-control" rows="7"></textarea>
								</form>
							</div>
						</div>
						<div class="col-md-6 col-lg-4">
							<div class="tt-shopcart-box tt-boredr-large">
								<table class="tt-shopcart-table01">
									<tbody>
										<tr>
											<th><?= __("SUBTOTAL") ?></th>
											<td>$324</td>
										</tr>
									</tbody>
									<tfoot>
										<tr>
											<th><?= __("GRAND TOTAL") ?></th>
											<td>$324</td>
										</tr>
									</tfoot>
								</table>
								<a href="shopping_cart_02.html#" class="btn btn-lg"><span class="icon icon-check_circle"></span>{{ __('PROCEED TO CHECKOUT') }}</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	@parent
	<script type="text/javascript">
		$(document).ready(function() {
			console.log('Cart module loaded...');
			$('#js-cart-minus').click(function() {
				var quantityValue = $('#js-cart-quantity').val()
				console.log('Down clicked ', quantityValue);
			});
			$('#js-cart-plus').click(function() {
				var quantityValue = $('#js-cart-quantity').val()
				console.log('Up clicked ', quantityValue);
			});
			$('#js-cart-remove').click(function(e) {
				e.preventDefault();
				var itemId = $('#js-cart-hidden-item-id').val();
				console.log('Remove item ', itemId);
			});
			$('#js-cart-location').change(function() {
				var locationValue = $(this).val();
				sendHttpRequest('/get-district', 'get', {location_id: locationValue}, getDistrictSuccess);
			});
		});

		function sendHttpRequest(_endpoint, _method, _data, success_callback) {
			$.ajax({
				url: _endpoint,
				type: _method,
				data: _data,
				error: function(error) {
					console.log('Request error ');
				},
				success: function(response) {
					if ( typeof success_callback == 'function' ) {
						success_callback(response);
					}
				}
			});
		}

		function getDistrictSuccess(response) {
			if ( response.status == 'successful' ) {
				var data = response.data;

				$('#js-cart-district').empty().append($('<option>',{value: '', text: 'State/Province'}));
				$.each(data, function(i, item){
					$('#js-cart-district').append($('<option>',{value: item.id+'_'+item.is_urban, text: item.name}));
				});
			}
		}
	</script>
@endsection
