<div id="cart-module-content">
    <div class="container-indent">
        @if (empty($cartItems))
            <div id="isEmptyCart" class="tt-empty-cart">
                @include('cart::cart.empty')
            </div>
        @else
            @php
                $shoppingRating = getOption('shopping-ratings');
                $shoppingRatingCount = getOption('shopping-ratings-count');
                $currentLocale = strtoupper(env('APP_LOCALE'));
                if (empty($currentLocale)) {
                    $currentLocale = 'US';
                }
                $shoppingUrl = getOption('general.google_customer_review_url', "https://customerreviews.google.com/v/merchant?q=printerval.com&v=19&hl=en&c=") . $currentLocale;
                $isShowGuarantee = config("cart::sa.show_guarantee", true);
                $designFee = config('cart::sa.design_fee', 0);
                $useTaxes = config('cart::sa.use_taxes', false);
                $rewardsPercent = config('cart::sa.rewards_percent', 0);
                function getLinkLoyalty($locale) {
                    $listLink = [
                        'US' => 'https://printerval.com/printerval-reward-programs-n898.html',
                        'CA' => 'https://printerval.com/ca/printerval-reward-programs-n907142.html',
                        'UK' => 'https://printerval.com/uk/loyalty-program-n907157.html',
                        'IT' => 'https://printerval.com/it/printerval-reward-programs-n906991.html',
                        'FR' => 'https://printerval.com/fr/printerval-reward-programs-n907127.html',
                        'AU' => 'https://printerval.com/au/loyalty-program-n907143.html',
                        'JP' => 'https://printerval.com/jp/printerval-reward-programs-n907128.html',
                        'DE' => 'https://printerval.com/de/printerval-reward-programs-n907123.html',
                        'PR' => 'https://printerval.com/printerval-reward-programs-n898.html',
                        'ES' => 'https://printerval.com/es/printerval-reward-programs-n906979.html',
                        'PT' => 'https://printerval.com/printerval-reward-programs-n898.html',
                        'PL' => 'https://printerval.com/printerval-reward-programs-n898.html',

                    ];
                    return $listLink[$locale] ?? $listLink['US'];
                }
                $usePaypalExpressCheckout = config("cart::paypal.use_paypal_express_checkout", false);
                $useSpecialShippingFee = config("cart::sa.use_special_shipping_fee", false);
            @endphp

            <div id="cart-default-lcp">
                <nav aria-label="Breadcrumb">
                    <ol class="checkout-breadcrumb breadcrumb--center" role="list">
                        <li class="breadcrumb__item breadcrumb__item--current">
                            <span class="breadcrumb__text">{{ __('Cart') }}</span>
                            <small class="active"></small>
                        </li>
                        <li class="breadcrumb__item breadcrumb__item--blank" aria-current="step">
                            <span class="breadcrumb__text">{{ __('Order Information') }}</span>
                            <small></small>
                        </li>
                        <li class="breadcrumb__item breadcrumb__item--blank">
                            <span class="breadcrumb__text">{{ __('Complete') }}</span>
                        </li>
                    </ol>
                </nav>
                <div class="cart-list-product-box">
                    <div class="form-shopcart">
                        <div class="cart-left-wrapper">
                            <div class="flex-box shopcart-row shopcart-head">
                                <div class="shopcart-item shopcart-name">
                                    {{ __('Item') }}
                                </div>
                                <div class="shopcart-contain">
                                    <div class="shopcart-item shopcart-price" style="justify-content: center">
                                        {{ __('Đơn giá') }}
                                    </div>
                                    <div class="shopcart-item shopcart-qty">
                                        {{ __('Số lượng') }}
                                    </div>
                                    <div class="shopcart-item shopcart-subtotal">
                                        {!! __('Thành tiền') !!}
                                    </div>
                                </div>
                            </div>

                            @foreach ($cartItems as $index => $cartItem)
                                <div class="flex-box shopcart-row shopcart-content">
                                    <div class="shopcart-item shopcart-name">
                                        <div class="shopcart-item shopcart-name">
                                            <a href="{{ $cartItem['url'] }}" class="shopcart-image flex-box align-c flex-c">
                                                @if ($index == 0)
                                                    <img src="{{ getImageCdn($cartItem['image_url'], 540, 540, false) }}" alt="cart-item" fetchpriority="high" />
                                                @else
                                                    <img src="{{ getImageCdn($cartItem['image_url'], 540, 540, false) }}" alt="cart-item" />
                                                @endif
                                            </a>
                                            <div class="shopcart-info" style="display: flex; grid-gap: 3px; flex-wrap: wrap">
                                                @php
                                                    $productName = $cartItem['product_name'];
                                                    if (!empty($cartItem['name_variant']) && strpos($productName, ", " . $cartItem['name_variant']) !== false) {
                                                        $productName = str_replace(", " . $cartItem['name_variant'], "", $productName);
                                                    }
                                                @endphp
                                                <a class="shopcart-item-link" href="{{ $cartItem['url'] }}" target="_blank">{{ $productName }}</a>
                                                <span class="skeleton-box" style="width:10%;"></span>
                                                <div class="skeleton-box" style="width: 20%; padding: 10px 0;"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="shopcart-contain" style="display: flex; justify-content: flex-end">
                                        <div class="shopcart-item shopcart-price" style="height: 16px">
                                            <span class="skeleton-box" style="width:100%;"></span>
                                        </div>
                                        <div class="shopcart-item shopcart-qty" style="height: 16px">
                                            <span class="skeleton-box" style="width:92%;"></span>
                                        </div>
                                        <div class="shopcart-item shopcart-subtotal" style="height: 16px">
                                            <span class="skeleton-box" style="width:100%;"></span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="cart-right-wrapper">
                            @for($i = 0; $i < 4; $i++)
                            <div class="flex-box flex-s shopcart-row shopcart-footer">
                                <div class="shopcart-item" style="width: 50%">
                                    <span class="skeleton-box" style="height: 26px"></span>
                                </div>
                                <div class="shopcart-item flex-b flex-e">
                                    <span class="skeleton-box" style="width: 50%; height: 26px"></span>
                                </div>
                            </div>
                            @endfor
                            <div class="button-contain flex-box align-c flex-e" style="padding-top: var(--pr-spacing-05);">
                                <span class="skeleton-box" style="width:100%; height: 60px"></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div ng-app="myApp" ng-controller="CartController" ng-cloak>
                <nav aria-label="Breadcrumb" ng-show="items.length != 0">
                    <ol class="checkout-breadcrumb breadcrumb--center" role="list">
                        <li class="breadcrumb__item breadcrumb__item--current">
                            <span class="breadcrumb__text">{{ __('Cart') }}</span>
                            <small class="active"></small>
                        </li>
                        <li class="breadcrumb__item breadcrumb__item--blank" aria-current="step">
                            <span class="breadcrumb__text">{{ __('Order Information') }}</span>
                            <small></small>
                        </li>
                        <li class="breadcrumb__item breadcrumb__item--blank">
                            <span class="breadcrumb__text">{{ __('Complete') }}</span>
                        </li>
                    </ol>
                </nav>
                <div class="cart-list-product-box" ng-show="items.length != 0 && !firstLoadingCart">
                    <div class="form-shopcart">
                        <!-- Cart left col -->
                        <div class="cart-left-wrapper @{{ loadingRemoveItem ? 'loading-remove-item' : ''}}">
                            @if($currentLocale == 'US' || $currentLocale == 'UK' || $currentLocale == 'CA' || $currentLocale == 'AU')
                                <div class="loyalty-noti-wrapper" ng-show="showLoyaltyNoti && morePoint > 0">
                                    <div class="loyalty-noti-content">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 8m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z" /><path d="M12 8l0 13" /><path d="M19 12v7a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-7" /><path d="M7.5 8a2.5 2.5 0 0 1 0 -5a4.8 8 0 0 1 4.5 5a4.8 8 0 0 1 4.5 -5a2.5 2.5 0 0 1 0 5" /></svg>
                                        <div class="loyalty-noti">{{ __('Buy') }} <b class="text-bold">@{{ moreAmount }}</b> @{{ textMoreAmount.replace("#point", morePoint) }}</div>
                                    </div>
                                    <span class="loyalty-noti-close" ng-click="closeLoyaltyNoti()">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 6l-12 12" /><path d="M6 6l12 12" /></svg>
                                </span>
                                </div>
                            @endif
                            @if ($useSpecialShippingFee)
                            <div class="fee-special-wrapper" ng-show="textSpecialShippingFee">
                                <div class="fee-special-content">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="22"  height="22"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12.5 21h-3.926a3 3 0 0 1 -2.965 -2.544l-1.255 -8.152a2 2 0 0 1 1.977 -2.304h11.339a2 2 0 0 1 1.977 2.304l-.416 2.7" /><path d="M9 11v-5a3 3 0 0 1 6 0v5" /><path d="M16 21l5 -5" /><path d="M21 21v.01" /><path d="M16 16v.01" /></svg>
                                    <span ng-bind-html="textSpecialShippingFee"></span>
                                </div>
                            </div>
                            @endif

                            <div class="flex-box shopcart-row shopcart-head">
                                <div class="shopcart-item shopcart-name">
                                    {{ __('Item') }}
                                </div>
                                <div class="shopcart-contain">
                                    <div class="shopcart-item shopcart-price" style="justify-content: center">
                                        {{ __('Đơn giá') }}
                                    </div>
                                    <div class="shopcart-item shopcart-qty">
                                        {{ __('Số lượng') }}
                                    </div>
                                    <div class="shopcart-item shopcart-subtotal">
                                        {!! __('Thành tiền') !!}
                                    </div>
                                </div>
                            </div>

                            <div class="flex-box shopcart-row shopcart-content" data-cart-item-id="@{{ item.id }}" id="tr-item-cart-@{{ item.id }}" data-product-id="@{{ item.product_id }}" ng-repeat="item in items" >
                                <div class="shopcart-item shopcart-name">
                                    <a href="@{{ item.force_url ? item.force_url : (item.product_sku_id ? item.url + '?spid=' + item.product_sku_id : item.url) }}" target="_blank" class="shopcart-image flex-box align-c flex-c">
                                        <img ng-src="@{{ getImageCdn(item.image_url, 540, 540, false) }}" alt="@{{ item.product_name }}" title="@{{ item.product_name }}" referrerpolicy="no-referrer">
                                    </a>

                                    <div class="shopcart-info">
                                        <a class="shopcart-item-link" ng-bind-html="item.product_name | safeHtml" href="@{{ item.force_url ? item.force_url : (item.product_sku_id ? item.url + '?spid=' + item.product_sku_id : item.url) }}" target="_blank">
                                        </a>
                                        <div class="shopcart-configurations">
                                            <span class="config-item" ng-show="item.name_variant" style="display: block;">
                                                @{{ item.name_variant }}
                                            </span>
                                            <div class="config-item" ng-repeat="(key, value) in item.configurations">
                                                <div ng-if="key != 'print_location' && key != 'previewUrl' && key != 'buy_design' && key != 'design_fee' && key != 'hire_designer'">
                                                    @{{ key }}: @{{ value }}
                                                </div>
                                                <div ng-if="key == 'print_location' && getByField(printLocations, 'value', value)">
                                                    {{ __('Print Location') }}: @{{ getByField(printLocations, 'value', value).name }}
                                                </div>
                                            </div>
                                            <div ng-if="item.print_location_3d">
                                                {{ __('Print Location') }}: @{{ item.print_location_3d }}
                                            </div>
                                            
                                            <div ng-if="item.preview_url">
                                                {{ __('Preview url') }}: <a href="@{{ item.preview_url }}" target="_blank">{{ __('View') }}</a>
                                            </div>
                                        </div>
                                        <div class="shopcart-configurations">
                                            <div class="discount-box shopcart-discount-code"></div>
                                        </div>
                                        <div class="shopcart-configurations">
                                            <i style="color: #ff7300;" class="buy-more-text"></i>
                                        </div>
                                        <div class="shopcart-configurations">
                                            <i style="color: #ff7300;" class="buy-more-text-title"></i>
                                        </div>
                                        <div class="flex-b align-c make-change-wrap" ng-hide="freeshipPackageProduct && freeshipPackageProduct.id == item.product_id">
                                            <span id="js-update-item" ng-hide="item.disable_make_change" ng-click="openFormChangeVariant(item)">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" ng-show="item.loadingMakeChange" viewBox="0 0 16 16" class="bi bi-arrow-repeat active">
                                                    <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"></path>
                                                    <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"></path>
                                                </svg>
                                                <svg ng-show="!item.loadingMakeChange"  xmlns="http://www.w3.org/2000/svg"  width="16"  height="16"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                                                {{ __('Edit')}}
                                            </span>
                                            <span id="js-delete-item" ng-click="openModalRemoveCartItem(item)" class="flex-b align-c">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M4 7l16 0"></path><path d="M10 11l0 6"></path><path d="M14 11l0 6"></path><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path></svg>
                                                <span>{{ __('Remove')}}</span>
                                            </span>
                                        </div>
                                        <div ng-if="item.hire_designer != undefined" class="buydesign-item">
                                            <div  class="flex-b buydesign-content-item hiredesign-content-item">
                                                <label for="hire-designer-@{{ item.id }}" class="checkbox-label buydesign-action">
                                                    <input 
                                                        type="checkbox" 
                                                        name="buy-designer" 
                                                        class="checkbox-input" 
                                                        id="hire-designer-@{{ item.id }}" 
                                                        ng-model="item.hire_designer" 
                                                        ng-checked="item.hire_designer" 
                                                        ng-change="onChangeHireDesigner(item)"
                                                    />
                                                    <span class="input-type-checkbox"></span>
                                                    <div>
                                                        {{ __('Hire Artist For Customization') }}
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="cart-buyDesign" ng-hide="item.disable_make_change || checkValidDownloadDesign(item) || item.is_custom_design == 1 || item.is_valid_buy_design == 0 || item.hire_designer != undefined || designFeeByProducts[item.product_id] == 0">
                                            <input type="checkbox" name="buydesign" class="checkbox-input" id="open-buyDesign-@{{ item.id }}">
                                            <div class="buydesign-item" id="buy-this-design-@{{ item.id }}">
                                                <div class="flex-b buydesign-content-item">
                                                    <label for="buydesign-@{{ item.id }}" class="checkbox-label buydesign-action">
                                                        <input type="checkbox" class="checkbox-input" id="buydesign-@{{ item.id }}" ng-model="item.buy_design" ng-checked="item.buy_design" ng-change="buyDesign(item)">
                                                        <span class="input-type-checkbox"></span>
                                                        <div>
                                                            @{{ textBuyDesign.replace("#amount", formatPrice(designFeeByProducts[item.product_id] + getIncludeDesignFee(item))) }}
                                                        </div>
                                                    </label>
                                                    <label for="open-buyDesign-@{{ item.id }}" class="checkbox-label">
                                                        <svg class="question-circle" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"> <path d="M8 2a5.53 5.53 0 0 0-3.594 1.342c-.766.66-1.321 1.52-1.464 2.383C1.266 6.095 0 7.555 0 9.318 0 11.366 1.708 13 3.781 13h8.906C14.502 13 16 11.57 16 9.773c0-1.636-1.242-2.969-2.834-3.194C12.923 3.999 10.69 2 8 2zm2.354 6.854-2 2a.5.5 0 0 1-.708 0l-2-2a.5.5 0 1 1 .708-.708L7.5 9.293V5.5a.5.5 0 0 1 1 0v3.793l1.146-1.147a.5.5 0 0 1 .708.708z"></path> </svg>
                                                        <svg class="close-circle" xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor"viewBox="0 0 16 16"> <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.354 4.646a.5.5 0 1 0-.708.708L7.293 8l-2.647 2.646a.5.5 0 0 0 .708.708L8 8.707l2.646 2.647a.5.5 0 0 0 .708-.708L8.707 8l2.647-2.646a.5.5 0 0 0-.708-.708L8 7.293 5.354 4.646z"/> </svg>
                                                    </label>
                                                </div>
                                                <div class="this-design-wrapper">
                                                    <a href="{{ getOption('general.buy_design_policy', '#') }}" class="buydesign-help" target="_blank">
                                                        <small>{{ __('You will receive the link to download the original design file of this item within 24 hours')}}</small>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z">
                                                            </path>
                                                        </svg>
                                                    </a>
                                                    <div class="design-template">
                                                        <img ng-src="@{{ getImageCdn(item.design_url || item.image_url, 540, 540, true) }}" alt="" width="200" height="200" referrerpolicy="no-referrer">
                                                    </div>
                                                </div>
                                            </div>
                                            <label class="close-buyDesign" for="open-buyDesign-@{{ item.id }}"></label>
                                        </div>
                                    
                                    </div>
                                </div>
                                <div class="shopcart-contain">
                                    <div class="shopcart-item shopcart-price" ng-class="{'has-save-price': item.discount_value}" data-unit-price="@{{ item.price }}">
                                        <span class="shopping-price" style="color: #C52C29;">
                                            @{{ formatPrice(item.price) }}
                                        </span>
                                        <del class="shopping-hight-price" ng-if="item.high_price && item.high_price > item.price">
                                            @{{ formatPrice(item.high_price) }}
                                        </del>
                                        <small class="shopping-save-price" ng-if="item.discount_value">
                                            <?= sprintf(__('Save %s'), '{{ formatPrice(item.discount_value) }}') ?>
                                        </small>
                                    </div>
                                    <div class="shopcart-item shopcart-qty">
                                        <div class="shopcart-qty flex-box align-s flex-c">
                                            <button class="shopcart-button minus" type="button" name="button" ng-click="changeQuantity(item, item.quantity, 'decrease')" ng-disabled="loading">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" fill="currentColor" class="bi bi-dash-lg" viewBox="0 0 16 16">
                                                    <path d="M0 8a1 1 0 0 1 1-1h14a1 1 0 1 1 0 2H1a1 1 0 0 1-1-1z" />
                                                </svg>
                                            </button>
                                            <input type="text" ng-value="item.quantity" class="quantity shopcart-input number-input" ng-model="item.quantity" autocomplete="off" ng-change="changeCustomQuantity(item, item.quantity)" ng-model-options="{ debounce: 500 }">
                                            <button class="shopcart-button plus" type="button" name="button" ng-click="changeQuantity(item, item.quantity, 'increase')" ng-disabled="loading">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                                                    <path d="M8 0a1 1 0 0 1 1 1v6h6a1 1 0 1 1 0 2H9v6a1 1 0 1 1-2 0V9H1a1 1 0 0 1 0-2h6V1a1 1 0 0 1 1-1z"></path>
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="shopcart-item shopcart-subtotal">
                                        <span>
                                            @{{ formatPrice(item.total_amount, 0, false) }}
                                        </span>
                                        <small class="shopcart-delete-item module-remove-item" data-cart-item-id="@{{ item.id }}" ng-click="openModalRemoveCartItem(item)">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5zm3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0V6z"/>
                                                <path fill-rule="evenodd" d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1v1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4H4.118zM2.5 3V2h11v1h-11z"/>
                                            </svg>
                                        </small>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <!-- End Cart left col -->
                        <!-- Cart right col -->
                        <div class="cart-right-wrapper">
                            <div class="flex-box shopcart-row shopcart-footer">
                                <div class="shopcart-item shopcart-qty">
                                    {!! __('Tạm tính') !!}
                                </div>
                                <div class="shopcart-item shopcart-subtotal">
                                    @{{ formatPrice(cart.sub_total, 0, false) }}
                                </div>
                            </div>
                            <div class="flex-box shopcart-row shopcart-footer">
                                <div class="shopcart-item shopcart-qty">
                                    {!! __('Shipping fee') !!}
                                </div>
                                <div class="shopcart-item shopcart-subtotal" ng-show="isValidateSpecialShippingFee">
                                    @{{ formatPrice(cart.special_shipping_fee, 0, false) }}
                                </div>
                                <div class="shopcart-item shopcart-subtotal" ng-show="!isValidateSpecialShippingFee">
                                    @{{ formatPrice(shipping_fee, 0, false) }}
                                </div>
                            </div>
                            @if ($useTaxes)
                            <div class="flex-box shopcart-row shopcart-footer">
                                <div class="shopcart-item shopcart-qty">
                                    {!! __('Taxes') !!}
                                </div>
                                <div class="shopcart-item shopcart-subtotal">
                                    {!! __('Calculated at checkout') !!}
                                </div>
                            </div>
                            @endif
                            <div class="flex-box shopcart-row shopcart-footer">
                                <div class="shopcart-item shopcart-qty">
                                    <b>{!! __('Total') !!}</b>
                                </div>
                                <div class="shopcart-item shopcart-subtotal discount-value js-cart-subtotal-value">
                                    @{{ getCartAmount() }}
                                </div>
                            </div>
                            <span class="points-rewards flex-b align-c flex-e" ng-show="customerRewards.showRewards && pointEarn > 0">
                                {{ __('Rewards') }}
                                <div class="address-tooltip">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-question-circle" viewBox="0 0 16 16">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                        <path d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286zm1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94"/>
                                    </svg>
                                    <div class="address-tooltip-content">
                                        @{{ earnPointText.replace("#point", pointEarn) }}
                                        <br>
                                        <span style="cursor: pointer">
                                            <a href="{{ getLinkLoyalty($currentLocale) }}" target="_blank">
                                                {{ __('Learn about the Loyalty Program') }}
                                            </a>
                                        </span>
                                    </div>
                                </div>
                                {{ __('Earn') }} @{{ pointEarn }}CP
                            </span>
                            <div class="flex-box shopcart-row shopcart-footer deliveryTextShow flex-b flex-s" style="padding-right: 8px; font-weight: 400;">
                                <span ng-bind-html="deliveryTextShow"></span>
                                <a class="change-shipping-country" href="javascript:;" ng-click="openSelectCountry()">{{ __('Change') }}</a>
                            </div>
                            <div class="address-col" style="z-index: 12">
                                <div class="autocomplate-content content-select-country" ng-show="isShowSelectCountry">
                                    <div class="content-select-country-content">
                                        <div class="search">
                                            <div class="content-select-country-header">{{ __('Shipping Country') }}</div>
                                            <input type="checkbox" id="select-country" name="" value="">
                                            <label for="select-country" class="content-select-country-wrapper">
                                                <span class="form-control select" ng-click="openSearchCountry()">
                                                    @{{ tmpSelectedCountry.nicename }}
                                                </span>
                                                <div class="list-country">
                                                    <div class="select-country">
                                                        <input type="text" class="form-control" placeholder="{{ __('Choose your country or region') }}" ng-model="filterCountry" ng-change="searchCountry()" ng-model-options="{ debounce: 500 }">
                                                    </div>
                                                    <div class="country-region-item" ng-repeat="item in listSearchCountries" ng-click="selectCountry(item)">@{{ item.nicename }}</div>
                                                </div>
                                            </label>
                                            <div class="content-select-country-action">
                                                <button class="submit" type="submit" ng-click="saveSelectCountry()">{{ __('Update') }}</button>
                                                <button class="button default" type="reset" ng-click="closeSelectCountry()" style="text-transform: none;">{{ __('Close') }}</button>
                                            </div>
                                        </div>
                                    </div>
                                    <label ng-show="isSearch" ng-click="openSearchCountry()" class="openSearchCountry" for="select-country"></label>
                                </div>
                            </div>
                            <div class="flex-box shopcart-row shopcart-footer js-cart-discount" style="margin-top: 8px; padding-top:8px; border: none;" ng-show="discountValue > 0">
                                <div class="shopcart-item shopcart-qty" style="margin-top: 7px;">
                                    {{ __('Discount') }}:
                                </div>
                                <div class="shopcart-item shopcart-subtotal discount-value js-cart-discount-value">
                                    @{{ discountValue }}
                                </div>
                            </div>
                            <div class="cart-buy-more" style="font-weight: 400 !important;"></div>
                            <div class="cart-free-ship" style="font-weight: 400 !important; color: var(--pr-color-secondary); font-style: italic; font-size: 14px;"></div>
                            <div class="footer-ext-wrapper">

                                <div class="button-contain flex-box align-c flex-e">
                                    <a class="button btn-link flex-box align-c flex-c" href="{{ route('home') }}">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" fill="currentColor" class="bi bi-chevron-left" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z" />
                                        </svg>
                                        <span style="margin-left: 5px">
                                            {{ __('Mua sắm') }}
                                        </span>
                                    </a>
                                    <a href="javascript:;" class="button btn-to-checkout flex-box align-c flex-c" ng-click="processCheckout()" ng-disabled="loading">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-bag-check" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M10.854 8.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 0 1 .708-.708L7.5 10.793l2.646-2.647a.5.5 0 0 1 .708 0z"/>
                                            <path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1zm3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-3.5zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V5z"/>
                                        </svg>
                                        <span>
                                            {{ __('Thanh toán') }}
                                        </span>
                                    </a>
                                </div>
                                @if ($usePaypalExpressCheckout)
                                <div class="button-contain flex-box align-c flex-e" style="margin-top: 14px; flex-wrap: wrap;">
                                    <div class="sereprate-express-btn">
                                        <span>{{ __("Express checkout") }}</span>
                                    </div>
                                    <div id="paypal-button-container-sidebar" style="width: 100%;"></div>
                                    <p id="result-message"></p>
                                </div>
                                @endif
                                <div class="great-taste">
                                </div>
                                @php
                                    $footerPaymentsList = getOption('payments-list', '');
                                @endphp
                                {!!$footerPaymentsList!!}

                                @if ($shoppingRatingCount > 0)
                                    <div class="cart-customer-review flex-b align-c flex-c flex-w">
                                        <?php
                                            $text = __('#value out of 5 based on #reviews_count#reviews_text');
                                            $text = str_replace("#value", $shoppingRating, $text);
                                            $text = str_replace("#reviews_count", $shoppingRatingCount, $text);
                                            $reviewText = '<strong class="cart-customer-review-item">' . __('reviews') . '</strong>';
                                            $text = str_replace("#reviews_text", $reviewText, $text);
                                        ?>
                                            <a href="{{ $shoppingUrl }}" target="_blank">
                                                {{ __('Our customers are saying: ') }}
                                            </a>
                                            <a href="{{ $shoppingUrl }}" target="_blank">

                                            <span class="star-review-wrapp flex-b align-c">
                                                <?php
                                                    for ($i = 1; $i <= 5; $i++) {
                                                        if ($i <= round($shoppingRating)) {
                                                            echo '<svg viewBox="0 0 576 512" width="100" title="star">
                                                                    <path d="M259.3 17.8L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z" />
                                                                </svg>';
                                                        } else {
                                                            echo '<svg viewBox="0 0 576 512" width="100" title="star">
                                                                    <path d="M259.3 17.8L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z" />
                                                                </svg>';
                                                        }
                                                    }
                                                ?>
                                                <div class="cover" style="--rating:{{ $shoppingRating }}"></div>
                                            </span>
                                            </a>
                                            <a href="{{ $shoppingUrl }}" target="_blank">
                                                <span><?= $text ?></span>
                                            </a>
                                            <img class="cart-customer-review-item" src="/modules/cart/images/google.svg" height="24" alt="">
                                            <a href="{{ $shoppingUrl }}" target="_blank">
                                                <strong>{{ __('Google Customer Reviews') }}</strong>
                                            </a>
                                        <?php
                                            $customerReviewText = __("Our customer say #excellent_text #star_image 4.4 out of 5 based on 184,96 #reviews_text #branch_image");
                                            $excellentText = '<strong class="cart-customer-review-item">' . __('Excellent') . '</strong>';
                                            $starImage = '';
                                            $branchImage = '<img class="cart-customer-review-item" src="/modules/cart/images/google.svg" height="24" alt="">';
                                            $reviewText = '<strong class="cart-customer-review-item">' . __('reviews') . '</strong>';
                                            $customerReviewText = str_replace('#excellent_text', $excellentText, $customerReviewText);
                                            $customerReviewText = str_replace('#star_image', $starImage, $customerReviewText);
                                            $customerReviewText = str_replace('#reviews_text', $reviewText, $customerReviewText);
                                            $customerReviewText = str_replace('#branch_image', $branchImage, $customerReviewText);
                                        ?>

                                    </div>
                                @endif
                                @if ($isShowGuarantee)
                                <div class="product-detail-row flex-b align-c product-detail-addon">
                                    <img class="p-2" width="60px" height="60px" style="margin-right: 15px;" src="/modules/cart/images/guarantee.png" alt="" style="padding: 2px">
                                        <div>
                                            <span class="product-row-text addition-head">{{ __('Don’t love it? We’ll fix it. For free.') }}</span>
                                            <br>
                                            <a class="product-row-text addition-head" href="{{ getOption('guarantee_url', '/the-printerval-guarantee-n629.html') }}" target="_blank"
                                            style="color: var(--secondary)"
                                            >
                                            {{ formatString(__('%s Guarantee'), getOption('general.store_name', 'Printerval')) }} »
                                        </a>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <!-- End Cart right col -->
                    </div>
                </div>
                <div id="isEmptyCart" class="tt-empty-cart" ng-show="items.length == 0 && !firstLoadingCart">
                    @include('cart::cart.empty')
                </div>
            
                @include('cart::includes.make-change')
                <div class="delete-item-wrapper @{{ showModalRemoveCartItem ? 'show-remove-modal' : '' }}" ng-show="showModalRemoveCartItem" style="display: none;">
                    <div class="delete-item-content">
                        <div class="delete-item-content-top">
                            <div class="delete-item-title">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#d2212b" class="bi bi-exclamation-triangle" viewBox="0 0 16 16">
                                    <path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.15.15 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.2.2 0 0 1-.054.06.1.1 0 0 1-.066.017H1.146a.1.1 0 0 1-.066-.017.2.2 0 0 1-.054-.06.18.18 0 0 1 .002-.183L7.884 2.073a.15.15 0 0 1 .054-.057m1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767z"/>
                                    <path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0M7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0z"/>
                                </svg>
                                <span>{{ __('Remove item') }}</span>
                                <span class="close-pop" ng-click="closeModalRemoveCartItem()">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                        <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
                                    </svg>
                                </span>
                            </div>
                            <div class="delete-item-desc">{{ __('Are you sure you want to remove this item?') }}</div>
                            <div class="delete-item-action">
                                <a href="javascript:;" class="delete-item-action-cancel" ng-click="closeModalRemoveCartItem()">{{ __('Cancel') }}</a>
                                <a href="javascript:;" class="delete-item-action-delete" ng-click="removeCartItems(itemRemove)">{{ __('Remove') }}</a>
                            </div>
                        </div>
                        <div class="delete-item-content-bottom">
                            <div class="delete-item-title" ng-show="comments.length > 0">
                                <svg width="16" height="16" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                                    <path fill="#FFB636" d="m252.5 381l-128 49c-5.9 2.2-12.1-2.3-11.8-8.6l7-136.9c.1-2.1-.6-4.2-1.9-5.9L31.6 172c-4-4.9-1.6-12.2 4.5-13.9l132.4-35.6c2.1-.6 3.9-1.9 5-3.7L248.3 4c3.4-5.3 11.2-5.3 14.6 0l74.8 114.9c1.2 1.8 3 3.1 5 3.7l132.4 35.6c6.1 1.6 8.5 9 4.5 13.9l-86.1 106.6c-1.3 1.7-2 3.8-1.9 5.9l7 136.9c.3 6.3-5.9 10.8-11.8 8.6l-128-49c-2.1-.8-4.3-.8-6.3-.1z"/>
                                    <path fill="#FFD469" d="m456.1 51.7l-41-41c-1.2-1.2-2.8-1.7-4.4-1.5c-1.6.2-3.1 1.2-3.9 2.6l-42.3 83.3c-1.2 2.1-.8 4.6.9 6.3c1 1 2.4 1.5 3.7 1.5c.9 0 1.8-.2 2.6-.7L454.9 60c1.4-.8 2.4-2.2 2.6-3.9c.3-1.6-.3-3.2-1.4-4.4zm-307 43.5l-42.3-83.3c-.8-1.4-2.2-2.4-3.9-2.6c-1.6-.2-3.3.3-4.4 1.5l-41 41c-1.2 1.2-1.7 2.8-1.5 4.4c.2 1.6 1.2 3.1 2.6 3.9l83.3 42.3c.8.5 1.7.7 2.6.7c1.4 0 2.7-.5 3.7-1.5c1.7-1.8 2-4.4.9-6.4zm140.7 410l-29-88.8c-.2-.9-.7-1.7-1.3-2.3c-1-1-2.3-1.5-3.7-1.5c-2.4 0-4.4 1.6-5.1 3.9l-29 88.8c-.4 1.6-.1 3.3.9 4.6c1 1.3 2.5 2.1 4.2 2.1h57.9c1.6 0 3.2-.8 4.2-2.1c1.1-1.4 1.4-3.1.9-4.7z"/>
                                </svg>
                                <span>{{ __('Product Review Best Practices') }}</span>
                            </div>
                            <div class="cart-revew-slider" ng-show="comments.length > 0">
                                <div class="cart-review-item-list">
                                    <div class="swiper-wrapper">
                                        <div class="cart-review-item-item swiper-slide" ng-repeat="comment in comments">
                                            <img class="cart-review-item-rate" src="{{ asset('modules/cart/images/star-list.svg') }}" height="14" height="78">
                                            <div class="cart-review-item-title">@{{ comment.name }}</div>
                                            <div class="cart-review-item-content">@{{ comment.content ? comment.content : comment.title }}</div>
                                        </div>
                                    </div>
                                    <div class="swiper-button-next cart-revew-next"></div>
                                    <div class="swiper-button-prev cart-revew-prev"></div> 
                                    <div class="swiper-pagination cart-pagination"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="delete-item-background" ng-click="closeModalRemoveCartItem()"></div>
                </div>
                @include('cart::includes.guest-popup')
            </div>
        @endif
    </div>

    <div class="md-also-bought-content" id="also-bought-content">
        <div class="md-also-bought-heading">
            {{ __('You may also like')}}
        </div>
        <div class="md-also-bought-slide">
            <div class="md-also-bought-list">
            </div>
        </div>
    </div>
</div>
@view('cart.tracking',['cartItems' => $cartItems])
<script>
    let cartItems = {!! json_encode($cartItems) !!}
    window.dataLayer.push({'currency': "<?= env('CURRENCY_UNIT','USD') ?>"});
</script>
