@extends('layouts/master')
@section('title')
{{ __('Cancel') }}
@endsection

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/themes/base/jquery-ui.min.css" integrity="sha512-ELV+xyi8IhEApPS/pSj66+Jiw+sOT1Mqkzlh8ExXihe4zfqbWkxPRi8wptXIO9g73FSlhmquFlUOuMSoXz5IRw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
   @import url('https://fonts.googleapis.com/css2?family=Chakra+Petch:wght@300;400;500;600;700&family=Poppins:ital,wght@0,200;0,300;0,400;0,500;1,200;1,300;1,400;1,500&display=swap');
    .confirm-cancellation {
        width: 90%;
        margin: 20px auto;
        display: grid;
        grid-template-columns: 1.3fr 0.7fr;
        grid-gap: 32px;
        align-items: center;
        padding: 48px 0 24px;
        text-align: left;
        max-width: 1000px;
    }

    .cancellation-messenger {
        display: grid;
        grid-gap: 10px;
    }

    .cancellation-messenger-title {
        font-size: 45px;
        line-height: 1.2;
        font-weight: 500;
        color: var(--secondary);
        margin-bottom: 0;
        font-family: 'Chakra Petch', sans-serif;
    }

    #cart-module-content .cancellation-messenger-content * {
        font-weight: 400 !important;
    }

    .cancellation-messenger-footer {
        display: flex;
        grid-gap: 10px;
    }

    .cancellation-messenger-footer a {
        background-color: #ff7300;
        color: #fff;
        padding: 10px 24px;
        border-radius: 36px;
        cursor: pointer;
        display: block;
        text-decoration: none;
    }

    .cancellation-messenger-footer a:focus,
    .cancellation-messenger-footer a:active,
    .cancellation-messenger-footer a:hover {
        background-color: #5441b5;
        color: #fff;
    }

    @media (max-width: 880px) {
        .confirm-cancellation {
            display: flex;
            flex-direction: column-reverse;
            justify-content: center;
            padding: 0;
        }
        .cancellation-messenger-title {
            font-size: 30px;
        }
    }
</style>
@endsection

@section('main')
<div id="cart-module-content" class="checkout-page">
    <div class="container-indent flex-box flex-w">
        <div class="confirm-cancellation">
            <div class="cancellation-messenger">
                @if (isset($order) && isset($order['note']) && strpos($order['note'], 'Khách yc cancel (hợp lệ)') !== false)
                    <div class="cancellation-messenger-title">
                        {{ __("Order Successfully Canceled") }}
                    </div>
                    <div class="cancellation-messenger-content">
                        <p>{{ __("Your order has been successfully canceled. The refund will be processed within 5-7 days!") }}</p>
                        <p>{{ __("We sincerely appreciate your trust in us and look forward to welcoming you back in the future. Thank you for being a valued customer!") }}</p>
                    </div>
                    <div class="cancellation-messenger-footer">
                        <a href="{{ env('APP_URL') }}" rel="noopener noreferrer">
                            {{ __('Continute shopping') }}
                        </a>
                    </div>
                @else
                    <div class="cancellation-messenger-title">
                        {{ __("Unable to Cancel Order") }}
                    </div>
                    <div class="cancellation-messenger-content">
                        <p>{{ __("We were unable to process your cancellation request for the order. This could be due to one of the following reasons:") }}</p>
                        <ul>
                            <li>{{ __("The order number is incorrect.") }}</li>
                            <li>{{ __("The order has already been processed or shipped.") }}</li>
                        </ul>
                        <p>{{ __("If you need further assistance, please contact our customer support team. We’re here to help!") }}</p>
                    </div>
                    <div class="cancellation-messenger-footer">
                        <a href="{{ env('APP_URL') }}" rel="noopener noreferrer">
                            {{ __('Continue shopping') }}
                        </a>
                    </div>
                @endif
            </div>
            <div class="cancellation-image">
                <img src="{{ asset('modules/cart/images/order-confirm.svg') }}" alt="Confirm cancellation" width="330" height="250">
            </div>
        </div>
    </div>
</div>
@endsection