@php
    $checkoutLocale = env('APP_LOCALE', 'us');
    if (!$checkoutLocale) {
        $checkoutLocale = 'us';
    }
    $paypalExpressCheckout = config("cart::paypal.express_checkout", false);
    $filePath = base_path('app/Modules/Cart/Setting/phone.json');
    $jsonContent = trim(file_get_contents($filePath));
    $allCountries = json_decode($jsonContent, true);
@endphp
<script type="text/javascript">
    window._uxa = window._uxa || [];
    window._uxa.push(["setCustomVariable", 1, "pageType", "Checkout"]);
</script>

<script type="text/javascript">
    var token = '{{ getFingerprint() }}';
    var cartCdnIgnoreUrl = <?= json_encode(config('cdn.ignore', [])); ?>;
    var priceConfig = <?= json_encode(getPriceConfig()) ?>;
    var cartCdnAllowUrl = <?= json_encode(config('cdn.allow', [])); ?>;
    var user = <?= json_encode($user); ?>;
    var appUrl = "<?= config("app.url") ?>";
    var merchantItentifier = "<?= $merchantItentifier ?>";
    var mode = getParameterByName("mode");
    var allCountries = JSON.parse('<?= addslashes(json_encode($allCountries)) ?>');
</script>
<script src="//js.stripe.com/v3/"></script>
<script src="{{ asset('modules/cart/js/angular.min.js') }}"></script>
<script src="{{ asset('modules/cart/js/angular-sanitize.min.js') }}"></script>
<script src="{{ asset('modules/cart/js/ui-select.min.js') }}"></script>
<script src="{{ asset('modules/cart/js/html2canvas.min.js') }}"></script>
@if ($paypalExpressCheckout)
<script src="https://www.paypal.com/sdk/js?components=buttons,card-fields&client-id=<?=$paypalKey?>&commit=true"></script>
@endif
<script src="https://applepay.cdn-apple.com/jsapi/v1.1.0/apple-pay-sdk.js"></script>
<script src="https://checkoutshopper-test.cdn.adyen.com/checkoutshopper/sdk/6.9.0/adyen.js" integrity="sha384-VB3SxkD+sTFJL36cbTToRDKrdvAJWmdf7t42zY4Z7wU9BdqvRjNtAof2qTQjPa/n" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://checkoutshopper-test.cdn.adyen.com/checkoutshopper/sdk/6.9.0/adyen.css" integrity="sha384-Qy8fmdXhmf9H2Pgbmr7b0UkpeSvi7n3RFhpoZXYQPGpKIn9SH+0fT4905fsSA8Am" crossorigin="anonymous">
{{--<script src="{{ asset('modules/cart/js/jquery-ui.min.js') }}"></script>--}}

<script>
var appName = "<?= config('app.name') ?>";
var stripe = Stripe("<?= $stripeKey ?>", {locale: 'auto'});
var productsBySeller = <?= json_encode($productsBySeller) ?>;
var useCheckoutInForm = "<?=config('cart::stripe.use_checkout_in_form')?>";
var usePaypalByLimit = "<?= $usePaypalByLimit ?>";
var base_api_url = "<?= config('cart::sa.api_url') ?>";
var useDiscount = "<?= config("discount::sa.use_discount", false) ?>";
var paypalFee = "<?= config("cart::paypal.include_fee", 0) ?>";
var usePaypal = "<?= config("cart::paypal.use_paypal", false) ?>";
var lianFee = "<?= config("cart::lian.include_fee", 0) ?>";
var useLian = "<?= config("cart::lian.use_lian", false) ?>";
var paypalExpressCheckout = "<?= config("cart::paypal.express_checkout", false) ?>";
var usePaypalExpressCheckout = "<?= config("cart::paypal.use_paypal_express_checkout", false) ? 1 : 0?>";
var stripeFee = "<?= config("cart::stripe.include_fee", 0) ?>";
var giropayFee = "<?= config("cart::stripe.giropay_include_fee", 0) ?>";
var applepayFee = "<?= config("cart::stripe.applepay_include_fee", 0) ?>";
var klarnaFee = "<?= config("cart::stripe.klarna_include_fee", 0) ?>";
var afterpayFee = "<?= config("cart::stripe.afterpay_include_fee", 0) ?>";
var codFee = "<?= config("cart::sa.cod_include_fee", 0) ?>";
var adyenFee = "<?= config("cart::adyen.include_fee") ?>";
var tipsValue = "<?= config("cart::sa.tips_value", "") ?>";
var tipsValuePercent = "<?= config("cart::sa.tips_value_percent", "") ?>";
var showTips = "<?= config("cart::sa.show_tips", false) ?>";
var useGiropay = "<?= config("cart::stripe.use_giropay", false) ?>";
var useApplePay = "<?= config('cart::stripe.use_applepay', false) ?>";
var useExpressCheckout = "<?= config('cart::stripe.use_express_checkout', false) ?>";
var useKlarna = "<?= config('cart::stripe.use_klarna', false) ?>";
var useAfterPay = "<?= config('cart::stripe.use_afterpay', false) ?>";
var useCOD = "<?= config('cart::sa.use_cod', false) ?>";
var currencyUnit = "<?= strtolower(config('cart::sa.currency_unit')) ?>";
var keepOriginal = <?= json_encode(config('cart::sa.keep_original_price', [])) ?>;
var validCountry = <?= json_encode(config('cart::sa.valid_country', [])) ?>;
var useTaxes = "<?= config("cart::sa.use_taxes", false) ?>";
var taxes = <?= json_encode(config('cart::sa.taxes', [])) ?>;
var designFee = "<?= config('cart::sa.design_fee') ?>";
var giftWrapFee = "<?= config('cart::sa.gift_wrap_fee') ?>";
var includeDesignFee = "<?= config('cart::sa.design_include_fee') ?>";
var suspiciousFee = "<?= config('cart::sa.suspicious_fee') ?>";
var excludedEmailSuspicious = <?= json_encode(config('cart::sa.suspicious_email', [])) ?>;
var rewardsPercent = "<?= config('cart::sa.rewards_percent', 0) ?>";
var showRewards = "<?= config('cart::sa.show_rewards', false) ?>";
var originOrder = <?= isset($originOrder) ? json_encode($originOrder) : "null" ?>;
var exchangeFingerprint = "<?= isset($exchangeFingerprint) ? $exchangeFingerprint : '' ?>";
var currentPath = "<?= request()->path() ?>"
var otherTaxFee = "<?= config("cart::sa.other_tax_fee", 0) ?>";
var useSpecialShippingFee = "<?= config("cart::sa.use_special_shipping_fee", false) ?>";
var shouldUseNewInterface = "a";
var shippingFeeByLevel = [4.99, 0];
if (shouldUseNewInterface == 'b') {
    shippingFeeByLevel = [5.99, 0];
}
@if (isset($_GET['ab_testing']) && $_GET['ab_testing'] == '1')
    useSpecialShippingFee = true;
@endif
var textAwayShippingFee = `{{ __("You are #amount away from #shipping_fee flat rate shipping!") }}`;
var textAwayShippingFeeLevel2 = `{{ __("You are #amount away from free shipping!") }}`;
var buyMoreByQuantityText = "{{ __('#price each for #quantity items') }}";
var defaultBuyMoreText = "{{ __('Buying In Bulk?') }}";
if (tipsValue != "") {
    tipsValue = tipsValue.split(",");
}
if (tipsValuePercent != "") {
    tipsValuePercent = tipsValuePercent.split(",");
}
var ignoreOptionIds = <?= json_encode(config('pod::sa.custom_ignore_option_id.' . $checkoutLocale, [])) ?>;
var localeCheckout = "{{ env('APP_LOCALE') }}";
var prefixLocaleUrl = "{{ env('APP_LOCALE') != '' ? '/' . env('APP_LOCALE') . '/' : '/' }}";
var expressAuDescription = [
    "{{ __('Delivery date not guaranteed') }}",
    "{{ __('Tracking number') }}",
    "{{ __('Not deliverable to PO Boxes') }}",
];
var expressDescription = [
    "{{ __('Delivery date guaranteed') }}",
    "{{ __('Tracking number') }}",
    "{{ __('Not deliverable to PO Boxes') }}",
];
var shippingTypeAdvantages = {
    "standard": [
        "{{ __('Tracking number') }}",
        "{{ __('Saturday delivery') }}",
    ],
    "premium": [
        "{{ __('Tracking number') }}",
        "{{ __('Saturday delivery') }}",
    ],

};
var monthNames = [
    "{{ __('Jan. #date') }}", "{{ __('Feb. #date') }}", "{{ __('Mar. #date') }}", "{{ __('Apr. #date') }}", "{{ __('May. #date') }}", "{{ __('Jun. #date') }}",
    "{{ __('Jul. #date') }}", "{{ __('Aug. #date') }}", "{{ __('Sep. #date') }}", "{{ __('Oct. #date') }}", "{{ __('Nov. #date') }}", "{{ __('Dec. #date') }}"
];
var shippingFromText = "{{ __('#type shipping from #location') }}";
var shippingText = "{{ __('#type shipping') }}";
var textBusinessDays = "{{ __('#date business days with tracking') }}";
var textMoreShippingType = "{{ __('You have #number more delivery options') }}";
var textBuyDesign = `{{ __("Love this design? Purchase Licensed Design File. +#amount") }}`;
var noTipsText = "{{ __('No tips') }}";
var calculateCheckoutText = "{{ __('Calculated at checkout') }}";
var otherText = "{{ __('Other') }}";
var textFreeShippingTemplate = "{{ __('#type #freeIfLimit on orders over #value') }}";
var textAboveShippingTemplate = "{{ __('#type Free on orders over #value') }}";
var enterNameText = "{{ __('Enter a name') }}";
var enterFirstNameText = "{{ __('Enter a first name') }}";
var enterLastNameText = "{{ __('Enter a last name') }}";
var enterPhoneText = "{{ __('Enter a phone') }}";
var invaluePhoneText = "{{ __('Invalid phone number format.') }}" + "<br/>" + "{{ __('Example: +1 2223334444') }}";
var enterEmailText = "{{ __('Enter an email') }}";
var invalidEmailText = "{{ __('Invalid email') }}";
var recheckEmailText = "{{ __('Please check your email one more time before making the payment!') }}";
var selectCountryText = "{{ __('Select a Country / Region') }}";
var selectProvinceText = "{{ __('Select a State / Province') }}";
var enterCityNameText = "{{ __('Enter a City / Suburb') }}";
var selectDistrictText = "{{ __('Select a District / Town') }}";
var enterStateNameText = "{{ __('Enter a State / Province') }}";
var enterZipcodeText = "{{ __('Enter a ZIP code') }}";
var enterAddressText = "{{ __('Enter an address') }}";
var deliveryNoteLongText = "{{ __('Delivery note is too long') }}";
var errorCheckoutText = "{{ __('Error. Please try again later!') }}";
var applyCodeSuccessText = "{{ __('Apply code successfully!') }}";
var enterCodeText = "{{ __('Enter a valid promotion code!') }}";
var checkCountryAndZipcodeText = "{{ __('Unspecified delivery time. Please check your Country & ZIP code.') }}";
var invalidQuantityText = "{{ __('Invalid quantity!') }}";
var addedToCartText = "{{ __('Added to Cart!') }}";
var confirmRemoveItemText = "{{ __('Are you sure you want to remove this item?') }}";
var giftMessageLongText = "{{ __('Your message is too long') }}";
var giftNoMessageText = "{{ __('Enter a message') }}";
var freesshippingBoxPriceText = "{{ __('Only #price') }}";
var askUsePointText = "{{ __('Do you want to use #rewards points for this payment?') }}";
var tenancyToken = "<?= !empty($tenancyToken) ? $tenancyToken : '' ?>";
var earnPointText = "{{ __('Earn #point loyalty points with every purchase and redeem them for exclusive rewards in your account. Stay tuned for more exciting benefits with the Printerval Loyalty Program!') }}";
var invalidCardText = "{{ __('Your card is invalid') }}";
var priceTempate = "{{ getCurrencyTemplate() }}";
var currency_units = <?= json_encode(config('default.currency_units')) ?>;
var countryByIp = "{{ config('app.locale_shipping') }}";
var defaultCurrencyUnit = "{{ isset($_COOKIE['currency']) ? $_COOKIE['currency'] : config('default.currency_unit') }}";
var cjeventCookie = "{{ isset($_COOKIE['cje']) ? $_COOKIE['cje'] : '' }}";
if (!countryByIp) {
    countryByIp = "{{ \App\Utils::countryFromIp() }}";
}
var countries = <?= json_encode($countries) ?>;
var customerCountry = {"id":226,"iso":"US","name":"UNITED STATES","nicename":"United States"};
for (let index = 0; index < countries.length; index++) {
    const element = countries[index];
    if (element.iso == "AF") {
        countries.splice(index, 1);
    }
    if (element.iso == countryByIp.toUpperCase()) {
        customerCountry = element;
    }
}
var siteBaseUrl = "{{ route('home') }}";
toastr.options = {
    "autoDismiss": true,
    "preventDuplicates": true,
    "debug": false,
    "positionClass": "toast-bottom-right",
    "onclick": null,
    "fadeIn": 300,
    "fadeOut": 1000,
    "timeOut": 3000,
    "extendedTimeOut": 1000
};
var cartTranslateText = {
    front: "{{ __('Front') }}",
    back: "{{ __('Back') }}",
    left: "{{ __('Left') }}",
    right: "{{ __('Right') }}",
    top: "{{ __('Top') }}",
    bottom: "{{ __('Bottom') }}"
};

var addressBookModal = document.getElementById('addressBookModal');
var ggApiKey = "<?= config('cart::sa.google_api_key') ?>"
var adyenClientKey = "<?= config('cart::adyen.client_key') ?>"
var adyenServiceUrl = "<?= config('cart::adyen.service_url') ?>"
var adyenEnvironment = "<?= config('cart::adyen.environment') ?>"
var printLocations = <?= json_encode(getPrintLocationConfig()) ?>;
var printLocationsPrice = <?= json_encode(getPrintLocationPriceConfig()) ?>;
var cardForm = "<?= config('cart::sa.card_form', 'stripe') ?>";
console.log('cardForm', cardForm);
if (mode == 'paypal') {
    cardForm = "paypal";
} else if (mode == 'adyen') {
    cardForm = "adyen";
}
// setTimeout(function() {
//     var visitSource = getCookie('visit_source');
//     var isFbSource = /facebook|instagram/.test(visitSource);
//     if(visitSource && fbq && isFbSource){
// if(typeof fbq != 'undefined'){
//     fbq('track', 'InitiateCheckout',{
//     },{
//         'eventID':"{!! env('APP_LOCALE')  .'_'.strtotime('now') !!}"
//     });
// }
// },1000);

window.PodHireDesignerFee = {{ config('pod::sa.hire_designer_fee', 3) }};
</script>
<script src="{{ asset('modules/cart/js/checkout.js') }}?v={{ config('sa.version') }}"></script>
<script>
    var makeChangeApp = app;
</script>
<script src="{{ '/assets/js/controllers/sku-controller.js?v=' . config('sa.version') }}"></script>
<script src="{{ '/assets/js/controllers/print-location-controller.js?v=' . config('sa.version') }}"></script>
<script src="{{ asset('modules/cart/js/make-change.js') }}?v={{ config('sa.version') }}"></script>