@extends('layouts/master')

@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/themes/base/jquery-ui.min.css"
          integrity="sha512-ELV+xyi8IhEApPS/pSj66+Jiw+sOT1Mqkzlh8ExXihe4zfqbWkxPRi8wptXIO9g73FSlhmquFlUOuMSoXz5IRw=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    @view('checkout.checkout-css')
    <style>
        .show-payment-loading .payment-loading-action {
            border-radius: 4px;
            background: linear-gradient(45deg, rgba(209, 209, 209, 0.35), rgba(11, 11, 11, 0.1), rgba(209, 209, 209, 0.1), rgba(209, 209, 209, 0.15));
            background-size: 400% 400%;
            animation: gradient 3000ms ease infinite;
            user-select: none;
            width: 100%;
            display: block;
            min-height: 22px
        }

        @keyframes gradient {
            0% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
            100% {
                background-position: 0% 50%;
            }
        }
    </style>
@endsection

@section('main')
    <?php
    $shippingPolicyUrl = getOption('checkout.shipping.url');
    if (!$shippingPolicyUrl) {
        $shippingPolicyUrl = "javascript:;";
    }
    $paypalFee = config("cart::paypal.include_fee");
    $usePaypal = config("cart::paypal.use_paypal", false);
    $paypalExpressCheckout = config("cart::paypal.express_checkout", false);
    $stripeFee = config("cart::stripe.include_fee");
    $giropayFee = config("cart::stripe.giropay_include_fee");
    $applepayFee = config("cart::stripe.applepay_include_fee");
    $klarnaFee = config("cart::stripe.klarna_include_fee");
    $afterpayFee = config("cart::stripe.afterpay_include_fee");
    $codFee = config("cart::sa.cod_include_fee");
    $useGiropay = config("cart::stripe.use_giropay", false);
    $useApplepay = config("cart::stripe.use_applepay", false);
    $useExpressCheckout = config("cart::stripe.use_express_checkout", false);
    $useKlarna = config("cart::stripe.use_klarna", false);
    $useAfterpay = config("cart::stripe.use_afterpay", false);
    $useCOD = config("cart::sa.use_cod", false);
    $useBusinessDay = config('cart::sa.use_business_day', false);
    $useTaxes = config('cart::sa.use_taxes', false);
    $buyNowPayLaterText = __("Buy now, pay later via #type");
    $checkoutViaText = __("Checkout via #type");
    $isShowTransactionFee = true;
    $isShowGuarantee = config('cart::sa.is_show_guarantee', true);
    $designFee = config('cart::sa.design_fee', 0);
    $rewardsPercent = config('cart::sa.rewards_percent', 0);
    $isShowFreeShippingPackage = false;
    $cardForm = config('cart::sa.card_form', 'stripe');
    if (isset($_GET["mode"]) && $_GET["mode"] == "paypal") {
        $cardForm = "paypal";
    }
    if ($stripeFee == 0) {
        $allZero = true;
        if ($usePaypal && $paypalFee > 0) {
            $allZero = false;
        }
        if ($useGiropay && $giropayFee > 0) {
            $allZero = false;
        }
        if ($useKlarna && $klarnaFee > 0) {
            $allZero = false;
        }
        if ($useAfterpay && $afterpayFee > 0) {
            $allZero = false;
        }
        if ($useApplepay && $applepayFee > 0) {
            $allZero = false;
        }
        if ($useCOD && $codFee > 0) {
            $allZero = false;
        }
        if ($allZero) {
            $isShowTransactionFee = false;
        }
    }
    $handlingFeeText = __("Handling fee is the fulfillment fee. This is the fee you pay to process an order.");
    ?>
    <div id="cart-module-content" class="checkout-page">
        <div class="description-exchange">
            {{__('Make changes to your previously placed order, including updating product variations and shipping service. Ensure everything is correct before confirming your changes.')}}
        </div>
        <div class="container-indent flex-box flex-w" ng-show="cart">
            <div class="container-indent flex-box flex-w" ng-app="myApp" ng-controller="CheckOutController" ng-cloak style="margin: 0 auto">
                <div class="cart-center-col">
                    <div class="checkout-address-container checkout-address-container" id="form-checkout">
                        <div class="checkout-address-form">
                            <div class="common-title">
                                <span class="font-big font-bold mx-lg-5">{{ __('Shipping Address') }}</span>
                            </div>
                            <form class="address-container" novalidate="novalidate" action="/checkout" ng-cloak autocomplete="nope">
                                <div ng-class="{ 'address-row' : true, 'custom-state' : shipingLocation.province && shipingLocation.province.id == -1 }" id="shipping-info-area">
                                    <div class="address-col" ng-class="class('country')" style="z-index: 12" id="country_parent">
                                        <label for="country">
                                            {{ __('Country / Region') }}
                                        </label>
                                        <input autocomplete="off" class="input-text input-dropdown filter-country @{{ isShowSelectCountry ? 'selected' : '' }}" readonly value="@{{ shipingLocation.country.nicename }}" placeholder="{{ __('Select Country / Region')}}" type="text">
                                        <span class="js-close-search-filter" ng-click="closeSelectCountry()" ng-show="isShowSelectCountry">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                            </svg>
                                        </span>
                                        <div class="autocomplate-content content-select-country" ng-show="isShowSelectCountry">
                                            <div class="search">
                                                <input class="autocomplate-search filter-country input-text" placeholder="{{ __('Enter Country / Region to search')}}" type="text" value="" autocomplete="none" readonly>
                                            </div>
                                        </div>

                                        <div class="invalid-feedback" ng-if="hasError('country')" ng-bind="getErrorMsg('country')"> </div>
                                        <div class="background-select-country" ng-show="isShowSelectCountry" ng-click="closeSelectCountry()"></div>
                                    </div>
                                </div>
                                <div class="address-row address-suggestion flex-box flex-s flex-w">
                                    <div class="address-col" id="address_parent">
                                        <label for="address">
                                            {{ __('Address') }}
                                        </label>
                                        <input id="address"
                                               type="text"
                                               class="form-control"
                                               ng-class="class('address')"
                                               ng-model="address"
                                               ng-change="change('address');"
                                               placeholder=""
                                               autocomplete="shipping street-address"
                                               ng-model-options="{ debounce: 500 }"
                                               ng-blur="blurAction('address', address)"
                                        >
                                        <div class="invalid-feedback" ng-if="hasError('address')" ng-bind="getErrorMsg('address')"> </div>
                                    </div>
                                </div>
                                <div class="address-row flex-box flex-s flex-w">
                                    <div class="address-col" id="optional_address_parent">
                                        <label for="optional-address">
                                            {{ __('Apartment, suite, etc. (optional)') }}
                                        </label>
                                        <input
                                                id="optional_address"
                                                name="optional_address"
                                                type="text"
                                                class="form-control"
                                                ng-class="class('optional_address')"
                                                placeholder=""
                                                autocomplete="none"
                                                ng-model="shipingLocation.optional_address"
                                                ng-change="change('optional_address')"
                                                ng-blur="blurAction('optional_address', shipingLocation.optional_address)"
                                        >
                                    </div>
                                </div>
                                <div class="address-row flex-box flex-s flex-w">
                                    <div class="address-col" ng-show="shipingLocation.country && shipingLocation.country.iso != 'VN'" id="city_name_parent">
                                        <label>
                                            {{ __('City / Suburb') }}
                                        </label>
                                        <input
                                                name="city_name"
                                                class="form-control"
                                                type="text"
                                                ng-class="class('city_name')"
                                                id="city_name"
                                                ng-model="shipingLocation.city_name"
                                                ng-change="change('city_name')"
                                                ng-blur="blurAction('city_name', shipingLocation.city_name)"
                                        />
                                        <div class="invalid-feedback" ng-if="hasError('city_name')" ng-bind="getErrorMsg('city_name')"> </div>
                                    </div>
                                    <div class="address-col" ng-class="class('province')" ng-show="shipingLocation.country && provinces && provinces.length > 0" id="province_parent">
                                        <label>
                                            {{ __('State / Province') }}
                                        </label>
                                        <input autocomplete="off" class="input-text input-dropdown filter-province @{{ isShowSelectProvince ? 'selected' : '' }}" readonly value="@{{ shipingLocation.province.name }}" placeholder="{{ __('State / Province')}}" type="text" ng-click="openSelectProvince()">
                                        <span class="js-close-search-filter" ng-click="closeSelectProvince()" ng-show="isShowSelectProvince">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                            </svg>
                                        </span>
                                        <div class="autocomplate-content content-select-country select-state" ng-show="isShowSelectProvince">
                                            <div class="search">
                                                <input class="autocomplate-search filter-province input-text" placeholder="{{ __('Enter to search')}}" type="text" value="" autocomplete="none">
                                            </div>
                                            <ul class="list-filter-item">
                                                <li class="search-filter-item" ng-repeat="item in provinces" ng-click="selectProvince(item);">@{{ item.name }}</li>
                                            </ul>
                                        </div>
                                        <div class="invalid-feedback" ng-if="hasError('province')" ng-bind="getErrorMsg('province')"> </div>
                                        <div class="background-select-province" ng-show="isShowSelectProvince" ng-click="closeSelectProvince()"></div>
                                    </div>
                                    <div class="address-col" ng-class="class('district')" ng-show="shipingLocation.province && districts && districts.length > 0" id="district_parent">
                                        <label>
                                            {{ __('District') }}
                                        </label>
                                        <input autocomplete="off" class="input-text input-dropdown filter-district @{{ isShowSelectDistrict ? 'selected' : '' }}" readonly name="" value="@{{ shipingLocation.district.name }}" placeholder="{{ __('District / Town') }}" type="text" ng-click="openSelectDistrict()">
                                        <span class="js-close-search-filter" ng-click="closeSelectDistrict()" ng-show="isShowSelectDistrict">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                            </svg>
                                        </span>
                                        <div class="autocomplate-content content-select-country select-state" ng-show="isShowSelectDistrict">
                                            <div class="search">
                                                <input class="autocomplate-search filter-district input-text" placeholder="{{ __('Enter to search')}}" type="text" value="" autocomplete="none">
                                            </div>
                                            <ul class="list-filter-item">
                                                <li class="search-filter-item" ng-repeat="item in districts" ng-click="selectDistrict(item);">@{{ item.name }}</li>
                                            </ul>
                                        </div>
                                        <div class="invalid-feedback" ng-if="hasError('district')" ng-bind="getErrorMsg('district')"> </div>
                                        <div class="background-select-district" ng-show="isShowSelectDistrict" ng-click="closeSelectDistrict()"></div>
                                    </div>
                                    <div ng-class="{ 'address-col' : true, 'active' : shipingLocation.state_name != '' || isFocusStateName }" ng-show="shipingLocation.province && shipingLocation.province.id == -1" id="state_name_parent">
                                        <label>
                                            {{ __('Other State / Province') }}
                                        </label>
                                        <input
                                                name="state_name"
                                                class="form-control"
                                                type="text"
                                                ng-class="class('state_name')"
                                                id="state_name"
                                                ng-model="shipingLocation.state_name"
                                                ng-change="change('state_name')"
                                                ng-focus="changeFocusStateName(true)"
                                                ng-blur="changeFocusStateName(false); blurAction('state_name', shipingLocation.state_name)"
                                        />
                                        <div class="invalid-feedback" ng-if="hasError('state_name')" ng-bind="getErrorMsg('state_name')"> </div>
                                    </div>
                                    <div class="address-col" id="zipcode_parent">
                                        <label for="zipcode">
                                            {{ __('ZIP / Postal code') }}
                                        </label>
                                        <input
                                                id="zipcode"
                                                name="zipcode"
                                                type="text"
                                                class="form-control"
                                                ng-class="class('zipcode')"
                                                ng-model="shipingLocation.zipcode"
                                                ng-change="change('zipcode');"
                                                ng-blur="blurAction('zipcode', shipingLocation.zipcode)"
                                        >
                                        <div class="invalid-feedback" ng-if="hasError('zipcode')" ng-bind="getErrorMsg('zipcode')"> </div>
                                    </div>
                                </div>
                                <a class="shopcart-checkout-btn disable-links" style="opacity: 0.5;" ng-if="loading">
                                    {{ __('Loading') }}<span>&nbsp</span><i class='fa fa-spinner fa-spin'></i>
                                </a>
                                <div class="shopcart-checkout-btn" ng-click="saveShippingInfo()" ng-if="!loading">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-shield-check" viewBox="0 0 16 16" style="margin-right: 8px;">
                                        <path d="M5.338 1.59a61.44 61.44 0 0 0-2.837.856.481.481 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.725 10.725 0 0 0 2.287 2.233c.346.244.652.42.893.533.12.057.218.095.293.118a.55.55 0 0 0 .101.025.615.615 0 0 0 .1-.025c.076-.023.174-.061.294-.118.24-.113.547-.29.893-.533a10.726 10.726 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.775 11.775 0 0 1-2.517 2.453 7.159 7.159 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7.158 7.158 0 0 1-1.048-.625 11.777 11.777 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 62.456 62.456 0 0 1 5.072.56z"></path>
                                        <path d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z"></path>
                                    </svg>
                                    {{ __('Change') }}
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="cart-sidebar" ng-cloak style="display: none;">
                    <div class="sidebar-content">
                        <div class="shopcart-fixed-sidebar-container">

                            <div class="common-title">
                            <span class="font-big font-bold mx-lg-5">
                                {{ __('Order Summary') }}
                            </span>
                            </div>
                            <div class="shopcart-summary-container checkout-item-box order-summary">
                                <div class="summary-subtotal-container-wrap">
                                    <div class="subtotal-item flex-box flex-s align-c">
                                        <span>{{ __('Subtotal') }}:</span>
                                        <span class="primary-text p-price-cart fw-500">@{{ formatPrice(cart.sub_total, 0, false) }}</span>
                                    </div>
                                    <div class="subtotal-item flex-box flex-s align-c" ng-show="discount" ng-if="discountType == 'normal'">
                                        <span>{{ __('Discount') }}:</span>
                                        <span class="primary-text p-price-cart fw-500">-@{{ formatPrice(discount, 0, false) }}</span>
                                    </div>
                                    <div class="subtotal-item flex-box flex-s align-c" ng-show="discount" ng-if="discountType == 'freeship' && customerRewards.rewards > 0">
                                        <span>{{ __('Discount') }}:</span>
                                        <span class="primary-text p-price-cart fw-500">-@{{ formatPrice(customerRewards.rewards, 0, false) }}</span>
                                    </div>
                                    <div class="subtotal-item flex-box flex-s align-c">
                                    <span class="flex-b align-c">
                                        {{ __('Shipping fee') }}:
                                    </span>
                                        <span class="primary-text p-price-cart fw-500" ng-if="discountType == 'normal'">@{{ (shipping_fee && shipping_fee > 0 ? '+' : '') + formatPrice(shipping_fee, 0, false) }}</span>
                                        <span class="primary-text p-price-cart fw-500" ng-if="discountType == 'freeship' && customerRewards.rewards == 0">@{{ (shipping_fee && discount && shipping_fee - discount > 0 ? '+' : '') + shipping_fee - discount > 0 ? formatPrice(shipping_fee - discount, 0, false) : formatPrice(0, 0, false) }}</span>
                                        <span class="primary-text p-price-cart fw-500" ng-if="discountType == 'freeship' && customerRewards.rewards > 0">@{{ (shipping_fee && discount && shipping_fee - discount + customerRewards.rewards > 0 ? '+' : '') + shipping_fee - discount + customerRewards.rewards > 0 ? formatPrice(shipping_fee - discount + customerRewards.rewards, 0, false) : formatPrice(0, 0, false) }}</span>
                                    </div>

                                    @if ($isShowTransactionFee)
                                        <div class="subtotal-item flex-box flex-s align-c">
                                    <span class="flex-b align-c">
                                        @{{ payment_type == 'paypal' ? "Paypal's " :
                                            payment_type == 'stripe' ? "Stripe's " :
                                            payment_type == 'giropay' ? "Giropay's " :
                                            payment_type == 'klarna' ? "Klarna's " : ""
                                        }}{{ __('Transaction fee') }}:
                                        <div class="address-tooltip">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                                <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                            </svg>
                                            <div class="address-tooltip-content">
                                                {{ __('Please be advised this is the fee you pay every time you process a transaction. This fee goes to the payment gateway and we do not own it.') }}
                                            </div>
                                        </div>
                                    </span>
                                            <span class="primary-text p-price-cart fw-500">@{{ (otherFee ? '+' : '') + formatPrice(otherFee, 0, false) }}</span>
                                        </div>
                                    @endif
                                    <div class="subtotal-item flex-box flex-s align-c" ng-show="showTips">
                                        <span>{{ __('Tips') }}:</span>
                                        <span class="primary-text p-price-cart fw-500">@{{ (tipsAmount && tipsAmount > 0 ? '+' : '') + formatPrice(tipsAmount, 0, false) }}</span>
                                    </div>
                                    @if ($useTaxes)
                                        <div class="subtotal-item flex-box flex-s align-c" ng-show="shipingLocation.country && shipingLocation.country.iso == 'US'">
                                            <span>{!! __('Taxes') !!}:</span>
                                            <span class="primary-text p-price-cart fw-500">@{{ calculateTaxFee() }}</span>
                                        </div>
                                    @endif
                                    <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px">
                                        <span>{{ __('Paid amount') }}:</span>
                                        <span class="subtotal-price p-price-main primary-text">@{{ formatPrice(originOrder.amount, 0, false) }}</span>
                                    </div>
                                    <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px">
                                        <span>{{ __('Total') }}:</span>
                                        <span class="subtotal-price p-price-main primary-text">@{{ getCartAmount() }}</span>
                                    </div>
                                    <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px" ng-if="getCartAmount(false) > originOrder.amount">
                                        <span>{{ __('Total additional payment') }}:</span>
                                        <span class="subtotal-price p-price-main primary-text">@{{ formatPrice(getCartAmount(false) - originOrder.amount, 0, false) }}</span>
                                    </div>
                                    <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px" ng-if="getCartAmount(false) == originOrder.amount">
                                        <span>{{ __('Total additional payment') }}:</span>
                                        <span class="subtotal-price p-price-main primary-text">{{ __('No extra charges.') }}</span>
                                    </div>
                                    <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px" ng-if="getCartAmount(false) < originOrder.amount">
                                        <span>{{ __('Total refund') }}:</span>
                                        <span class="subtotal-price p-price-main primary-text">@{{ formatPrice(originOrder.amount - getCartAmount(false), 0, false) }}</span>
                                    </div>
                                </div>

                            </div>

                            <div class="show-payment-loading" ng-class="{'loading-height': !isShowPaymentType}" ng-show="!isShowPaymentType">
                                <div class="payment-loading-title payment-loading-action" style="height: 30px;margin-bottom: 12px;margin-top: 12px;"></div>
                                <div class="payment-loading-box flex-b" style="gap: 5px">
                                    <span class="payment-loading-action" style="height: 54px; width: 100px;"></span>
                                    <span class="payment-loading-action" style="height: 54px; width: 100px;"></span>
                                </div>
                                <div class="payment-loading-note payment-loading-action" style="height: 21px;margin-top:10px;margin-bottom: 10px;"></div>
                                <div class="payment-loading-card flex-b align-s flex-s flex-w" style=" gap: 8px">
                                    <span class="payment-loading-action" style="width: 100%; height: 52px;"></span>
                                    <span class="payment-loading-action" style="width: 60%; height: 52px;"></span>
                                    <span class="payment-loading-action" style="width: 37%"></span>
                                </div>
                            </div>
                            <div id="show-payment-type" ng-show="isShowPaymentType">
                                <div class="common-title" >
                                <span class="font-big font-bold mx-lg-5">
                                    {{ __('Payment Methods') }}
                                </span>
                                </div>
                                <div class="shopcart-summary-container checkout-item-box payment-method" ng-show="getCartAmount(false) != originOrder.amount">
                                    <div class="payment-method-button">
                                        @if ($useCOD)
                                            <div class="payment-method-item @{{ payment_type == 'cod' ? 'active' : '' }}">
                                                <input id="cod-method" type="radio" name="" ng-checked="payment_type == 'cod'" checked ng-click="changePayment('cod')" ng-disabled="loading">
                                                <label for="cod-method" class="input-radio title-btn flex-box">
                                                    <div class="input-content flex-box align-c flex-w">
                                                        <img src="{{ asset('modules/cart/images/cash-on-delivery.png') }}" height="20">
                                                        <span class="title-payment-button">{{ __("Cash on delivery") }}</span>
                                                    </div>
                                                </label>
                                            </div>
                                        @endif
                                        @if ($cardForm == 'stripe')
                                            <div class="payment-method-item @{{ payment_type == 'stripe' ? 'active' : '' }}">
                                                <input id="stripe-method" type="radio" ng-checked="payment_type == 'stripe'" checked ng-click="changePayment('stripe')" ng-disabled="loading">
                                                <label for="stripe-method" class="input-radio title-btn flex-box flex-w stripe-form-checkout">
                                                    <div class="input-content flex-box align-c flex-w">
                                                        <img src="{{ asset('modules/cart/images/card2.svg') }}" height="20" widht="20">
                                                        <span class="title-payment-button">{{ __("Card") }}</span>
                                                    </div>
                                                </label>
                                            </div>
                                        @elseif ($cardForm == 'paypal')
                                            <div class="payment-method-item @{{ payment_type == 'paypal_card' ? 'active' : '' }}">
                                                <input id="paypal-cart-method" type="radio" ng-checked="payment_type == 'paypal_card'" checked ng-click="changePayment('paypal_card')" ng-disabled="loading">
                                                <label for="paypal-cart-method" class="input-radio title-btn flex-box flex-w stripe-form-checkout">
                                                    <div class="input-content flex-box align-c flex-w">
                                                        <img src="{{ asset('modules/cart/images/card2.svg') }}" height="20" widht="20">
                                                        <span class="title-payment-button">{{ __("Card") }}</span>
                                                    </div>
                                                </label>
                                            </div>
                                        @endif

                                        <!-- useKlarna -->
                                        @if ($useKlarna)
                                            <div class="payment-method-item @{{ payment_type == 'klarna' ? 'active' : '' }}">
                                                <input id="klarna-method" type="radio" ng-checked="payment_type == 'klarna'" ng-click="changePayment('klarna')" ng-disabled="loading">
                                                <label for="klarna-method" class="input-radio title-btn flex-box">
                                                    <div class="input-content flex-box align-c flex-w">
                                                        <img src="{{ asset('modules/cart/images/klarna2.svg') }}" height="20" widht="20">
                                                        <div class="title-payment-button">{{ __("Klarna") }}</div>
                                                    </div>
                                                </label>
                                            </div>
                                        @endif

                                        <!-- useAfterpay -->
                                        @if ($useAfterpay)
                                            <div class="payment-method-item @{{ payment_type == 'afterpay' ? 'active' : '' }}">
                                                <input id="afterpay-method" type="radio" ng-checked="payment_type == 'afterpay'" ng-click="changePayment('afterpay')" ng-disabled="loading">
                                                <label for="afterpay-method" class="input-radio title-btn flex-box" ng-show="isShowAfterPay && shipingLocation.country && shipingLocation.country.iso == 'US'">
                                                    <div class="input-content flex-box align-c flex-w">
                                                        <img src="{{ asset('modules/cart/images/afterpay2.png') }}" height="20" widht="20">
                                                        <img src="{{ asset('modules/cart/images/klarna2.svg') }}" height="20" widht="20">
                                                        <img src="{{ asset('modules/cart/images/affirm.svg') }}" height="18"  widht="18" ng-show="getCartAmount(false) > 50">
                                                        <div class="title-payment-button">{{ __("Buy now, pay later") }}</div>
                                                    </div>
                                                </label>
                                            </div>
                                        @endif

                                        <!-- usePaypal -->
                                        @if ($usePaypalByLimit && $usePaypal && $isValidPaypalByProduct)
                                            <div class="payment-method-item @{{ payment_type == 'paypal' ? 'active' : '' }}" ng-show="validPaypal">
                                                <input id="paypal-method" type="radio" ng-checked="payment_type == 'paypal'" ng-click="changePayment('paypal')" ng-disabled="loading">
                                                <label for="paypal-method" class="input-radio title-btn flex-box">
                                                    <div class="input-content flex-box align-c flex-w">
                                                        <img src="{{ asset('modules/cart/images/paypal2.svg') }}" height="20" widht="20">
                                                        <div class="title-payment-button">{{ __("PayPal") }}</div>
                                                    </div>
                                                </label>
                                            </div>
                                        @endif

                                        <!-- useGiropay -->
                                        @if ($useGiropay)
                                            <div class="payment-method-item @{{ payment_type == 'giropay' ? 'active' : '' }}">
                                                <input id="giropay-method" type="radio" ng-checked="payment_type == 'giropay'" ng-click="changePayment('giropay')" ng-disabled="loading">
                                                <label for="giropay-method" class="input-radio title-btn flex-box">
                                                    <div class="input-content flex-box align-c flex-w">
                                                        <img src="{{ asset('modules/cart/images/giropay.png') }}" height="20" widht="20">
                                                        <div class="title-payment-button">{{ __("GiroPay") }}</div>
                                                    </div>
                                                </label>
                                            </div>

                                        @endif

                                        <!-- useApplepay -->
                                        @if ($useApplepay)
                                            <div class="payment-method-item @{{ payment_type == 'apple_google' ? 'active' : '' }} @{{ validApplePay ? 'valid-apple' : '' }}" ng-show="validApplePay" style="display: none;">
                                                <input id="applepay-method" type="radio" ng-checked="payment_type == 'apple_google'" ng-click="changePayment('apple_google')" ng-disabled="loading">
                                                <label for="applepay-method" class="input-radio title-btn flex-box" id="label-applepay" ng-show="validApplePay">
                                                    <div class="input-content flex-box align-c flex-w">
                                                        <img ng-show="paymentGateway.isApplePay" src="{{ asset('modules/cart/images/apple-pay-logo.png?v=' . config('sa.version')) }}" height="20">
                                                        <img ng-show="paymentGateway.isGooglePay" src="{{ asset('modules/cart/images/google-pay-logo.png?v=' . config('sa.version')) }}" height="20" width="20">
                                                        <div ng-show="paymentGateway.isApplePay" class="title-payment-button">{{ __("Apple") }}</div>
                                                        <div ng-show="paymentGateway.isGooglePay" class="title-payment-button">{{ __("Google") }}</div>
                                                    </div>
                                                </label>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="credit-form" id="cod-form" style="display: none;">
                                        <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                            @if ($codFee > 0)
                                                <label for="cod-method">
                                                    <small style="color: #ff7300; font-style:italic">(+<span>{{ $codFee }}%</span> {{ __('Handling fee') }})</small>
                                                </label>
                                            @elseif ($codFee == 0)
                                                <label for="cod-method">
                                                    <small style="color: #ff7300; font-style:italic">({{ __('No handling fee!') }})</small>
                                                </label>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="credit-form" id="klarna-form" style="display: none;">
                                        <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                            @if ($klarnaFee > 0)
                                                <label for="klarna-method">
                                                    <small style="color: #ff7300;"><span>{{ $klarnaFee }}%</span> {{ __('Handling fee') }}</small>
                                                </label>
                                            @elseif ($klarnaFee == 0)
                                                <label for="klarna-method">
                                                    <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                                </label>
                                            @endif
                                            <div class="address-tooltip">
                                                <div class="address-tooltip-info">
                                                    {{ $handlingFeeText }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="credit-form" id="afterpay-form">
                                        <div class="flex-box align-c flex-w address-tooltip-wrapp" ng-show="isShowAfterPay && shipingLocation.country && shipingLocation.country.iso == 'US'">
                                            @if ($afterpayFee > 0)
                                                <label for="afterpay-method">
                                                    <small style="color: #ff7300;" class="show-note-payment">{{ __('May not be accepted by some locales or users. In this case please choose another payment method') }}</small>
                                                    <small style="color: #ff7300;">Pay in 4 instalments of @{{ getAmountAfterPay() }}</small><br>
                                                    <!-- <small style="color: #ff7300;"><span>{{ $afterpayFee }}%</span> {{ __('Handling fee') }}. </small> -->
                                                </label>
                                            @elseif ($afterpayFee == 0)
                                                <label for="afterpay-method">
                                                    <small style="color: #ff7300;" class="show-note-payment">{{ __('May not be accepted by some locales or users. In this case please choose another payment method') }}</small>
                                                    <!-- <small style="color: #ff7300;">{{ __('No handling fee!') }}</small> -->
                                                </label>
                                            @endif
                                            <div class="address-tooltip" style="display: none;">
                                                <div class="address-tooltip-info">
                                                    {{ $handlingFeeText }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- <div class="credit-form" id="paypal-form" style="display: none;">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                        @if ($paypalFee > 0)
                                        <label for="paypal-method">
                                            <small style="color: #ff7300;"><span>{{ $paypalFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($paypalFee == 0)
                                        <label for="paypal-method">
                                            <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                    @if ($paypalFee > 0)
                                        <div class="address-tooltip">
                                            <div class="address-tooltip-info">
                                            {{ $handlingFeeText }}
                                        </div>
                                    </div>
@endif
                                    </div>
                                </div> -->
                                    <div class="credit-form" id="giropay-form" style="display: none;">
                                        <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                            @if ($giropayFee > 0)
                                                <label for="giropay-method">
                                                    <small style="color: #ff7300;"><span>{{ $giropayFee }}%</span> {{ __('Handling fee') }}</small>
                                                </label>
                                            @elseif ($giropayFee == 0)
                                                <label for="giropay-method">
                                                    <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                                </label>
                                            @endif
                                            <div class="address-tooltip">
                                                <div class="address-tooltip-info">
                                                    {{ $handlingFeeText }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- <div class="credit-form" id="apple-google-form" style="display: none;">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp" ng-show="validApplePay">
                                        @if ($applepayFee > 0)
                                        <label for="applepay-method">
                                            <small style="color: #ff7300;"><span>{{ $applepayFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($applepayFee == 0)
                                        <label for="applepay-method">
                                            <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                    <div class="address-tooltip">
                                        <div class="address-tooltip-info">
{{ $handlingFeeText }}
                                    </div>
                                </div>
                            </div>
                        </div> -->
                                    <div class="credit-form" id="paypal-card-form" style="display: <?= $cardForm == 'stripe' ? 'none' : 'block' ?>">
                                        <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                            @if ($paypalFee > 0)
                                                <label for="paypal-cart-method">
                                                    <small style="color: #ff7300;"><span>{{ $paypalFee }}%</span> {{ __('Handling fee') }}</small>
                                                </label>
                                            @elseif ($paypalFee == 0)
                                                <label for="paypal-cart-method">
                                                    <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                                </label>
                                            @endif
                                            <div class="address-tooltip">
                                                <div class="address-tooltip-info">{{ $handlingFeeText }}</div>
                                            </div>
                                            <div class="flex-box align-c" style="margin-top: 5px;">
                                                <img src="{{ asset('modules/cart/images/visa.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/master-card.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/amex.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/jcb.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/discover.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/eftpos.png') }}" style="width: 34px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/unionpay.png') }}" style="width: 39px; margin-right: 4px;">
                                            </div>
                                        </div>
                                        <form id="card-form">
                                            <label for="card-number">Card Number</label>
                                            <div id="card-number" class="card_field"></div>
                                            <div style="display: flex; flex-direction: row; width: 100%;">
                                                <div style="width: 30%;">
                                                    <label for="card-expiry">Expiration Date</label>
                                                    <div id="card-expiry" class="card_field"></div>
                                                </div>
                                                <div style="padding-left: 10px; width:70%;">
                                                    <label for="cvv">CVV</label>
                                                    <div id="card-cvv" class="card_field"></div>
                                                </div>
                                            </div>
                                            <div id="card-name" class="card_field"></div>
                                            <div id="paypal-card-errors" class="error invalid-feedback" role="alert">
                                            <span class="message">
                                                @{{ errorCard }}
                                            </span>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="credit-form" id="payment-form" style="display: <?= $cardForm == 'stripe' ? 'block' : 'none' ?>;">
                                        <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                            <!-- @if ($stripeFee > 0)
                                                <label for="stripe-method">
                                                    <small style="color: #ff7300;"><span>{{ $stripeFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($stripeFee == 0)
                                                <label for="stripe-method">
                                                    <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                            <div class="address-tooltip">
                                                <div class="address-tooltip-info">{{ $handlingFeeText }}</div>
                                        </div> -->
                                            <div class="flex-box align-c" style="margin-top: 5px;">
                                                <img src="{{ asset('modules/cart/images/visa.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/master-card.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/amex.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/jcb.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/discover.png') }}" style="width: 35px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/eftpos.png') }}" style="width: 34px; margin-right: 4px;">
                                                <img src="{{ asset('modules/cart/images/unionpay.png') }}" style="width: 39px; margin-right: 4px;">
                                            </div>
                                        </div>
                                        <form class="">
                                            <div class="card-number">
                                                <label class="credit-label" for="">
                                                    <span>{{ __('Card Number') }}</span>
                                                    <div class="address-tooltip">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                                        </svg>
                                                        <div class="address-tooltip-content">
                                                            {{ __("We don't store ANY of your card information.") }}
                                                        </div>
                                                    </div>
                                                </label>
                                                <div id="credit-card-number" class="field empty credit-control"></div>
                                            </div>
                                            <div class="flex-b flex-s card-info">
                                                <div class="card-expire card-info-item">
                                                    <label class="credit-label" for="">
                                                        <span>{{ __('Expiry date') }}</span>
                                                    </label>
                                                    <div id="credit-card-expiry" class="field empty third-width credit-control"></div>
                                                </div>
                                                <div class="card-cvc card-info-item">
                                                    <label class="credit-label" for="">
                                                        <span>CVC</span>
                                                        <div class="address-tooltip">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                                                <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                                            </svg>
                                                            <div class="address-tooltip-content">
                                                                {{ __('3-digit security code usually found on the back of your card. American Express cards have a 4-digit code located on the front.') }}
                                                            </div>
                                                        </div>
                                                    </label>
                                                    <div id="credit-card-cvc" class="field empty third-width credit-control"></div>
                                                </div>
                                            </div>
                                            <div id="credit-card-errors" class="error invalid-feedback" role="alert">
                                            <span class="message">
                                                @{{ errorCard }}
                                            </span>
                                            </div>
                                            <button type="submit" data-tid="elements_examples.form.pay_button" hidden class="hidden">{{ __('Submit Payment') }}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div id="credit-card-errors" class="error-payment invalid-feedback" role="alert">
                            <span class="message">
                                @{{ errorPayment }}
                            </span>
                            </div>
                            <!-- #end show Payment type  -->

                            <div class="overflow-hidden shopcart-payment-btn-container">
                                <div class="shopcart-checkout-btn-container">
                                    <a class="shopcart-checkout-btn disable-links" style="opacity: 0.5;" ng-if="loading">
                                        {{ __('Loading') }}<span>&nbsp</span><i class='fa fa-spinner fa-spin'></i>
                                    </a>
                                    <a class="shopcart-checkout-btn" ng-click="order()" ng-if="!loading">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-shield-check" viewBox="0 0 16 16" style="margin-right: 8px;">
                                            <path d="M5.338 1.59a61.44 61.44 0 0 0-2.837.856.481.481 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.725 10.725 0 0 0 2.287 2.233c.346.244.652.42.893.533.12.057.218.095.293.118a.55.55 0 0 0 .101.025.615.615 0 0 0 .1-.025c.076-.023.174-.061.294-.118.24-.113.547-.29.893-.533a10.726 10.726 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.775 11.775 0 0 1-2.517 2.453 7.159 7.159 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7.158 7.158 0 0 1-1.048-.625 11.777 11.777 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 62.456 62.456 0 0 1 5.072.56z"></path>
                                            <path d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z"></path>
                                        </svg>
                                        {{ __('Place Order Now') }}
                                    </a>
                                    <div id="express-checkout-element">
                                        <!-- Express Checkout Element will be inserted here -->
                                    </div>
                                    <div id="error-message" style="color: red; margin-top: 5px;">
                                        <!-- Display error message to your customers here -->
                                    </div>
                                    <div id="payment-request-button" style="margin: 12px 0;">
                                    </div>
                                    <button id="applePayButton" ng-show="modeCheckout == 'test'" style="display: none;">Pay with Apple Pay</button>
                                </div>
                                <div class="submit-a-ticket" style="margin-bottom: 10px;">
                                    @php
                                        $supportStr = __('Having trouble? #submitATicket and we will get back to you!');
                                        $submitLink = '<a class="submit-a-ticket-link" style="color: #ec8700;" target="_blank" href="' . clroute('/contact/ticket/flow?mode=creating-an-issue-report') . '">' . __('Submit a ticket') . '</a>';
                                        $supportStr = str_replace('#submitATicket', $submitLink, $supportStr);
                                    @endphp
                                    {!! $supportStr !!}
                                </div>
                                @if ($isShowGuarantee && false)
                                    <fieldset class="guaranteed-wrapper">
                                        <!-- <legend>{!! __('Guaranteed <span style="color: #04eb04;">SAFE</span> Checkout') !!}</legend> -->
                                        <div class="guaranteed-box">
                                            <img src="{{ asset('modules/cart/images/verify.webp?v=2025') }}" width="100">
                                            <img src="{{ asset('modules/cart/images/paypal-verify.webp?v=2025') }}" width="100">
                                            <img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
                                        </div>
                                    </fieldset>
                                @endif
                                @if (config("cart::sa.trustlock", true))
                                    <fieldset class="guaranteed-wrapper">
                                        <div class="guaranteed-box" style="padding: 8px;">
                                            <a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-business-TL-873835142792" class="trustlock-img">
                                                <img width="74" height="55"
                                                     src="{{ asset('modules/cart/images/business-trust-seal-trust-lock.webp?v=2025') }}"
                                                     alt="">
                                            </a>
                                            <a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-privacy-TL-873835142792" class="trustlock-img">
                                                <img width="74" height="55"
                                                     src="{{ asset('modules/cart/images/privacy-trust-seal-trust-lock.webp?v=2025') }}"
                                                     alt="">
                                            </a>
                                            <a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-ssl-TL-873835142792" class="trustlock-img">
                                                <img width="74"
                                                     height="55"
                                                     src="{{ asset('modules/cart/images/ssl-secure-trust-seal-trust-lock.webp?v=2025') }}"
                                                     alt="">
                                            </a>
                                            <a href="{{ getOption('general.payment_method_url', 'payment-methods-n653.html') }}" class="link-guaranteed-img" target="_blank">
                                                <img src="{{ asset('modules/cart/images/paypal-verify2.webp?v=2025') }}" width="100">
                                            </a>
                                            <a href="{{ getOption('general.payment_method_url', 'payment-methods-n653.html') }}" class="link-guaranteed-img" target="_blank">
                                                <img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
                                            </a>
                                        </div>
                                    </fieldset>
                                @else
                                    <fieldset class="guaranteed-wrapper">
                                        <!-- <legend>{!! __('Guaranteed <span style="color: #04eb04;">SAFE</span> Checkout') !!}</legend> -->
                                        <div class="guaranteed-box guaranteed-box-not-strustlock">
                                            <img src="{{ asset('modules/cart/images/verify.webp?v=2025') }}" width="100">
                                            <img src="{{ asset('modules/cart/images/paypal-verify.webp?v=2025') }}" width="100">
                                            <img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
                                        </div>
                                    </fieldset>
                                @endif
                                <div style="margin-top: 18px; display: none;">
                                    <ul class="flex-b align-c flex-s flex-w" style="
                                    list-style: none; padding-left: 0px; color: var(--primary); font-size: 13px;font-weight: 400;
                                ">
                                        <li>
                                            <a href="{{ clroute(getOption('general.refund_url', 'refund-policy-n650.html')) }}" target="_blank">
                                                {{ __('Refund policy') }}
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ clroute(getOption('general.return_url', 'returns-exchanges-policy-n651.html')) }}" target="_blank">
                                                {{__('Returns & Exchanges Policy')}}
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ clroute(getOption('general.shipping_url', 'shipping-delivery-n7.html')) }}" target="_blank">
                                                {{ __('Shipping policy') }}
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ clroute(getOption('general.privacy_url', 'privacy-policy-n13.html')) }}" target="_blank">
                                                {{__('Privacy policy')}}
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ clroute(getOption('general.terms_service_url', 'terms-of-service-n5.html')) }}" target="_blank">
                                                {{__('Terms of service')}}
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    @parent
    <script>
        var mySwiper = new Swiper ('.cart-review-item-list', {
            loop: true,
            slidesPerView: 1,
            spaceBetween: 0,
            autoplay:  2500,
            navigation: {
                nextEl: ".cart-revew-next",
                prevEl: ".cart-revew-prev",
            }
        });
        var orderCode = '{{ !empty($originOrder['code']) ? $originOrder['code'] : '' }}';
    </script>
    @view('checkout.checkout-script')
    @view('build-source')
@endsection