@extends('layouts/master')
@section('title')
	{{ __('Checkout') }}
@endsection

@section('css')
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/themes/base/jquery-ui.min.css" integrity="sha512-ELV+xyi8IhEApPS/pSj66+Jiw+sOT1Mqkzlh8ExXihe4zfqbWkxPRi8wptXIO9g73FSlhmquFlUOuMSoXz5IRw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
	@view('checkout.checkout-css')
    <style>
        .show-payment-loading .payment-loading-action {border-radius: 4px; background: linear-gradient(45deg, rgba(209,209,209,0.35), rgba(11,11,11,0.1), rgba(209,209,209,0.1), rgba(209,209,209,0.15)); background-size: 400% 400%; animation: gradient 3000ms ease infinite; user-select: none; width: 100%; display: block; min-height: 22px}
        @keyframes gradient { 0% { background-position: 0% 50%; } 50% { background-position: 100% 50%; } 100% { background-position: 0% 50%; } }
    </style>
@endsection

@section('main')
<?php
$shippingPolicyUrl = getOption('checkout.shipping.url');
if (!$shippingPolicyUrl) {
	$shippingPolicyUrl = "javascript:;";
}
$paypalFee = config("cart::paypal.include_fee");
$usePaypal = config("cart::paypal.use_paypal", false);
$paypalExpressCheckout = config("cart::paypal.express_checkout", false);
$stripeFee = config("cart::stripe.include_fee");
$giropayFee = config("cart::stripe.giropay_include_fee");
$applepayFee = config("cart::stripe.applepay_include_fee");
$klarnaFee = config("cart::stripe.klarna_include_fee");
$afterpayFee = config("cart::stripe.afterpay_include_fee");
$codFee = config("cart::sa.cod_include_fee");
$useGiropay = config("cart::stripe.use_giropay", false);
$useApplepay = config("cart::stripe.use_applepay", false);
$useExpressCheckout = config("cart::stripe.use_express_checkout", false);
$useKlarna = config("cart::stripe.use_klarna", false);
$useAfterpay = config("cart::stripe.use_afterpay", false);
$useCOD = config("cart::sa.use_cod", false);
$useBusinessDay = config('cart::sa.use_business_day', false);
$useTaxes = config('cart::sa.use_taxes', false);
$buyNowPayLaterText = __("Buy now, pay later via #type");
$checkoutViaText = __("Checkout via #type");
$isShowTransactionFee = true;
$isShowGuarantee = config('cart::sa.is_show_guarantee', true);
$designFee = config('cart::sa.design_fee', 0);
$rewardsPercent = config('cart::sa.rewards_percent', 0);
$isShowFreeShippingPackage = false;
$cardForm = config('cart::sa.card_form', 'stripe');
if (isset($_GET["mode"]) && $_GET["mode"] == "paypal") {
	$cardForm = "paypal";
}
if ($stripeFee == 0) {
	$allZero = true;
	if ($usePaypal && $paypalFee > 0) {
		$allZero = false;
	}
	if ($useGiropay && $giropayFee > 0) {
		$allZero = false;
	}
	if ($useKlarna && $klarnaFee > 0) {
		$allZero = false;
	}
	if ($useAfterpay && $afterpayFee > 0) {
		$allZero = false;
	}
	if ($useApplepay && $applepayFee > 0) {
		$allZero = false;
	}
	if ($useCOD && $codFee > 0) {
		$allZero = false;
	}
	if ($allZero) {
		$isShowTransactionFee = false;
	}
}
$handlingFeeText = __("Handling fee is the fulfillment fee. This is the fee you pay to process an order.");
?>

<div id="cart-module-content" class="checkout-page">
    <div class="description-exchange">
        {{__('Make changes to your previously placed order, including updating product variations and shipping service. Ensure everything is correct before confirming your changes.')}}
    </div>
	<div class="container-indent flex-box flex-w" ng-show="cart">
        <div class="container-indent flex-box flex-w" ng-app="myApp" ng-controller="CheckOutController" ng-cloak style="margin: 0 auto">
            <div class="cart-center-col">
                <div class="checkout-address-container checkout-address-container" id="form-checkout" style="display: none;">
                    <div class="checkout-address-form">
                        <div class="common-title">
                            <span class="font-big font-bold mx-lg-5">{{ __("Billing information") }}</span>
                        </div>
                        <form class="address-container" novalidate="novalidate" action="/checkout" ng-cloak autocomplete="nope">
                            <div class="address-row">
                                <div class="address-col" id="first_name_parent">
                                    <label for="name">
                                        {{ __('First name') }}
                                    </label>
                                    <input id="first_name" name="name" type="text" class="form-control" ng-class="class('first_name')" ng-model="first_name" ng-change="change('first_name')" ng-blur="blurAction('first_name', first_name)">
                                    <div class="invalid-feedback" ng-if="hasError('first_name')" ng-bind="getErrorMsg('first_name')"></div>
                                </div>
                                <div class="address-col" id="last_name_parent">
                                    <label for="name">
                                        {{ __('Last name') }}
                                    </label>
                                    <input id="last_name" name="name" type="text" class="form-control" ng-class="class('last_name')" ng-model="last_name" ng-change="change('last_name')" ng-blur="blurAction('last_name', last_name)">
                                    <div class="invalid-feedback" ng-if="hasError('last_name')" ng-bind="getErrorMsg('last_name')"></div>
                                </div>
                                
                            </div>
                            <div class="address-row">
                                <div class="address-col" id="phone_parent">
                                    <label for="phone">
                                        {{ __('Phone') }} ({{ __('required') }})
                                    </label>
                                    <input id="phone" name="phone" type="tel" class="form-control" ng-class="class('phone')" ng-model="phone" ng-change="change('phone')" ng-blur="handleBlurPhone(); blurAction('phone', phone)">
                                    <div class="invalid-feedback" ng-if="hasError('phone')" ng-bind-html="getErrorMsg('phone')"></div>
                                    <div class="address-tooltip">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                        </svg>
                                        <div class="address-tooltip-content">
                                            {{ __('In case we need to contact you about your order') }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="address-row">
                                <div class="address-col" id="email_parent">
                                    <label for="email">
                                        {{ __('Email') }} ({{ __('required') }})
                                    </label>
                                    <input id="email" name="email" type="text" class="form-control" ng-class="class('email')" ng-model="email" ng-change="change('email')" ng-blur="verifyEmail(); getCustomerInfo(); blurAction('email', email)">
                                    <div class="invalid-feedback" ng-if="hasError('email')" ng-bind-html="getErrorMsg('email')"> </div>
                                    <div class="address-tooltip">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                        </svg>
                                        <div class="address-tooltip-content">
                                            {{ __('We will update the status of your order via this email address') }}
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="common-title">
                                <span class="font-big font-bold mx-lg-5">{{ __('Shipping Address') }}</span>
                                <span ng-if="addressBook && addressBook.length">
                                    <button class="btn-open-fill-from-address-book" type="button" ng-click="openAddressBook()">
                                        {{ __('Fill from address book') }}
                                    </button>
                                </span>
                            </div>

                            <input class="gift-checkbox" id="gift-infomation" type="checkbox" ng-checked="gift.is_check" autocomplete="off" ng-click="openSendGift()">
                            <label class="gift-infomation" for="gift-infomation">
                                <small class="checkbox"></small>
                                <span class="gift-title">
                                    {{ __('Send to your friend') }}
                                </span>
                            </label>
                            <div class="gift-content">
                                <div class="address-row">
                                    <div class="address-col" id="sender-name">
                                        <label for="sender-name-input">
                                            {{ __("Recipient's full name") }}
                                        </label>
                                        <input id="sender-name-input" name="name" type="text" class="form-control"  ng-class="class('name', 'gift')" ng-model="gift.name" ng-change="change('name', 'gift')" autocomplete="off">
                                        <div class="invalid-feedback" ng-if="hasError('name', 'gift')" ng-bind="getErrorMsg('name', 'gift')"></div>
                                    </div>
                                    <div class="address-col" id="phone-gift-parent">
                                        <label for="sender-phone-input">
                                            {{ __("Recipient's phone") }}
                                        </label>
                                        <input id="sender-phone-input" name="phone" type="text" class="form-control" ng-class="class('phone', 'gift')" ng-model="gift.phone" ng-change="change('phone', 'gift')" autocomplete="off">
                                        <div class="invalid-feedback" ng-if="hasError('phone', 'gift')" ng-bind-html="getErrorMsg('phone', 'gift')"></div>
                                        <div class="address-tooltip">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                                <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                            </svg>
                                            <div class="address-tooltip-content">
                                                {{ __("If you're sending this order as a gift, we'll use this phone number to coordinate the delivery with the recipient and clarify any details if needed.") }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div ng-class="{ 'address-row' : true, 'custom-state' : shipingLocation.province && shipingLocation.province.id == -1 }" id="shipping-info-area">
                                <div class="address-col" ng-class="class('country')" style="z-index: 12" id="country_parent">
                                    <label for="country">
                                        {{ __('Country / Region') }}
                                    </label>
                                    <input autocomplete="off" class="input-text input-dropdown filter-country @{{ isShowSelectCountry ? 'selected' : '' }}" readonly value="@{{ shipingLocation.country.nicename }}" placeholder="{{ __('Select Country / Region')}}" type="text" ng-click="openSelectCountry()">
                                    <span class="js-close-search-filter" ng-click="closeSelectCountry()" ng-show="isShowSelectCountry">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                            <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                        </svg>
                                    </span>
                                    <div class="autocomplate-content content-select-country" ng-show="isShowSelectCountry">
                                        <div class="search">
                                            <input class="autocomplate-search filter-country input-text" placeholder="{{ __('Enter Country / Region to search')}}" type="text" value="" autocomplete="none">
                                        </div>
                                        <ul class="list-filter-item">
                                            <li class="search-filter-item" ng-repeat="item in countries" ng-click="selectCountry(item);">@{{ item.nicename }}</li>
                                        </ul>
                                    </div>

                                    <div class="invalid-feedback" ng-if="hasError('country')" ng-bind="getErrorMsg('country')"> </div>
                                    <div class="background-select-country" ng-show="isShowSelectCountry" ng-click="closeSelectCountry()"></div>
                                </div>
                            </div>
                            <div class="address-row address-suggestion flex-box flex-s flex-w">
                                <div class="address-col" id="address_parent">
                                    <label for="address">
                                        {{ __('Address') }}
                                    </label>
                                    <input id="address"
                                        type="text"
                                        class="form-control"
                                        ng-class="class('address')"
                                        ng-model="address"
                                        ng-change="change('address');"
                                        placeholder=""
                                        autocomplete="shipping street-address"
                                        ng-model-options="{ debounce: 500 }"
                                        ng-blur="blurAction('address', address)"
                                    >
                                    <div class="invalid-feedback" ng-if="hasError('address')" ng-bind="getErrorMsg('address')"> </div>
                                </div>
                            </div>
                            <div class="address-row flex-box flex-s flex-w">
                                <div class="address-col" id="optional_address_parent">
                                    <label for="optional-address">
                                        {{ __('Apartment, suite, etc. (optional)') }}
                                    </label>
                                    <input
                                        id="optional_address"
                                        name="optional_address"
                                        type="text"
                                        class="form-control"
                                        ng-class="class('optional_address')"
                                        placeholder=""
                                        autocomplete="none"
                                        ng-model="shipingLocation.optional_address"
                                        ng-change="change('optional_address')"
                                        ng-blur="blurAction('optional_address', shipingLocation.optional_address)"
                                    >
                                </div>
                            </div>
                            <div class="address-row flex-box flex-s flex-w">
                                <div class="address-col" ng-show="shipingLocation.country && shipingLocation.country.iso != 'VN'" id="city_name_parent">
                                    <label>
                                        {{ __('City / Suburb') }}
                                    </label>
                                    <input
                                        name="city_name"
                                        class="form-control"
                                        type="text"
                                        ng-class="class('city_name')"
                                        id="city_name"
                                        ng-model="shipingLocation.city_name"
                                        ng-change="change('city_name')"
                                        ng-blur="blurAction('city_name', shipingLocation.city_name)"
                                    />
                                    <div class="invalid-feedback" ng-if="hasError('city_name')" ng-bind="getErrorMsg('city_name')"> </div>
                                </div>
                                <div class="address-col" ng-class="class('province')" ng-show="shipingLocation.country && provinces && provinces.length > 0" id="province_parent">
                                    <label>
                                        {{ __('State / Province') }}
                                    </label>
                                    <input autocomplete="off" class="input-text input-dropdown filter-province @{{ isShowSelectProvince ? 'selected' : '' }}" readonly value="@{{ shipingLocation.province.name }}" placeholder="{{ __('State / Province')}}" type="text" ng-click="openSelectProvince()">
                                    <span class="js-close-search-filter" ng-click="closeSelectProvince()" ng-show="isShowSelectProvince">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                            <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                        </svg>
                                    </span>
                                    <div class="autocomplate-content content-select-country select-state" ng-show="isShowSelectProvince">
                                        <div class="search">
                                            <input class="autocomplate-search filter-province input-text" placeholder="{{ __('Enter to search')}}" type="text" value="" autocomplete="none">
                                        </div>
                                        <ul class="list-filter-item">
                                            <li class="search-filter-item" ng-repeat="item in provinces" ng-click="selectProvince(item);">@{{ item.name }}</li>
                                        </ul>
                                    </div>
                                    <div class="invalid-feedback" ng-if="hasError('province')" ng-bind="getErrorMsg('province')"> </div>
                                    <div class="background-select-province" ng-show="isShowSelectProvince" ng-click="closeSelectProvince()"></div>
                                </div>
                                <div class="address-col" ng-class="class('district')" ng-show="shipingLocation.province && districts && districts.length > 0" id="district_parent">
                                    <label>
                                        {{ __('District') }}
                                    </label>
                                    <input autocomplete="off" class="input-text input-dropdown filter-district @{{ isShowSelectDistrict ? 'selected' : '' }}" readonly name="" value="@{{ shipingLocation.district.name }}" placeholder="{{ __('District / Town') }}" type="text" ng-click="openSelectDistrict()">
                                    <span class="js-close-search-filter" ng-click="closeSelectDistrict()" ng-show="isShowSelectDistrict">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                            <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                                        </svg>
                                    </span>
                                    <div class="autocomplate-content content-select-country select-state" ng-show="isShowSelectDistrict">
                                        <div class="search">
                                            <input class="autocomplate-search filter-district input-text" placeholder="{{ __('Enter to search')}}" type="text" value="" autocomplete="none">
                                        </div>
                                        <ul class="list-filter-item">
                                            <li class="search-filter-item" ng-repeat="item in districts" ng-click="selectDistrict(item);">@{{ item.name }}</li>
                                        </ul>
                                    </div>
                                    <div class="invalid-feedback" ng-if="hasError('district')" ng-bind="getErrorMsg('district')"> </div>
                                    <div class="background-select-district" ng-show="isShowSelectDistrict" ng-click="closeSelectDistrict()"></div>
                                </div>
                                <div ng-class="{ 'address-col' : true, 'active' : shipingLocation.state_name != '' || isFocusStateName }" ng-show="shipingLocation.province && shipingLocation.province.id == -1" id="state_name_parent">
                                    <label>
                                        {{ __('Other State / Province') }}
                                    </label>
                                    <input
                                        name="state_name"
                                        class="form-control"
                                        type="text"
                                        ng-class="class('state_name')"
                                        id="state_name"
                                        ng-model="shipingLocation.state_name"
                                        ng-change="change('state_name')"
                                        ng-focus="changeFocusStateName(true)"
                                        ng-blur="changeFocusStateName(false); blurAction('state_name', shipingLocation.state_name)"
                                    />
                                    <div class="invalid-feedback" ng-if="hasError('state_name')" ng-bind="getErrorMsg('state_name')"> </div>
                                </div>
                                <div class="address-col" id="zipcode_parent">
                                    <label for="zipcode">
                                        {{ __('ZIP / Postal code') }}
                                    </label>
                                    <input
                                        id="zipcode"
                                        name="zipcode"
                                        type="text"
                                        class="form-control"
                                        ng-class="class('zipcode')"
                                        ng-model="shipingLocation.zipcode"
                                        ng-change="change('zipcode');"
                                        ng-blur="blurAction('zipcode', shipingLocation.zipcode)"
                                    >
                                    <div class="invalid-feedback" ng-if="hasError('zipcode')" ng-bind="getErrorMsg('zipcode')"> </div>
                                </div>
                            </div>
                            <div class="address-row flex-box flex-s flex-w">
                                <div class="address-col" id="delivery_note_parent">
                                    <label for="delivery_note">
                                        {{ __('Order notes (optional)') }}
                                    </label>
                                    <textarea
                                        id="delivery_note"
                                        name="delivery_note"
                                        type="text"
                                        class="form-control"
                                        ng-model="delivery_note"
                                        ng-change="change('delivery_note')"
                                        ng-blur="blurAction('delivery_note', delivery_note)"
                                    >
                                    </textarea>
                                    <div class="invalid-feedback" ng-if="hasError('delivery_note')" ng-bind="getErrorMsg('delivery_note')"> </div>
                                </div>
                            </div>

                            <!-- Billing -->
                            <div class="BillingAddressWrapper">
                                <div class="common-title">
                                    <span class="font-big font-bold mx-lg-5">{{ __('Billing address') }}</span>
                                </div>
                                <div ng-if="!isDiffirentBillingAddress">{{ __('Billing address matches shipping address')}}</div>
                                <div ng-if="isDiffirentBillingAddress">{{ __('Different billing address')}}</div>
                                <label class="toggleBillingAddress" for="toggleBillingAddress" ng-click="changeBillingAddress()">
                                    {{ __('Change')}}
                                </label>
                                <input id="toggleBillingAddress" type="checkbox">
                                <div class="billing-address-content">
                                    <div class="address-row">
                                        <div class="address-col" style="width: 100%">
                                            <label for="name">
                                                {{ __('Name') }}
                                            </label>
                                            <input id="billing-name" name="name" type="text" class="form-control" ng-model="billingAddress.name" ng-class="class('name', 'billing')" ng-change="change('name', 'billing')">
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>

                                    <div ng-class="{ 'address-row' : true, 'custom-state' : billingAddress.province && billingAddress.province.id == -1 }">
                                        <div class="address-col" ng-class="class('country', 'billing')">
                                            <label for="country">
                                                {{ __('Country / Region') }}
                                            </label>

                                            <ui-select ng-model="billingAddress.country" theme="select2" ng-disabled="!countries" title="{{ __('Select Country/Region') }}" style="width: 100%" ng-change="changeCountry('billing'); change('country', 'billing')">
                                                <ui-select-match>@{{$select.selected.nicename}}</ui-select-match>
                                                <ui-select-choices repeat="item in countries | filter: $select.search">
                                                    <div ng-bind-html="item.nicename | highlight: $select.search"></div>
                                                </ui-select-choices>
                                            </ui-select>

                                            <div class="invalid-feedback" ng-if="hasError('country', 'billing')" ng-bind="getErrorMsg('country', 'billing')"> </div>
                                        </div>
                                    </div>
                                    <div class="address-row flex-box flex-s flex-w">
                                        <div class="address-col">
                                            <label for="address">
                                                {{ __('Address') }}
                                            </label>
                                            <input id="billing-address" name="address" type="text" class="form-control" ng-class="class('address', 'billing')" placeholder="" autocomplete="none" ng-model="billingAddress.address" ng-change="change('address', 'billing')">
                                            <div class="invalid-feedback"> </div>
                                        </div>
                                    </div>
                                    <div class="address-row flex-box flex-s flex-w">
                                        <div class="address-col">
                                            <label for="billing-optional-address">
                                                {{ __('Apartment, suite, etc. (optional)') }}
                                            </label>
                                            <input id="billing-optional_address" name="billing-optional_address" type="text" class="form-control" ng-class="class('optional_address', 'billing')" placeholder="" autocomplete="none" ng-model="billingAddress.optional_address" ng-change="change('optional_address', 'billing')">
                                        </div>
                                    </div>
                                    <div class="address-row flex-box flex-s flex-w">
                                        <div class="address-col" ng-if="billingAddress.country">
                                            <label>
                                                {{ __('City / Suburb') }}
                                            </label>
                                            <input name="city_name" class="form-control" type="text" ng-class="class('city_name', 'billing')" id="billing-city_name" ng-model="billingAddress.city_name" ng-change="change('city_name', 'billing')"/>
                                            <div class="invalid-feedback"> </div>
                                        </div>
                                        <div class="address-col" ng-class="class('province', 'billing')" ng-if="billingAddress.country && provincesBillings && provincesBillings.length">
                                            <label>
                                                {{ __('State / Province') }}
                                            </label>
                                            <ui-select ng-model="billingAddress.province" ng-disabled="!provincesBillings || !provincesBillings.length" class="select-country" theme="select2" title="{{ __('Select Country/Region') }}" style="width: 100%" ng-change="changeProvince('billing'); change('province', 'billing')">
                                                <ui-select-match>@{{$select.selected.name}}</ui-select-match>
                                                <ui-select-choices repeat="item in provincesBillings | filter: $select.search">
                                                    <div ng-bind-html="item.name | highlight: $select.search"></div>
                                                </ui-select-choices>
                                            </ui-select>
                                            <div class="invalid-feedback" ng-if="hasError('province', 'billing')" ng-bind="getErrorMsg('province', 'billing')"> </div>
                                        </div>
                                        <div ng-class="{ 'address-col' : true, 'active' : billingAddress.state_name != '' || isFocusStateName }" ng-if="billingAddress.province && billingAddress.province.id == -1">
                                            <label>
                                                {{ __('Other State / Province') }}
                                            </label>
                                            <input name="state_name" class="form-control" type="text" ng-class="class('state_name', 'billing')" id="billing-state_name" ng-model="billingAddress.state_name" ng-change="change('state_name', 'billing')"/>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                        <div class="address-col">
                                            <label for="zipcode">
                                                {{ __('ZIP / Postal code') }}
                                            </label>
                                            <input id="billing-zipcode" name="zipcode" type="text" class="form-control" ng-class="class('zipcode', 'billing')" ng-model="billingAddress.zipcode" ng-change="change('zipcode', 'billing')">
                                            <div class="invalid-feedback"> </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="cart-list-product-box" ng-cloak>
                    <div class="common-title">
                        <span class="font-big font-bold mx-lg-5">{{ __('Order Review') }}</span>
                    </div>
                    <div ng-show="firstLoadingCart.is_show" class="loading-item-box">
                        <div class="form-shopcart checkout-item-box" ng-repeat="n in range(1, totalCartItem)">
                            <div class="shopcart-item shopcart-name">
                                <span class="shopcart-image">
                                    <span class="skeleton-box" style="width:100px; min-width: 100px; height: 100px"></span>
                                </span>
                                    <div class="shopcart-info" style="display: flex; flex-wrap: wrap;">
                                    <span class="skeleton-box" style="width:100%; margin-bottom: 3px"></span>
                                    <div style="display: flex;flex-direction: column;margin-top: 10px;">
                                        <span class="skeleton-box" style="width:80px; margin-bottom: 3px"></span>
                                        <span class="skeleton-box" style="width:60px;"></span>
                                    </div>
                                        <div style="display: flex; flex-direction: column; margin-top: 16px">
                                        <span class="skeleton-box" style="width: 160px;margin-bottom: 3px"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="order-item-shiping-method order-selected-shiping" style="border-color: #ddd; background-color: #f9f9f9; margin-top: 16px">
                            <div class="order-item-shiping-method-content flex-b flex-dc">
                            <div class="flex-b flex-s" style="width: 100%; margin-bottom: 10px">
                                    <span class="skeleton-box" style="width:70%"></span>
                                <span class="skeleton-box" style="width:12%;"></span>
                            </div>
                            <span class="skeleton-box" style="width:30%; margin-bottom: 10px;"></span>
                            <span class="skeleton-box" style="width:60%;"></span>
                            </div>
                        </div>
                    </div>
                    <div class="form-shopcart checkout-item-box @{{ loadingRemoveItem ? 'loading-remove-item' : ''}}" ng-repeat="shippingInfo in shippingInfos" ng-show="shippingInfos.length > 0 && !firstLoadingCart.is_show">
                        <div class="shopcart-row shopcart-content" ng-repeat='item in shippingInfo.cartItems'>
                            <div class="shopcart-item shopcart-name">
                                <span class="shopcart-image">
                                    <a target="_blank" class="shopcart-item-link" href="@{{ item.product_sku_id ? item.url + '?spid=' + item.product_sku_id : item.url }}">
                                        <img ng-src="@{{ getImageCdn(item.image_url, 540, 540, false) }}" alt="@{{ item.product_name }}" title="@{{ item.product_name }}" referrerpolicy="no-referrer">
                                    </a>
                                </span>
                                <div class="shopcart-info checkout-info">
                                    <a target="_blank" ng-bind-html="item.product_name | safeHtml" class="shopcart-item-link" href="@{{ item.product_sku_id ? item.url + '?spid=' + item.product_sku_id : item.url }}">
                                    </a>
                                    <div class="shopcart-configurations">
                                        <span class="config-item" ng-show="item.name_variant" style="display: block;">
                                            @{{ item.name_variant }}
                                        </span>
                                        <div class="config-item" ng-repeat="(key, value) in item.configurations">
                                            <div ng-if="key != 'print_location' && key != 'previewUrl' && key != 'buy_design' && key != 'design_fee'">
                                                @{{ key }}: @{{ value }}
                                            </div>
                                            <div ng-if="key == 'print_location' && getByField(printLocations, 'value', value)">
                                                {{ __('Print Location') }}: @{{ getByField(printLocations, 'value', value).name }}
                                            </div>
                                        </div>
                                        <div ng-if="item.preview_url">
                                            {{ __('Preview url') }}: <a href="@{{ item.preview_url }}" target="_blank">{{ __('View') }}</a>
                                        </div>
                                    </div>
                                    @if (Config::get('cart::sa.allow_update_checkout_item', true))
                                    <div class="flex-b align-c make-change-wrap" ng-hide="freeshipPackageProduct && freeshipPackageProduct.id == item.product_id">
                                        <span id="js-update-item" ng-hide="item.disable_make_change" ng-click="openFormChangeVariant(item)">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" ng-show="item.loadingMakeChange" viewBox="0 0 16 16" class="bi bi-arrow-repeat active">
                                                <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"></path>
                                                <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"></path>
                                            </svg>   
                                            <svg xmlns="http://www.w3.org/2000/svg" ng-show="!item.loadingMakeChange" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.com/svgjs" width="16" height="16" x="0" y="0" viewBox="0 0 512 511" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                                <g>
                                                    <path d="M405.332 256.484c-11.797 0-21.332 9.559-21.332 21.332v170.668c0 11.754-9.559 21.332-21.332 21.332H64c-11.777 0-21.332-9.578-21.332-21.332V149.816c0-11.754 9.555-21.332 21.332-21.332h170.668c11.797 0 21.332-9.558 21.332-21.332 0-11.777-9.535-21.336-21.332-21.336H64c-35.285 0-64 28.715-64 64v298.668c0 35.286 28.715 64 64 64h298.668c35.285 0 64-28.714 64-64V277.816c0-11.796-9.54-21.332-21.336-21.332zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                                                    <path d="M200.02 237.05a10.793 10.793 0 0 0-2.922 5.438l-15.082 75.438c-.703 3.496.406 7.101 2.922 9.64a10.673 10.673 0 0 0 7.554 3.114c.68 0 1.387-.063 2.09-.211l75.414-15.082c2.09-.43 3.988-1.43 5.461-2.926l168.79-168.79-75.415-75.41zM496.383 16.102c-20.797-20.801-54.633-20.801-75.414 0l-29.524 29.523 75.414 75.414 29.524-29.527C506.453 81.465 512 68.066 512 53.816s-5.547-27.648-15.617-37.714zm0 0" fill="#019adc" data-original="#000000" class=""></path>
                                                </g>
                                            </svg>
                                            {{ __('Edit')}}
                                        </span>
                                    </div>
                                    @endif
                                    <div class="shopcart-contain-checkout">
                                        <div class="shopcart-item shopcart-price primary-text shopcart-item-checkout" style="text-align: left">
                                            <span style="color: #C52C29; font-weight: 500;">
                                                @{{ formatPrice(item.price) }}
                                            </span>
                                            &times;
                                            <span>@{{item.quantity}}</span>
                                            <small ng-if="item.high_price && item.high_price > item.price" style="text-decoration: line-through; display: block;">
                                                @{{ formatPrice(item.high_price) }}
                                            </small>
                                        </div>
                                        <div class="shopcart-item shopcart-subtotal primary-text">
                                            @{{ formatPrice(item.total_amount, 0, false) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="order-shiping-method-wrapper" ng-show="shippingInfo.cartItems && shippingInfo.cartItems.length > 0">
                            <ul class="order-list-item-shiping-method" ng-hide="shippingInfo.selectedShipping.minTime == 0 && shippingInfo.selectedShipping.maxTime == 0">
                                <li class="order-item-shiping-method order-selected-shiping">
                                    <div class="order-item-shiping-method-content flex-b align-c flex-w">
                                        <div style="display: flex; width: 100%;">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="cart-truck" viewBox="0 0 16 16" style="width: 40px;">
                                                <path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h9A1.5 1.5 0 0 1 12 3.5V5h1.02a1.5 1.5 0 0 1 1.17.563l1.481 1.85a1.5 1.5 0 0 1 .329.938V10.5a1.5 1.5 0 0 1-1.5 1.5H14a2 2 0 1 1-4 0H5a2 2 0 1 1-3.998-.085A1.5 1.5 0 0 1 0 10.5v-7zm1.294 7.456A1.999 1.999 0 0 1 4.732 11h5.536a2.01 2.01 0 0 1 .732-.732V3.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .294.456zM12 10a2 2 0 0 1 1.732 1h.768a.5.5 0 0 0 .5-.5V8.35a.5.5 0 0 0-.11-.312l-1.48-1.85A.5.5 0 0 0 13.02 6H12v4zm-9 1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm9 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"/>
                                            </svg>
                                            <div class="flex-b align-c flex-w">

                                                <div class="shipping-information" style="display: flex; align-items: flex-start">

                                                    <span class="order-choose-item-method-shiping" ng-if="shippingInfo.selectedShipping.location">@{{ shippingFromText.replace("#type", shippingInfo.selectedShipping.name_shipping) }}</span>
                                                    <span class="order-choose-item-method-shiping" ng-if="!shippingInfo.selectedShipping.location">@{{ shippingText.replace("#type", shippingInfo.selectedShipping.name_shipping) }}</span>
                                                    @if ($shippingPolicyUrl != 'javascript:;')
                                                    <a class="flex-b address-tooltip shipping-policy-help" target="_blank" href="{{ $shippingPolicyUrl }}" style="margin: 4px 6px" onclick="event.stopPropagation();">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" viewBox="0 0 16 16">
                                                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"></path>
                                                        </svg>
                                                        <div class="address-tooltip-content" style="font-weight: 300; width: max-content; width: -moz-max-content">
                                                            {{ __('See more') }}
                                                        </div>
                                                    </a>
                                                    @endif

                                                </div>

                                                <span class="order-choose-item-method-price p-price-cart">@{{ formatPrice(shippingInfo.selectedShipping.shipping_fee, 0, false) }}</span>

                                                <div class="order-choose-item-method-time flex-b align-c">
                                                    @if ($useBusinessDay)
                                                        <!-- @{{ shippingInfo.selectedShipping.textMinBusinessDays }} - @{{ shippingInfo.selectedShipping.textMaxBusinessDays }} -->
                                                        @{{ shippingInfo.selectedShipping.textBusinessDays }}
                                                    @else
                                                        @{{ shippingInfo.selectedShipping.minDateString }} - @{{ shippingInfo.selectedShipping.maxDateString }}
                                                    @endif
                                                </div>

                                                <div class="order-choose-item-advantages">
                                                    <small ng-show="shippingInfo.selectedShipping.type == 'standard'">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-all" viewBox="0 0 16 16">
                                                            <path d="M8.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L2.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093L8.95 4.992a.252.252 0 0 1 .02-.022zm-.92 5.14.92.92a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 1 0-1.091-1.028L9.477 9.417l-.485-.486-.943 1.179z"></path>
                                                        </svg>
                                                        {{ __('Delivery date guaranteed') }}
                                                    </small>
                                                    <small ng-show="shippingInfo.selectedShipping.type != 'standard'">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-all" viewBox="0 0 16 16">
                                                            <path d="M8.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L2.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093L8.95 4.992a.252.252 0 0 1 .02-.022zm-.92 5.14.92.92a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 1 0-1.091-1.028L9.477 9.417l-.485-.486-.943 1.179z"></path>
                                                        </svg>
                                                        {{ __('Delivery date not guaranteed') }}
                                                    </small>
                                                    <small>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-all" viewBox="0 0 16 16">
                                                            <path d="M8.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L2.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093L8.95 4.992a.252.252 0 0 1 .02-.022zm-.92 5.14.92.92a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 1 0-1.091-1.028L9.477 9.417l-.485-.486-.943 1.179z"></path>
                                                        </svg>
                                                        {{ __('Tracking number') }}
                                                    </small>
                                                    <div class="checkout-buymore-product" ng-bind-html="shippingInfo.selectedShipping.freeShipping"></div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <small class="order-choose-item-method-icon"></small>
                                </li>
                                <li class="order-item-shiping-method order-choose-item-method @{{ shippingInfo.selectedShipping.id == shipping.id ? 'order-selected-item' : '' }}" ng-repeat="shipping in shippingInfo.shipping_info" ng-click="changeShippingType(shipping, shippingInfo)">
                                    <div class="order-item-shiping-method-content flex-b align-c flex-w">
                                        <span class="order-choose-item-method-shiping" ng-if="shipping.location">@{{ shippingFromText.replace("#type", shipping.name_shipping) }}</span>
                                        <span class="order-choose-item-method-shiping" ng-if="!shipping.location">@{{ shippingText.replace("#type", shipping.name_shipping) }}</span>
                                        <span class="order-choose-item-method-price p-price-cart">@{{ formatPrice(shipping.shipping_fee, 0, false) }}</span>
                                        @if ($useBusinessDay)
                                        <!-- <span class="order-choose-item-method-time">@{{ shipping.textMinBusinessDays }} - @{{ shipping.textMaxBusinessDays }}</span> -->
                                        <span class="order-choose-item-method-time">@{{ shipping.textBusinessDays }}</span>
                                        @else
                                        <span class="order-choose-item-method-time">@{{ shipping.minDateString }} - @{{ shipping.maxDateString }}</span>
                                        @endif
                                        <div class="order-choose-item-advantages">
                                            <small ng-show="shipping.type != 'premium' && shipping.type != 'express'">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-all" viewBox="0 0 16 16">
                                                    <path d="M8.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L2.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093L8.95 4.992a.252.252 0 0 1 .02-.022zm-.92 5.14.92.92a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 1 0-1.091-1.028L9.477 9.417l-.485-.486-.943 1.179z"></path>
                                                </svg>
                                                <span>{{ __('Delivery date guaranteed') }}</span>
                                            </small>
                                            <small ng-show="shipping.type == 'premium' || shipping.type == 'express'">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-all" viewBox="0 0 16 16">
                                                    <path d="M8.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L2.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093L8.95 4.992a.252.252 0 0 1 .02-.022zm-.92 5.14.92.92a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 1 0-1.091-1.028L9.477 9.417l-.485-.486-.943 1.179z"></path>
                                                </svg>
                                                <span>{{ __('Delivery date not guaranteed') }}</span>
                                            </small>
                                            <small>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check-all" viewBox="0 0 16 16">
                                                    <path d="M8.97 4.97a.75.75 0 0 1 1.07 1.05l-3.99 4.99a.75.75 0 0 1-1.08.02L2.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093L8.95 4.992a.252.252 0 0 1 .02-.022zm-.92 5.14.92.92a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 1 0-1.091-1.028L9.477 9.417l-.485-.486-.943 1.179z"></path>
                                                </svg>
                                                {{ __('Tracking number') }}
                                            </small>
                                            <small style="font-style: italic;" ng-show="shipping.type == 'premium' && false">
                                                *{{ __('It may take 1-2 days more than expected if the delivery date falls on a weekend') }}
                                            </small>
                                        </div>
                                    </div>
                                    <small class="order-choose-item-method-icon"></small>
                                </li>
                                <li class="order-item-shiping-method more-shiping order-selected-shiping" ng-show="shippingInfo.shipping_info.length > 1">
                                    <div class="order-item-shiping-method-content flex-b align-c flex-w">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="cart-truck" viewBox="0 0 16 16">
                                            <path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h9A1.5 1.5 0 0 1 12 3.5V5h1.02a1.5 1.5 0 0 1 1.17.563l1.481 1.85a1.5 1.5 0 0 1 .329.938V10.5a1.5 1.5 0 0 1-1.5 1.5H14a2 2 0 1 1-4 0H5a2 2 0 1 1-3.998-.085A1.5 1.5 0 0 1 0 10.5v-7zm1.294 7.456A1.999 1.999 0 0 1 4.732 11h5.536a2.01 2.01 0 0 1 .732-.732V3.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 .294.456zM12 10a2 2 0 0 1 1.732 1h.768a.5.5 0 0 0 .5-.5V8.35a.5.5 0 0 0-.11-.312l-1.48-1.85A.5.5 0 0 0 13.02 6H12v4zm-9 1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm9 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"/>
                                        </svg>
                                        <span>
                                            @{{ textMoreShippingType.replace('#number', shippingInfo.shipping_info.length - 1) }}
                                        </span>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="cart-sidebar" ng-cloak>
                <div class="sidebar-content">
                    <div class="shopcart-fixed-sidebar-container">

                        <div class="common-title">
                            <span class="font-big font-bold mx-lg-5">
                                {{ __('Order Summary') }}
                            </span>
                        </div>
                        <div class="shopcart-summary-container checkout-item-box order-summary">
                            <div class="summary-subtotal-container-wrap">
                                <div class="subtotal-item flex-box flex-s align-c">
                                    <span>{{ __('Subtotal') }}:</span>
                                    <span class="primary-text p-price-cart fw-500">@{{ formatPrice(cart.sub_total, 0, false) }}</span>
                                </div>
                                <div class="subtotal-item flex-box flex-s align-c" ng-show="discount" ng-if="discountType == 'normal'">
                                    <span>{{ __('Discount') }}:</span>
                                    <span class="primary-text p-price-cart fw-500">-@{{ formatPrice(discount, 0, false) }}</span>
                                </div>
                                <div class="subtotal-item flex-box flex-s align-c" ng-show="discount" ng-if="discountType == 'freeship' && customerRewards.rewards > 0">
                                    <span>{{ __('Discount') }}:</span>
                                    <span class="primary-text p-price-cart fw-500">-@{{ formatPrice(customerRewards.rewards, 0, false) }}</span>
                                </div>
                                <div class="subtotal-item flex-box flex-s align-c">
                                    <span class="flex-b align-c">
                                        {{ __('Shipping fee') }}:
                                    </span>
                                    <span class="primary-text p-price-cart fw-500" ng-if="discountType == 'normal'">@{{ (shipping_fee && shipping_fee > 0 ? '+' : '') + formatPrice(shipping_fee, 0, false) }}</span>
                                    <span class="primary-text p-price-cart fw-500" ng-if="discountType == 'freeship' && customerRewards.rewards == 0">@{{ (shipping_fee && discount && shipping_fee - discount > 0 ? '+' : '') + shipping_fee - discount > 0 ? formatPrice(shipping_fee - discount, 0, false) : formatPrice(0, 0, false) }}</span>
                                    <span class="primary-text p-price-cart fw-500" ng-if="discountType == 'freeship' && customerRewards.rewards > 0">@{{ (shipping_fee && discount && shipping_fee - discount + customerRewards.rewards > 0 ? '+' : '') + shipping_fee - discount + customerRewards.rewards > 0 ? formatPrice(shipping_fee - discount + customerRewards.rewards, 0, false) : formatPrice(0, 0, false) }}</span>
                                </div>

                                @if ($isShowTransactionFee)
                                <div class="subtotal-item flex-box flex-s align-c">
                                    <span class="flex-b align-c">
                                        {{ __('Handling fee') }}:
                                        <div class="address-tooltip address-tooltip-left">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                                <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                            </svg>
                                            <div class="address-tooltip-content">
                                                {{ __('Please be advised this is the fee you pay every time you process a transaction. This fee goes to the payment gateway and we do not own it.') }}
                                            </div>
                                        </div>
                                    </span>
                                    <span class="primary-text p-price-cart fw-500">@{{ (otherFee ? '+' : '') + formatPrice(otherFee, 0, false) }}</span>
                                </div>
                                @endif
                                <div class="subtotal-item flex-box flex-s align-c" ng-show="showTips">
                                    <span>{{ __('Tips') }}:</span>
                                    <span class="primary-text p-price-cart fw-500">@{{ (tipsAmount && tipsAmount > 0 ? '+' : '') + formatPrice(tipsAmount, 0, false) }}</span>
                                </div>
                                @if ($useTaxes)
                                <div class="subtotal-item flex-box flex-s align-c" ng-show="shipingLocation.country && shipingLocation.country.iso == 'US'">
                                    <span>{!! __('Taxes') !!}:</span>
                                    <span class="primary-text p-price-cart fw-500">@{{ calculateTaxFee() }}</span>
                                </div>
                                @endif
                                <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px">
                                    <span>{{ __('Paid amount') }}:</span>
                                    <span class="subtotal-price p-price-main primary-text">@{{ formatPrice(originOrder.amount, 0, false) }}</span>
                                </div>
                                <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px">
                                    <span>{{ __('Total') }}:</span>
                                    <span class="subtotal-price p-price-main primary-text">@{{ getCartAmount() }}</span>
                                </div>
                                <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px" ng-if="getCartAmount(false) > originOrder.amount">
                                    <span>{{ __('Total additional payment') }}:</span>
                                    <span class="subtotal-price p-price-main primary-text">@{{ formatPrice(getCartAmount(false) - originOrder.amount, 0, false) }}</span>
                                </div>
                                <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px" ng-if="getCartAmount(false) == originOrder.amount">
                                    <span>{{ __('Total additional payment') }}:</span>
                                    <span class="primary-text">{{ __('No extra charges.') }}</span>
                                </div>
                                <div class="subtotal-item flex-box flex-s align-c" style="margin-top: 10px" ng-if="getCartAmount(false) < originOrder.amount">
                                    <span>{{ __('Total refund') }}:</span>
                                    <span class="subtotal-price p-price-main primary-text">@{{ formatPrice(originOrder.amount - getCartAmount(false), 0, false) }}</span>
                                </div>
                            </div>
                            
                        </div>
                        
                        <div class="show-payment-loading" ng-class="{'loading-height': !isShowPaymentType}" ng-show="!isShowPaymentType">
                            <div class="payment-loading-title payment-loading-action" style="height: 30px;margin-bottom: 12px;margin-top: 12px;"></div>
                            <div class="payment-loading-box flex-b" style="gap: 5px">
                                <span class="payment-loading-action" style="height: 54px; width: 100px;"></span>
                                <span class="payment-loading-action" style="height: 54px; width: 100px;"></span>
                            </div>
                            <div class="payment-loading-note payment-loading-action" style="height: 21px;margin-top:10px;margin-bottom: 10px;"></div>
                            <div class="payment-loading-card flex-b align-s flex-s flex-w" style=" gap: 8px">
                                <span class="payment-loading-action" style="width: 100%; height: 52px;"></span>
                                <span class="payment-loading-action" style="width: 60%; height: 52px;"></span>
                                <span class="payment-loading-action" style="width: 37%"></span>
                            </div>
                        </div>
                        <div id="show-payment-type" ng-show="isShowPaymentType">			
                            <div class="common-title" >
                                <span class="font-big font-bold mx-lg-5">
                                    {{ __('Payment Methods') }}
                                </span>
                            </div>
                            <div class="shopcart-summary-container checkout-item-box payment-method" ng-show="getCartAmount(false) > originOrder.amount">
                                <div class="payment-method-button">
                                    @if ($useCOD)
                                        <div class="payment-method-item @{{ payment_type == 'cod' ? 'active' : '' }}">
                                            <input id="cod-method" type="radio" name="" ng-checked="payment_type == 'cod'" checked ng-click="changePayment('cod')" ng-disabled="loading">
                                            <label for="cod-method" class="input-radio title-btn flex-box">									
                                                <div class="input-content flex-box align-c flex-w">
                                                    <img src="{{ asset('modules/cart/images/cash-on-delivery.png') }}" height="20">	
                                                    <span class="title-payment-button">{{ __("Cash on delivery") }}</span>
                                                </div>
                                            </label>
                                        </div>
                                    @endif
                                    @if ($cardForm == 'stripe')
                                    <div class="payment-method-item @{{ payment_type == 'stripe' ? 'active' : '' }}">
                                        <input id="stripe-method" type="radio" ng-checked="payment_type == 'stripe'" checked ng-click="changePayment('stripe')" ng-disabled="loading">
                                        <label for="stripe-method" class="input-radio title-btn flex-box flex-w stripe-form-checkout">									
                                            <div class="input-content flex-box align-c flex-w">
                                                <img src="{{ asset('modules/cart/images/card2.svg') }}" height="20" widht="20">	
                                                <span class="title-payment-button">{{ __("Card") }}</span>
                                            </div>
                                        </label>
                                    </div>
                                    @elseif ($cardForm == 'paypal')
                                    <div class="payment-method-item @{{ payment_type == 'paypal_card' ? 'active' : '' }}">
                                        <input id="paypal-cart-method" type="radio" ng-checked="payment_type == 'paypal_card'" checked ng-click="changePayment('paypal_card')" ng-disabled="loading">
                                        <label for="paypal-cart-method" class="input-radio title-btn flex-box flex-w stripe-form-checkout">									
                                            <div class="input-content flex-box align-c flex-w">
                                                <img src="{{ asset('modules/cart/images/card2.svg') }}" height="20" widht="20">	
                                                <span class="title-payment-button">{{ __("Card") }}</span>
                                            </div>
                                        </label>
                                    </div>
                                    @endif

                                    <!-- useKlarna -->
                                    @if ($useKlarna)
                                        <div class="payment-method-item @{{ payment_type == 'klarna' ? 'active' : '' }}">
                                            <input id="klarna-method" type="radio" ng-checked="payment_type == 'klarna'" ng-click="changePayment('klarna')" ng-disabled="loading">
                                            <label for="klarna-method" class="input-radio title-btn flex-box">
                                                <div class="input-content flex-box align-c flex-w">
                                                    <img src="{{ asset('modules/cart/images/klarna2.svg') }}" height="20" widht="20">
                                                    <div class="title-payment-button">{{ __("Klarna") }}</div>
                                                </div>
                                            </label>
                                        </div>
                                    @endif

                                    <!-- useAfterpay -->
                                    @if ($useAfterpay)
                                        <div class="payment-method-item @{{ payment_type == 'afterpay' ? 'active' : '' }}">
                                            <input id="afterpay-method" type="radio" ng-checked="payment_type == 'afterpay'" ng-click="changePayment('afterpay')" ng-disabled="loading">
                                            <label for="afterpay-method" class="input-radio title-btn flex-box" ng-show="isShowAfterPay && shipingLocation.country && shipingLocation.country.iso == 'US'">									
                                                <div class="input-content flex-box align-c flex-w">										
                                                    <img src="{{ asset('modules/cart/images/afterpay2.png') }}" height="20" widht="20">
                                                    <img src="{{ asset('modules/cart/images/klarna2.svg') }}" height="20" widht="20">					
                                                    <img src="{{ asset('modules/cart/images/affirm.svg') }}" height="18"  widht="18" ng-show="getCartAmount(false) > 50">									
                                                    <div class="title-payment-button">{{ __("Buy now, pay later") }}</div>
                                                </div>
                                            </label>
                                        </div>							
                                    @endif
                                    
                                    <!-- usePaypal -->
                                    @if ($usePaypalByLimit && $usePaypal && $isValidPaypalByProduct)
                                        <div class="payment-method-item @{{ payment_type == 'paypal' ? 'active' : '' }}" ng-show="validPaypal">
                                            <input id="paypal-method" type="radio" ng-checked="payment_type == 'paypal'" ng-click="changePayment('paypal')" ng-disabled="loading">
                                            <label for="paypal-method" class="input-radio title-btn flex-box">
                                                <div class="input-content flex-box align-c flex-w">
                                                    <img src="{{ asset('modules/cart/images/paypal2.svg') }}" height="20" widht="20">
                                                    <div class="title-payment-button">{{ __("PayPal") }}</div>
                                                </div>
                                            </label>
                                        </div>								
                                    @endif

                                    <!-- useGiropay -->
                                    @if ($useGiropay)
                                        <div class="payment-method-item @{{ payment_type == 'giropay' ? 'active' : '' }}">
                                            <input id="giropay-method" type="radio" ng-checked="payment_type == 'giropay'" ng-click="changePayment('giropay')" ng-disabled="loading">
                                            <label for="giropay-method" class="input-radio title-btn flex-box">									
                                                <div class="input-content flex-box align-c flex-w">
                                                    <img src="{{ asset('modules/cart/images/giropay.png') }}" height="20" widht="20">
                                                    <div class="title-payment-button">{{ __("GiroPay") }}</div>
                                                </div>
                                            </label>
                                        </div>
                                        
                                    @endif

                                    <!-- useApplepay -->
                                    @if ($useApplepay)
                                        <div class="payment-method-item @{{ payment_type == 'apple_google' ? 'active' : '' }} @{{ validApplePay ? 'valid-apple' : '' }}" ng-show="validApplePay" style="display: none;">
                                            <input id="applepay-method" type="radio" ng-checked="payment_type == 'apple_google'" ng-click="changePayment('apple_google')" ng-disabled="loading">
                                            <label for="applepay-method" class="input-radio title-btn flex-box" id="label-applepay" ng-show="validApplePay">									
                                                <div class="input-content flex-box align-c flex-w">
                                                    <img ng-show="paymentGateway.isApplePay" src="{{ asset('modules/cart/images/apple-pay-logo.png?v=' . config('sa.version')) }}" height="20">
                                                    <img ng-show="paymentGateway.isGooglePay" src="{{ asset('modules/cart/images/google-pay-logo.png?v=' . config('sa.version')) }}" height="20" width="20">
                                                    <div ng-show="paymentGateway.isApplePay" class="title-payment-button">{{ __("Apple") }}</div>
                                                    <div ng-show="paymentGateway.isGooglePay" class="title-payment-button">{{ __("Google") }}</div>
                                                </div>
                                            </label>
                                        </div>								
                                    @endif
                                </div>
                                <div class="credit-form" id="cod-form" style="display: none;">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                        @if ($codFee > 0)
                                        <label for="cod-method">
                                            <small style="color: #ff7300; font-style:italic">(+<span>{{ $codFee }}%</span> {{ __('Handling fee') }})</small>
                                        </label>
                                        @elseif ($codFee == 0)
                                        <label for="cod-method">
                                            <small style="color: #ff7300; font-style:italic">({{ __('No handling fee!') }})</small>
                                        </label>
                                        @endif
                                    </div>
                                </div>
                                <div class="credit-form" id="klarna-form" style="display: none;">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                        @if ($klarnaFee > 0)
                                        <label for="klarna-method">
                                            <small style="color: #ff7300;"><span>{{ $klarnaFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($klarnaFee == 0)
                                        <label for="klarna-method">
                                            <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                        <div class="address-tooltip">
                                            <div class="address-tooltip-info">
                                                {{ $handlingFeeText }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="credit-form" id="afterpay-form">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp" ng-show="isShowAfterPay && shipingLocation.country && shipingLocation.country.iso == 'US'">
                                        @if ($afterpayFee > 0)
                                        <label for="afterpay-method">
                                            <small style="color: #ff7300;" class="show-note-payment">{{ __('May not be accepted by some locales or users. In this case please choose another payment method') }}</small>
                                            <small style="color: #ff7300;">Pay in 4 instalments of @{{ getAmountAfterPay() }}</small><br>
                                            <!-- <small style="color: #ff7300;"><span>{{ $afterpayFee }}%</span> {{ __('Handling fee') }}. </small> -->
                                        </label>
                                        @elseif ($afterpayFee == 0)
                                        <label for="afterpay-method">
                                            <small style="color: #ff7300;" class="show-note-payment">{{ __('May not be accepted by some locales or users. In this case please choose another payment method') }}</small>
                                            <!-- <small style="color: #ff7300;">{{ __('No handling fee!') }}</small> -->
                                        </label>
                                        @endif
                                        <div class="address-tooltip" style="display: none;">
                                            <div class="address-tooltip-info">
                                                {{ $handlingFeeText }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="credit-form" id="paypal-form" style="display: none;">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                        @if ($paypalFee > 0)
                                        <label for="paypal-method">
                                            <small style="color: #ff7300;"><span>{{ $paypalFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($paypalFee == 0)
                                        <label for="paypal-method">
                                            <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                        @if ($paypalFee > 0)
                                        <div class="address-tooltip">
                                            <div class="address-tooltip-info">
                                            {{ $handlingFeeText }}
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div> -->
                                <div class="credit-form" id="giropay-form" style="display: none;">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                        @if ($giropayFee > 0)
                                        <label for="giropay-method">
                                            <small style="color: #ff7300;"><span>{{ $giropayFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($giropayFee == 0)
                                        <label for="giropay-method">
                                            <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                        <div class="address-tooltip">
                                            <div class="address-tooltip-info">
                                                {{ $handlingFeeText }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="credit-form" id="apple-google-form" style="display: none;">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp" ng-show="validApplePay">
                                        @if ($applepayFee > 0)
                                        <label for="applepay-method">
                                            <small style="color: #ff7300;"><span>{{ $applepayFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($applepayFee == 0)
                                        <label for="applepay-method">
                                            <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                        <div class="address-tooltip">
                                            <div class="address-tooltip-info">
                                                {{ $handlingFeeText }}
                                            </div>
                                        </div>
                                    </div>
                                </div> -->
                                <div class="credit-form" id="paypal-card-form" style="display: <?= $cardForm == 'stripe' ? 'none' : 'block' ?>">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                        @if ($paypalFee > 0)
                                        <label for="paypal-cart-method">
                                            <small style="color: #ff7300;"><span>{{ $paypalFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($paypalFee == 0)
                                        <label for="paypal-cart-method">
                                            <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                        <div class="address-tooltip">
                                            <div class="address-tooltip-info">{{ $handlingFeeText }}</div>
                                        </div>
                                        <div class="flex-box align-c" style="margin-top: 5px;">
                                            <img src="{{ asset('modules/cart/images/visa.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/master-card.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/amex.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/jcb.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/discover.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/eftpos.png') }}" style="width: 34px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/unionpay.png') }}" style="width: 39px; margin-right: 4px;">
                                        </div>
                                    </div>
                                    <form id="card-form">
                                        <label for="card-number">Card Number</label>
                                        <div id="card-number" class="card_field"></div>
                                        <div style="display: flex; flex-direction: row; width: 100%;">
                                            <div style="width: 30%;">
                                                <label for="card-expiry">Expiration Date</label>
                                                <div id="card-expiry" class="card_field"></div>
                                            </div>
                                            <div style="padding-left: 10px; width:70%;">
                                                <label for="cvv">CVV</label>
                                                <div id="card-cvv" class="card_field"></div>
                                            </div>
                                        </div>				
                                        <div id="card-name" class="card_field"></div>
                                        <div id="paypal-card-errors" class="error invalid-feedback" role="alert">
                                            <span class="message">
                                                @{{ errorCard }}
                                            </span>
                                        </div>
                                    </form>
                                </div>
                                <div class="credit-form" id="payment-form" style="display: <?= $cardForm == 'stripe' ? 'block' : 'none' ?>;">
                                    <div class="flex-box align-c flex-w address-tooltip-wrapp">
                                        <!-- @if ($stripeFee > 0)
                                        <label for="stripe-method">
                                            <small style="color: #ff7300;"><span>{{ $stripeFee }}%</span> {{ __('Handling fee') }}</small>
                                        </label>
                                        @elseif ($stripeFee == 0)
                                        <label for="stripe-method">
                                            <small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
                                        </label>
                                        @endif
                                        <div class="address-tooltip">
                                            <div class="address-tooltip-info">{{ $handlingFeeText }}</div>
                                        </div> -->
                                        <div class="flex-box align-c" style="margin-top: 5px;">
                                            <img src="{{ asset('modules/cart/images/visa.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/master-card.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/amex.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/jcb.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/discover.png') }}" style="width: 35px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/eftpos.png') }}" style="width: 34px; margin-right: 4px;">
                                            <img src="{{ asset('modules/cart/images/unionpay.png') }}" style="width: 39px; margin-right: 4px;">
                                        </div>
                                    </div>
                                    <form class="">
                                        <div class="card-number">
                                            <label class="credit-label" for="">
                                                <span>{{ __('Card Number') }}</span>
                                                <div class="address-tooltip">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                                        <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                                    </svg>
                                                    <div class="address-tooltip-content">
                                                        {{ __("We don't store ANY of your card information.") }}
                                                    </div>
                                                </div>
                                            </label>
                                            <div id="credit-card-number" class="field empty credit-control"></div>
                                        </div>
                                        <div class="flex-b flex-s card-info">
                                            <div class="card-expire card-info-item">
                                                <label class="credit-label" for="">
                                                    <span>{{ __('Expiry date') }}</span>
                                                </label>
                                                <div id="credit-card-expiry" class="field empty third-width credit-control"></div>
                                            </div>
                                            <div class="card-cvc card-info-item">
                                                <label class="credit-label" for="">
                                                    <span>CVC</span>
                                                    <div class="address-tooltip">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
                                                        </svg>
                                                        <div class="address-tooltip-content">
                                                            {{ __('3-digit security code usually found on the back of your card. American Express cards have a 4-digit code located on the front.') }}
                                                        </div>
                                                    </div>
                                                </label>
                                                <div id="credit-card-cvc" class="field empty third-width credit-control"></div>
                                            </div>
                                        </div>
                                        <div id="credit-card-errors" class="error invalid-feedback" role="alert">
                                            <span class="message">
                                                @{{ errorCard }}
                                            </span>
                                        </div>
                                        <button type="submit" data-tid="elements_examples.form.pay_button" hidden class="hidden">{{ __('Submit Payment') }}</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div id="credit-card-errors" class="error-payment invalid-feedback" role="alert">
                            <span class="message">
                                @{{ errorPayment }}
                            </span>
                        </div>
                        <!-- #end show Payment type  -->

                        <div class="overflow-hidden shopcart-payment-btn-container">
                            <div class="shopcart-checkout-btn-container">
                                <a class="shopcart-checkout-btn disable-links" style="opacity: 0.5;" ng-if="loading">
                                    {{ __('Loading') }}<span>&nbsp</span><i class='fa fa-spinner fa-spin'></i>
                                </a>
                                <a class="shopcart-checkout-btn" ng-click="order()" ng-if="!loading">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-shield-check" viewBox="0 0 16 16" style="margin-right: 8px;">
                                        <path d="M5.338 1.59a61.44 61.44 0 0 0-2.837.856.481.481 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.725 10.725 0 0 0 2.287 2.233c.346.244.652.42.893.533.12.057.218.095.293.118a.55.55 0 0 0 .101.025.615.615 0 0 0 .1-.025c.076-.023.174-.061.294-.118.24-.113.547-.29.893-.533a10.726 10.726 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.775 11.775 0 0 1-2.517 2.453 7.159 7.159 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7.158 7.158 0 0 1-1.048-.625 11.777 11.777 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 62.456 62.456 0 0 1 5.072.56z"></path>
                                        <path d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z"></path>
                                    </svg>
                                    {{ __('Place Order Now') }}
                                </a>
                                <div id="express-checkout-element">
                                <!-- Express Checkout Element will be inserted here -->
                                </div>
                                <div id="error-message" style="color: red; margin-top: 5px;">
                                <!-- Display error message to your customers here -->
                                </div>
                                <div id="payment-request-button" style="margin: 12px 0;">
                                </div>
                                <button id="applePayButton" ng-show="modeCheckout == 'test'" style="display: none;">Pay with Apple Pay</button>
                            </div>
                            <div class="submit-a-ticket" style="margin-bottom: 10px;">
                                @php
                                    $supportStr = __('Having trouble? #submitATicket and we will get back to you!');
                                    $submitLink = '<a class="submit-a-ticket-link" style="color: #ec8700;" target="_blank" href="' . clroute('/contact/ticket/flow?mode=creating-an-issue-report') . '">' . __('Submit a ticket') . '</a>';
                                    $supportStr = str_replace('#submitATicket', $submitLink, $supportStr);
                                @endphp
                                {!! $supportStr !!}
                            </div>
                            @if ($isShowGuarantee && false)
                            <fieldset class="guaranteed-wrapper">
                                <!-- <legend>{!! __('Guaranteed <span style="color: #04eb04;">SAFE</span> Checkout') !!}</legend> -->
                                <div class="guaranteed-box">
                                    <img src="{{ asset('modules/cart/images/verify.webp?v=2025') }}" width="100">
                                    <img src="{{ asset('modules/cart/images/paypal-verify.webp?v=2025') }}" width="100">
                                    <img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
                                </div>
                            </fieldset>
                            @endif
                            @if (config("cart::sa.trustlock", true))
                            <fieldset class="guaranteed-wrapper">
                                <div class="guaranteed-box" style="padding: 8px;">
                                    <a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-business-TL-873835142792" class="trustlock-img">
                                        <img width="74" height="55" 
                                            src="{{ asset('modules/cart/images/business-trust-seal-trust-lock.webp?v=2025') }}"
                                            alt="">
                                    </a> 
                                    <a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-privacy-TL-873835142792" class="trustlock-img">
                                        <img width="74" height="55" 
                                            src="{{ asset('modules/cart/images/privacy-trust-seal-trust-lock.webp?v=2025') }}" 
                                            alt="">
                                    </a>        
                                    <a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-ssl-TL-873835142792" class="trustlock-img">
                                        <img width="74"
                                            height="55" 
                                            src="{{ asset('modules/cart/images/ssl-secure-trust-seal-trust-lock.webp?v=2025') }}"
                                            alt="">
                                    </a> 							
                                    <a href="{{ getOption('general.payment_method_url', 'payment-methods-n653.html') }}" class="link-guaranteed-img" target="_blank">				
                                        <img src="{{ asset('modules/cart/images/paypal-verify2.webp?v=2025') }}" width="100">
                                    </a>
                                    <a href="{{ getOption('general.payment_method_url', 'payment-methods-n653.html') }}" class="link-guaranteed-img" target="_blank">
                                        <img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
                                    </a>
                                </div>
                            </fieldset>
                            @else
                            <fieldset class="guaranteed-wrapper">
                                <!-- <legend>{!! __('Guaranteed <span style="color: #04eb04;">SAFE</span> Checkout') !!}</legend> -->
                                <div class="guaranteed-box guaranteed-box-not-strustlock">
                                    <img src="{{ asset('modules/cart/images/verify.webp?v=2025') }}" width="100">
                                    <img src="{{ asset('modules/cart/images/paypal-verify.webp?v=2025') }}" width="100">
                                    <img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
                                </div>
                            </fieldset>
                            @endif
                            <div style="margin-top: 18px; display: none;">
                                <ul class="flex-b align-c flex-s flex-w" style="
                                    list-style: none; padding-left: 0px; color: var(--primary); font-size: 13px;font-weight: 400;
                                ">
                                    <li>
                                        <a href="{{ clroute(getOption('general.refund_url', 'refund-policy-n650.html')) }}" target="_blank">
                                            {{ __('Refund policy') }}
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ clroute(getOption('general.return_url', 'returns-exchanges-policy-n651.html')) }}" target="_blank">
                                            {{__('Returns & Exchanges Policy')}}
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ clroute(getOption('general.shipping_url', 'shipping-delivery-n7.html')) }}" target="_blank">
                                            {{ __('Shipping policy') }}
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ clroute(getOption('general.privacy_url', 'privacy-policy-n13.html')) }}" target="_blank">
                                            {{__('Privacy policy')}}
                                        </a>
                                    </li>
                                    <li>
                                        <a href="{{ clroute(getOption('general.terms_service_url', 'terms-of-service-n5.html')) }}" target="_blank">
                                            {{__('Terms of service')}}
                                        </a>
                                    </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('cart::includes.make-change')

            <!-- Modal Pre-order -->
            <div id="preOrderModal" class="pre-order-modal" ng-show="showModalPreOrder">
                <div class="modal-preorder-content">
                    <div class="modal-preorder-close" ng-click="closePreOrderForm()">
                        <label>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                            </svg>
                        </label>
                    </div>
                    <div class="modal-wrapper">
                        <img src="{{ asset('modules/cart/images/payment-order.png') }}" alt="">
                        <div class="preorder-title">
                            {{ __('Are you having problems with the payment?') }}
                        </div>
                        <div class="preorder-title">
                            {{ __("Don't worry, you can pre-order and pay later. Our staff will get back to you.") }}
                        </div>
                        <div class="preorder-col">
                            <label for="preorder-note">
                                {{ __('Order notes (optional)') }}
                            </label>
                            <textarea
                                id="preorder_note"
                                name="preorder_note"
                                type="text"
                                class="form-control"
                                ng-model="preOrderNote"
                                ng-change="changePreOrderNote()"
                            >
                            </textarea>
                            <div class="invalid-feedback" ng-if="errorPreOrderNote" ng-bind="errorPreOrderNote"></div>
                        </div>	
                                    
                    </div>
                    <div class="modal-action">
                        <a class="preorder-checkout-btn btn disable-links" style="opacity: 0.5;" ng-show="loading">
                            {{ __('Loading') }}<span>&nbsp</span><i class='fa fa-spinner fa-spin'></i>
                        </a>
                        <div class="preorder-action">
                            <button class="btn preorder-accept" ng-show="!loading" ng-click="preOrder()" ng-disabled="loading">{{ __('OK Buy now, pay later') }}</button>
                            <button class="btn preoder-cancel" ng-show="!loading" ng-click="closePreOrderForm()" ng-disabled="loading">{{ __('No, Try again') }}</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="delete-item-wrapper" ng-show="showModalRemoveCartItem">
                <div class="delete-item-content">
                    <div class="delete-item-content-top">
                        <div class="delete-item-title">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#d2212b" class="bi bi-exclamation-triangle" viewBox="0 0 16 16">
                                <path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.15.15 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.2.2 0 0 1-.054.06.1.1 0 0 1-.066.017H1.146a.1.1 0 0 1-.066-.017.2.2 0 0 1-.054-.06.18.18 0 0 1 .002-.183L7.884 2.073a.15.15 0 0 1 .054-.057m1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767z"/>
                                <path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0M7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0z"/>
                            </svg>
                            <span>{{ __('Remove item') }}</span>
                            <span class="close-pop" ng-click="closeModalRemoveCartItem()">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                    <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
                                </svg>
                            </span>
                        </div>
                        <div class="delete-item-desc">{{ __('Are you sure you want to remove this item?') }}</div>
                        <div class="delete-item-action">
                            <a href="javascript:;" class="delete-item-action-cancel" ng-click="closeModalRemoveCartItem()">{{ __('Cancel') }}</a>
                            <a href="javascript:;" class="delete-item-action-delete" ng-click="removeCartItems(itemRemove)">{{ __('Remove') }}</a>
                        </div>
                    </div>
                    <div class="delete-item-content-bottom">
                        <div class="delete-item-title" ng-show="comments.length > 0">
                            <svg width="16" height="16" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                                <path fill="#FFB636" d="m252.5 381l-128 49c-5.9 2.2-12.1-2.3-11.8-8.6l7-136.9c.1-2.1-.6-4.2-1.9-5.9L31.6 172c-4-4.9-1.6-12.2 4.5-13.9l132.4-35.6c2.1-.6 3.9-1.9 5-3.7L248.3 4c3.4-5.3 11.2-5.3 14.6 0l74.8 114.9c1.2 1.8 3 3.1 5 3.7l132.4 35.6c6.1 1.6 8.5 9 4.5 13.9l-86.1 106.6c-1.3 1.7-2 3.8-1.9 5.9l7 136.9c.3 6.3-5.9 10.8-11.8 8.6l-128-49c-2.1-.8-4.3-.8-6.3-.1z"/>
                                <path fill="#FFD469" d="m456.1 51.7l-41-41c-1.2-1.2-2.8-1.7-4.4-1.5c-1.6.2-3.1 1.2-3.9 2.6l-42.3 83.3c-1.2 2.1-.8 4.6.9 6.3c1 1 2.4 1.5 3.7 1.5c.9 0 1.8-.2 2.6-.7L454.9 60c1.4-.8 2.4-2.2 2.6-3.9c.3-1.6-.3-3.2-1.4-4.4zm-307 43.5l-42.3-83.3c-.8-1.4-2.2-2.4-3.9-2.6c-1.6-.2-3.3.3-4.4 1.5l-41 41c-1.2 1.2-1.7 2.8-1.5 4.4c.2 1.6 1.2 3.1 2.6 3.9l83.3 42.3c.8.5 1.7.7 2.6.7c1.4 0 2.7-.5 3.7-1.5c1.7-1.8 2-4.4.9-6.4zm140.7 410l-29-88.8c-.2-.9-.7-1.7-1.3-2.3c-1-1-2.3-1.5-3.7-1.5c-2.4 0-4.4 1.6-5.1 3.9l-29 88.8c-.4 1.6-.1 3.3.9 4.6c1 1.3 2.5 2.1 4.2 2.1h57.9c1.6 0 3.2-.8 4.2-2.1c1.1-1.4 1.4-3.1.9-4.7z"/>
                            </svg>
                            <span>{{ __('Product Review Best Practices') }}</span>
                        </div>
                        <div class="cart-revew-slider" ng-show="comments.length > 0">
                            <div class="cart-review-item-list">
                                <div class="swiper-wrapper">
                                    <div class="cart-review-item-item swiper-slide" ng-repeat="comment in comments">
                                        <img class="cart-review-item-rate" src="{{ asset('modules/cart/images/star-list.svg') }}" height="14" height="78">
                                        <div class="cart-review-item-title">@{{ comment.name }}</div>
                                        <div class="cart-review-item-content">@{{ comment.content ? comment.content : comment.title }}</div>
                                    </div>
                                </div>
                                <div class="swiper-button-next cart-revew-next"></div>
                                <div class="swiper-button-prev cart-revew-prev"></div> 
                                <div class="swiper-pagination"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="delete-item-background" ng-click="closeModalRemoveCartItem()"></div>
            </div>
            <div class="popup-new-item-wrapper payment-fail-popup" ng-show="isShowPaymentFail">
                <div class="popup-new-item-content">
                    <div class="popup-new-item-content-top">
                        <div class="popup-new-item-title">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#d2212b" class="bi bi-exclamation-triangle" viewBox="0 0 16 16">
                                <path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.15.15 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.2.2 0 0 1-.054.06.1.1 0 0 1-.066.017H1.146a.1.1 0 0 1-.066-.017.2.2 0 0 1-.054-.06.18.18 0 0 1 .002-.183L7.884 2.073a.15.15 0 0 1 .054-.057m1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767z"/>
                                <path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0M7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0z"/>
                            </svg>
                            <span>{{ __('Payment failed') }}</span>
                            <span class="close-pop" ng-click="closePopupPaymentFail()">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                                    <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
                                </svg>
                            </span>
                        </div>
                        <div class="popup-new-item-desc">
                            <p>{{ __('The payment was unsuccessful due to an abnormality.') }}</p>
                            <p>{{ __('Please check your payment info or use a another payment method') }}</p>
                        </div>

                        <div class="popup-new-item-action">
                            <a href="javascript:;" class="popup-new-action-cancel" ng-click="closePopupPaymentFail()">{{ __('Try again') }}</a>
                            <a href="{{ clroute('/contact/ticket') }}" target="_blank" class="popup-new-action-delete">{{ __('Submit a ticket') }}</a>
                        </div>
                    </div>
                </div>
                <div class="popup-new-item-background" ng-click="closePopupPaymentFail()"></div></div>
            </div>
        </div>
	</div>
</div>

@endsection

@section('js')
	@parent
	<script>
		var mySwiper = new Swiper ('.cart-review-item-list', {
			loop: true,
			slidesPerView: 1,
			spaceBetween: 0,
			autoplay:  2500,
			navigation: {
				nextEl: ".cart-revew-next",
				prevEl: ".cart-revew-prev",
			}
		});
	</script>
	@view('checkout.checkout-script')
	@view('build-source')
@endsection
