@extends('layouts/master')
@section('title')
	{{ __('Checkout') }}
@endsection

@section('css')
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.13.2/themes/base/jquery-ui.min.css" integrity="sha512-ELV+xyi8IhEApPS/pSj66+Jiw+sOT1Mqkzlh8ExXihe4zfqbWkxPRi8wptXIO9g73FSlhmquFlUOuMSoXz5IRw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
	@mobile
		@view('checkout.checkout-css', ['isMobile' => true])
	@elsemobile
		@view('checkout.checkout-css', ['isMobile' => false])
	@endmobile
@endsection

@section('main')
<div id="cart-module-content" class="checkout-page">
	<div class="container-indent flex-box flex-w" ng-show="cart">
		@if(View::exists('inc.cart.checkout-header'))
			@include('inc.cart.checkout-header')
		@endif

		@mobile
			@view('checkout.content', ['isMobile' => true])
		@elsemobile
			@view('checkout.content', ['isMobile' => false])
		@endmobile
	</div>
</div>
@if(View::exists('inc.cart.checkout-footer'))
@endif
@view('checkout.tracking',['cartItems' => $cartItems])
@endsection

@section('js')
	@parent
@mobile
		@view('checkout.checkout-script', ['isMobile' => true])
	@elsemobile
		@view('checkout.checkout-script', ['isMobile' => false])
	@endmobile
	@view('build-source')
	<script>
		var mySwiper = new Swiper ('.cart-review-item-list', {
			loop: true,
			slidesPerView: 1,
			spaceBetween: 0,
			autoplay:  2500,
			navigation: {
				nextEl: ".cart-revew-next",
				prevEl: ".cart-revew-prev",
			}
		})
	</script>
@endsection
