@extends('layouts.master')

@section('css')

<link rel="stylesheet" href="{{ asset('modules/cart/css/timeline.css') }}?v={{ config('sa.version') }}">
<link rel="stylesheet" data-name="TrackOderCss" href="{{ asset('modules/cart/css/trackoder-css.css') }}?v={{ config('sa.version') }}">
<link rel="stylesheet" data-name="TrackOderCss" href="{{ asset('modules/cart/css/trackorder-optimize.css') }}?v={{ config('sa.version') }}">
<style>
    [ng\:cloak],
    [ng-cloak],
    [data-ng-cloak],
    [x-ng-cloak],
    .ng-cloak,
    .x-ng-cloak {
        visibility: hidden !important;
    }

</style>
@endsection
@php
    $priceConfig = getPriceConfig();
    $addPrice = 0;
    $ratio = 1;
    if ($priceConfig) {
        $addPrice = $priceConfig['adding_price'];
        $ratio = $priceConfig['ratio'];
    }
@endphp
@section('main')
    <div class="wrap site-w" id="track-order-pageContent" ng-app="trackOrder" ng-controller="TrackingOrderController" ng-cloak>
        <div id="track-order-content">
            <div class="track-order-form-wrap" ng-if="states.screen == 'inputForm'">
                <div class="track-image">
                    <img src="{{ getOption('general.track_order_img_url', getImageCdn('/modules/cart/images/track-order.png', 630, 0)) }}" width="315" height="315" alt="{{ __('Track order')}}">
                </div>            
                <form id="orderreport-form" ng-if="states.screen == 'inputForm'" ng-submit="submit()">
                    <h3>{{ __('TRACK YOUR ORDER') }}</h3>
                    <p>
                        {{ __('To track your order please enter your Order Code and email in the box below and press the Track button') }}
                    </p>

                    <div class="input-contain">
                        <div class="track-col">
                            <label for="email" class="tooltip">
                                <strong>{{ __('Billing Email') }}</strong>
                                <span class="tooltiptext tooltip-left">{{ __('Email used to place your order') }}</span>
                            </label>
                            <input type="email" id="email" name="email" ng-required="true" ng-model="data.email"
                                placeholder="{{ __('Enter the email used to place your order') }}"
                                value="{{ app('request')->input('email', '') }}" autocomplete="off" class="form-control"
                                tabindex="1">
                        </div>
                        <div class="track-col">
                            <label for="order-id">
                                <strong>{{ __('Order Code') }}</strong>
                                <a href="#" class="find-code-btn"
                                    onclick="openModal()"><small>{{ __('Where do I find this') }}?</small></a></label>
                            <input type="text" id="order-id" name="order-id" ng-required="true" ng-model="data.orderId"
                                placeholder="{{ __('Enter your Order code') }}"
                                value="{{ app('request')->input('order-code', '') }}" autocomplete="off" class="form-control"
                                tabindex="1">
                        </div>
                        <div class="track-col">
                            <button ng-if="!states.loading" class="button primary">{{ __('TRACK') }}</button>
                            <div ng-if="states.loading" class="loader"></div>
                        </div>
                    </div>
                    <span class="error-message" style="margin-top: 8px">@{{ states.message }}</span> 
                    <a ng-if="!states.loading" href="{{ clroute('/contact/ticket') }}" class="OpenASupport" target="_blank">
                        <small>{{ __('Open A Support Ticket') }}</small>
                    </a>
                    
                </form>
            </div>

            <div class="tracking-order-wrapper" ng-if="states.screen == 'result'">
                <div class="tracking-order-wrapper-content">
                    <div class="order-info-header">
                        <div class="info-left">
                            <div class="ordercode-and-btn">
                                <div class="order-code"> #@{{ trackdata.order.code }} </div>
                                <div class="request-cancel">
                                    <div class="header-summary-order">
                                        <a class="cancel-button button tooltip-cannot" ng-show="allowCancelStatuses.includes(trackdata.order.status)" ng-click="openFormCancelOrder()">
                                            {{ __('Request Cancellation')}}
                                            <span class="tooltiptext is-desktop" ng-show="trackdata.order.status == 'PENDING'">{{__('Your order is in production and cannot be automatically canceled. Please contact us for assistance.')}}</span>
                                            <span class="tooltiptext is-desktop" ng-show="trackdata.order.status == 'ISSUED' || trackdata.order.status == 'DELIVERING' || trackdata.order.status == 'READY_TO_SHIP'">{{__('Your order is being shipped and can no longer be canceled. Please kindly wait for its arrival.')}}</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <span class="tooltiptext is-mobile" ng-show="trackdata.order.status == 'PENDING'">{{__('Your order is in production and cannot be automatically canceled. Please contact us for assistance.')}}</span>
                            <span class="tooltiptext is-mobile" ng-show="trackdata.order.status == 'ISSUED' || trackdata.order.status == 'DELIVERING' || trackdata.order.status == 'READY_TO_SHIP'">{{__('Your order is being shipped and can no longer be canceled. Please kindly wait for its arrival.')}}</span>
                            <div class="order-datetime-payment">
                                <div class="payment-info"><span>{{__('Payment method')}}:</span> @{{ stripePayment.includes(trackdata.order.payment_type) ? "STRIPE" : paypalPayment.includes(trackdata.order.payment_type) ? "PAYPAL" : trackdata.order.payment_type }}</div>
                            </div>
                            
                        </div>
                        <div class="info-right">
                            <div class="total-amount-order">
                                @{{ formatPrice(trackdata.order.amount, 0, false) }}
                            </div>
                            <div class="order-status">
                                @{{ trackdata.status }}
                            </div>
    
                        </div>
                    </div>
                    <div class="order-expected-wrapper">
                        <div class="header">
                            <div class="payment-info title-trackorder-page">{{__('Shipping info')}}: @{{ trackdata.order.shipping_info }}</div>
                            <div class="order-expected-status">
                                @{{ orderExpectText.replace("#time", convertFromGMT7ToUTC(trackdata.order.created_at_origin, trackdata.order.shipping_max_time, true)) }}
                            </div>
                        </div>
                        <div class="order-expected-timeline">
                            <div class="stepper">
                                <div class="stepper-step stepper-step-finish" aria-label="Order Placed" tabindex="0">
                                    <div class="stepper-step-icon stepper-step-icon-finish">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="32" height="32" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve">
                                            <g>
                                                <path d="M495.914 189.604c-18.965-15.914-47.343-13.424-63.228 5.506l-42.695 50.523V99.129c0-12.279-5.106-24.17-14.008-32.625l-56.978-54.125C310.606 4.4 299.6.005 288.015.005H44.999C20.187.005 0 20.192 0 45.004v421.991c0 24.812 20.187 44.999 44.999 44.999h299.994c24.812 0 44.999-20.187 44.999-44.999v-81.961L501.46 253c15.987-19.052 13.509-47.408-5.546-63.396zM299.994 35.695c60.013 57.008 55.751 52.841 56.876 54.309h-56.876V35.695zm59.998 431.3c0 8.271-6.729 15-15 15H44.999c-8.271 0-15-6.729-15-15V45.004c0-8.271 6.729-15 15-15h224.995v74.998c0 8.284 6.716 15 15 15h74.998v161.129l-63.77 75.46a45.226 45.226 0 0 0-9.296 18.47l-13.94 58.356a14.999 14.999 0 0 0 20.555 17.248l55.05-23.862a45.226 45.226 0 0 0 11.401-7.151v47.343zm-35.677-97.168 22.978 19.28-5.11 6.052a15.057 15.057 0 0 1-5.523 4.12l-27.524 11.931 6.971-29.178a15.019 15.019 0 0 1 3.064-6.116l5.144-6.089zm42.329-3.643-22.967-19.271 82.91-98.11 22.919 19.231-82.862 98.15zm111.865-132.502-9.649 11.43-22.908-19.222 9.682-11.457c5.289-6.303 14.71-7.125 20.997-1.849 6.412 5.379 7.119 14.852 1.878 21.098z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                                <path d="M224.995 90.003H74.998c-8.284 0-15 6.716-15 15s6.716 15 15 15h149.997c8.284 0 15-6.716 15-15s-6.716-15-15-15zM314.993 181.001H74.998c-8.284 0-15 6.716-15 15s6.716 15 15 15h239.995c8.284 0 15-6.716 15-15s-6.716-15-15-15zM314.993 271H74.998c-8.284 0-15 6.716-15 15 0 8.284 6.716 15 15 15h239.995c8.284 0 15-6.716 15-15 0-8.285-6.716-15-15-15zM224.995 360.998H74.998c-8.284 0-15 6.716-15 15s6.716 15 15 15h149.997c8.284 0 15-6.716 15-15s-6.716-15-15-15z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="stepper-step-text">{{__('Order Placed')}}</div>
                                    <div class="stepper-step-date">@{{ convertFromGMT7ToUTC(trackdata.order.created_at_origin) }}</div>
                                </div>
                                <div class="stepper-step @{{ checkStatusShipping(trackdata.order, 'ISSUED', 'step') }}" aria-label="Packaging" tabindex="0">
                                    <div class="stepper-step-icon @{{ checkStatusShipping(trackdata.order, 'ISSUED') }}">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="32" height="32" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve">
                                            <g>
                                                <path d="M492.522 118.3 266.433 3.743l-.094-.047c-10.067-5.012-22.029-4.9-32.002.3L137.368 55.46c-.788.334-1.545.739-2.27 1.205L18.896 118.337C7.24 124.44 0 136.398 0 149.559V362.44c0 13.161 7.24 25.118 18.896 31.221l215.345 114.292.097.051a35.255 35.255 0 0 0 16.297 3.981 35.232 35.232 0 0 0 15.704-3.682l226.183-114.604C504.538 387.69 512 375.618 512 362.18V149.82c0-13.439-7.462-25.512-19.478-31.52zM248.237 30.569a5.26 5.26 0 0 1 4.705-.042l211.629 107.23-82.364 41.005L175.308 69.275l72.929-38.706zM235.424 474.63 32.91 367.147l-.097-.051a5.237 5.237 0 0 1-2.824-4.656V163.091l205.435 107.124V474.63zm15.153-230.335L46.272 137.76l97.024-51.493L349.171 195.21l-98.594 49.085zm231.432 117.883a5.22 5.22 0 0 1-2.911 4.703L265.414 475.152V270.408l98.386-48.982v51.355c0 8.281 6.714 14.995 14.995 14.995s14.995-6.714 14.995-14.995v-66.286l88.219-43.92v199.603z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="stepper-step-text">{{__('Packaging')}}</div>
                                    <div class="stepper-step-date">@{{ convertFromGMT7ToUTC(getStatusTime(trackdata.order, 'ISSUED')) }}</div>
                                </div>
                                <div class="stepper-step @{{ checkStatusShipping(trackdata.order, 'DELIVERING', 'step') }}" aria-label="On The Road" tabindex="0">
                                    <div class="stepper-step-icon @{{ checkStatusShipping(trackdata.order, 'DELIVERING') }}">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="32" height="32" x="0" y="0" viewBox="0 0 32 32" style="enable-background:new 0 0 512 512" xml:space="preserve" fill-rule="evenodd">
                                            <g transform="matrix(1.0999999999999999,0,0,1.0999999999999999,-1.6000000596046426,-1.5999999523162813)">
                                                <path d="M5.036 24H5a2.997 2.997 0 0 1-3-3V7a3 3 0 0 1 3-3h12a2.997 2.997 0 0 1 3 3v3h3.172a3 3 0 0 1 2.121.879l3.828 3.828A3 3 0 0 1 30 16.828V21a3 3 0 0 1-2.541 2.965A3.502 3.502 0 0 1 24 28 3.502 3.502 0 0 1 20.536 24h-8.572A3.502 3.502 0 0 1 8.5 28a3.502 3.502 0 0 1-3.464-4zm21.413-2H27a1 1 0 0 0 1-1v-4.172a.997.997 0 0 0-.293-.706l-3.828-3.83a1.002 1.002 0 0 0-.707-.292H20v10h1.551c.632-.619 1.496-1 2.449-1s1.817.381 2.449 1zm-15.5 0H18V7a1.002 1.002 0 0 0-1-1H5a1 1 0 0 0-1 1v14a1.002 1.002 0 0 0 1 1h1.051c.632-.619 1.496-1 2.449-1s1.817.381 2.449 1zm11.636 2a1.5 1.5 0 1 0 2.831 1 1.5 1.5 0 0 0-2.831-1zm-15.5 0a1.5 1.5 0 1 0 2.831 1 1.5 1.5 0 0 0-2.831-1z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="stepper-step-text">{{__('On The Road')}}</div>
                                    <div class="stepper-step-date">@{{ convertFromGMT7ToUTC(getStatusTime(trackdata.order, 'DELIVERING')) }}</div>
                                </div>
                                <div class="stepper-step @{{ checkStatusShipping(trackdata.order, 'FINISHED', 'step') }}" aria-label="Delivered" tabindex="0">
                                    <div class="stepper-step-icon @{{ checkStatusShipping(trackdata.order, 'FINISHED') }}">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="32" height="32" x="0" y="0" viewBox="0 0 32 32" style="enable-background:new 0 0 512 512" xml:space="preserve">
                                            <g>
                                                <g data-name="31-Delivered">
                                                    <path d="M24.29 19.29 21 22.59l-1.29-1.3a1 1 0 0 0-1.42 1.42l2 2a1 1 0 0 0 1.42 0l4-4a1 1 0 0 0-1.42-1.42z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                                    <path d="M22 14a8 8 0 1 0 8 8 8 8 0 0 0-8-8zm0 14a6 6 0 1 1 6-6 6 6 0 0 1-6 6z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                                    <path d="M26 2H6a4 4 0 0 0-4 4v20a4 4 0 0 0 4 4h8a1 1 0 0 0 0-2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h5v7a1 1 0 0 0 .62.92 1 1 0 0 0 1.09-.21l1.29-1.3 1.29 1.3a1 1 0 0 0 1.42 0l1.29-1.3 1.29 1.3A1 1 0 0 0 20 12a.84.84 0 0 0 .38-.08A1 1 0 0 0 21 11V4h5a2 2 0 0 1 2 2v8a1 1 0 0 0 2 0V6a4 4 0 0 0-4-4zm-7 6.59-.29-.3a1 1 0 0 0-1.42 0L16 9.59l-1.29-1.3a1 1 0 0 0-1.42 0l-.29.3V4h6z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="stepper-step-text">{{__('Delivered')}}</div>
                                    <div class="stepper-step-date">@{{ convertFromGMT7ToUTC(getStatusTime(trackdata.order, 'FINISHED')) }}</div>
                                </div>
                                <div class="stepper-line">
                                    <div class="stepper-line-background"></div>
                                    <div class="stepper-line-foreground" style="--percent:@{{ getPercentShipping(trackdata.order) }}%; "></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="order-activity-wrapper" ng-if="trackdata.order.timelines && trackdata.order.timelines.length">
                        <div class="title-activity title-trackorder-page">
                            {{__('Order Activity')}}
                        </div>
                        <div ng-if="trackdata.order.shipment_data" ng-repeat="shipment in trackdata.order.shipment_data" >
                            <div ng-if="shipment.shipper" class="name-company">{{__('Shipping Company')}}: <span>@{{ shipment.shipper.name }}</span></div>
                            <div class="shipping-code">{{__('Shipping Code')}}: 
                                <a href="@{{ shipment.url }}" target="__blank">
                                    @{{ shipment.code }}
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                        <g>
                                          <g data-name="ARROW 48">
                                            <path d="M487.84 272.85a24 24 0 0 0-24 24v96.61a70.46 70.46 0 0 1-70.38 70.38H118.54a70.46 70.46 0 0 1-70.38-70.38V118.54a70.46 70.46 0 0 1 70.38-70.38h96.61a24 24 0 1 0 0-48h-96.61A118.52 118.52 0 0 0 .16 118.54v274.92a118.52 118.52 0 0 0 118.38 118.38h274.92a118.52 118.52 0 0 0 118.38-118.38v-96.61a24 24 0 0 0-24-24z" fill="currentColor" opacity="1" data-original="#000000" class=""></path>
                                            <path d="M487.33 0h-149.2a24 24 0 0 0-24 23.53C313.88 37 325.21 48 338.67 48H430L238.86 239.2a24 24 0 0 0 0 33.94 24 24 0 0 0 33.94 0L464 82v91.66a24 24 0 0 0 48 0v-149A24.66 24.66 0 0 0 487.33 0z" fill="currentColor" opacity="1" data-original="#000000" class=""></path>
                                          </g>
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="list-activity @{{ trackdata.order.timelines.length > 6 ? 'list-activity-max-6' : '' }} @{{ trackdata.order.show_all_activity ? 'show-all' : '' }}">
                            <div class="item-activity @{{ getDeliverType(timeline.content) == 'delivered' ? 'item-success' : '' }}" ng-repeat="timeline in trackdata.order.timelines">
                                <div class="icon-activity">
                                    <img ng-if="getDeliverType(timeline.content) == 'delivered'" src="{{ asset('modules/cart/images/track-order/check.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24">
                                    <img ng-if="getDeliverType(timeline.content) == 'delivering'" src="{{ asset('modules/cart/images/track-order/user.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24">
                                    <img ng-if="getDeliverType(timeline.content) == 'arrived'" src="{{ asset('modules/cart/images/track-order/map.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24">
                                    <img ng-if="getDeliverType(timeline.content) == 'default'" src="{{ asset('modules/cart/images/track-order/map-trifold.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24">
                                    <!-- <img src="{{ asset('modules/cart/images/track-order/note.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24"> -->
                                </div>
                                <div class="desc-activity">
                                    <p class="title-activity-item">@{{ timeline.content }}</p>
                                    <p class="time-activity">@{{ convertGMT7toUTC(timeline.time) }}</p>
                                </div>
                            </div>
                            <div class="item-activity-see-all @{{ trackdata.order.timelines.length > 6 ? 'list-activity-max-6' : '' }}" ng-show="!trackdata.order.show_all_activity && trackdata.order.timelines.length > 6" ng-click="showAllActivity(trackdata.order)">
                                <div class="content-seeall-activity">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-three-dots" viewBox="0 0 16 16">
                                        <path d="M3 9.5a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3m5 0a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3m5 0a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3"/>
                                    </svg>
                                    <span>{{__('See all')}}</span>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                    <div class="order-products-wrapper">
                        <div class="title-product title-trackorder-page">
                            {{__('Products')}}
                            <span class="number">(@{{ trackdata.order.items.length }})</span>
                        </div>
                        <div class="list-products-order">
                            <div class="head-list-products">
                                <div class="name col-1">{{__('Product')}}</div>
                                <div class="price col-2">{{__('Price')}}</div>
                                <div class="quantity col-3">{{__('Quantity')}}</div>
                                <div class="sub-total col-4">{{__('Sub total')}}</div>
                            </div>
                            <div class="list-product-items">
                                <div class="item-list-product" ng-repeat="item in trackdata.order.items">
                                    <div class="name col-1">
                                        <a ng-href="@{{ item.url }}" title="@{{ item.name }}" class="product-link image-product">
                                            <img ng-src="@{{ item.image_url }}" alt="@{{ item.name }}" width="80" height="80">
                                        </a>
                                        <div class="product-info">
                                            <a ng-href="@{{ item.url }}" title="@{{ item.name }}" class="product-link name-product">
                                                @{{ item.name }}
                                            </a>
                                            <div class="p-location">
                                                <div class="config-item" ng-if="item.configurationsParse" ng-repeat="(key, value) in item.configurationsParse">
                                                    <div ng-if="key != 'print_location' && key != 'previewUrl' && key != 'buy_design' && key != 'design_fee'" style="font-weight: 400;">
                                                        <span class="font-weight:500;">@{{ key }}:</span> @{{ value }}
                                                    </div>
                                                    <div ng-if="key == 'print_location' && getByField(printLocations, 'value', value)">
                                                        {{ __('Print Location') }}: @{{ getByField(printLocations, 'value', value).name }}
                                                    </div>
                                                </div>
                                                <div ng-if="item.preview_url">
                                                    {{ __('Preview url') }}: <a href="@{{ item.preview_url }}" target="_blank">{{ __('View') }}</a>
                                                </div>
                                                <div ng-if="item.print_location_3d">
                                                    {{ __('Print Location') }}: @{{ item.print_location_3d }}
                                                </div>
                                            </div>
                                            <div class="p-design">
                                                <div ng-if="designByOrderItem[item.id]" style="font-weight: 400;" ng-repeat="(resolution, design) in designByOrderItem[item.id]">
                                                    <a href="@{{ replaceDownloadImage(design) }}" class="download-design-link" target="_blank" download>
                                                    <span>{{ __('Click here to download design file') }} <span ng-if="resolution.includes('x')">(@{{ resolution }})</span></span>
                                                        <div class="download-design-icon">
                                                            <img ng-src="@{{ design }}" alt="" referrerpolicy="no-referrer">
                                                            <svg class="question-circle" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"> 
                                                                <path d="M8 2a5.53 5.53 0 0 0-3.594 1.342c-.766.66-1.321 1.52-1.464 2.383C1.266 6.095 0 7.555 0 9.318 0 11.366 1.708 13 3.781 13h8.906C14.502 13 16 11.57 16 9.773c0-1.636-1.242-2.969-2.834-3.194C12.923 3.999 10.69 2 8 2zm2.354 6.854-2 2a.5.5 0 0 1-.708 0l-2-2a.5.5 0 1 1 .708-.708L7.5 9.293V5.5a.5.5 0 0 1 1 0v3.793l1.146-1.147a.5.5 0 0 1 .708.708z">
                                                                </path> 
                                                            </svg>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="price col-2">@{{ formatPrice(item.price, 0) }}</div>
                                    <div class="quantity col-3">x@{{ item.quantity }}</div>
                                    <div class="sub-total col-4 p-price-color">@{{ formatPrice(item.price * item.quantity, 0) }}</div>
                                </div>
                            </div>
                            <div class="order-product" ng-if="trackdata.order.shipping_fee">
                                <div class="product-sku-name">{{ __('Shipping fee') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(trackdata.order.shipping_fee, 0, false) }}</div>
                            </div>
    
                            <div class="order-product" ng-if="trackdata.order.other_fee && trackdata.order.other_fee > 0">
                                <div class="product-sku-name">{{ __('Other fee') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(trackdata.order.other_fee, 0, false) }}</div>
                            </div>
                            <div class="order-product" ng-if="trackdata.order.design_fee && trackdata.order.design_fee > 0">
                                <div class="product-sku-name">{{ __('Design fee') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(trackdata.order.design_fee, 0, false) }}</div>
                            </div>
                            <div class="order-product" ng-if="trackdata.order.tips > 0">
                                <div class="product-sku-name">{{ __('Tips') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(trackdata.order.tips, 0, false) }}</div>
                            </div>
                            <div class="order-product" ng-if="trackdata.order.tax > 0">
                                <div class="product-sku-name">{{ __('Taxes') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(trackdata.order.tax, 0, false) }}</div>
                            </div>
                            <div class="order-product" ng-if="trackdata.order.discount > 0">
                                <div class="product-sku-name">{{ __('Discount') }}</div>
                                <div class="product-order-value p-price-color">-@{{ formatPrice(trackdata.order.discount, 0, false) }}</div>
                            </div>
                            {{-- <div class="order-product">
                                <div class="product-sku-name">{{ __('Shipping info') }}</div>
                                <div class="product-order-value">@{{ trackdata.order.shipping_info }}</div>
                            </div> --}}
                            <div class="order-product">
                                <div class="product-sku-name">{{ __('Amount') }}</div>
                                <div class="product-order-value p-price-color p-price-color-total">@{{ formatPrice(trackdata.order.amount, 0, false) }}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tracking-order-wrapper-content" ng-if="trackdata.childOrder && trackdata.childOrder.length > 0" ng-repeat="childOrder in trackdata.childOrder">
                    <div class="title-related-shipment">
                        {{__('Related Shipment ')}} #@{{ trackdata.order.code }}
                    </div>
                    <div class="order-info-header">
                        <div class="info-left">
                            <div class="order-code">
                                #@{{ childOrder.code }}
                            </div>
                            <div class="order-datetime-payment">
                                <div class="payment-info"><span>{{__('Payment method')}}:</span> @{{ stripePayment.includes(trackdata.order.payment_type) ? "STRIPE" : paypalPayment.includes(trackdata.order.payment_type) ? "PAYPAL" : trackdata.order.payment_type }}</div>
                            </div>
                            
                        </div>
                        <div class="info-right">
                            <div class="total-amount-order">
                                @{{ formatPrice(childOrder.amount, 0, false) }}
                            </div>
                            <div class="order-status">
                                @{{ childOrder.order_status }}
                            </div>
                        </div>
                    </div>
                    <div class="order-expected-wrapper">
                        <div class="header">
                            <div class="payment-info title-trackorder-page">{{__('Shipping info')}}: @{{ childOrder.shipping_info }}</div>
                            <div class="order-expected-status">
                                @{{ orderExpectText.replace("#time", convertFromGMT7ToUTC(childOrder.created_at, childOrder.shipping_max_time, true)) }}
                            </div>
                        </div>
                        <div class="order-expected-timeline">
                            <div class="stepper">
                                <div class="stepper-step stepper-step-finish" aria-label="Order Placed" tabindex="0">
                                    <div class="stepper-step-icon stepper-step-icon-finish">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="32" height="32" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve">
                                            <g>
                                                <path d="M495.914 189.604c-18.965-15.914-47.343-13.424-63.228 5.506l-42.695 50.523V99.129c0-12.279-5.106-24.17-14.008-32.625l-56.978-54.125C310.606 4.4 299.6.005 288.015.005H44.999C20.187.005 0 20.192 0 45.004v421.991c0 24.812 20.187 44.999 44.999 44.999h299.994c24.812 0 44.999-20.187 44.999-44.999v-81.961L501.46 253c15.987-19.052 13.509-47.408-5.546-63.396zM299.994 35.695c60.013 57.008 55.751 52.841 56.876 54.309h-56.876V35.695zm59.998 431.3c0 8.271-6.729 15-15 15H44.999c-8.271 0-15-6.729-15-15V45.004c0-8.271 6.729-15 15-15h224.995v74.998c0 8.284 6.716 15 15 15h74.998v161.129l-63.77 75.46a45.226 45.226 0 0 0-9.296 18.47l-13.94 58.356a14.999 14.999 0 0 0 20.555 17.248l55.05-23.862a45.226 45.226 0 0 0 11.401-7.151v47.343zm-35.677-97.168 22.978 19.28-5.11 6.052a15.057 15.057 0 0 1-5.523 4.12l-27.524 11.931 6.971-29.178a15.019 15.019 0 0 1 3.064-6.116l5.144-6.089zm42.329-3.643-22.967-19.271 82.91-98.11 22.919 19.231-82.862 98.15zm111.865-132.502-9.649 11.43-22.908-19.222 9.682-11.457c5.289-6.303 14.71-7.125 20.997-1.849 6.412 5.379 7.119 14.852 1.878 21.098z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                                <path d="M224.995 90.003H74.998c-8.284 0-15 6.716-15 15s6.716 15 15 15h149.997c8.284 0 15-6.716 15-15s-6.716-15-15-15zM314.993 181.001H74.998c-8.284 0-15 6.716-15 15s6.716 15 15 15h239.995c8.284 0 15-6.716 15-15s-6.716-15-15-15zM314.993 271H74.998c-8.284 0-15 6.716-15 15 0 8.284 6.716 15 15 15h239.995c8.284 0 15-6.716 15-15 0-8.285-6.716-15-15-15zM224.995 360.998H74.998c-8.284 0-15 6.716-15 15s6.716 15 15 15h149.997c8.284 0 15-6.716 15-15s-6.716-15-15-15z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="stepper-step-text">{{__('Order Placed')}}</div>
                                    <div class="stepper-step-date">@{{ convertFromGMT7ToUTC(childOrder.created_at) }}</div>
                                </div>
                                <div class="stepper-step @{{ checkStatusShipping(childOrder, 'ISSUED', 'step') }}" aria-label="Packaging" tabindex="0">
                                    <div class="stepper-step-icon @{{ checkStatusShipping(childOrder, 'ISSUED') }}">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="32" height="32" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve">
                                            <g>
                                                <path d="M492.522 118.3 266.433 3.743l-.094-.047c-10.067-5.012-22.029-4.9-32.002.3L137.368 55.46c-.788.334-1.545.739-2.27 1.205L18.896 118.337C7.24 124.44 0 136.398 0 149.559V362.44c0 13.161 7.24 25.118 18.896 31.221l215.345 114.292.097.051a35.255 35.255 0 0 0 16.297 3.981 35.232 35.232 0 0 0 15.704-3.682l226.183-114.604C504.538 387.69 512 375.618 512 362.18V149.82c0-13.439-7.462-25.512-19.478-31.52zM248.237 30.569a5.26 5.26 0 0 1 4.705-.042l211.629 107.23-82.364 41.005L175.308 69.275l72.929-38.706zM235.424 474.63 32.91 367.147l-.097-.051a5.237 5.237 0 0 1-2.824-4.656V163.091l205.435 107.124V474.63zm15.153-230.335L46.272 137.76l97.024-51.493L349.171 195.21l-98.594 49.085zm231.432 117.883a5.22 5.22 0 0 1-2.911 4.703L265.414 475.152V270.408l98.386-48.982v51.355c0 8.281 6.714 14.995 14.995 14.995s14.995-6.714 14.995-14.995v-66.286l88.219-43.92v199.603z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="stepper-step-text">{{__('Packaging')}}</div>
                                    <div class="stepper-step-date">@{{ convertFromGMT7ToUTC(getStatusTime(childOrder, 'ISSUED')) }}</div>
                                </div>
                                <div class="stepper-step @{{ checkStatusShipping(childOrder, 'DELIVERING', 'step') }}" aria-label="On The Road" tabindex="0">
                                    <div class="stepper-step-icon @{{ checkStatusShipping(childOrder, 'DELIVERING') }}">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="32" height="32" x="0" y="0" viewBox="0 0 32 32" style="enable-background:new 0 0 512 512" xml:space="preserve" fill-rule="evenodd">
                                            <g transform="matrix(1.0999999999999999,0,0,1.0999999999999999,-1.6000000596046426,-1.5999999523162813)">
                                                <path d="M5.036 24H5a2.997 2.997 0 0 1-3-3V7a3 3 0 0 1 3-3h12a2.997 2.997 0 0 1 3 3v3h3.172a3 3 0 0 1 2.121.879l3.828 3.828A3 3 0 0 1 30 16.828V21a3 3 0 0 1-2.541 2.965A3.502 3.502 0 0 1 24 28 3.502 3.502 0 0 1 20.536 24h-8.572A3.502 3.502 0 0 1 8.5 28a3.502 3.502 0 0 1-3.464-4zm21.413-2H27a1 1 0 0 0 1-1v-4.172a.997.997 0 0 0-.293-.706l-3.828-3.83a1.002 1.002 0 0 0-.707-.292H20v10h1.551c.632-.619 1.496-1 2.449-1s1.817.381 2.449 1zm-15.5 0H18V7a1.002 1.002 0 0 0-1-1H5a1 1 0 0 0-1 1v14a1.002 1.002 0 0 0 1 1h1.051c.632-.619 1.496-1 2.449-1s1.817.381 2.449 1zm11.636 2a1.5 1.5 0 1 0 2.831 1 1.5 1.5 0 0 0-2.831-1zm-15.5 0a1.5 1.5 0 1 0 2.831 1 1.5 1.5 0 0 0-2.831-1z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="stepper-step-text">{{__('On The Road')}}</div>
                                    <div class="stepper-step-date">@{{ convertFromGMT7ToUTC(getStatusTime(childOrder, 'DELIVERING')) }}</div>
                                </div>
                                <div class="stepper-step @{{ checkStatusShipping(childOrder, 'FINISHED', 'step') }}" aria-label="Delivered" tabindex="0">
                                    <div class="stepper-step-icon @{{ checkStatusShipping(childOrder, 'FINISHED') }}">
                                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="32" height="32" x="0" y="0" viewBox="0 0 32 32" style="enable-background:new 0 0 512 512" xml:space="preserve">
                                            <g>
                                                <g data-name="31-Delivered">
                                                    <path d="M24.29 19.29 21 22.59l-1.29-1.3a1 1 0 0 0-1.42 1.42l2 2a1 1 0 0 0 1.42 0l4-4a1 1 0 0 0-1.42-1.42z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                                    <path d="M22 14a8 8 0 1 0 8 8 8 8 0 0 0-8-8zm0 14a6 6 0 1 1 6-6 6 6 0 0 1-6 6z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                                    <path d="M26 2H6a4 4 0 0 0-4 4v20a4 4 0 0 0 4 4h8a1 1 0 0 0 0-2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h5v7a1 1 0 0 0 .62.92 1 1 0 0 0 1.09-.21l1.29-1.3 1.29 1.3a1 1 0 0 0 1.42 0l1.29-1.3 1.29 1.3A1 1 0 0 0 20 12a.84.84 0 0 0 .38-.08A1 1 0 0 0 21 11V4h5a2 2 0 0 1 2 2v8a1 1 0 0 0 2 0V6a4 4 0 0 0-4-4zm-7 6.59-.29-.3a1 1 0 0 0-1.42 0L16 9.59l-1.29-1.3a1 1 0 0 0-1.42 0l-.29.3V4h6z" fill="curentColor" opacity="1" data-original="#000000"></path>
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="stepper-step-text">{{__('Delivered')}}</div>
                                    <div class="stepper-step-date">@{{ convertFromGMT7ToUTC(getStatusTime(childOrder, 'FINISHED')) }}</div>
                                </div>
                                <div class="stepper-line">
                                    <div class="stepper-line-background"></div>
                                    <div class="stepper-line-foreground" style="--percent:@{{ getPercentShipping(childOrder) }}%; "></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="order-activity-wrapper" ng-if="childOrder.timelines && childOrder.timelines.length">
                        <div class="title-activity title-trackorder-page">
                            {{__('Order Activity')}}
                        </div>
                        <div ng-if="childOrder.shipment_data" ng-repeat="shipment in childOrder.shipment_data" >
                            <div ng-if="shipment.shipper" class="name-company">{{__('Shipping Company')}}: <span>@{{ shipment.shipper.name }}</span></div>
                            <div class="shipping-code">
                                {{__('Shipping Code')}}: 
                                <a href="@{{ shipment.url }}" target="__blank">
                                    @{{ shipment.code }}
                                    <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                                        <g>
                                          <g data-name="ARROW 48">
                                            <path d="M487.84 272.85a24 24 0 0 0-24 24v96.61a70.46 70.46 0 0 1-70.38 70.38H118.54a70.46 70.46 0 0 1-70.38-70.38V118.54a70.46 70.46 0 0 1 70.38-70.38h96.61a24 24 0 1 0 0-48h-96.61A118.52 118.52 0 0 0 .16 118.54v274.92a118.52 118.52 0 0 0 118.38 118.38h274.92a118.52 118.52 0 0 0 118.38-118.38v-96.61a24 24 0 0 0-24-24z" fill="currentColor" opacity="1" data-original="#000000" class=""></path>
                                            <path d="M487.33 0h-149.2a24 24 0 0 0-24 23.53C313.88 37 325.21 48 338.67 48H430L238.86 239.2a24 24 0 0 0 0 33.94 24 24 0 0 0 33.94 0L464 82v91.66a24 24 0 0 0 48 0v-149A24.66 24.66 0 0 0 487.33 0z" fill="currentColor" opacity="1" data-original="#000000" class=""></path>
                                          </g>
                                        </g>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="list-activity @{{ childOrder.timelines.length > 6 ? 'list-activity-max-6' : '' }} @{{ childOrder.show_all_activity ? 'show-all' : '' }}">
                            <div class="item-activity @{{ getDeliverType(timeline.content) == 'delivered' ? 'item-success' : '' }}" ng-repeat="timeline in childOrder.timelines">
                                <div class="icon-activity">
                                    <img ng-if="getDeliverType(timeline.content) == 'delivered'" src="{{ asset('modules/cart/images/track-order/check.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24">
                                    <img ng-if="getDeliverType(timeline.content) == 'delivering'" src="{{ asset('modules/cart/images/track-order/user.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24">
                                    <img ng-if="getDeliverType(timeline.content) == 'arrived'" src="{{ asset('modules/cart/images/track-order/map.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24">
                                    <img ng-if="getDeliverType(timeline.content) == 'default'" src="{{ asset('modules/cart/images/track-order/map-trifold.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24">
                                    <!-- <img src="{{ asset('modules/cart/images/track-order/note.svg?v=' . config('sa.version')) }}" alt="" width="24" height="24"> -->
                                </div>
                                <div class="desc-activity">
                                    <p class="title-activity-item">@{{ timeline.content }}</p>
                                    <p class="time-activity">@{{ convertGMT7toUTC(timeline.time) }}</p>
                                </div>
                            </div>
                            <div class="item-activity-see-all @{{ childOrder.timelines.length > 6 ? 'list-activity-max-6' : '' }}" ng-show="!childOrder.show_all_activity && childOrder.timelines.length > 6" ng-click="showAllActivity(childOrder)">
                                <div class="content-seeall-activity">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-three-dots" viewBox="0 0 16 16">
                                        <path d="M3 9.5a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3m5 0a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3m5 0a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3"/>
                                    </svg>
                                    <span>{{__('See all')}}</span>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                    <div class="order-products-wrapper">
                        <div class="title-product title-trackorder-page">
                            {{__('Products')}}
                            <span class="number">(@{{ childOrder.items.length }})</span>
                        </div>
                        <div class="list-products-order">
                            <div class="head-list-products">
                                <div class="name col-1">{{__('Product')}}</div>
                                <div class="price col-2">{{__('Price')}}</div>
                                <div class="quantity col-3">{{__('Quantity')}}</div>
                                <div class="sub-total col-4">{{__('Sub total')}}</div>
                            </div>
                            <div class="list-product-items">
                                <div class="item-list-product" ng-repeat="item in childOrder.items">
                                    <div class="name col-1">
                                        <a ng-href="@{{ item.url }}" title="@{{ item.name }}" class="product-link image-product">
                                            <img ng-src="@{{ item.image_url }}" alt="@{{ item.name }}" width="80" height="80">
                                        </a>
                                        <div class="product-info">
                                            <a ng-href="@{{ item.url }}" title="@{{ item.name }}" class="product-link name-product">
                                                @{{ item.name }}
                                            </a>
                                            <div class="p-location">
                                                <div class="config-item" ng-if="item.configurationsParse" ng-repeat="(key, value) in item.configurationsParse">
                                                    <div ng-if="key != 'print_location' && key != 'previewUrl' && key != 'buy_design' && key != 'design_fee'" style="font-weight: 400;">
                                                        <span class="font-weight:500;">@{{ key }}:</span> @{{ value }}
                                                    </div>
                                                    <div ng-if="key == 'print_location' && getByField(printLocations, 'value', value)">
                                                        {{ __('Print Location') }}: @{{ getByField(printLocations, 'value', value).name }}
                                                    </div>
                                                </div>
                                                <div ng-if="item.preview_url">
                                                    {{ __('Preview url') }}: <a href="@{{ item.preview_url }}" target="_blank">{{ __('View') }}</a>
                                                </div>
                                                <div ng-if="item.print_location_3d">
                                                    {{ __('Print Location') }}: @{{ item.print_location_3d }}
                                                </div>
                                            </div>
                                            <div class="p-design">
                                                <div ng-if="designByOrderItem[item.id]" style="font-weight: 400;" ng-repeat="(resolution, design) in designByOrderItem[item.id]">
                                                    <a href="@{{ replaceDownloadImage(design) }}" class="download-design-link" target="_blank" download>
                                                    <span>{{ __('Click here to download design file') }} <span ng-if="resolution.includes('x')">(@{{ resolution }})</span></span>
                                                        <div class="download-design-icon">
                                                            <img ng-src="@{{ design }}" alt="" referrerpolicy="no-referrer">
                                                            <svg class="question-circle" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"> 
                                                                <path d="M8 2a5.53 5.53 0 0 0-3.594 1.342c-.766.66-1.321 1.52-1.464 2.383C1.266 6.095 0 7.555 0 9.318 0 11.366 1.708 13 3.781 13h8.906C14.502 13 16 11.57 16 9.773c0-1.636-1.242-2.969-2.834-3.194C12.923 3.999 10.69 2 8 2zm2.354 6.854-2 2a.5.5 0 0 1-.708 0l-2-2a.5.5 0 1 1 .708-.708L7.5 9.293V5.5a.5.5 0 0 1 1 0v3.793l1.146-1.147a.5.5 0 0 1 .708.708z">
                                                                </path> 
                                                            </svg>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="price col-2">@{{ formatPrice(item.price, 0) }}</div>
                                    <div class="quantity col-3">x@{{ item.quantity }}</div>
                                    <div class="sub-total col-4 p-price-color">@{{ formatPrice(item.price * item.quantity, 0) }}</div>
                                </div>
                            </div>
                            <div class="order-product" ng-if="childOrder.shipping_fee">
                                <div class="product-sku-name">{{ __('Shipping fee') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(childOrder.shipping_fee, 0, false) }}</div>
                            </div>
    
                            <div class="order-product" ng-if="childOrder.other_fee && childOrder.other_fee > 0">
                                <div class="product-sku-name">{{ __('Other fee') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(childOrder.other_fee, 0, false) }}</div>
                            </div>
                            <div class="order-product" ng-if="childOrder.design_fee && childOrder.design_fee > 0">
                                <div class="product-sku-name">{{ __('Design fee') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(childOrder.design_fee, 0, false) }}</div>
                            </div>
                            <div class="order-product" ng-if="childOrder.tips > 0">
                                <div class="product-sku-name">{{ __('Tips') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(childOrder.tips, 0, false) }}</div>
                            </div>
                            <div class="order-product" ng-if="childOrder.tax > 0">
                                <div class="product-sku-name">{{ __('Taxes') }}</div>
                                <div class="product-order-value p-price-color">@{{ formatPrice(childOrder.tax, 0, false) }}</div>
                            </div>
                            <div class="order-product" ng-if="childOrder.discount > 0">
                                <div class="product-sku-name">{{ __('Discount') }}</div>
                                <div class="product-order-value p-price-color">-@{{ formatPrice(childOrder.discount, 0, false) }}</div>
                            </div>
                            {{-- <div class="order-product">
                                <div class="product-sku-name">{{ __('Shipping info') }}</div>
                                <div class="product-order-value">@{{ childOrder.shipping_info }}</div>
                            </div> --}}
                            <div class="order-product">
                                <div class="product-sku-name">{{ __('Amount') }}</div>
                                <div class="product-order-value p-price-color p-price-color-total">@{{ formatPrice(childOrder.amount, 0, false) }}</div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="order-info-wrapper">
                    <div class="billing-address-wrapper">
                        <div class="title-product title-trackorder-page">
                            {{__('Billing Address')}}
                            <div class="address-tooltip">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
                                    <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"></path>
                                </svg>
                                <div class="address-tooltip-content"> {{__('Billing address cannot be changed and does not affect the delivery process.')}}</div>
                            </div>
                        </div>
                        <div class="group-info">
                            <span class="name"><b>{{__('Full Name')}}:</b> @{{ trackdata.order.attributes.customer_info.full_name }}</span>
                            <span class="email"><b>{{__('Email')}}:</b> @{{ trackdata.order.attributes.customer_info.email }}</span>
                            <span class="phone"><b>{{__('Phone Number')}}:</b> @{{ trackdata.order.attributes.customer_info.phone }}</span>
                            <span class="location"><b>{{__('Location')}}:</b> @{{ getBillingLocation(trackdata) }}</span>
                            <span class="address"><b>{{ __('Address') }}:</b> @{{ trackdata.order.billingAddress.address }}</span>
                            <span class="zipcode"><b>{{__('Zipcode')}}:</b> @{{ trackdata.order.billingAddress.zip_code }}</span>
                        </div>
                    </div>
                    <div class="shipping-address-wrapper">
                        <div class="title-product title-trackorder-page">
                            {{__('Shipping Address')}}
                        </div>
                        <div class="group-info">
                            <span class="name"><b>{{__('Full Name')}}:</b> @{{ trackdata.order.attributes.gift_info && trackdata.order.attributes.gift_info.name ? trackdata.order.attributes.gift_info.name : trackdata.order.attributes.customer_info.full_name }}</span>
                            <span class="phone"><b>{{__('Phone Number')}}:</b> @{{ trackdata.order.attributes.gift_info && trackdata.order.attributes.gift_info.phone ? trackdata.order.attributes.gift_info.phone : trackdata.order.attributes.customer_info.phone }}</span>
                            <span class="location"><b>{{__('Location')}}:</b> @{{ getShippingLocation(trackdata) }}</span>
                            <span class="address"><b>{{ __('Address') }}: </b> @{{ trackdata.order.delivery_address }}</span>
                            <span class="address" ng-show="trackdata.order.optional_address"><b>{{ __('Address Line 2') }}:</b> @{{ trackdata.order.optional_address }}</span>
                            <span class="zipcode"><b>{{__('Zipcode')}}:</b> @{{ trackdata.order.zip_code }}</span>
                        </div>
                        @if (!Config::get('cart::sa.hide_element', false))
                            <a ng-if="trackdata.order.status != 'CANCELED' && trackdata.order.status != 'FINISHED' && trackdata.order.status != 'RETURNED'"
                               class="button btn-change-info light" target="_blank"
                               ng-href="@{{ currentLocale + '/contact/ticket/flow?change_order=1&order_code=' + trackdata.order.code + '&email=' + data.email }}">
                                {{ __('Change shipping info') }}
                            </a>
                        @endif
                    </div>
                    <div class="shipping-address-wrapper">
                        <div class="title-product title-trackorder-page" ng-show="trackdata.order.delivery_note">
                            {{__('Order Notes')}}
                        </div>
                        <div class="group-info" ng-show="trackdata.order.delivery_note">
                            @{{ trackdata.order.delivery_note }}
                        </div>
                        <div class="title-product title-trackorder-page" ng-show="tickets.length > 0">
                            {{__('Ticket Related')}}
                        </div>
                        <a href="javascript:;" class="ticket-item" ng-repeat="ticket in tickets" ng-click="openTicket(ticket.id, ticket.email)" ng-show="tickets.length > 0">
                            <div class="item-subject ng-binding">@{{ ticket.title }}</div>
                            <div class="user-email ng-binding">@{{ ticket.customer_name ? ticket.customer_name : 'Customer' }}</div>
                            <div class="item-ordercode ng-binding">@{{ ticket.order_code }}</div>
                            <div class="status">
                                <div class="status-ticket status-open" ng-show="ticket.status != 'close'">{{ __('Open') }}</div>
                                <div class="status-ticket status-close" ng-show="ticket.status == 'close'">{{ __('Close') }}</div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
            <div class="text-center flex-b align-c flex-c tracking-order-action" ng-if="states.screen == 'result'">
                <a class="button light" href="track-order">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"> <path d="M2.5 1A1.5 1.5 0 0 0 1 2.5v11A1.5 1.5 0 0 0 2.5 15h6.086a1.5 1.5 0 0 0 1.06-.44l4.915-4.914A1.5 1.5 0 0 0 15 8.586V2.5A1.5 1.5 0 0 0 13.5 1h-11zM2 2.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 .5.5V8H9.5A1.5 1.5 0 0 0 8 9.5V14H2.5a.5.5 0 0 1-.5-.5v-11zm7 11.293V9.5a.5.5 0 0 1 .5-.5h4.293L9 13.793z"/> </svg>
                    {{ __('Track Another Order') }}
                </a>
                <a href="javascript:;" ng-click="createTicket()">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16"> <path d="M4 4.85v.9h1v-.9H4Zm7 0v.9h1v-.9h-1Zm-7 1.8v.9h1v-.9H4Zm7 0v.9h1v-.9h-1Zm-7 1.8v.9h1v-.9H4Zm7 0v.9h1v-.9h-1Zm-7 1.8v.9h1v-.9H4Zm7 0v.9h1v-.9h-1Z"/> <path d="M1.5 3A1.5 1.5 0 0 0 0 4.5V6a.5.5 0 0 0 .5.5 1.5 1.5 0 1 1 0 3 .5.5 0 0 0-.5.5v1.5A1.5 1.5 0 0 0 1.5 13h13a1.5 1.5 0 0 0 1.5-1.5V10a.5.5 0 0 0-.5-.5 1.5 1.5 0 0 1 0-3A.5.5 0 0 0 16 6V4.5A1.5 1.5 0 0 0 14.5 3h-13ZM1 4.5a.5.5 0 0 1 .5-.5h13a.5.5 0 0 1 .5.5v1.05a2.5 2.5 0 0 0 0 4.9v1.05a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-1.05a2.5 2.5 0 0 0 0-4.9V4.5Z"/> </svg>
                    {{ __('Open A Support Ticket') }}
                </a>
            </div>
    
            <div class="referral-banner" ng-if="states.screen == 'result'">
                <a href="{{ clroute('/refer') }}">
                    <div class="info">
                        <h3>{{ __('Refer Friends Now') }}</h3>
                        <span>
                            @{{ referText.replace('%s', formatPrice(referAmount, 0, true)) }}
                        </span>
                    </div>
                    <img src="{{ getImageCdn('/assets/images/referral-banner.png', 1200, 0) }}" alt="{{ __('Refer A Friend')}}">
                </a>
            </div>
        </div>
        <!-- The Modal -->
        <div id="modalInstruction" class="modal-custom">

            <!-- Modal content -->
            <div class="modal-custom-content">
                <span class="close" style="float: right; margin-top: -10px; cursor: pointer;">&times;</span>
                <h3 class="text-center">{{ __('Where do I find order code?') }}</h3>
                <div class="modal-infomation">
                    <p class="flex-b align-c">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"> <path d="M8 9.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3z"/> </svg>
                        <b style=" font-weight: 500; ">{{ str_replace('#name', config("app.name"), __('Check your email for an order confirmation from #name')) }} </b>
                    </p>
                    <img src="{{ getOption('general.find_order_code_img_url_1', asset('modules/cart/images/order1.png?v=' . config('sa.version'))) }}" alt="{{ __('Order number') }}">
                    <p class="flex-b align-c">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"> <path d="M8 9.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3z"/> </svg>
                        <b style=" font-weight: 500; ">{{ __(' When you completed your order  ') }}</b>
                    </p>
                    <img src="{{ getOption('general.find_order_code_img_url_2', asset('modules/cart/images/order2.png?v=' . config('sa.version'))) }}" alt="{{ __('Order number') }}">
                    
                </div>
            </div>
        </div>
        <div class="confirm-cancel-wrapper" ng-show="showCancelOrder">
            <div class="confirm-cancel-content">
                <div class="confirm-cancel-title">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#d2212b" class="bi bi-exclamation-triangle" viewBox="0 0 16 16">
                        <path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.15.15 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.2.2 0 0 1-.054.06.1.1 0 0 1-.066.017H1.146a.1.1 0 0 1-.066-.017.2.2 0 0 1-.054-.06.18.18 0 0 1 .002-.183L7.884 2.073a.15.15 0 0 1 .054-.057m1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767z"/>
                        <path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0M7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0z"/>
                    </svg>
                    <span>{{ __('Are you sure?') }}</span>
                    <span class="close-pop" ng-click="closeFormCancelOrder()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                            <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
                        </svg>
                    </span>
                </div>
                <div class="confirm-cancel-desc">{{ __('If you cancel this order, the refund will be processed within 5-7 days.') }}</div>
                <div class="confirm-cancel-form">
                    <form id="cancelReason" method="POST" action="/">
                        <div id="titleGroup" class="form-floating">
                            <label for="title" class="form-label">{{__('Reason for cancellation')}}</label>
                            <textarea rows="3" class="form-control" id="title" type="text" name="reason" value="" ng-model="cancelOrderData.reason"></textarea>
                        </div>
                        <div id="imageUpload" class="form-floating">
                            <label for="imageInput" class="form-label">{{__('Upload Images')}}</label>
                            <input class="form-control d-none" id="imageInput" type="file" name="image_file" accept=".jpeg,.png,.jpg" ngf-select="uploadImage($file)">
                            <label for="imageInput" class="upload-file-wrapper text-center">
                                <img src="{{ asset('modules/cart/images/upload.svg?v=' . config('sa.version')) }}" alt="icon upload" width="36" height="36">
                                <span class="imageInputMessage">{{__('Upload Images for Cancellation')}}</span>
                                <div class="loader-image" ng-show="loadingUpload"></div>
                            </label>
                            <div class="img-preview-item" ng-show="cancelOrderData.image_url">
                                <img ng-src="@{{ cancelOrderData.image_url }}" alt="">
                                <span class="remove-image" ng-click="removeImage()"> × </span>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="confirm-cancel-action">
                    <a href="javascript:;" class="confirm-cancel-action-cancel" ng-click="closeFormCancelOrder()">{{ __('Not now') }}</a>
                    <a href="javascript:;" class="confirm-cancel-action-delete" ng-click="cancelOrder()">{{ __('Cancel Order') }}</a>
                </div>
            </div>
            <div class="confirm-cancel-background"></div>
        </div>
    </div>
    
    @endsection

    @section('js')
        <script type="text/javascript">
            window._uxa = window._uxa || [];
            window._uxa.push(["setCustomVariable", 1, "pageType", "TrackOrder"]);
        </script>
        <script src="{{ asset('/system/js/scripts/angular.min.js?v=' . config('sa.version')) }}"></script>
        <script src="{{ asset('/system/js/scripts/ng-file-upload.min.js?v=' . config('sa.version')) }}"></script>
        <script>
            var modal = document.getElementById("modalInstruction");
            var span = document.getElementsByClassName("close")[0];
            var priceTemplate = "{{ getCurrencyTemplate() }}";
            var allTemplate = <?= json_encode(config('default.currency_template')); ?>;
            var googleCloudStorageBucket = '<?=config('sa.google_cloud_storage_bucket')?>';
            var currentLocale = '<?= !empty(env('APP_LOCALE')) ? env('APP_LOCALE') : 'us' ?>';
            var trackOrderTranslateText = {
                front: "{{ __('Front') }}",
                back: "{{ __('Back') }}",
                left: "{{ __('Left') }}",
                right: "{{ __('Right') }}",
                top: "{{ __('Top') }}",
                bottom: "{{ __('Bottom') }}"
            };

            const baseApiUrl = '{{ config('sa.api_url') }}';
            // const baseApiUrl = 'https://glob.api.prv.test.megaads.vn';

            function openModal() {
                event.preventDefault();
                modal.style.display = "block";
            }

            span.onclick = function() {
                modal.style.display = "none";
            }
            window.onclick = function(event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }
            var failMessage = "<?= __("We cannot find your order. Please double-check your email address or order code.") ?>"

            var trackOrder = angular.module('trackOrder', ["ngFileUpload"]);
            trackOrder.controller('TrackingOrderController', ['$scope', '$http', 'Upload', function($scope, $http, Upload) {

                $scope.states = {
                    screen: 'inputForm', // inputForm / result
                }

                $scope.data = {
                    email: '{{ app('request')->input('email', '') }}',
                    orderId: '{{ app('request')->input('order-code', '') }}'
                }
                $scope.priceConfig = null;
                $scope.trackdata = null;
                $scope.mapImages = { // USPS Canada Post Asendia DHL UPS Australia Post Royal Mail YunExpress
                    'USPS': 'https://printerval.com/files/default/31-07-2021/90011902-10158231700619810-8599436210709987328-n-61050a3fc1c61.png',
                    'Canada Post': 'https://printerval.com/files/default/31-07-2021/qh9pyzb8-61050a6a1141d.png',
                    'Asendia': 'https://printerval.com/files/default/31-07-2021/new-asendia-logo-610509dc51307.png',
                    'DHL': 'https://printerval.com/files/default/31-07-2021/588b0e974b6d4-61050a95bb52f.jpg',
                    'UPS': 'https://printerval.com/files/default/31-07-2021/2000px-united-parcel-service-logo-2014svg-859x1024-61050ab572b83.png',
                    'Australia Post': 'https://printerval.com/files/default/31-07-2021/auspostlogo1-61050b1bd54f0.png',
                    'Royal Mail': 'https://printerval.com/files/default/31-07-2021/unnamed-61050b52b3c3d.png',
                    'YunExpress': 'https://printerval.com/files/default/31-07-2021/004441100-1559825343-61050b86cf210.png'
                };

                $scope.currentLocale = currentLocale;
                $scope.template = "{{ __('#month #date, #year') }}";
                $scope.referText = "{{ __('Get %s to spend each time you refer a friend') }}";
                $scope.orderPlaceInText = "{{ __('Order Placed in #time') }}";
                $scope.orderExpectText = "{{ __('Order expected arrival before #time') }}";
                $scope.referAmount = <?= getOption('referral_user_value_discount', 7.5) ?>;
                $scope.designByOrderItem = {};
                $scope.printLocations = <?= json_encode(getPrintLocationConfig()) ?>;

                $scope.stripePayment = ["STRIPE", "STRIPE_EXPRESS", "PRODUCT_EXPRESS", "APPLE_GOOGLE", "AFTERPAY"];
                $scope.paypalPayment = ["PAYPAL", "PAYPAL_EXPRESS"];
                $scope.locale = "{{ env('APP_LOCALE') }}"
                $scope.tickets = [];
                $scope.showCancelOrder = false;
                $scope.cancelOrderData = {
                    "reason": "",
                    "image_url": null
                };
                $scope.allowCancelStatuses = ["PENDING", "PROCESSING", "ISSUED", "DELIVERING", "READY_TO_SHIP"];
                $scope.loadingUpload = false;
                $scope.getShippingLocation = function(trackdata) {
                    let locations = [];
                    if (trackdata) {
                        if(trackdata.order.country.nicename) locations.push(trackdata.order.country.nicename);
                        if(trackdata.order.state_name) locations.push(trackdata.order.state_name);
                        if(trackdata.order.city_name) locations.push(trackdata.order.city_name);
                    }
                    return locations.join(', ');
                }
                $scope.getBillingLocation = function(trackdata) {
                    let locations = [];
                    if (trackdata.order.billingAddress) {
                        if(trackdata.order.billingAddress.country && trackdata.order.billingAddress.country.nicename) locations.push(trackdata.order.billingAddress.country.nicename);
                        if(trackdata.order.billingAddress.state_name) locations.push(trackdata.order.billingAddress.state_name);
                        if(trackdata.order.billingAddress.city_name) locations.push(trackdata.order.billingAddress.city_name);
                    }

                    return locations.join(', ');
                }

                const getOrderLocate = (orderCode) => {
                    const match = orderCode.match(/([A-Z]+)/);
                    if (match && match[0]) {
                        return match[0];
                    }
                    return 'us';
                }

                const getTrackingApiUrl = (orderLocate = 'US') => 
                {
                    const trackingUrl = new URL(baseApiUrl);
                    // const trackingUrl = new URL('https://us.api.printerval.com');
                    const hostSegments = trackingUrl.host.split('.');

                    if (hostSegments.length == 4 && hostSegments[0] != 'api') {
                        hostSegments[0] = orderLocate.toLowerCase();
                        trackingUrl.host = hostSegments.join('.');
                        return trackingUrl.toString();
                    }

                    return baseApiUrl + '/';
                }

                $scope.submit = function() 
                {
                    $scope.states.loading = true;

                    const orderLocate = getOrderLocate($scope.data.orderId);
                    const trackingUrl = getTrackingApiUrl(orderLocate);

                    $scope.data.service_token = 'megaads@123'
                    $http({
                        method: "POST",
                        url: trackingUrl + "track-order",
                        data: $scope.data
                    }).then(function(response) {
                        $scope.states.loading = false;
                        $scope.states.message = null;
                        if (response.data.status !== "fail" && response.data.data.order) {
                            $scope.states.screen = 'result';
                            $scope.trackdata = response.data.data;
                            if (response.data.data && response.data.data.order && response.data.data.order.customer) {
                                response.data.data.order.customer.order_code = response.data.data.order.code;
                                localStorage.setItem('track-order-customer', JSON.stringify(response.data.data.order.customer));
                                $scope.trackdata.order.customer.email_text = response.data.data.order.customer.email;
                                if ($scope.trackdata.order.customer.email_text.length > 20) {
                                    $scope.trackdata.order.customer.email_text = $scope.trackdata.order.customer.email_text.substr(0, 20) + "...";
                                }
                            }
                            if (response.data.data && response.data.data.designByOrderItem) {
                                $scope.designByOrderItem = response.data.data.designByOrderItem;
                            }
                            $scope.isFormatPrice = true;
                            let designFee = 0;
                            for (let index = 0; index < $scope.trackdata.order.items.length; index++) {
                                const element = $scope.trackdata.order.items[index];
                                try {
                                    let configurations = JSON.parse(element.configurations);
                                    element.configurationsParse = {};
                                    for (let i in configurations) {
                                        if (typeof configurations[i] == 'string' || typeof configurations[i] == 'number') {
                                            element.configurationsParse[i] = configurations[i];
                                        }
                                    }
                                    if (configurations && configurations.design_fee) {
                                        designFee += parseFloat(configurations.design_fee);
                                    }
                                    if (configurations["Preview url"]) {
                                        element.preview_url = configurations["Preview url"]['image_url'];
                                    }
                                    if (configurations.config_by_print_location) {
                                        element.print_location_3d = Object.keys(configurations.config_by_print_location).map(text => trackOrderTranslateText[text]).join(', ');
                                    }
                                } catch (error) {
                                    console.log(error);
                                }
                            }

                            $scope.trackdata.order.design_fee = designFee;

                            try {
                                const locateNCurrency = JSON.parse(locales);
                                if (locateNCurrency[orderLocate.toLowerCase()]) {
                                    $scope.currencyUnit = locateNCurrency[orderLocate.toLowerCase()].currencyUnit;
                                }
                            } catch (error) {
                                console.warn(error);   
                            }

                            if ($scope.trackdata.order.used_rewards) {
                                $scope.trackdata.order.discount = parseFloat($scope.trackdata.order.discount) + parseFloat($scope.trackdata.order.used_rewards);
                            }
                            if ($scope.trackdata.order.currency_config) {
                                $scope.isFormatPrice = false;
                                let data = JSON.parse($scope.trackdata.order.currency_config);
                                $scope.currencyUnit = data.currency;
                                $scope.priceConfig = {
                                    ratio: data.ratio,
                                    adding_price: data.adding_price,
                                }
                                $scope.trackdata.amount = data.dataOrder.amount_convert;
                                $scope.trackdata.order.amount = data.amount_convert;
                                $scope.trackdata.order.discount = data.discountConvert;
                                $scope.trackdata.order.other_fee = data.other_fee;
                                $scope.trackdata.order.design_fee = data.design_fee;
                                $scope.trackdata.order.shipping_fee = data.shippingFeeConvert;
                                $scope.trackdata.order.tips = data.tipsConvert;
                                if (data.usedRewardsConvert) {
                                    $scope.trackdata.order.discount = parseFloat($scope.trackdata.order.discount) + parseFloat($scope.trackdata.order.usedRewardsConvert);
                                }
                                $scope.trackdata.order.tax = data.taxConvert;
                            }
                            if ($scope.trackdata.childOrder) {
                                for (let index = 0; index < $scope.trackdata.childOrder.length; index++) {
                                    const element = $scope.trackdata.childOrder[index];
                                    let designFeeChild = 0;
                                    if (element.used_rewards) {
                                        element.discount = parseFloat(element.discount) + parseFloat(element.used_rewards);
                                    }
                                    for (let index = 0; index < element.items.length; index++) {
                                        const childItem = element.items[index];
                                        try {
                                            let configurations = JSON.parse(childItem.configurations);
                                            childItem.configurationsParse = {};
                                            for (let i in configurations) {
                                                if (typeof configurations[i] == 'string' || typeof configurations[i] == 'number') {
                                                    childItem.configurationsParse[i] = configurations[i];
                                                }
                                            }
                                            if (configurations && configurations.design_fee) {
                                                designFeeChild += parseFloat(configurations.design_fee);
                                            }
                                            if (configurations["Preview url"]) {
                                                element.preview_url = configurations["Preview url"]['image_url'];
                                            }
                                            if (configurations.config_by_print_location) {
                                                element.print_location_3d = Object.keys(configurations.config_by_print_location).map(text => trackOrderTranslateText[text]).join(', ');
                                            }
                                        } catch (error) {
                                            console.log(error);
                                        }
                                    }
                                    element.design_fee = designFeeChild;
                                    if (element.currency_config) {
                                        let data = JSON.parse(element.currency_config);
                                        element.amount = data.amount_convert;
                                        element.discount = data.discountConvert;
                                        element.other_fee = data.other_fee;
                                        element.design_fee = data.design_fee;
                                        element.shipping_fee = data.shippingFeeConvert;
                                        element.tips = data.tipsConvert;
                                        if (data.usedRewardsConvert) {
                                            element.discount = parseFloat(element.discount) + parseFloat(data.usedRewardsConvert);
                                        }
                                        element.used_rewards = parseFloat(data.usedRewardsConvert);
                                        element.tax = data.taxConvert;
                                    }
                                }
                            }
                            $scope.loadTicket();
                        } else {
                            $scope.states.message = failMessage;
                        }
                    })
                }

                $scope.formatPrice = function(price, numberAdd = 1, format = true) {
                    if (format && price != 0) {
                        if ($scope.priceConfig) {
                            price = (parseFloat(price) + parseFloat($scope.priceConfig.adding_price) * numberAdd) * parseFloat($scope.priceConfig.ratio);
                        }
                        price = decimalAdjust('ceil', price);
                    }
                    if ($scope.currencyUnit) {
                        return formatPrice(price, allTemplate[$scope.currencyUnit]);
                    } else {
                        return formatPrice(price, priceTemplate);
                    }
                    
                };

                $scope.replaceDownloadImage = (url) => {
                    url = url.replace("storage.googleapis.", "dl.printerval.");
                    url = url.replace("asset.prtvstatic.", "dl.printerval.");
                    return url.replace("assets.", "dl.");
                }
                function decimalAdjust(type, value) {
                    let template = priceTemplate;
                    if ($scope.currencyUnit) {
                        template = allTemplate[$scope.currencyUnit];
                    }
                    let matches = template.match(/{money}{([^a-zA-z0-9]+)}{([0-9]+)}/);
                    let exp = -2;
                    if (matches.length == 3) {
                        exp = parseInt(matches[2] * (matches[2] ? -1 : 1));
                    }
                    // If the exp is undefined or zero...
                    if (typeof exp === 'undefined' || +exp === 0) {
                    return Math[type](value);
                    }
                    value = +value;
                    exp = +exp;
                    // If the value is not a number or the exp is not an integer...
                    if (isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
                        return NaN;
                    }
                    // Shift
                    value = value.toString().split('e');
                    value = Math[type](+(value[0] + 'e' + (value[1] ? (+value[1] - exp) : -exp)));
                    // Shift back
                    value = value.toString().split('e');
                    return +(value[0] + 'e' + (value[1] ? (+value[1] + exp) : exp));
                }
                $scope.calculateLastAmount = (id) => {
                    let currencyConfig = null;
                    if ($scope.trackdata.order.currency_config) {
                        currencyConfig = JSON.parse($scope.trackdata.order.currency_config);
                    }
                    let totalAmount = 0;
                    if (currencyConfig) {
                        let mainOrderAmount = decimalAdjust('ceil', $scope.trackdata.order.amount * currencyConfig.ratio);
                        totalAmount = parseFloat(currencyConfig.amount_convert) - mainOrderAmount;
                        $scope.trackdata.childOrder.forEach(element => {
                            if (element.id != id) {
                                totalAmount -= parseFloat(element.amount);
                            }
                        });
                    } else {
                        totalAmount = 0;
                        $scope.trackdata.childOrder.forEach(element => {
                            if (element.id == id) {
                                totalAmount = parseFloat(element.amount);
                            }
                        });
                    }
                    return totalAmount;
                }

                $scope.formatTime = function(t) {
                    var t = t.split(/[- :]/);
                    var d = new Date(Date.UTC(t[0], t[1] - 1, t[2], t[3], t[4], t[5]));

                    var year = d.getFullYear();
                    var month = d.toLocaleString(getLang(), { month: 'long' });
                    var date = d.getDate();
                    let retval = $scope.template;
                    retval = retval.replace("#month", month);
                    retval = retval.replace("#date", date);
                    retval = retval.replace("#year", year);
                    return retval;
                }
                $scope.getByField = function (list, fieldName, value) {
                    var retVal = null;
                    list.forEach(function (item) {
                        if (item[fieldName] == value) {
                            retVal = item;
                        }
                    });
                    return retVal;
                };

                function getLang() {
                    if (navigator.languages != undefined)
                        return navigator.languages[0];
                    return navigator.language;
                }

                if ($scope.data.email && $scope.data.orderId) {
                    $scope.submit();
                }

                $scope.convertGMT7toUTC = (dateString) => {
                    // Parse the input date string as a Date object
                    const localDate = new Date(dateString);
                    // Calculate the offset for GMT+7 in milliseconds
                    const offset = 7 * 60 * 60 * 1000;
                    // Convert the local date to UTC by subtracting the offset
                    const utcDate = new Date(localDate.getTime() - offset);
                    return $scope.formatDate(utcDate);
                }

                $scope.formatDate = (date) => {
                    // Format the date components
                    const year = date.getUTCFullYear();
                    const month = String(date.getUTCMonth() + 1).padStart(2, '0'); // Months are zero-based
                    const day = String(date.getUTCDate()).padStart(2, '0');
                    const hours = String(date.getUTCHours()).padStart(2, '0');
                    const minutes = String(date.getUTCMinutes()).padStart(2, '0');

                    // Return the formatted date string
                    return `${year}-${month}-${day} ${hours}:${minutes} (UTC)`;
                }

                $scope.loadTicket = () => {
                    let data = [];
                    let locale = $scope.locale;
                    if (locale == "") {
                        locale = "us";
                    }
                    if ($scope.trackdata.order) {
                        data.push({order_id: $scope.trackdata.order.id, locate: locale});
                    }
                    if ($scope.trackdata.childOrder) {
                        for (let index = 0; index < $scope.trackdata.childOrder.length; index++) {
                            const element = $scope.trackdata.childOrder[index];
                            data.push({order_id: element.id, locate: locale});
                        }
                    }
                    $http.post("/ticket/order/load-ticket", {items: data}).then(function(response) {
                        if (response.data.status == 'successful') {
                            $scope.tickets = response.data.result;
                        }
                    });
                }
                $scope.openTicket = (id, email) => {
                    localStorage.removeItem('track-order-customer');
                    let locale = $scope.locale;
                    let url = "/contact/ticket?id=" + id + "&email=" + email
                    if (locale != "") {
                        url = "/" + locale + url;
                    }
                    window.open(url, "_blank");
                }
                $scope.createTicket = () => {
                    localStorage.setItem('track-order-customer', JSON.stringify($scope.trackdata.order.customer));
                    let locale = $scope.locale;
                    let url = "/contact/ticket/flow?source=track-order&email=" + $scope.data.email + "&order_code=" + $scope.trackdata.order.code;
                    if (locale != "") {
                        url = "/" + locale + url;
                    }
                    window.open(url, "_blank");
                }
                $scope.openFormCancelOrder = () => {
                    if ($scope.trackdata.order.status != 'PROCESSING') {
                        return;
                    }
                    $scope.cancelOrderData = {
                        "reason": "",
                        "image_file": null
                    };
                    $("body").addClass("open-confirm-cancel-popup");
                    $scope.showCancelOrder = true;
                }
                $scope.closeFormCancelOrder = () => {
                    $scope.showCancelOrder = false;
                    $("body").removeClass("open-confirm-cancel-popup");
                }
                $scope.cancelOrder = () => {
                    const dateString = $scope.trackdata.order.created_at_origin;
                    const inputDate = new Date(dateString);
                    const fourHoursAgo = new Date(Date.now() - 4 * 60 * 60 * 1000); // 4 hours ago
                    if ($scope.trackdata.order.status != 'PROCESSING' || inputDate < fourHoursAgo) {
                        toastr.error("{{ __('Your order is in production and cannot be automatically canceled. Please contact us for assistance.') }}");
                        return;
                    }
                    if (!$scope.cancelOrderData.reason) {
                        toastr.error("{{ __('Please enter the reason for cancellation') }}");
                        return;
                    }
                    let data = {
                        id: $scope.trackdata.order.id,
                        email: $scope.trackdata.order.customer.email,
                        cancel_data: $scope.cancelOrderData,
                    };
                    $http.post("/order/cancel", data).then(function(response) {
                        if (response.data.status == 'successful') {
                            toastr.success(response.data.message);
                        } else {
                            toastr.error(response.data.message);
                        }
                        $scope.showCancelOrder = false;
                        $("body").removeClass("open-confirm-cancel-popup");
                    });
                }
                $scope.uploadImage = async function (file) {
                    if (file) {
                        $scope.loadingUpload = true;
                        var image = await $scope.upload(file);
                        if (image) {
                            $scope.$applyAsync(function () {
                                $scope.cancelOrderData.image_url = image;
                            });
                        }
                        $scope.loadingUpload = false;
                    }
                }
                $scope.upload = function (file, type = 'default', validateFile = false) {
                    if (!file) {
                        return;
                    }
                    if (typeof file == 'array') {
                        file = file[0];
                    }
                    return new Promise(function(resolve, reject) {
                        Upload.upload({
                            url: googleCloudStorageBucket + '/upload',
                            data: {upload: file, type: type, validate_file: validateFile ? 1 : 0}
                        }).then(function (resp) {
                            if (resp.data.error) {
                                toastr.error(resp.data.error);
                            }
                            if (resp.data.errors) {
                                for (let message of resp.data.errors) {
                                    toastr.error(message);
                                }
                            }
                            if (resp.data.status == 'successful') {
                                let upload = resp.data.upload[0];
                                resolve(upload);
                            } else {
                                reject(0);
                            }
                        }, function (resp) {
                            reject(0);
                        });
                    });
                };

                $scope.removeImage = () => {
                    $scope.cancelOrderData.image_url = null;
                }

                $scope.convertFromGMT7ToUTC = (dateString, daysToAdd = 0, ignoreWeekend = false) => {
                    if (!dateString) {
                        return '';
                    }

                    // Parse the string into a JavaScript Date object and treat it as GMT+7
                    let date = new Date(dateString.replace(' ', 'T') + '+07:00'); 

                    if (ignoreWeekend) {
                        // Function to add days while skipping weekends
                        const addBusinessDays = (startDate, days) => {
                            let currentDate = new Date(startDate);
                            while (days > 0) {
                                currentDate.setUTCDate(currentDate.getUTCDate() + 1);
                                const dayOfWeek = currentDate.getUTCDay(); // 0 = Sunday, 6 = Saturday
                                if (dayOfWeek !== 0 && dayOfWeek !== 6) { // Skip weekends
                                    days--;
                                }
                            }
                            return currentDate;
                        };

                        // Add the specified days, ignoring weekends
                        date = addBusinessDays(date, daysToAdd);
                    } else {
                        // Add the specified days
                        date.setUTCDate(date.getUTCDate() + daysToAdd);
                    }

                    // Format the date in UTC
                    const options = {
                        timeZone: 'UTC',
                        year: 'numeric',
                        month: 'short',
                        day: 'numeric',
                        hour: 'numeric',
                        minute: 'numeric',
                        hour12: true
                    };
                    let result = new Intl.DateTimeFormat('en-US', options).format(date).replace(',', '');
                    result += ' (UTC)';

                    return result;
                };

                $scope.getDeliverType = (content) => {
                    if (content.includes("delivered") || content.includes("Delivered")) {
                        return "delivered";
                    }
                    if (content.includes("arrived") || content.includes("Arrived")) {
                        return "arrived";
                    }
                    if (content.includes("departed") || content.includes("Departed")) {
                        return "delivering";
                    }
                    return "default";
                }

                $scope.checkStatusShipping = (order, type, classType = 'icon') => {
                    let isFinished = false;
                    let isDelivering = false;
                    let isPackaging = false;
                    if (order.status_time && order.status_time.length > 0) {
                        for (let index = 0; index < order.status_time.length; index++) {
                            const element = order.status_time[index];
                            if (element.status == "FINISHED") {
                                isFinished = true;
                                isDelivering = true;
                                isPackaging = true;
                            } else if (element.status == "DELIVERING") {
                                isDelivering = true;
                                isPackaging = true;
                            } else if (element.status == "ISSUED") {
                                isPackaging = true;
                            }
                        }
                    }
                    let className = '';
                    if (classType == 'icon') {
                        className = '';
                        if (type == "ISSUED" && isPackaging) {
                            if (isDelivering) {
                                className = 'stepper-step-icon-finish'
                            } else {
                                className = 'stepper-step-icon-pending'
                            }
                        }
                        if (type == "DELIVERING" && isDelivering) {
                            if (isFinished) {
                                className = 'stepper-step-icon-finish'
                            } else {
                                className = 'stepper-step-icon-pending'
                            }
                        }
                        if (type == "FINISHED" && isFinished) {
                            className = 'stepper-step-icon-finish'
                        }
                    } else {
                        className = '';
                        if (type == "ISSUED" && isPackaging) {
                            className = 'stepper-step-finish'
                        }
                        if (type == "DELIVERING" && isDelivering) {
                            className = 'stepper-step-finish'
                        }
                        if (type == "FINISHED" && isFinished) {
                            className = 'stepper-step-finish'
                        }
                    }
                    return className;
                }

                $scope.getPercentShipping = (order) => {
                    let percent = 15;
                    let isFinished = false;
                    let isDelivering = false;
                    let isPackaging = false;
                    if (order.status_time && order.status_time.length > 0) {
                        for (let index = 0; index < order.status_time.length; index++) {
                            const element = order.status_time[index];
                            if (element.status == "FINISHED") {
                                isFinished = true;
                            } else if (element.status == "DELIVERING") {
                                isDelivering = true;
                            } else if (element.status == "ISSUED") {
                                isPackaging = true;
                            }
                        }
                    }
                    if (isFinished) {
                        percent = 100;
                    } else if (isDelivering) {
                        percent = 75;
                    } else if (isPackaging) {
                        percent = 45;
                    }
                    return percent;
                } 

                $scope.getStatusTime = (order, type) => {
                    if (order.status_time && order.status_time.length > 0) {
                        for (let index = 0; index < order.status_time.length; index++) {
                            const element = order.status_time[index];
                            if (element.status == type) {
                                return element.created_at;
                            }
                        }
                    }
                    return '';
                }

                $scope.showAllActivity = (order) => {
                    order.show_all_activity = true;
                }
            }]);
        </script>
    @endsection
