@section('css')
    <link rel="stylesheet" href="{{ asset('modules/cart/css/explore-picked.css') }}?v={{ config('sa.version') }}">
@append
<section class="cart-explore-picked-module site-w">
    <h2 class="component-heading">
        {{ __('Explore products picked for you') }}
    </h2>
    <div class="cart-explore-picked-wrapper">
        <div class="cart-explore-picked swiper-wrapper">
        </div>
        <div class="swiper-button-next explore-products-btn-next"></div>
        <div class="swiper-button-prev explore-products-btn-prev"></div>
    </div>
</section>
@section('js')
@parent
<script>
    $.ajax({url: "/product/recommendation?size=30"}).done(function(response) {
        var locale = '';
        if (localePrefix && localePrefix !== 'us') {
            locale = '/' + localePrefix;
        }
        if (response.status == 'successful') {
            const recommendationProducts = response.result;
            if (recommendationProducts && recommendationProducts.length > 0) {
                let html = "";
                for (let index = 0; index < recommendationProducts.length; index++) {
                    let url = recommendationProducts[index].url;
                    url = locale + url;
                    html += `
                        <div class="cart-explore-picked-item swiper-slide">
                            <a href="${url}?internal_source=finish-recommendation">
                                <div class="cart-explore-picked-image" href="#">
                                    <img src="${getImageCdn(recommendationProducts[index].image_url, 540, 540)}"
                                        alt="Discover ${recommendationProducts[index].name}">
                                </div>
                                <h3 class="cart-explore-picked-title">
                                    ${recommendationProducts[index].name}
                                </h3>
                            </a>
                            <div class="featured-product-price">
                                ${recommendationProducts[index].display_price}
                            </div>`
                        if (recommendationProducts[index].high_price && recommendationProducts[index].high_price > recommendationProducts[index].price) {
                            html +=`
                            <del class="featured-product-high-price">
                                ${recommendationProducts[index].display_high_price}
                            </del>`
                        }
                        html += `
                        </div>
                    `;
                    if (typeof isMobile !== 'undefined' && isMobile && recommendationProducts.length > 4) {
                        index++;
                        if (recommendationProducts[index]) {
                            let mobileUrl = recommendationProducts[index].url;
                            mobileUrl = locale + mobileUrl;
                            html += `
                                <div class="cart-explore-picked-item swiper-slide">
                                    <a href="${mobileUrl}?internal_source=finish-recommendation">
                                        <div class="cart-explore-picked-image">
                                            <img src="${getImageCdn(recommendationProducts[index].image_url, 540, 540)}"
                                                alt="Discover ${recommendationProducts[index].name}">
                                        </div>
                                        <h3 class="cart-explore-picked-title">
                                            ${recommendationProducts[index].name}
                                        </h3>
                                    </a>
                                    <div class="featured-product-price">
                                        ${recommendationProducts[index].display_price}
                                    </div>`
                                    if (recommendationProducts[index].high_price && recommendationProducts[index].high_price > recommendationProducts[index].price) {
                                        html +=`
                                        <del class="featured-product-high-price">
                                            ${recommendationProducts[index].display_high_price}
                                        </del>`
                                    }
                                html += `
                                </div>
                            `;
                                
                        }
                    }
                }
                $(".cart-explore-picked-wrapper").find(".cart-explore-picked").html(html);
                $(".cart-explore-picked-wrapper").show();

                const recommendImages = document.querySelectorAll('.cart-explore-picked-wrapper img');
                for (let i = 0; i < recommendImages.length; i++) {
                    const image = recommendImages[i];
                    window.printerval.watchLoadingImage(image);
                }

                if (screen.width > 520) {
                    var swiper = new Swiper('.cart-explore-picked-wrapper', {                    
                        preloadImages: false,
                        lazy: true,
                        slidesPerView: 2.3,                     
                        slidesPerGroup: 2,  
                        spaceBetween: 16, 
                        grid: {
                            rows: 2,
                            fill: "row"
                        },
                        navigation: {
                            nextEl: ".explore-products-btn-next",
                            prevEl: ".explore-products-btn-prev",
                            clickable: true,
                        },
                        breakpoints: {
                            760: {
                                slidesPerView: 3.3,
                                slidesPerGroup: 2,
                            },
                            990: {
                                slidesPerView: 4,
                                slidesPerGroup: 4,
                                grid: {
                                    rows: 2,
                                    fill: "row"
                                },
                            },
                            1200: {
                                slidesPerView: 4,
                                slidesPerGroup: 4,
                            },
                            1300: {
                                slidesPerView: 5,
                                slidesPerGroup: 5,
                            }
                        }
                    });
                }
            }

        } else {
            $(".cart-explore-picked-module").hide();
        }
    })
</script>
@endsection
